/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class LocalityAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private final String[] headers = new String[]{"vertexName", "numTasks", "dataLocalRatio", "rackLocalRatio", "otherRatio", "avgDataLocalTaskRuntime", "avgRackLocalTaskRuntime", "avgOtherLocalTaskRuntime", "noOfInputs", "avgHDFSBytesRead_DataLocal", "avgHDFSBytesRead_RackLocal", "avgHDFSBytesRead_Others", "recommendation"};
    private static final String DATA_LOCAL_RATIO = "tez.locality-analyzer.data.local.ratio";
    private static final float DATA_LOCAL_RATIO_DEFAULT = 0.5f;
    private final CSVResult csvResult = new CSVResult(this.headers);

    public LocalityAnalyzer(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (VertexInfo vertexInfo : dagInfo.getVertices()) {
            String vertexName = vertexInfo.getVertexName();
            Map dataLocalTask = vertexInfo.getCounter(DAGCounter.class.getName(), DAGCounter.DATA_LOCAL_TASKS.toString());
            Map rackLocalTask = vertexInfo.getCounter(DAGCounter.class.getName(), DAGCounter.RACK_LOCAL_TASKS.toString());
            long dataLocalTasks = 0L;
            long rackLocalTasks = 0L;
            if (!dataLocalTask.isEmpty()) {
                dataLocalTasks = ((TezCounter)dataLocalTask.get(DAGCounter.class.getName())).getValue();
            }
            if (!rackLocalTask.isEmpty()) {
                rackLocalTasks = ((TezCounter)rackLocalTask.get(DAGCounter.class.getName())).getValue();
            }
            long totalVertexTasks = vertexInfo.getNumTasks();
            if (dataLocalTasks <= 0L && rackLocalTasks <= 0L) continue;
            float dataLocalRatio = (float)dataLocalTasks * 1.0f / (float)totalVertexTasks;
            float rackLocalRatio = (float)rackLocalTasks * 1.0f / (float)totalVertexTasks;
            float othersRatio = (float)(totalVertexTasks - (dataLocalTasks + rackLocalTasks)) * 1.0f / (float)totalVertexTasks;
            LinkedList record = Lists.newLinkedList();
            record.add(vertexName);
            record.add("" + totalVertexTasks);
            record.add("" + dataLocalRatio);
            record.add("" + rackLocalRatio);
            record.add("" + othersRatio);
            TaskAttemptDetails dataLocalResult = this.computeAverages(vertexInfo, DAGCounter.DATA_LOCAL_TASKS);
            TaskAttemptDetails rackLocalResult = this.computeAverages(vertexInfo, DAGCounter.RACK_LOCAL_TASKS);
            TaskAttemptDetails otherTaskResult = this.computeAverages(vertexInfo, DAGCounter.OTHER_LOCAL_TASKS);
            record.add("" + dataLocalResult.avgRuntime);
            record.add("" + rackLocalResult.avgRuntime);
            record.add("" + otherTaskResult.avgRuntime);
            record.add("" + (vertexInfo.getInputEdges().size() + vertexInfo.getAdditionalInputInfoList().size()));
            record.add("" + dataLocalResult.avgHDFSBytesRead);
            record.add("" + rackLocalResult.avgHDFSBytesRead);
            record.add("" + otherTaskResult.avgHDFSBytesRead);
            String recommendation = "";
            if (dataLocalRatio < this.getConf().getFloat(DATA_LOCAL_RATIO, 0.5f)) {
                recommendation = "Data locality is poor for this vertex. Try tuning tez.am.container.reuse.locality.delay-allocation-millis, tez.am.container.reuse.rack-fallback.enabled, tez.am.container.reuse.non-local-fallback.enabled";
            }
            record.add(recommendation);
            this.csvResult.addRecord(record.toArray(new String[record.size()]));
        }
    }

    private TaskAttemptDetails computeAverages(VertexInfo vertexInfo, DAGCounter counter) {
        long totalTime = 0L;
        long totalTasks = 0L;
        long totalHDFSBytesRead = 0L;
        TaskAttemptDetails result = new TaskAttemptDetails();
        for (TaskAttemptInfo attemptInfo : vertexInfo.getTaskAttempts()) {
            Map localityCounter = attemptInfo.getCounter(DAGCounter.class.getName(), counter.toString());
            if (localityCounter.isEmpty() || ((TezCounter)localityCounter.get(DAGCounter.class.getName())).getValue() <= 0L) continue;
            totalTime += attemptInfo.getTimeTaken();
            ++totalTasks;
            Map hdfsBytesReadCounter = attemptInfo.getCounter(FileSystemCounter.class.getName(), FileSystemCounter.HDFS_BYTES_READ.name());
            for (Map.Entry entry : hdfsBytesReadCounter.entrySet()) {
                totalHDFSBytesRead += ((TezCounter)entry.getValue()).getValue();
            }
        }
        if (totalTasks > 0L) {
            result.avgRuntime = (float)totalTime * 1.0f / (float)totalTasks;
            result.avgHDFSBytesRead = (float)totalHDFSBytesRead * 1.0f / (float)totalTasks;
        }
        return result;
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Locality Analyzer";
    }

    @Override
    public String getDescription() {
        return "Analyze for locality information (data local, rack local, off-rack)";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        LocalityAnalyzer analyzer = new LocalityAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }

    static class TaskAttemptDetails {
        float avgHDFSBytesRead;
        float avgRuntime;

        TaskAttemptDetails() {
        }
    }
}

