/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.analyzer.plugins.CriticalPathAnalyzer;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService;
import org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.history.ATSImportTool;
import org.apache.tez.history.parser.ATSFileParser;
import org.apache.tez.history.parser.SimpleHistoryParser;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.test.SimpleTestDAG;
import org.apache.tez.test.SimpleTestDAG3Vertices;
import org.apache.tez.test.TestInput;
import org.apache.tez.test.TestProcessor;
import org.apache.tez.test.dag.SimpleReverseVTestDAG;
import org.apache.tez.test.dag.SimpleVTestDAG;
import org.apache.tez.tests.MiniTezClusterWithTimeline;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(TestAnalyzer.class);
    private static String TEST_ROOT_DIR = "target/" + TestAnalyzer.class.getName() + "-tmpDir";
    private static String DOWNLOAD_DIR = TEST_ROOT_DIR + "/download";
    private static final String SIMPLE_HISTORY_DIR = "/tmp/simplehistory/";
    private static final String HISTORY_TXT = "history.txt";
    private static MiniDFSCluster dfsCluster;
    private static MiniTezClusterWithTimeline miniTezCluster;
    private static Configuration conf;
    private static FileSystem fs;
    private static TezClient tezSession;
    private boolean usingATS = true;
    private boolean downloadedSimpleHistoryFile = false;
    private static String yarnTimelineAddress;

    @BeforeClass
    public static void setupClass() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.edits.noeditlogchannelflush", false);
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
        dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        fs = dfsCluster.getFileSystem();
        conf.set("fs.defaultFS", fs.getUri().toString());
        TestAnalyzer.setupTezCluster();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        LOG.info("Stopping mini clusters");
        if (miniTezCluster != null) {
            miniTezCluster.stop();
            miniTezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    private CriticalPathAnalyzer setupCPAnalyzer() {
        Configuration analyzerConf = new Configuration(false);
        analyzerConf.setBoolean("tez.critical-path-analyzer.draw-svg", false);
        CriticalPathAnalyzer cp = new CriticalPathAnalyzer();
        cp.setConf(analyzerConf);
        return cp;
    }

    private static void setupTezCluster() throws Exception {
        conf.setInt("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 100);
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setBoolean("tez.allow.disabled.timeline-domains", true);
        conf.set("tez.history.logging.service.class", ATSHistoryLoggingService.class.getName());
        miniTezCluster = new MiniTezClusterWithTimeline(TestAnalyzer.class.getName(), 1, 1, 1, true);
        miniTezCluster.init(conf);
        miniTezCluster.start();
        yarnTimelineAddress = miniTezCluster.getConfig().get("yarn.timeline-service.webapp.address");
    }

    private TezConfiguration createCommonTezLog() throws Exception {
        TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
        tezConf.setInt("tez.am.am-rm.heartbeat.interval-ms.max", 100);
        Path remoteStagingDir = dfsCluster.getFileSystem().makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
        return tezConf;
    }

    private void createTezSessionATS() throws Exception {
        TezConfiguration tezConf = this.createCommonTezLog();
        tezConf.setBoolean("yarn.timeline-service.enabled", true);
        tezConf.set("yarn.timeline-service.webapp.address", miniTezCluster.getConfig().get("yarn.timeline-service.webapp.address"));
        tezConf.setBoolean("tez.allow.disabled.timeline-domains", true);
        tezConf.set("tez.history.logging.service.class", ATSHistoryLoggingService.class.getName());
        Path remoteStagingDir = dfsCluster.getFileSystem().makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
        tezSession = TezClient.create((String)"TestAnalyzer", (TezConfiguration)tezConf, (boolean)true);
        tezSession.start();
    }

    private void createTezSessionSimpleHistory() throws Exception {
        TezConfiguration tezConf = this.createCommonTezLog();
        tezConf.set("tez.history.logging.service.class", SimpleHistoryLoggingService.class.getName());
        tezConf.set("tez.simple.history.logging.dir", SIMPLE_HISTORY_DIR);
        Path remoteStagingDir = dfsCluster.getFileSystem().makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
        tezSession = TezClient.create((String)"TestFaultTolerance", (TezConfiguration)tezConf, (boolean)true);
        tezSession.start();
    }

    private StepCheck createStep(String attempt, CriticalPathAnalyzer.CriticalPathDependency reason) {
        return this.createStep(attempt, reason, null, null);
    }

    private StepCheck createStep(String attempt, CriticalPathAnalyzer.CriticalPathDependency reason, TaskAttemptTerminationCause errCause, List<String> notes) {
        return new StepCheck(attempt, reason, errCause, notes);
    }

    private void runDAG(DAG dag, DAGStatus.State finalState) throws Exception {
        tezSession.waitTillReady();
        LOG.info("ABC Running DAG name: " + dag.getName());
        DAGClient dagClient = tezSession.submitDAG(dag);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            LOG.info("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appContext: " + dagClient.getExecutionContext() + " Current state: " + dagStatus.getState());
            Thread.sleep(100L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        Assert.assertEquals((Object)finalState, (Object)dagStatus.getState());
    }

    private void verify(ApplicationId appId, int dagNum, List<StepCheck[]> steps) throws Exception {
        String dagId = TezDAGID.getInstance((ApplicationId)appId, (int)dagNum).toString();
        DagInfo dagInfo = this.getDagInfo(dagId);
        this.verifyCriticalPath(dagInfo, steps);
    }

    private DagInfo getDagInfo(String dagId) throws Exception {
        DagInfo dagInfo = null;
        if (this.usingATS) {
            String[] args = new String[]{"--dagId=" + dagId, "--downloadDir=" + DOWNLOAD_DIR, "--yarnTimelineAddress=" + yarnTimelineAddress};
            int result = ATSImportTool.process((String[])args);
            Assert.assertTrue((result == 0 ? 1 : 0) != 0);
            File downloadedFile = new File(DOWNLOAD_DIR + "/" + dagId + ".zip");
            ATSFileParser parser = new ATSFileParser(Arrays.asList(downloadedFile));
            dagInfo = parser.getDAGData(dagId);
            Assert.assertTrue((boolean)dagInfo.getDagId().equals(dagId));
        } else {
            if (!this.downloadedSimpleHistoryFile) {
                this.downloadedSimpleHistoryFile = true;
                TezDAGID tezDAGID = TezDAGID.fromString((String)dagId);
                ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)tezDAGID.getApplicationId(), (int)1);
                Path historyPath = new Path(miniTezCluster.getConfig().get("fs.defaultFS") + "/tmp/simplehistory/history.txt." + applicationAttemptId);
                FileSystem fs = historyPath.getFileSystem(miniTezCluster.getConfig());
                Path localPath = new Path(DOWNLOAD_DIR, HISTORY_TXT);
                fs.copyToLocalFile(historyPath, localPath);
            }
            File localFile = new File(DOWNLOAD_DIR, HISTORY_TXT);
            SimpleHistoryParser parser = new SimpleHistoryParser(Arrays.asList(localFile));
            dagInfo = parser.getDAGData(dagId);
            Assert.assertTrue((boolean)dagInfo.getDagId().equals(dagId));
        }
        return dagInfo;
    }

    private void verifyCriticalPath(DagInfo dagInfo, List<StepCheck[]> stepsOptions) throws Exception {
        CriticalPathAnalyzer cp = this.setupCPAnalyzer();
        cp.analyze(dagInfo);
        List criticalPath = cp.getCriticalPath();
        for (CriticalPathAnalyzer.CriticalPathStep step : criticalPath) {
            LOG.info("ABC Step: " + step.getType());
            if (step.getType() == CriticalPathAnalyzer.CriticalPathStep.EntityType.ATTEMPT) {
                LOG.info("ABC Attempt: " + step.getAttempt().getShortName() + " " + step.getAttempt().getDetailedStatus());
            }
            LOG.info("ABC Reason: " + step.getReason());
            String notes = Joiner.on((String)";").join((Iterable)step.getNotes());
            LOG.info("ABC Notes: " + notes);
        }
        boolean foundMatchingLength = false;
        for (StepCheck[] steps : stepsOptions) {
            if (steps.length + 2 != criticalPath.size()) continue;
            foundMatchingLength = true;
            Assert.assertEquals((Object)CriticalPathAnalyzer.CriticalPathStep.EntityType.VERTEX_INIT, (Object)((CriticalPathAnalyzer.CriticalPathStep)criticalPath.get(0)).getType());
            Assert.assertEquals((Object)((CriticalPathAnalyzer.CriticalPathStep)criticalPath.get(1)).getAttempt().getShortName(), (Object)((CriticalPathAnalyzer.CriticalPathStep)criticalPath.get(0)).getAttempt().getShortName());
            for (int i = 1; i < criticalPath.size() - 1; ++i) {
                StepCheck check = steps[i - 1];
                CriticalPathAnalyzer.CriticalPathStep step = (CriticalPathAnalyzer.CriticalPathStep)criticalPath.get(i);
                Assert.assertEquals((Object)CriticalPathAnalyzer.CriticalPathStep.EntityType.ATTEMPT, (Object)step.getType());
                Assert.assertTrue((String)check.getAttemptDetail(), (boolean)step.getAttempt().getShortName().matches(check.getAttemptDetail()));
                Assert.assertEquals((Object)steps[i - 1].getReason(), (Object)step.getReason());
                if (check.getErrCause() != null) {
                    Assert.assertEquals((Object)check.getErrCause(), (Object)TaskAttemptTerminationCause.valueOf((String)step.getAttempt().getTerminationCause()));
                }
                if (check.getNotesStr() == null) continue;
                String notes = Joiner.on((String)"#").join((Iterable)step.getNotes());
                for (String note : check.getNotesStr()) {
                    Assert.assertTrue((String)note, (boolean)notes.contains(notes));
                }
            }
            Assert.assertEquals((Object)CriticalPathAnalyzer.CriticalPathStep.EntityType.DAG_COMMIT, (Object)((CriticalPathAnalyzer.CriticalPathStep)criticalPath.get(criticalPath.size() - 1)).getType());
            break;
        }
        Assert.assertTrue((boolean)foundMatchingLength);
    }

    @Test(timeout=300000L)
    public void testWithATS() throws Exception {
        this.usingATS = true;
        this.createTezSessionATS();
        this.runTests();
    }

    @Test(timeout=300000L)
    public void testWithSimpleHistory() throws Exception {
        this.usingATS = false;
        this.createTezSessionSimpleHistory();
        this.runTests();
    }

    private void runTests() throws Exception {
        ApplicationId appId = tezSession.getAppMasterApplicationId();
        ArrayList stepsOptions = Lists.newArrayList();
        stepsOptions.add(this.testAttemptOfDownstreamVertexConnectedWithTwoUpstreamVerticesFailure());
        stepsOptions.add(this.testInputFailureCausesRerunOfTwoVerticesWithoutExit());
        stepsOptions.add(this.testMultiVersionInputFailureWithoutExit());
        stepsOptions.add(this.testCascadingInputFailureWithoutExitSuccess());
        stepsOptions.add(this.testTaskMultipleFailures());
        stepsOptions.add(this.testBasicInputFailureWithoutExit());
        stepsOptions.add(this.testBasicTaskFailure());
        stepsOptions.add(this.testBasicSuccessScatterGather());
        stepsOptions.add(this.testMultiVersionInputFailureWithExit());
        stepsOptions.add(this.testBasicInputFailureWithExit());
        stepsOptions.add(this.testInputFailureRerunCanSendOutputToTwoDownstreamVertices());
        stepsOptions.add(this.testCascadingInputFailureWithExitSuccess());
        stepsOptions.add(this.testInternalPreemption());
        if (tezSession != null) {
            tezSession.stop();
        }
        Thread.sleep(7500L);
        for (int i = 0; i < stepsOptions.size(); ++i) {
            this.verify(appId, i + 1, (List)stepsOptions.get(i));
        }
    }

    private List<StepCheck[]> testBasicSuccessScatterGather() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG.createDAG((String)"testBasicSuccessScatterGather", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testBasicTaskFailure() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, (String)"v1"), true);
        testConf.set(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, (String)"v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, (String)"v1"), 0);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.RETRY_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG.createDAG((String)"testBasicTaskFailure", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testTaskMultipleFailures() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, (String)"v1"), true);
        testConf.set(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, (String)"v1"), "0");
        testConf.setInt(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, (String)"v1"), 1);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.RETRY_DEPENDENCY), this.createStep("v1 : 000000_2", CriticalPathAnalyzer.CriticalPathDependency.RETRY_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG.createDAG((String)"testTaskMultipleFailures", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testBasicInputFailureWithExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, (String)"v2"), true);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v2"), "0");
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG.createDAG((String)"testBasicInputFailureWithExit", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testBasicInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v2"), true);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v2"), "0");
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG.createDAG((String)"testBasicInputFailureWithoutExit", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testMultiVersionInputFailureWithExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, (String)"v2"), true);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v2"), "0,1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v2"), "0");
        testConf.setInt(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, (String)"v2"), 1);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v1 : 000000_2", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_2", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG.createDAG((String)"testMultiVersionInputFailureWithExit", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testMultiVersionInputFailureWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleTestDAG.TEZ_SIMPLE_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v2"), true);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v2"), "0");
        testConf.setInt(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, (String)"v2"), 1);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v1 : 000000_2", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG.createDAG((String)"testMultiVersionInputFailureWithoutExit", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private void setCascadingInputFailureConfig(Configuration testConf, boolean failAndExit, int numTasks) {
        testConf.setInt(SimpleTestDAG3Vertices.TEZ_SIMPLE_DAG_NUM_TASKS, numTasks);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, (String)"v2"), failAndExit);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v2"), "-1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v2"), "1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v2"), "0");
        testConf.setInt(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, (String)"v2"), 0);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, (String)"v3"), failAndExit);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v3"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v3"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v3"), "-1");
        testConf.setInt(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, (String)"v3"), 0);
    }

    private List<StepCheck[]> testCascadingInputFailureWithoutExitSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        this.setCascadingInputFailureConfig(testConf, false, 1);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v2 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG3Vertices.createDAG((String)"testCascadingInputFailureWithoutExitSuccess", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testCascadingInputFailureWithExitSuccess() throws Exception {
        Configuration testConf = new Configuration(false);
        this.setCascadingInputFailureConfig(testConf, true, 1);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v2 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v2 : 000000_2", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v3 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG3Vertices.createDAG((String)"testCascadingInputFailureWithExitSuccess", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testInternalPreemption() throws Exception {
        Configuration testConf = new Configuration(false);
        this.setCascadingInputFailureConfig(testConf, false, 2);
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 00000[01]_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v2 : 00000[01]_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY, TaskAttemptTerminationCause.INTERNAL_PREEMPTION, null), this.createStep("v2 : 00000[01]_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY, null, Collections.singletonList("preemption of v3")), this.createStep("v2 : 00000[01]_1", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v3 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleTestDAG3Vertices.createDAG((String)"testInternalPreemption", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testInputFailureCausesRerunOfTwoVerticesWithoutExit() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleVTestDAG.TEZ_SIMPLE_V_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, (String)"v3"), false);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v3"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v3"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v3"), "-1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, (String)"v3"), "1");
        StepCheck[] check = new StepCheck[]{this.createStep("v[12] : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v[12] : 000000_[01]", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v[12] : 000000_[012]", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v[12] : 000000_[12]", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v[12] : 000000_2", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleVTestDAG.createDAG((String)"testInputFailureCausesRerunOfTwoVerticesWithoutExit", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testAttemptOfDownstreamVertexConnectedWithTwoUpstreamVerticesFailure() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleVTestDAG.TEZ_SIMPLE_V_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_DO_FAIL, (String)"v3"), true);
        testConf.set(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_TASK_INDEX, (String)"v3"), "0");
        testConf.setInt(TestProcessor.getVertexConfName((String)TestProcessor.TEZ_FAILING_PROCESSOR_FAILING_UPTO_TASK_ATTEMPT, (String)"v3"), 1);
        StepCheck[] check = new StepCheck[]{this.createStep("v[12] : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v3 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v3 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.RETRY_DEPENDENCY), this.createStep("v3 : 000000_2", CriticalPathAnalyzer.CriticalPathDependency.RETRY_DEPENDENCY)};
        DAG dag = SimpleVTestDAG.createDAG((String)"testAttemptOfDownstreamVertexConnectedWithTwoUpstreamVerticesFailure", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    private List<StepCheck[]> testInputFailureRerunCanSendOutputToTwoDownstreamVertices() throws Exception {
        Configuration testConf = new Configuration(false);
        testConf.setInt(SimpleReverseVTestDAG.TEZ_SIMPLE_REVERSE_V_DAG_NUM_TASKS, 1);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v2"), true);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, (String)"v2"), false);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v2"), "-1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v2"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v2"), "-1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, (String)"v2"), "0");
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL, (String)"v3"), true);
        testConf.setBoolean(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, (String)"v3"), false);
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_INDEX, (String)"v3"), "-1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, (String)"v3"), "0");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, (String)"v3"), "-1");
        testConf.set(TestInput.getVertexConfName((String)TestInput.TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, (String)"v3"), "0");
        StepCheck[] check = new StepCheck[]{this.createStep("v1 : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.INIT_DEPENDENCY), this.createStep("v[23] : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY), this.createStep("v1 : 000000_1", CriticalPathAnalyzer.CriticalPathDependency.OUTPUT_RECREATE_DEPENDENCY), this.createStep("v[23] : 000000_0", CriticalPathAnalyzer.CriticalPathDependency.DATA_DEPENDENCY)};
        DAG dag = SimpleReverseVTestDAG.createDAG((String)"testInputFailureRerunCanSendOutputToTwoDownstreamVertices", (Configuration)testConf);
        this.runDAG(dag, DAGStatus.State.SUCCEEDED);
        return Collections.singletonList(check);
    }

    static {
        conf = new Configuration();
        tezSession = null;
    }

    private class StepCheck {
        String attempt;
        CriticalPathAnalyzer.CriticalPathDependency reason;
        TaskAttemptTerminationCause errCause;
        List<String> notesStr;

        StepCheck(String attempt, CriticalPathAnalyzer.CriticalPathDependency reason, TaskAttemptTerminationCause cause, List<String> notes) {
            this.attempt = attempt;
            this.reason = reason;
            this.errCause = cause;
            this.notesStr = notes;
        }

        String getAttemptDetail() {
            return this.attempt;
        }

        CriticalPathAnalyzer.CriticalPathDependency getReason() {
            return this.reason;
        }

        TaskAttemptTerminationCause getErrCause() {
            return this.errCause;
        }

        List<String> getNotesStr() {
            return this.notesStr;
        }
    }
}

