/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.tests;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.app.launcher.TezTestServiceNoOpContainerLauncher;
import org.apache.tez.dag.app.rm.TezTestServiceTaskSchedulerService;
import org.apache.tez.dag.app.taskcomm.TezTestServiceTaskCommunicatorImpl;
import org.apache.tez.examples.JoinValidateConfigured;
import org.apache.tez.runtime.library.processor.SleepProcessor;
import org.apache.tez.serviceplugins.api.ContainerLauncherDescriptor;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.apache.tez.serviceplugins.api.TaskCommunicatorDescriptor;
import org.apache.tez.serviceplugins.api.TaskSchedulerDescriptor;
import org.apache.tez.tests.ExternalTezServiceTestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExternalTezServices {
    private static final Logger LOG = LoggerFactory.getLogger(TestExternalTezServices.class);
    private static final String EXT_PUSH_ENTITY_NAME = "ExtServiceTestPush";
    private static ExternalTezServiceTestHelper extServiceTestHelper;
    private static final Path SRC_DATA_DIR;
    private static final Path HASH_JOIN_EXPECTED_RESULT_PATH;
    private static final Path HASH_JOIN_OUTPUT_PATH;
    private static final Vertex.VertexExecutionContext EXECUTION_CONTEXT_EXT_SERVICE_PUSH;
    private static final Vertex.VertexExecutionContext EXECUTION_CONTEXT_REGULAR_CONTAINERS;
    private static final Vertex.VertexExecutionContext EXECUTION_CONTEXT_IN_AM;
    private static final Vertex.VertexExecutionContext EXECUTION_CONTEXT_DEFAULT;
    private static String TEST_ROOT_DIR;

    @BeforeClass
    public static void setup() throws Exception {
        extServiceTestHelper = new ExternalTezServiceTestHelper(TEST_ROOT_DIR);
        UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)extServiceTestHelper.getConfForJobs());
        TaskSchedulerDescriptor[] taskSchedulerDescriptors = new TaskSchedulerDescriptor[]{(TaskSchedulerDescriptor)TaskSchedulerDescriptor.create((String)EXT_PUSH_ENTITY_NAME, (String)TezTestServiceTaskSchedulerService.class.getName()).setUserPayload(userPayload)};
        ContainerLauncherDescriptor[] containerLauncherDescriptors = new ContainerLauncherDescriptor[]{(ContainerLauncherDescriptor)ContainerLauncherDescriptor.create((String)EXT_PUSH_ENTITY_NAME, (String)TezTestServiceNoOpContainerLauncher.class.getName()).setUserPayload(userPayload)};
        TaskCommunicatorDescriptor[] taskCommunicatorDescriptors = new TaskCommunicatorDescriptor[]{(TaskCommunicatorDescriptor)TaskCommunicatorDescriptor.create((String)EXT_PUSH_ENTITY_NAME, (String)TezTestServiceTaskCommunicatorImpl.class.getName()).setUserPayload(userPayload)};
        ServicePluginsDescriptor servicePluginsDescriptor = ServicePluginsDescriptor.create((boolean)true, (boolean)true, (TaskSchedulerDescriptor[])taskSchedulerDescriptors, (ContainerLauncherDescriptor[])containerLauncherDescriptors, (TaskCommunicatorDescriptor[])taskCommunicatorDescriptors);
        extServiceTestHelper.setupSharedTezClient(servicePluginsDescriptor);
        Path dataPath1 = new Path(SRC_DATA_DIR, "inPath1");
        Path dataPath2 = new Path(SRC_DATA_DIR, "inPath2");
        extServiceTestHelper.setupHashJoinData(SRC_DATA_DIR, dataPath1, dataPath2, HASH_JOIN_EXPECTED_RESULT_PATH, HASH_JOIN_OUTPUT_PATH);
    }

    @AfterClass
    public static void tearDown() throws IOException, TezException {
        extServiceTestHelper.tearDownAll();
    }

    @Test(timeout=60000L)
    public void testAllInService() throws Exception {
        int expectedExternalSubmissions = 7;
        this.runJoinValidate("AllInService", expectedExternalSubmissions, EXECUTION_CONTEXT_EXT_SERVICE_PUSH, EXECUTION_CONTEXT_EXT_SERVICE_PUSH, EXECUTION_CONTEXT_EXT_SERVICE_PUSH);
    }

    @Test(timeout=60000L)
    public void testAllInContainers() throws Exception {
        int expectedExternalSubmissions = 0;
        this.runJoinValidate("AllInContainers", expectedExternalSubmissions, EXECUTION_CONTEXT_REGULAR_CONTAINERS, EXECUTION_CONTEXT_REGULAR_CONTAINERS, EXECUTION_CONTEXT_REGULAR_CONTAINERS);
    }

    @Test(timeout=60000L)
    public void testAllInAM() throws Exception {
        int expectedExternalSubmissions = 0;
        this.runJoinValidate("AllInAM", expectedExternalSubmissions, EXECUTION_CONTEXT_IN_AM, EXECUTION_CONTEXT_IN_AM, EXECUTION_CONTEXT_IN_AM);
    }

    @Test(timeout=60000L)
    public void testMixed1() throws Exception {
        int expectedExternalSubmissions = 4;
        this.runJoinValidate("Mixed1", expectedExternalSubmissions, EXECUTION_CONTEXT_EXT_SERVICE_PUSH, EXECUTION_CONTEXT_EXT_SERVICE_PUSH, EXECUTION_CONTEXT_REGULAR_CONTAINERS);
    }

    @Test(timeout=60000L)
    public void testMixed2() throws Exception {
        int expectedExternalSubmissions = 3;
        this.runJoinValidate("Mixed2", expectedExternalSubmissions, EXECUTION_CONTEXT_REGULAR_CONTAINERS, EXECUTION_CONTEXT_REGULAR_CONTAINERS, EXECUTION_CONTEXT_EXT_SERVICE_PUSH);
    }

    @Test(timeout=60000L)
    public void testMixed3() throws Exception {
        int expectedExternalSubmissions = 4;
        this.runJoinValidate("Mixed3", expectedExternalSubmissions, EXECUTION_CONTEXT_EXT_SERVICE_PUSH, EXECUTION_CONTEXT_EXT_SERVICE_PUSH, EXECUTION_CONTEXT_IN_AM);
    }

    @Test(timeout=60000L)
    public void testMixed4() throws Exception {
        int expectedExternalSubmissions = 0;
        this.runJoinValidate("Mixed4", expectedExternalSubmissions, EXECUTION_CONTEXT_REGULAR_CONTAINERS, EXECUTION_CONTEXT_REGULAR_CONTAINERS, EXECUTION_CONTEXT_IN_AM);
    }

    @Test(timeout=60000L)
    public void testMixed5() throws Exception {
        int expectedExternalSubmissions = 2;
        this.runJoinValidate("Mixed5", expectedExternalSubmissions, EXECUTION_CONTEXT_REGULAR_CONTAINERS, EXECUTION_CONTEXT_EXT_SERVICE_PUSH, EXECUTION_CONTEXT_IN_AM);
    }

    @Test(timeout=60000L)
    public void testMixed6() throws Exception {
        int expectedExternalSubmissions = 3;
        this.runJoinValidate("Mixed6", expectedExternalSubmissions, EXECUTION_CONTEXT_IN_AM, EXECUTION_CONTEXT_IN_AM, EXECUTION_CONTEXT_EXT_SERVICE_PUSH);
    }

    @Test(timeout=60000L)
    public void testMixed7() throws Exception {
        int expectedExternalSubmissions = 0;
        this.runJoinValidate("Mixed7", expectedExternalSubmissions, EXECUTION_CONTEXT_IN_AM, EXECUTION_CONTEXT_IN_AM, EXECUTION_CONTEXT_REGULAR_CONTAINERS);
    }

    @Test(timeout=60000L)
    public void testErrorPropagation() throws TezException, InterruptedException, IOException {
        this.runExceptionSimulation();
    }

    private void runExceptionSimulation() throws IOException, TezException, InterruptedException {
        DAG dag = DAG.create((String)"InstrumentedFailures");
        Vertex v = Vertex.create((String)"Vertex1", (ProcessorDescriptor)ProcessorDescriptor.create((String)SleepProcessor.class.getName()), (int)3);
        v.setExecutionContext(EXECUTION_CONTEXT_EXT_SERVICE_PUSH);
        dag.addVertex(v);
        DAGClient dagClient = extServiceTestHelper.getSharedTezClient().submitDAG(dag);
        DAGStatus dagStatus = dagClient.waitForCompletion();
        Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagStatus.getState());
        Assert.assertEquals((long)1L, (long)dagStatus.getDAGProgress().getFailedTaskAttemptCount());
        Assert.assertEquals((long)1L, (long)dagStatus.getDAGProgress().getRejectedTaskAttemptCount());
    }

    private void runJoinValidate(String name, int extExpectedCount, Vertex.VertexExecutionContext lhsContext, Vertex.VertexExecutionContext rhsContext, Vertex.VertexExecutionContext validateContext) throws Exception {
        int externalSubmissionCount = extServiceTestHelper.getTezTestServiceCluster().getNumSubmissions();
        TezConfiguration tezConf = new TezConfiguration(extServiceTestHelper.getConfForJobs());
        JoinValidateConfigured joinValidate = new JoinValidateConfigured(EXECUTION_CONTEXT_DEFAULT, lhsContext, rhsContext, validateContext, name);
        String[] validateArgs = new String[]{"-disableSplitGrouping", HASH_JOIN_EXPECTED_RESULT_PATH.toString(), HASH_JOIN_OUTPUT_PATH.toString(), "3"};
        Assert.assertEquals((long)0L, (long)joinValidate.run(tezConf, validateArgs, extServiceTestHelper.getSharedTezClient()));
        Assert.assertEquals((long)extExpectedCount, (long)(extServiceTestHelper.getTezTestServiceCluster().getNumSubmissions() - externalSubmissionCount));
    }

    static {
        SRC_DATA_DIR = new Path("/tmp/" + TestExternalTezServices.class.getSimpleName());
        HASH_JOIN_EXPECTED_RESULT_PATH = new Path(SRC_DATA_DIR, "expectedOutputPath");
        HASH_JOIN_OUTPUT_PATH = new Path(SRC_DATA_DIR, "outPath");
        EXECUTION_CONTEXT_EXT_SERVICE_PUSH = Vertex.VertexExecutionContext.create((String)EXT_PUSH_ENTITY_NAME, (String)EXT_PUSH_ENTITY_NAME, (String)EXT_PUSH_ENTITY_NAME);
        EXECUTION_CONTEXT_REGULAR_CONTAINERS = Vertex.VertexExecutionContext.createExecuteInContainers((boolean)true);
        EXECUTION_CONTEXT_IN_AM = Vertex.VertexExecutionContext.createExecuteInAm((boolean)true);
        EXECUTION_CONTEXT_DEFAULT = EXECUTION_CONTEXT_EXT_SERVICE_PUSH;
        TEST_ROOT_DIR = "target/" + TestExternalTezServices.class.getName() + "-tmpDir";
    }
}

