/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.tests;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.examples.HashJoinExample;
import org.apache.tez.examples.JoinDataGen;
import org.apache.tez.service.MiniTezTestServiceCluster;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.tests.TestExternalTezServices;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalTezServiceTestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalTezServiceTestHelper.class);
    private volatile MiniTezCluster tezCluster;
    private volatile MiniDFSCluster dfsCluster;
    private volatile MiniTezTestServiceCluster tezTestServiceCluster;
    private volatile Configuration clusterConf = new Configuration();
    private volatile Configuration confForJobs;
    private volatile FileSystem remoteFs;
    private volatile TezClient sharedTezClient;

    public ExternalTezServiceTestHelper(String testRootDir) throws IOException {
        try {
            this.clusterConf.set("hdfs.minidfs.basedir", testRootDir);
            this.dfsCluster = new MiniDFSCluster.Builder(this.clusterConf).numDataNodes(1).format(true).racks(null).build();
            this.remoteFs = this.dfsCluster.getFileSystem();
            LOG.info("MiniDFSCluster started");
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        this.tezCluster = new MiniTezCluster(TestExternalTezServices.class.getName(), 1, 1, 1);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", this.remoteFs.getUri().toString());
        this.tezCluster.init(conf);
        this.tezCluster.start();
        LOG.info("MiniTezCluster started");
        this.clusterConf.set("fs.defaultFS", this.remoteFs.getUri().toString());
        for (Map.Entry entry : this.tezCluster.getConfig()) {
            this.clusterConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        long jvmMax = Runtime.getRuntime().maxMemory();
        this.tezTestServiceCluster = MiniTezTestServiceCluster.create(TestExternalTezServices.class.getSimpleName(), 3, (long)((double)jvmMax * 0.5), 1);
        this.tezTestServiceCluster.init(this.clusterConf);
        this.tezTestServiceCluster.start();
        LOG.info("MiniTezTestServer started");
        this.confForJobs = new Configuration(this.clusterConf);
        for (Map.Entry entry : this.tezTestServiceCluster.getClusterSpecificConfiguration()) {
            this.confForJobs.set((String)entry.getKey(), (String)entry.getValue());
        }
        Path stagingDirPath = new Path("/tmp/tez-staging-dir");
        this.remoteFs.mkdirs(stagingDirPath);
        this.confForJobs.set("tez.staging-dir", stagingDirPath.toString());
        this.confForJobs.setBoolean("tez.runtime.optimize.local.fetch", false);
    }

    public void setupSharedTezClient(ServicePluginsDescriptor servicePluginsDescriptor) throws IOException, TezException, InterruptedException {
        TezConfiguration tezClientConf = new TezConfiguration(this.confForJobs);
        this.sharedTezClient = TezClient.newBuilder((String)(TestExternalTezServices.class.getSimpleName() + "_session"), (TezConfiguration)tezClientConf).setIsSession(true).setServicePluginDescriptor(servicePluginsDescriptor).build();
        this.sharedTezClient.start();
        LOG.info("Shared TezSession started");
        this.sharedTezClient.waitTillReady();
        LOG.info("Shared TezSession ready for submission");
    }

    public void tearDownAll() throws IOException, TezException {
        if (this.sharedTezClient != null) {
            this.sharedTezClient.stop();
            this.sharedTezClient = null;
        }
        if (this.tezTestServiceCluster != null) {
            this.tezTestServiceCluster.stop();
            this.tezTestServiceCluster = null;
        }
        if (this.tezCluster != null) {
            this.tezCluster.stop();
            this.tezCluster = null;
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
        }
    }

    public void shutdownSharedTezClient() throws IOException, TezException {
        if (this.sharedTezClient != null) {
            this.sharedTezClient.stop();
            this.sharedTezClient = null;
        }
    }

    public void setupHashJoinData(Path srcDataDir, Path dataPath1, Path dataPath2, Path expectedResultPath, Path outputPath) throws Exception {
        this.remoteFs.mkdirs(srcDataDir);
        TezConfiguration tezConf = new TezConfiguration(this.confForJobs);
        JoinDataGen dataGen = new JoinDataGen();
        String[] dataGenArgs = new String[]{dataPath1.toString(), "1048576", dataPath2.toString(), "524288", expectedResultPath.toString(), "2"};
        Assert.assertEquals((long)0L, (long)dataGen.run(tezConf, dataGenArgs, this.sharedTezClient));
        HashJoinExample joinExample = new HashJoinExample();
        String[] args = new String[]{dataPath1.toString(), dataPath2.toString(), "2", outputPath.toString()};
        Assert.assertEquals((long)0L, (long)joinExample.run(tezConf, args, this.sharedTezClient));
        LOG.info("Completed generating Data - Expected Hash Result and Actual Join Result");
    }

    public MiniTezCluster getTezCluster() {
        return this.tezCluster;
    }

    public MiniDFSCluster getDfsCluster() {
        return this.dfsCluster;
    }

    public MiniTezTestServiceCluster getTezTestServiceCluster() {
        return this.tezTestServiceCluster;
    }

    public Configuration getClusterConf() {
        return this.clusterConf;
    }

    public Configuration getConfForJobs() {
        return this.confForJobs;
    }

    public FileSystem getRemoteFs() {
        return this.remoteFs;
    }

    public TezClient getSharedTezClient() {
        Objects.requireNonNull(this.sharedTezClient);
        return this.sharedTezClient;
    }
}

