/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.node;

import java.util.Objects;
import org.apache.hadoop.yarn.api.records.NodeId;

public class ExtendedNodeId
extends NodeId {
    private NodeId nodeId;
    private String host;
    private int port;
    private final String uniqueIdentifier;

    public ExtendedNodeId(NodeId nodeId, String uniqueIdentifier) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.uniqueIdentifier = uniqueIdentifier == null ? "" : uniqueIdentifier.trim();
    }

    public String getHost() {
        return this.nodeId.getHost();
    }

    protected void setHost(String host) {
        this.host = host;
        this.build();
    }

    public int getPort() {
        return this.nodeId.getPort();
    }

    protected void setPort(int port) {
        this.port = port;
        this.build();
    }

    protected void build() {
        this.nodeId = NodeId.newInstance((String)this.host, (int)this.port);
    }

    public String toString() {
        if (!this.uniqueIdentifier.isEmpty()) {
            return super.toString() + ":" + this.uniqueIdentifier;
        }
        return super.toString();
    }

    public int hashCode() {
        if (!this.uniqueIdentifier.isEmpty()) {
            return super.hashCode() + 31 * this.uniqueIdentifier.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExtendedNodeId amNodeId = (ExtendedNodeId)((Object)obj);
        return super.equals(obj) && Objects.equals(this.uniqueIdentifier, amNodeId.uniqueIdentifier);
    }
}

