/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.dag.api.HistoryLogLevel;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.ContainerStoppedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.history.logging.HistoryLoggingService;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHistoryEventHandler {
    private static ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
    private static ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
    private static String user = "TEST_USER";
    private Configuration baseConfig;

    @Before
    public void setupConfig() {
        this.baseConfig = new Configuration(false);
    }

    @Test
    public void testAll() {
        this.testLogLevel(null, 11);
        this.testLogLevel(HistoryLogLevel.NONE, 0);
        this.testLogLevel(HistoryLogLevel.AM, 1);
        this.testLogLevel(HistoryLogLevel.DAG, 3);
        this.testLogLevel(HistoryLogLevel.VERTEX, 4);
        this.testLogLevel(HistoryLogLevel.TASK, 5);
        this.testLogLevel(HistoryLogLevel.TASK_ATTEMPT, 9);
        this.testLogLevel(HistoryLogLevel.ALL, 11);
    }

    @Test
    public void testTaskAttemptFilters() {
        this.baseConfig.set("tez.history.logging.taskattempt-filters", "EXTERNAL_PREEMPTION,INTERRUPTED_BY_USER");
        this.testLogLevel(HistoryLogLevel.TASK_ATTEMPT, 5);
        this.testLogLevelWithRecovery(HistoryLogLevel.TASK_ATTEMPT, 5);
        this.baseConfig.set("tez.history.logging.taskattempt-filters", "EXTERNAL_PREEMPTION");
        this.testLogLevel(HistoryLogLevel.TASK_ATTEMPT, 7);
        this.testLogLevelWithRecovery(HistoryLogLevel.TASK_ATTEMPT, 7);
        this.baseConfig.set("tez.history.logging.taskattempt-filters", "INTERNAL_PREEMPTION");
        this.testLogLevel(HistoryLogLevel.TASK_ATTEMPT, 9);
        this.testLogLevelWithRecovery(HistoryLogLevel.TASK_ATTEMPT, 9);
    }

    @Test
    public void testWithDAGRecovery() {
        this.testLogLevelWithRecovery(null, 11);
        this.testLogLevelWithRecovery(HistoryLogLevel.AM, 1);
        this.testLogLevelWithRecovery(HistoryLogLevel.DAG, 3);
        this.testLogLevelWithRecovery(HistoryLogLevel.VERTEX, 4);
        this.testLogLevelWithRecovery(HistoryLogLevel.TASK, 5);
        this.testLogLevelWithRecovery(HistoryLogLevel.TASK_ATTEMPT, 9);
        this.testLogLevelWithRecovery(HistoryLogLevel.ALL, 11);
    }

    @Test
    public void testMultipleDag() {
        this.testLogLevel(null, HistoryLogLevel.NONE, 14);
        this.testLogLevel(null, HistoryLogLevel.AM, 14);
        this.testLogLevel(null, HistoryLogLevel.DAG, 16);
        this.testLogLevel(null, HistoryLogLevel.VERTEX, 17);
        this.testLogLevel(null, HistoryLogLevel.TASK, 18);
        this.testLogLevel(null, HistoryLogLevel.TASK_ATTEMPT, 22);
        this.testLogLevel(null, HistoryLogLevel.ALL, 22);
        this.testLogLevel(HistoryLogLevel.VERTEX, HistoryLogLevel.NONE, 5);
        this.testLogLevel(HistoryLogLevel.VERTEX, HistoryLogLevel.AM, 5);
        this.testLogLevel(HistoryLogLevel.VERTEX, HistoryLogLevel.DAG, 7);
        this.testLogLevel(HistoryLogLevel.VERTEX, HistoryLogLevel.VERTEX, 8);
        this.testLogLevel(HistoryLogLevel.VERTEX, HistoryLogLevel.TASK, 9);
        this.testLogLevel(HistoryLogLevel.VERTEX, HistoryLogLevel.TASK_ATTEMPT, 13);
        this.testLogLevel(HistoryLogLevel.VERTEX, HistoryLogLevel.ALL, 13);
        this.testLogLevel(HistoryLogLevel.NONE, HistoryLogLevel.NONE, 0);
    }

    private void testLogLevelWithRecovery(HistoryLogLevel level, int expectedCount) {
        HistoryEventHandler handler = this.createHandler(level);
        InMemoryHistoryLoggingService.events.clear();
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        List<DAGHistoryEvent> events = this.makeHistoryEvents(dagId, handler.getConfig());
        events.set(1, new DAGHistoryEvent(dagId, (HistoryEvent)new DAGRecoveredEvent(attemptId, dagId, "test", user, 0L, null)));
        for (DAGHistoryEvent event : events) {
            handler.handle(event);
        }
        Assert.assertEquals((String)("Failed for level: " + level), (long)expectedCount, (long)InMemoryHistoryLoggingService.events.size());
        handler.stop();
    }

    private void testLogLevel(HistoryLogLevel level, int expectedCount) {
        HistoryEventHandler handler = this.createHandler(level);
        InMemoryHistoryLoggingService.events.clear();
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId, handler.getConfig())) {
            handler.handle(event);
        }
        Assert.assertEquals((String)("Failed for level: " + level), (long)expectedCount, (long)InMemoryHistoryLoggingService.events.size());
        handler.stop();
    }

    private void testLogLevel(HistoryLogLevel defaultLogLevel, HistoryLogLevel dagLogLevel, int expectedCount) {
        HistoryEventHandler handler = this.createHandler(defaultLogLevel);
        InMemoryHistoryLoggingService.events.clear();
        TezDAGID dagId1 = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId1, handler.getConfig())) {
            handler.handle(event);
        }
        TezDAGID dagId2 = TezDAGID.getInstance((ApplicationId)appId, (int)2);
        Configuration conf = new Configuration(handler.getConfig());
        conf.setEnum("tez.history.logging.log.level", (Enum)dagLogLevel);
        for (DAGHistoryEvent event : this.makeHistoryEvents(dagId2, conf)) {
            handler.handle(event);
        }
        Assert.assertEquals((long)expectedCount, (long)InMemoryHistoryLoggingService.events.size());
        handler.stop();
    }

    private HistoryEventHandler createHandler(HistoryLogLevel logLevel) {
        Configuration conf = new Configuration(this.baseConfig);
        conf.setBoolean("tez.dag.recovery.enabled", false);
        conf.set("tez.history.logging.service.class", InMemoryHistoryLoggingService.class.getName());
        if (logLevel != null) {
            conf.setEnum("tez.history.logging.log.level", (Enum)logLevel);
        }
        DAG dag = (DAG)Mockito.mock(DAG.class);
        Mockito.when((Object)dag.getConf()).thenReturn((Object)conf);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new HadoopShim(){});
        Mockito.when((Object)appContext.getAMConf()).thenReturn((Object)conf);
        Mockito.when((Object)appContext.getCurrentDAG()).thenReturn((Object)dag);
        HistoryEventHandler handler = new HistoryEventHandler(appContext);
        handler.init(conf);
        return handler;
    }

    private List<DAGHistoryEvent> makeHistoryEvents(TezDAGID dagId, Configuration inConf) {
        ArrayList<DAGHistoryEvent> historyEvents = new ArrayList<DAGHistoryEvent>();
        long time = System.currentTimeMillis();
        Configuration conf = new Configuration(inConf);
        historyEvents.add(new DAGHistoryEvent(null, (HistoryEvent)new AMStartedEvent(attemptId, time, user)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new DAGSubmittedEvent(dagId, time, DAGProtos.DAGPlan.getDefaultInstance(), attemptId, null, user, conf, null, "default")));
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new VertexStartedEvent(vertexID, time, time)));
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)dagId.getId());
        TezTaskID tezTaskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskStartedEvent(tezTaskID, "test", time, time)));
        historyEvents.add(new DAGHistoryEvent((HistoryEvent)new ContainerLaunchedEvent(containerId, time, attemptId)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)tezTaskID, (int)1), "test", time, containerId, NodeId.newInstance((String)"localhost", (int)8765), null, null, null)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)tezTaskID, (int)1), "test", time, time + 1L, TaskAttemptState.KILLED, null, TaskAttemptTerminationCause.EXTERNAL_PREEMPTION, "", null, null, null, time, null, time, containerId, NodeId.newInstance((String)"localhost", (int)8765), null, null, null)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)tezTaskID, (int)2), "test", time, containerId, NodeId.newInstance((String)"localhost", (int)8765), null, null, null)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)tezTaskID, (int)2), "test", time + 2L, time + 3L, TaskAttemptState.KILLED, null, TaskAttemptTerminationCause.INTERRUPTED_BY_USER, "", null, null, null, time, null, time + 2L, containerId, NodeId.newInstance((String)"localhost", (int)8765), null, null, null)));
        historyEvents.add(new DAGHistoryEvent(dagId, (HistoryEvent)new DAGFinishedEvent(dagId, time, time, DAGState.SUCCEEDED, null, null, user, "test", null, attemptId, DAGProtos.DAGPlan.getDefaultInstance())));
        historyEvents.add(new DAGHistoryEvent((HistoryEvent)new ContainerStoppedEvent(containerId, time + 4L, 0, attemptId)));
        return historyEvents;
    }

    public static class InMemoryHistoryLoggingService
    extends HistoryLoggingService {
        static List<DAGHistoryEvent> events = new ArrayList<DAGHistoryEvent>();

        public InMemoryHistoryLoggingService() {
            super("InMemoryHistoryLoggingService");
        }

        public void handle(DAGHistoryEvent event) {
            events.add(event);
        }
    }
}

