/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TaskIDAware;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class TaskStartedEvent
implements HistoryEvent,
TaskIDAware {
    private TezTaskID taskID;
    private String vertexName;
    private long scheduledTime;
    private long startTime;
    private TaskState state;

    public TaskStartedEvent(TezTaskID taskId, String vertexName, long scheduledTime, long startTime) {
        this(taskId, vertexName, scheduledTime, startTime, TaskState.SCHEDULED);
    }

    public TaskStartedEvent(TezTaskID taskId, String vertexName, long scheduledTime, long startTime, TaskState state) {
        this.vertexName = vertexName;
        this.taskID = taskId;
        this.scheduledTime = scheduledTime;
        this.startTime = startTime;
        this.state = state;
    }

    public TaskStartedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskStartedProto toProto() {
        return RecoveryProtos.TaskStartedProto.newBuilder().setTaskId(this.taskID.toString()).setLaunchTime(this.startTime).setScheduledTime(this.scheduledTime).build();
    }

    public void fromProto(RecoveryProtos.TaskStartedProto proto) {
        this.taskID = TezTaskID.fromString((String)proto.getTaskId());
        this.startTime = proto.getLaunchTime();
        this.scheduledTime = proto.getScheduledTime();
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.TaskStartedProto proto = (RecoveryProtos.TaskStartedProto)inputStream.readMessage(RecoveryProtos.TaskStartedProto.PARSER, ExtensionRegistryLite.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskId=" + this.taskID.toString() + ", scheduledTime=" + this.scheduledTime + ", launchTime=" + this.startTime;
    }

    public TezTaskID getTaskID() {
        return this.taskID;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TaskState getState() {
        return this.state;
    }
}

