/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventUserServiceFatalError;
import org.apache.tez.dag.app.dag.event.DAGEventTerminateDag;
import org.apache.tez.dag.app.launcher.ContainerLauncherManager;
import org.apache.tez.dag.app.rm.ContainerLauncherEvent;
import org.apache.tez.dag.app.rm.ContainerLauncherLaunchRequestEvent;
import org.apache.tez.dag.app.rm.ContainerLauncherStopRequestEvent;
import org.apache.tez.dag.helpers.DagInfoImplForTest;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.serviceplugins.api.ContainerLaunchRequest;
import org.apache.tez.serviceplugins.api.ContainerLauncher;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.ContainerStopRequest;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.apache.tez.serviceplugins.api.ServicePluginErrorDefaults;
import org.apache.tez.serviceplugins.api.ServicePluginException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestContainerLauncherManager {
    private static final String DAG_NAME = "dagName";
    private static final int DAG_INDEX = 1;

    @Before
    @After
    public void resetTest() {
        ContainerLaucherRouterForMultipleLauncherTest.reset();
    }

    @Test(timeout=5000L)
    public void testNoLaunchersSpecified() throws IOException, TezException {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        TaskCommunicatorManagerInterface tal = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        try {
            new ContainerLaucherRouterForMultipleLauncherTest(appContext, tal, null, null, false);
            Assert.fail((String)"Expecting a failure without any launchers being specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testCustomLauncherSpecified() throws IOException, TezException {
        Configuration conf = new Configuration(false);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        TaskCommunicatorManagerInterface tal = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        String customLauncherName = "customLauncher";
        LinkedList<NamedEntityDescriptor> launcherDescriptors = new LinkedList<NamedEntityDescriptor>();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 3);
        UserPayload customPayload = UserPayload.create((ByteBuffer)bb);
        launcherDescriptors.add(new NamedEntityDescriptor(customLauncherName, FakeContainerLauncher.class.getName()).setUserPayload(customPayload));
        ContainerLaucherRouterForMultipleLauncherTest clr = new ContainerLaucherRouterForMultipleLauncherTest(appContext, tal, null, launcherDescriptors, true);
        try {
            clr.init(conf);
            clr.start();
            Assert.assertEquals((long)1L, (long)clr.getNumContainerLaunchers());
            Assert.assertFalse((boolean)clr.getYarnContainerLauncherCreated());
            Assert.assertFalse((boolean)clr.getUberContainerLauncherCreated());
            Assert.assertEquals((Object)customLauncherName, (Object)clr.getContainerLauncherName(0));
            Assert.assertEquals((Object)bb, (Object)clr.getContainerLauncherContext(0).getInitialUserPayload().getPayload());
        }
        finally {
            clr.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMultipleContainerLaunchers() throws IOException, TezException {
        Configuration conf = new Configuration(false);
        conf.set("testkey", "testvalue");
        UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        TaskCommunicatorManagerInterface tal = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        String customLauncherName = "customLauncher";
        LinkedList<NamedEntityDescriptor> launcherDescriptors = new LinkedList<NamedEntityDescriptor>();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 3);
        UserPayload customPayload = UserPayload.create((ByteBuffer)bb);
        launcherDescriptors.add(new NamedEntityDescriptor(customLauncherName, FakeContainerLauncher.class.getName()).setUserPayload(customPayload));
        launcherDescriptors.add(new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(userPayload));
        ContainerLaucherRouterForMultipleLauncherTest clr = new ContainerLaucherRouterForMultipleLauncherTest(appContext, tal, null, launcherDescriptors, true);
        try {
            clr.init(conf);
            clr.start();
            Assert.assertEquals((long)2L, (long)clr.getNumContainerLaunchers());
            Assert.assertTrue((boolean)clr.getYarnContainerLauncherCreated());
            Assert.assertFalse((boolean)clr.getUberContainerLauncherCreated());
            Assert.assertEquals((Object)customLauncherName, (Object)clr.getContainerLauncherName(0));
            Assert.assertEquals((Object)bb, (Object)clr.getContainerLauncherContext(0).getInitialUserPayload().getPayload());
            Assert.assertEquals((Object)TezConstants.getTezYarnServicePluginName(), (Object)clr.getContainerLauncherName(1));
            Configuration confParsed = TezUtils.createConfFromUserPayload((UserPayload)clr.getContainerLauncherContext(1).getInitialUserPayload());
            Assert.assertEquals((Object)"testvalue", (Object)confParsed.get("testkey"));
        }
        finally {
            clr.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testEventRouting() throws Exception {
        Configuration conf = new Configuration(false);
        UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        TaskCommunicatorManagerInterface tal = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        String customLauncherName = "customLauncher";
        LinkedList<NamedEntityDescriptor> launcherDescriptors = new LinkedList<NamedEntityDescriptor>();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 3);
        UserPayload customPayload = UserPayload.create((ByteBuffer)bb);
        launcherDescriptors.add(new NamedEntityDescriptor(customLauncherName, FakeContainerLauncher.class.getName()).setUserPayload(customPayload));
        launcherDescriptors.add(new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(userPayload));
        ContainerLaucherRouterForMultipleLauncherTest clr = new ContainerLaucherRouterForMultipleLauncherTest(appContext, tal, null, launcherDescriptors, true);
        try {
            clr.init(conf);
            clr.start();
            Assert.assertEquals((long)2L, (long)clr.getNumContainerLaunchers());
            Assert.assertTrue((boolean)clr.getYarnContainerLauncherCreated());
            Assert.assertFalse((boolean)clr.getUberContainerLauncherCreated());
            Assert.assertEquals((Object)customLauncherName, (Object)clr.getContainerLauncherName(0));
            Assert.assertEquals((Object)TezConstants.getTezYarnServicePluginName(), (Object)clr.getContainerLauncherName(1));
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(0))).initialize();
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(0))).start();
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(1))).initialize();
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(1))).start();
            ContainerLaunchContext clc1 = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
            Container container1 = (Container)Mockito.mock(Container.class);
            ContainerLaunchContext clc2 = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
            Container container2 = (Container)Mockito.mock(Container.class);
            ContainerLauncherLaunchRequestEvent launchRequestEvent1 = new ContainerLauncherLaunchRequestEvent(clc1, container1, 0, 0, 0);
            ContainerLauncherLaunchRequestEvent launchRequestEvent2 = new ContainerLauncherLaunchRequestEvent(clc2, container2, 1, 0, 0);
            clr.handle((ContainerLauncherEvent)launchRequestEvent1);
            ArgumentCaptor captor = ArgumentCaptor.forClass(ContainerLaunchRequest.class);
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(0))).launchContainer((ContainerLaunchRequest)captor.capture());
            Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
            ContainerLaunchRequest launchRequest1 = (ContainerLaunchRequest)captor.getValue();
            Assert.assertEquals((Object)clc1, (Object)launchRequest1.getContainerLaunchContext());
            clr.handle((ContainerLauncherEvent)launchRequestEvent2);
            captor = ArgumentCaptor.forClass(ContainerLaunchRequest.class);
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(1))).launchContainer((ContainerLaunchRequest)captor.capture());
            Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
            ContainerLaunchRequest launchRequest2 = (ContainerLaunchRequest)captor.getValue();
            Assert.assertEquals((Object)clc2, (Object)launchRequest2.getContainerLaunchContext());
        }
        finally {
            clr.stop();
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(0))).shutdown();
            ((ContainerLauncher)Mockito.verify((Object)clr.getTestContainerLauncher(1))).shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testReportFailureFromContainerLauncher() throws ServicePluginException, TezException {
        String dagName = DAG_NAME;
        boolean dagIndex = true;
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)1);
        DAG dag = (DAG)Mockito.mock(DAG.class);
        ((DAG)Mockito.doReturn((Object)DAG_NAME).when((Object)dag)).getName();
        ((DAG)Mockito.doReturn((Object)dagId).when((Object)dag)).getID();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)eventHandler).when((Object)appContext)).getEventHandler();
        ((AppContext)Mockito.doReturn((Object)dag).when((Object)appContext)).getCurrentDAG();
        ((AppContext)Mockito.doReturn((Object)"testlauncher").when((Object)appContext)).getContainerLauncherName(0);
        NamedEntityDescriptor taskCommDescriptor = new NamedEntityDescriptor("testlauncher", ContainerLauncherForTest.class.getName());
        LinkedList<NamedEntityDescriptor> list = new LinkedList<NamedEntityDescriptor>();
        list.add(taskCommDescriptor);
        ContainerLauncherManager containerLauncherManager = new ContainerLauncherManager(appContext, (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class), "", list, false);
        try {
            ContainerLaunchContext clc1 = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
            Container container1 = (Container)Mockito.mock(Container.class);
            ContainerLauncherLaunchRequestEvent launchRequestEvent = new ContainerLauncherLaunchRequestEvent(clc1, container1, 0, 0, 0);
            containerLauncherManager.handle((ContainerLauncherEvent)launchRequestEvent);
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
            Event rawEvent = (Event)argumentCaptor.getValue();
            Assert.assertTrue((boolean)(rawEvent instanceof DAGAppMasterEventUserServiceFatalError));
            DAGAppMasterEventUserServiceFatalError event = (DAGAppMasterEventUserServiceFatalError)rawEvent;
            Assert.assertEquals((Object)DAGAppMasterEventType.CONTAINER_LAUNCHER_SERVICE_FATAL_ERROR, (Object)event.getType());
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("ReportedFatalError"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains(ServicePluginErrorDefaults.INCONSISTENT_STATE.name()));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("[0:testlauncher]"));
            Mockito.reset((Object[])new EventHandler[]{eventHandler});
            ContainerId containerId2 = (ContainerId)Mockito.mock(ContainerId.class);
            NodeId nodeId2 = (NodeId)Mockito.mock(NodeId.class);
            ContainerLauncherStopRequestEvent stopRequestEvent = new ContainerLauncherStopRequestEvent(containerId2, nodeId2, null, 0, 0, 0);
            argumentCaptor = ArgumentCaptor.forClass(Event.class);
            containerLauncherManager.handle((ContainerLauncherEvent)stopRequestEvent);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
            rawEvent = (Event)argumentCaptor.getValue();
            Assert.assertTrue((boolean)(rawEvent instanceof DAGEventTerminateDag));
            DAGEventTerminateDag killEvent = (DAGEventTerminateDag)rawEvent;
            Assert.assertTrue((boolean)killEvent.getDiagnosticInfo().contains("ReportError"));
            Assert.assertTrue((boolean)killEvent.getDiagnosticInfo().contains(ServicePluginErrorDefaults.SERVICE_UNAVAILABLE.name()));
            Assert.assertTrue((boolean)killEvent.getDiagnosticInfo().contains("[0:testlauncher]"));
        }
        finally {
            containerLauncherManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testContainerLauncherUserError() throws ServicePluginException {
        ContainerLauncher containerLauncher = (ContainerLauncher)Mockito.mock(ContainerLauncher.class);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)eventHandler).when((Object)appContext)).getEventHandler();
        ((AppContext)Mockito.doReturn((Object)"testlauncher").when((Object)appContext)).getContainerLauncherName(0);
        Configuration conf = new Configuration(false);
        ContainerLauncherManager containerLauncherManager = new ContainerLauncherManager(appContext);
        containerLauncherManager.setContainerLauncher(containerLauncher);
        try {
            containerLauncherManager.init(conf);
            containerLauncherManager.start();
            ((ContainerLauncher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("testexception")}).when((Object)containerLauncher)).launchContainer((ContainerLaunchRequest)Mockito.any());
            ContainerLaunchContext clc1 = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
            Container container1 = (Container)Mockito.mock(Container.class);
            ContainerLauncherLaunchRequestEvent launchRequestEvent = new ContainerLauncherLaunchRequestEvent(clc1, container1, 0, 0, 0);
            containerLauncherManager.handle((ContainerLauncherEvent)launchRequestEvent);
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Event.class);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
            Event rawEvent = (Event)argumentCaptor.getValue();
            Assert.assertTrue((boolean)(rawEvent instanceof DAGAppMasterEventUserServiceFatalError));
            DAGAppMasterEventUserServiceFatalError event = (DAGAppMasterEventUserServiceFatalError)rawEvent;
            Assert.assertEquals((Object)DAGAppMasterEventType.CONTAINER_LAUNCHER_SERVICE_FATAL_ERROR, (Object)event.getType());
            Assert.assertTrue((boolean)event.getError().getMessage().contains("testexception"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("launching container"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("[0:testlauncher]"));
            Mockito.reset((Object[])new EventHandler[]{eventHandler});
            ((ContainerLauncher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("teststopexception")}).when((Object)containerLauncher)).stopContainer((ContainerStopRequest)Mockito.any());
            ContainerId containerId2 = (ContainerId)Mockito.mock(ContainerId.class);
            NodeId nodeId2 = (NodeId)Mockito.mock(NodeId.class);
            ContainerLauncherStopRequestEvent stopRequestEvent = new ContainerLauncherStopRequestEvent(containerId2, nodeId2, null, 0, 0, 0);
            argumentCaptor = ArgumentCaptor.forClass(Event.class);
            containerLauncherManager.handle((ContainerLauncherEvent)stopRequestEvent);
            ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)argumentCaptor.capture());
            rawEvent = (Event)argumentCaptor.getValue();
            Assert.assertTrue((boolean)(rawEvent instanceof DAGAppMasterEventUserServiceFatalError));
            event = (DAGAppMasterEventUserServiceFatalError)rawEvent;
            Assert.assertTrue((boolean)event.getError().getMessage().contains("teststopexception"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("stopping container"));
            Assert.assertTrue((boolean)event.getDiagnosticInfo().contains("[0:testlauncher]"));
        }
        finally {
            containerLauncherManager.stop();
        }
    }

    public static class ContainerLauncherForTest
    extends ContainerLauncher {
        public ContainerLauncherForTest(ContainerLauncherContext containerLauncherContext) {
            super(containerLauncherContext);
        }

        public void launchContainer(ContainerLaunchRequest launchRequest) throws ServicePluginException {
            this.getContext().reportError((ServicePluginError)ServicePluginErrorDefaults.INCONSISTENT_STATE, "ReportedFatalError", null);
        }

        public void stopContainer(ContainerStopRequest stopRequest) throws ServicePluginException {
            this.getContext().reportError((ServicePluginError)ServicePluginErrorDefaults.SERVICE_UNAVAILABLE, "ReportError", (DagInfo)new DagInfoImplForTest(1, TestContainerLauncherManager.DAG_NAME));
        }
    }

    public static class FakeContainerLauncher
    extends ContainerLauncher {
        public FakeContainerLauncher(ContainerLauncherContext containerLauncherContext) {
            super(containerLauncherContext);
        }

        public void launchContainer(ContainerLaunchRequest launchRequest) {
        }

        public void stopContainer(ContainerStopRequest stopRequest) {
        }
    }

    private static class ContainerLaucherRouterForMultipleLauncherTest
    extends ContainerLauncherManager {
        private static final AtomicInteger numContainerLaunchers = new AtomicInteger(0);
        private static final Set<Integer> containerLauncherIndices = new HashSet<Integer>();
        private static final ContainerLauncher yarnContainerLauncher = (ContainerLauncher)Mockito.mock(ContainerLauncher.class);
        private static final ContainerLauncher uberContainerlauncher = (ContainerLauncher)Mockito.mock(ContainerLauncher.class);
        private static final AtomicBoolean yarnContainerLauncherCreated = new AtomicBoolean(false);
        private static final AtomicBoolean uberContainerLauncherCreated = new AtomicBoolean(false);
        private static final List<ContainerLauncherContext> containerLauncherContexts = new LinkedList<ContainerLauncherContext>();
        private static final List<String> containerLauncherNames = new LinkedList<String>();
        private static final List<ContainerLauncher> testContainerLaunchers = new LinkedList<ContainerLauncher>();

        public static void reset() {
            numContainerLaunchers.set(0);
            containerLauncherIndices.clear();
            yarnContainerLauncherCreated.set(false);
            uberContainerLauncherCreated.set(false);
            containerLauncherContexts.clear();
            containerLauncherNames.clear();
            testContainerLaunchers.clear();
        }

        public ContainerLaucherRouterForMultipleLauncherTest(AppContext context, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, List<NamedEntityDescriptor> containerLauncherDescriptors, boolean isPureLocalMode) throws UnknownHostException, TezException {
            super(context, taskCommunicatorManagerInterface, workingDirectory, containerLauncherDescriptors, isPureLocalMode);
        }

        ContainerLauncher createContainerLauncher(NamedEntityDescriptor containerLauncherDescriptor, AppContext context, ContainerLauncherContext containerLauncherContext, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, int containerLauncherIndex, boolean isPureLocalMode) throws TezException {
            numContainerLaunchers.incrementAndGet();
            boolean added = containerLauncherIndices.add(containerLauncherIndex);
            Assert.assertTrue((String)"Cannot add multiple launchers with the same index", (boolean)added);
            containerLauncherNames.add(containerLauncherDescriptor.getEntityName());
            containerLauncherContexts.add(containerLauncherContext);
            return super.createContainerLauncher(containerLauncherDescriptor, context, containerLauncherContext, taskCommunicatorManagerInterface, workingDirectory, containerLauncherIndex, isPureLocalMode);
        }

        ContainerLauncher createYarnContainerLauncher(ContainerLauncherContext containerLauncherContext) {
            yarnContainerLauncherCreated.set(true);
            testContainerLaunchers.add(yarnContainerLauncher);
            return yarnContainerLauncher;
        }

        ContainerLauncher createUberContainerLauncher(ContainerLauncherContext containerLauncherContext, AppContext context, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, boolean isPureLocalMode) {
            uberContainerLauncherCreated.set(true);
            testContainerLaunchers.add(uberContainerlauncher);
            return uberContainerlauncher;
        }

        ContainerLauncher createCustomContainerLauncher(ContainerLauncherContext containerLauncherContext, NamedEntityDescriptor containerLauncherDescriptor) throws TezException {
            ContainerLauncher spyLauncher = (ContainerLauncher)Mockito.spy((Object)super.createCustomContainerLauncher(containerLauncherContext, containerLauncherDescriptor));
            testContainerLaunchers.add(spyLauncher);
            return spyLauncher;
        }

        public int getNumContainerLaunchers() {
            return numContainerLaunchers.get();
        }

        public boolean getYarnContainerLauncherCreated() {
            return yarnContainerLauncherCreated.get();
        }

        public boolean getUberContainerLauncherCreated() {
            return uberContainerLauncherCreated.get();
        }

        public String getContainerLauncherName(int containerLauncherIndex) {
            return containerLauncherNames.get(containerLauncherIndex);
        }

        public ContainerLauncher getTestContainerLauncher(int containerLauncherIndex) {
            return testContainerLaunchers.get(containerLauncherIndex);
        }

        public ContainerLauncherContext getContainerLauncherContext(int containerLauncherIndex) {
            return containerLauncherContexts.get(containerLauncherIndex);
        }
    }
}

