/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.TezAbstractEvent;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.TaskStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptKilled;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventKillRequest;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventOutputFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStartedRemotely;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSubmitted;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventTerminationCauseEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventScheduleTask;
import org.apache.tez.dag.app.dag.event.TaskEventTAFailed;
import org.apache.tez.dag.app.dag.event.TaskEventTAKilled;
import org.apache.tez.dag.app.dag.event.TaskEventTALaunched;
import org.apache.tez.dag.app.dag.event.TaskEventTASucceeded;
import org.apache.tez.dag.app.dag.event.TaskEventTermination;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TaskImpl;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TezBuilderUtils;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTaskImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestTaskImpl.class);
    private int taskCounter = 0;
    private final int partition = 1;
    private Configuration conf;
    private TaskCommunicatorManagerInterface taskCommunicatorManagerInterface;
    private TaskHeartbeatHandler taskHeartbeatHandler;
    private Credentials credentials;
    private Clock clock;
    private TaskLocationHint locationHint;
    private ApplicationId appId;
    private TezDAGID dagId;
    private TezVertexID vertexId;
    private AppContext appContext;
    private Resource taskResource;
    private Map<String, LocalResource> localResources;
    private Map<String, String> environment;
    private String javaOpts;
    private boolean leafVertex;
    private ContainerContext containerContext;
    private ContainerId mockContainerId;
    private Container mockContainer;
    private AMContainer mockAMContainer;
    private NodeId mockNodeId;
    private HistoryEventHandler mockHistoryHandler;
    private MockTaskImpl mockTask;
    private TaskSpec mockTaskSpec;
    private Vertex mockVertex;
    private TestEventHandler eventHandler;

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.conf.setInt("tez.am.task.max.failed.attempts", 4);
        this.taskCommunicatorManagerInterface = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        this.taskHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        this.credentials = new Credentials();
        this.clock = new SystemClock();
        this.locationHint = TaskLocationHint.createTaskLocationHint(null, null);
        this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.dagId = TezDAGID.getInstance((ApplicationId)this.appId, (int)1);
        this.vertexId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)1);
        this.appContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.appContext.getDAGRecoveryData()).thenReturn(null);
        this.appContext.setDAGRecoveryData(null);
        this.mockContainerId = (ContainerId)Mockito.mock(ContainerId.class);
        this.mockContainer = (Container)Mockito.mock(Container.class);
        this.mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        Mockito.when((Object)this.mockAMContainer.getContainer()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockContainer.getNodeHttpAddress()).thenReturn((Object)"localhost:1234");
        this.mockNodeId = (NodeId)Mockito.mock(NodeId.class);
        this.mockHistoryHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
        Mockito.when((Object)this.mockContainer.getId()).thenReturn((Object)this.mockContainerId);
        Mockito.when((Object)this.mockContainer.getNodeId()).thenReturn((Object)this.mockNodeId);
        Mockito.when((Object)this.mockAMContainer.getContainer()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.appContext.getAllContainers().get(this.mockContainerId)).thenReturn((Object)this.mockAMContainer);
        Mockito.when((Object)this.appContext.getHistoryHandler()).thenReturn((Object)this.mockHistoryHandler);
        this.taskResource = Resource.newInstance((int)1024, (int)1);
        this.localResources = new HashMap<String, LocalResource>();
        this.environment = new HashMap<String, String>();
        this.javaOpts = "";
        this.leafVertex = false;
        this.containerContext = new ContainerContext(this.localResources, this.credentials, this.environment, this.javaOpts);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(this.conf)).when((Object)vertex)).getVertexConfig();
        this.eventHandler = new TestEventHandler();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.taskResource, this.containerContext, vertex);
        this.mockTaskSpec = (TaskSpec)Mockito.mock(TaskSpec.class);
        this.mockVertex = (Vertex)Mockito.mock(Vertex.class);
        ServicePluginInfo servicePluginInfo = new ServicePluginInfo().setContainerLauncherName(TezConstants.getTezYarnServicePluginName());
        Mockito.when((Object)this.mockVertex.getServicePluginInfo()).thenReturn((Object)servicePluginInfo);
        Mockito.when((Object)this.mockVertex.getVertexConfig()).thenReturn((Object)new VertexImpl.VertexConfigImpl(this.conf));
    }

    private TezTaskID getNewTaskID() {
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)this.vertexId, (int)(++this.taskCounter));
        return taskID;
    }

    private void scheduleTaskAttempt(TezTaskID taskId) {
        this.mockTask.handle((TaskEvent)new TaskEventScheduleTask(taskId, this.mockTaskSpec, this.locationHint, false));
        this.assertTaskScheduledState();
        Assert.assertEquals((Object)this.mockTaskSpec, (Object)this.mockTask.getBaseTaskSpec());
        Assert.assertEquals((Object)this.locationHint, (Object)this.mockTask.getTaskLocationHint());
    }

    private void scheduleTaskAttempt(TezTaskID taskId, TaskState expectedState) {
        this.mockTask.handle((TaskEvent)new TaskEventScheduleTask(taskId, this.mockTaskSpec, this.locationHint, false));
        Assert.assertEquals((Object)expectedState, (Object)this.mockTask.getState());
        Assert.assertEquals((Object)this.mockTaskSpec, (Object)this.mockTask.getBaseTaskSpec());
        Assert.assertEquals((Object)this.locationHint, (Object)this.mockTask.getTaskLocationHint());
    }

    private void sendTezEventsToTask(TezTaskID taskId, int numTezEvents) {
        EventMetaData eventMetaData = new EventMetaData();
        DataMovementEvent dmEvent = DataMovementEvent.create(null);
        TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)dmEvent, eventMetaData);
        for (int i = 0; i < numTezEvents; ++i) {
            this.mockTask.registerTezEvent(tezEvent);
        }
    }

    private void killTask(TezTaskID taskId) {
        this.mockTask.handle((TaskEvent)new TaskEventTermination(taskId, TaskAttemptTerminationCause.TERMINATED_AT_SHUTDOWN, null));
        this.assertTaskKillWaitState();
    }

    private void failTask(TezTaskID taskId) {
        this.mockTask.handle((TaskEvent)new TaskEventTermination(taskId, TaskAttemptTerminationCause.TERMINATED_AT_SHUTDOWN, null));
        this.assertTaskKillWaitState();
    }

    private TaskEventTAKilled createTaskTAKilledEvent(TezTaskAttemptID taskAttemptId) {
        return this.createTaskTAKilledEvent(taskAttemptId, null);
    }

    private TaskEventTAKilled createTaskTAKilledEvent(TezTaskAttemptID taskAttemptId, TezAbstractEvent causalEvent) {
        return new TaskEventTAKilled(taskAttemptId, causalEvent);
    }

    private TaskEventTAFailed createTaskTAFailedEvent(TezTaskAttemptID taskAttemptId) {
        return this.createTaskTAFailedEvent(taskAttemptId, TaskFailureType.NON_FATAL, null);
    }

    private TaskEventTAFailed createTaskTAFailedEvent(TezTaskAttemptID taskAttemptId, TaskFailureType taskFailureType, TezAbstractEvent causalEvent) {
        return new TaskEventTAFailed(taskAttemptId, taskFailureType, causalEvent);
    }

    private TaskEventTALaunched createTaskTALauncherEvent(TezTaskAttemptID taskAttemptId) {
        return new TaskEventTALaunched(taskAttemptId);
    }

    private TaskEventTASucceeded createTaskTASucceededEvent(TezTaskAttemptID taskAttemptId) {
        return new TaskEventTASucceeded(taskAttemptId);
    }

    private TaskEvent createTaskTAAddSpecAttempt(TezTaskAttemptID taskAttemptId) {
        return new TaskEvent(taskAttemptId.getTaskID(), TaskEventType.T_ADD_SPEC_ATTEMPT);
    }

    private void killScheduledTaskAttempt(TezTaskAttemptID attemptId) {
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(attemptId));
        this.assertTaskScheduledState();
    }

    private void launchTaskAttempt(TezTaskAttemptID attemptId) {
        this.mockTask.handle((TaskEvent)this.createTaskTALauncherEvent(attemptId));
        this.assertTaskRunningState();
    }

    private void updateAttemptProgress(MockTaskAttemptImpl attempt, float p) {
        attempt.setProgress(p);
    }

    private void updateAttemptState(MockTaskAttemptImpl attempt, TaskAttemptState s) {
        attempt.setState(s);
    }

    private void killRunningTaskAttempt(TezTaskAttemptID attemptId, TaskState stateToVerify) {
        this.killRunningTaskAttempt(attemptId, stateToVerify, 1);
    }

    private void killRunningTaskAttempt(TezTaskAttemptID attemptId, TaskState stateToVerify, int killedCountToVerify) {
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(attemptId));
        this.assertTaskState(stateToVerify);
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)killedCountToVerify))).incrementKilledTaskAttemptCount();
    }

    private void failRunningTaskAttempt(TezTaskAttemptID attemptId) {
        this.failRunningTaskAttempt(attemptId, true);
    }

    private void failRunningTaskAttempt(TezTaskAttemptID attemptId, boolean verifyState) {
        int failedAttempts = this.mockTask.failedAttempts;
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(attemptId));
        if (verifyState) {
            this.assertTaskRunningState();
        }
        Assert.assertEquals((long)(failedAttempts + 1), (long)this.mockTask.failedAttempts);
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)(failedAttempts + 1)))).incrementFailedTaskAttemptCount();
    }

    private void assertTaskNewState() {
        this.assertTaskState(TaskState.NEW);
    }

    private void assertTaskScheduledState() {
        this.assertTaskState(TaskState.SCHEDULED);
    }

    private void assertTaskRunningState() {
        this.assertTaskState(TaskState.RUNNING);
    }

    private void assertTaskState(TaskState state) {
        Assert.assertEquals((Object)state, (Object)this.mockTask.getState());
    }

    private void assertTaskKillWaitState() {
        Assert.assertEquals((Object)TaskStateInternal.KILL_WAIT, (Object)this.mockTask.getInternalState());
    }

    private void assertTaskSucceededState() {
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)this.mockTask.getState());
    }

    @Test(timeout=5000L)
    public void testInit() {
        LOG.info("--- START: testInit ---");
        this.assertTaskNewState();
        assert (this.mockTask.getAttemptList().size() == 0);
    }

    @Test(timeout=5000L)
    public void testScheduleTask() {
        LOG.info("--- START: testScheduleTask ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
    }

    @Test(timeout=5000L)
    public void testKillScheduledTask() {
        LOG.info("--- START: testKillScheduledTask ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.killTask(taskId);
    }

    @Test(timeout=5000L)
    public void testKillRunningTask() {
        LOG.info("--- START: testKillRunningTask ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{VertexEventType.V_TASK_COMPLETED});
    }

    @Test(timeout=5000L)
    public void testTooManyFailedAttempts() {
        LOG.info("--- START: testTooManyFailedAttempts ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId, TaskState.SCHEDULED);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.scheduleTaskAttempt(taskId, TaskState.RUNNING);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.scheduleTaskAttempt(taskId, TaskState.RUNNING);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.scheduleTaskAttempt(taskId, TaskState.RUNNING);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID(), false);
        Assert.assertEquals((Object)TaskStateInternal.FAILED, (Object)this.mockTask.getInternalState());
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{VertexEventType.V_TASK_COMPLETED});
    }

    @Test(timeout=5000L)
    public void testTooManyAttempts() {
        LOG.info("--- START: testTooManyAttempts ---");
        this.conf.setInt("tez.am.task.max.attempts", 3);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(this.conf)).when((Object)vertex)).getVertexConfig();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.taskResource, this.containerContext, vertex);
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId, TaskState.SCHEDULED);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID(), TaskState.RUNNING, 1);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID(), TaskState.FAILED, 2);
        Assert.assertEquals((Object)TaskStateInternal.FAILED, (Object)this.mockTask.getInternalState());
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{VertexEventType.V_TASK_COMPLETED});
    }

    @Test(timeout=5000L)
    public void testFailedAttemptWithFatalError() {
        LOG.info("--- START: testFailedAttemptWithFatalError ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId, TaskState.SCHEDULED);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(this.mockTask.getLastAttempt().getTaskAttemptID(), TaskFailureType.FATAL, null));
        Assert.assertEquals((Object)TaskStateInternal.FAILED, (Object)this.mockTask.getInternalState());
        Assert.assertEquals((long)1L, (long)this.mockTask.failedAttempts);
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{VertexEventType.V_TASK_COMPLETED});
    }

    @Test(timeout=5000L)
    public void testKillRunningTaskPreviousKilledAttempts() {
        LOG.info("--- START: testKillRunningTaskPreviousKilledAttempts ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID(), TaskState.RUNNING);
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.mockTask.getInternalState());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{VertexEventType.V_TASK_COMPLETED});
    }

    @Test(timeout=5000L)
    public void testKillRunningTaskButAttemptSucceeds() {
        LOG.info("--- START: testKillRunningTaskButAttemptSucceeds ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
    }

    @Test(timeout=5000L)
    public void testKillRunningTaskButAttemptFails() {
        LOG.info("--- START: testKillRunningTaskButAttemptFails ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
    }

    @Test(timeout=5000L)
    public void testKillScheduledTaskAttempt() {
        LOG.info("--- START: testKillScheduledTaskAttempt ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        TezTaskAttemptID lastTAId = this.mockTask.getLastAttempt().getTaskAttemptID();
        this.killScheduledTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        Assert.assertEquals((Object)lastTAId, (Object)this.mockTask.getLastAttempt().getSchedulingCausalTA());
    }

    @Test(timeout=5000L)
    public void testLaunchTaskAttempt() {
        LOG.info("--- START: testLaunchTaskAttempt ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
    }

    @Test(timeout=5000L)
    public void testKillRunningTaskAttempt() {
        LOG.info("--- START: testKillRunningTaskAttempt ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        TezTaskAttemptID lastTAId = this.mockTask.getLastAttempt().getTaskAttemptID();
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID(), TaskState.RUNNING);
        Assert.assertEquals((Object)lastTAId, (Object)this.mockTask.getLastAttempt().getSchedulingCausalTA());
    }

    @Test(timeout=5000L)
    public void testKillTaskAttemptServiceBusy() {
        LOG.info("--- START: testKillTaskAttemptServiceBusy ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(this.mockTask.getLastAttempt().getTaskAttemptID(), new ServiceBusyEvent()));
        this.assertTaskRunningState();
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)0))).incrementKilledTaskAttemptCount();
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)1))).incrementRejectedTaskAttemptCount();
    }

    @Test(timeout=5000L)
    public void testKilledAttemptAtTaskKilled() {
        LOG.info("--- START: testKilledAttemptAtTaskKilled ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
    }

    @Test(timeout=5000L)
    public void testKilledAttemptAtTaskFailed() {
        LOG.info("--- START: testKilledAttemptAtTaskFailed ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        for (int i = 0; i < this.mockTask.maxFailedAttempts; ++i) {
            this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        }
        Assert.assertEquals((Object)TaskStateInternal.FAILED, (Object)this.mockTask.getInternalState());
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.FAILED, (Object)this.mockTask.getInternalState());
    }

    @Test(timeout=5000L)
    public void testFetchedEventsModifyUnderlyingList() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.sendTezEventsToTask(taskId, 2);
        TezTaskAttemptID attemptID = this.mockTask.getAttemptList().iterator().next().getTaskAttemptID();
        ArrayList fetchedList = this.mockTask.getTaskAttemptTezEvents(attemptID, 0, 100);
        Assert.assertEquals((long)2L, (long)fetchedList.size());
        this.sendTezEventsToTask(taskId, 4);
        Assert.assertEquals((long)2L, (long)fetchedList.size());
        fetchedList = this.mockTask.getTaskAttemptTezEvents(attemptID, 0, 100);
        Assert.assertEquals((long)6L, (long)fetchedList.size());
    }

    @Test(timeout=5000L)
    public void testTaskProgress() {
        LOG.info("--- START: testTaskProgress ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        float progress = 0.0f;
        assert (this.mockTask.getProgress() == progress);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        progress = 50.0f;
        this.updateAttemptProgress(this.mockTask.getLastAttempt(), progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 100.0f;
        this.updateAttemptProgress(this.mockTask.getLastAttempt(), progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 0.0f;
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.KILLED);
        assert (this.mockTask.getProgress() == progress);
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        assert (this.mockTask.getAttemptList().size() == 2);
        Assert.assertEquals((long)1L, (long)this.mockTask.failedAttempts);
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)1))).incrementFailedTaskAttemptCount();
        assert (this.mockTask.getProgress() == 0.0f);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        progress = 50.0f;
        this.updateAttemptProgress(this.mockTask.getLastAttempt(), progress);
        assert (this.mockTask.getProgress() == progress);
    }

    @Test(timeout=5000L)
    public void testFailureDuringTaskAttemptCommit() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        Assert.assertTrue((String)"First attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getLastAttempt().getTaskAttemptID()));
        TezTaskAttemptID lastTAId = this.mockTask.getLastAttempt().getTaskAttemptID();
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.FAILED);
        Assert.assertEquals((long)1L, (long)this.mockTask.getAttemptList().size());
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        Assert.assertEquals((long)1L, (long)this.mockTask.failedAttempts);
        Assert.assertEquals((Object)lastTAId, (Object)this.mockTask.getLastAttempt().getSchedulingCausalTA());
        Assert.assertFalse((String)"First attempt should not commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(0).getTaskAttemptID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        Assert.assertTrue((String)"Second attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.assertTaskSucceededState();
    }

    @Test(timeout=5000L)
    public void testEventBacklogDuringTaskAttemptCommit() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        Assert.assertEquals((Object)TaskState.SCHEDULED, (Object)this.mockTask.getState());
        Assert.assertFalse((String)"Commit should return false to make running task wait", (boolean)this.mockTask.canCommit(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        Assert.assertTrue((String)"Task state in AM is running now. Can commit.", (boolean)this.mockTask.canCommit(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.assertTaskSucceededState();
    }

    @Test(timeout=5000L)
    public void testChangeCommitTaskAttempt() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        TezTaskAttemptID lastTAId = this.mockTask.getLastAttempt().getTaskAttemptID();
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        Assert.assertEquals((Object)lastTAId, (Object)this.mockTask.getLastAttempt().getSchedulingCausalTA());
        Assert.assertTrue((String)"Second attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(1).getTaskAttemptID()));
        Assert.assertFalse((String)"First attempt should not commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(0).getTaskAttemptID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.FAILED);
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        Assert.assertFalse((String)"Second attempt should not commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(1).getTaskAttemptID()));
        Assert.assertTrue((String)"First attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(0).getTaskAttemptID()));
        this.updateAttemptState(this.mockTask.getAttemptList().get(0), TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(this.mockTask.getAttemptList().get(0).getTaskAttemptID()));
        this.assertTaskSucceededState();
    }

    @Test(timeout=5000L)
    public void testTaskSucceedAndRetroActiveFailure() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.assertTaskSucceededState();
        ((StateChangeNotifier)Mockito.verify((Object)this.mockTask.stateChangeNotifier)).taskSucceeded((String)Mockito.any(), (TezTaskID)Mockito.eq((Object)taskId), Mockito.eq((int)this.mockTask.getLastAttempt().getTaskAttemptID().getId()));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(DAGHistoryEvent.class);
        ((HistoryEventHandler)Mockito.verify((Object)this.mockHistoryHandler)).handle((DAGHistoryEvent)argumentCaptor.capture());
        DAGHistoryEvent dagHistoryEvent = (DAGHistoryEvent)argumentCaptor.getValue();
        HistoryEvent historyEvent = dagHistoryEvent.getHistoryEvent();
        Assert.assertTrue((boolean)(historyEvent instanceof TaskFinishedEvent));
        TaskFinishedEvent taskFinishedEvent = (TaskFinishedEvent)historyEvent;
        Assert.assertEquals((long)taskFinishedEvent.getFinishTime(), (long)this.mockTask.getFinishTime());
        this.eventHandler.events.clear();
        TezTaskAttemptID mockDestId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezEvent mockTezEvent = (TezEvent)Mockito.mock(TezEvent.class);
        EventMetaData meta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, "Vertex", "Edge", mockDestId);
        Mockito.when((Object)mockTezEvent.getSourceInfo()).thenReturn((Object)meta);
        TaskAttemptEventOutputFailed outputFailedEvent = new TaskAttemptEventOutputFailed(mockDestId, mockTezEvent, 1);
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(this.mockTask.getLastAttempt().getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)outputFailedEvent));
        this.assertTaskScheduledState();
        Event event = this.eventHandler.events.get(0);
        Assert.assertEquals((Object)AMNodeEventType.N_TA_ENDED, (Object)event.getType());
        event = this.eventHandler.events.get(this.eventHandler.events.size() - 1);
        Assert.assertEquals((Object)VertexEventType.V_TASK_RESCHEDULED, (Object)event.getType());
        List<MockTaskAttemptImpl> attempts = this.mockTask.getAttemptList();
        Assert.assertEquals((long)2L, (long)attempts.size());
        MockTaskAttemptImpl newAttempt = attempts.get(1);
        Assert.assertEquals((Object)mockDestId, (Object)newAttempt.getSchedulingCausalTA());
    }

    @Test(timeout=5000L)
    public void testTaskSucceedAndRetroActiveKilled() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getTaskAttemptID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.assertTaskSucceededState();
        ((StateChangeNotifier)Mockito.verify((Object)this.mockTask.stateChangeNotifier)).taskSucceeded((String)Mockito.any(), (TezTaskID)Mockito.eq((Object)taskId), Mockito.eq((int)this.mockTask.getLastAttempt().getTaskAttemptID().getId()));
        this.eventHandler.events.clear();
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.assertTaskScheduledState();
        Event event = this.eventHandler.events.get(0);
        Assert.assertEquals((Object)VertexEventType.V_TASK_RESCHEDULED, (Object)event.getType());
    }

    @Test(timeout=5000L)
    public void testDiagnostics_KillNew() {
        TezTaskID taskId = this.getNewTaskID();
        this.mockTask.handle((TaskEvent)new TaskEventTermination(taskId, TaskAttemptTerminationCause.TERMINATED_BY_CLIENT, null));
        Assert.assertEquals((long)1L, (long)this.mockTask.getDiagnostics().size());
        Assert.assertTrue((boolean)((String)this.mockTask.getDiagnostics().get(0)).contains(TaskAttemptTerminationCause.TERMINATED_BY_CLIENT.name()));
        Assert.assertEquals((long)0L, (long)this.mockTask.taskStartedEventLogged);
        Assert.assertEquals((long)1L, (long)this.mockTask.taskFinishedEventLogged);
    }

    @Test(timeout=5000L)
    public void testDiagnostics_Kill() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.mockTask.handle((TaskEvent)new TaskEventTermination(taskId, TaskAttemptTerminationCause.TERMINATED_AT_SHUTDOWN, null));
        Assert.assertEquals((long)1L, (long)this.mockTask.getDiagnostics().size());
        Assert.assertTrue((boolean)((String)this.mockTask.getDiagnostics().get(0)).contains(TaskAttemptTerminationCause.TERMINATED_AT_SHUTDOWN.name()));
    }

    @Test(timeout=20000L)
    public void testFailedThenSpeculativeFailed() {
        this.conf.setInt("tez.am.task.max.failed.attempts", 1);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(this.conf)).when((Object)vertex)).getVertexConfig();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.taskResource, this.containerContext, vertex);
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstAttempt.getTaskAttemptID());
        this.updateAttemptState(firstAttempt, TaskAttemptState.RUNNING);
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl specAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(specAttempt.getTaskAttemptID());
        this.updateAttemptState(specAttempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        this.updateAttemptState(firstAttempt, TaskAttemptState.FAILED);
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(firstAttempt.getTaskAttemptID()));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        this.updateAttemptState(specAttempt, TaskAttemptState.FAILED);
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(specAttempt.getTaskAttemptID()));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
    }

    @Test(timeout=20000L)
    public void testFailedThenSpeculativeSucceeded() {
        this.conf.setInt("tez.am.task.max.failed.attempts", 1);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(this.conf)).when((Object)vertex)).getVertexConfig();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.taskResource, this.containerContext, vertex);
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstAttempt.getTaskAttemptID());
        this.updateAttemptState(firstAttempt, TaskAttemptState.RUNNING);
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl specAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(specAttempt.getTaskAttemptID());
        this.updateAttemptState(specAttempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        this.updateAttemptState(firstAttempt, TaskAttemptState.FAILED);
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(firstAttempt.getTaskAttemptID()));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        this.updateAttemptState(specAttempt, TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(specAttempt.getTaskAttemptID()));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
    }

    @Test
    public void testKilledBeforeSpeculatedSucceeded() {
        this.conf.setInt("tez.am.task.max.failed.attempts", 1);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(this.conf)).when((Object)vertex)).getVertexConfig();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.taskResource, this.containerContext, vertex);
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstAttempt.getTaskAttemptID());
        this.updateAttemptState(firstAttempt, TaskAttemptState.RUNNING);
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(firstAttempt.getTaskAttemptID()));
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.mockTask.getInternalState());
        NodeId nodeId = this.mockNodeId;
        this.mockNodeId = null;
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        this.mockNodeId = nodeId;
        MockTaskAttemptImpl specAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(specAttempt.getTaskAttemptID());
        this.updateAttemptState(specAttempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((long)3L, (long)this.mockTask.getAttemptList().size());
        this.updateAttemptState(specAttempt, TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(specAttempt.getTaskAttemptID()));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)this.mockTask.getState());
        Assert.assertEquals((long)3L, (long)this.mockTask.getAttemptList().size());
    }

    @Test(timeout=20000L)
    public void testKilledAttemptUpdatesDAGScheduler() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstAttempt.getTaskAttemptID());
        this.updateAttemptState(firstAttempt, TaskAttemptState.RUNNING);
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(firstAttempt.getTaskAttemptID()));
        MockTaskAttemptImpl specAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(specAttempt.getTaskAttemptID());
        this.updateAttemptState(specAttempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        this.eventHandler.events.clear();
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(firstAttempt.getTaskAttemptID()));
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{DAGEventType.DAG_SCHEDULER_UPDATE, VertexEventType.V_TASK_COMPLETED, VertexEventType.V_TASK_ATTEMPT_COMPLETED});
        this.assertTaskSucceededState();
        ((StateChangeNotifier)Mockito.verify((Object)this.mockTask.stateChangeNotifier)).taskSucceeded((String)Mockito.any(), (TezTaskID)Mockito.eq((Object)taskId), Mockito.eq((int)firstAttempt.getTaskAttemptID().getId()));
        Event event = this.eventHandler.events.get(this.eventHandler.events.size() - 1);
        Assert.assertEquals((Object)TaskAttemptEventType.TA_KILL_REQUEST, (Object)event.getType());
        Assert.assertEquals((Object)specAttempt.getTaskAttemptID(), (Object)((TaskAttemptEventKillRequest)event).getTaskAttemptID());
        this.eventHandler.events.clear();
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(specAttempt.getTaskAttemptID()));
        this.assertTaskSucceededState();
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{DAGEventType.DAG_SCHEDULER_UPDATE, VertexEventType.V_TASK_ATTEMPT_COMPLETED});
    }

    @Test(timeout=20000L)
    public void testSpeculatedThenRetroactiveFailure() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstAttempt.getTaskAttemptID());
        this.updateAttemptState(firstAttempt, TaskAttemptState.RUNNING);
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(firstAttempt.getTaskAttemptID()));
        MockTaskAttemptImpl specAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(specAttempt.getTaskAttemptID());
        this.updateAttemptState(specAttempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        this.eventHandler.events.clear();
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(firstAttempt.getTaskAttemptID()));
        this.assertTaskSucceededState();
        ((StateChangeNotifier)Mockito.verify((Object)this.mockTask.stateChangeNotifier)).taskSucceeded((String)Mockito.any(), (TezTaskID)Mockito.eq((Object)taskId), Mockito.eq((int)firstAttempt.getTaskAttemptID().getId()));
        Event event = this.eventHandler.events.get(this.eventHandler.events.size() - 1);
        Assert.assertEquals((Object)TaskAttemptEventType.TA_KILL_REQUEST, (Object)event.getType());
        Assert.assertEquals((Object)specAttempt.getTaskAttemptID(), (Object)((TaskAttemptEventKillRequest)event).getTaskAttemptID());
        this.mockTask.handle((TaskEvent)this.createTaskTAKilledEvent(specAttempt.getTaskAttemptID()));
        this.assertTaskSucceededState();
        TezTaskAttemptID mockDestId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        TezEvent mockTezEvent = (TezEvent)Mockito.mock(TezEvent.class);
        EventMetaData meta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, "Vertex", "Edge", mockDestId);
        Mockito.when((Object)mockTezEvent.getSourceInfo()).thenReturn((Object)meta);
        TaskAttemptEventOutputFailed outputFailedEvent = new TaskAttemptEventOutputFailed(mockDestId, mockTezEvent, 1);
        this.eventHandler.events.clear();
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(firstAttempt.getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)outputFailedEvent));
        this.assertTaskScheduledState();
        event = this.eventHandler.events.get(this.eventHandler.events.size() - 1);
        Assert.assertEquals((Object)VertexEventType.V_TASK_RESCHEDULED, (Object)event.getType());
        List<MockTaskAttemptImpl> attempts = this.mockTask.getAttemptList();
        Assert.assertEquals((long)3L, (long)attempts.size());
        MockTaskAttemptImpl newAttempt = attempts.get(2);
        Assert.assertEquals((Object)mockDestId, (Object)newAttempt.getSchedulingCausalTA());
    }

    @Test(timeout=20000L)
    public void testIgnoreSpeculationOnSuccessfulOriginalAttempt() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstAttempt.getTaskAttemptID());
        this.updateAttemptState(firstAttempt, TaskAttemptState.SUCCEEDED);
        firstAttempt.handle(new TaskAttemptEvent(firstAttempt.getTaskAttemptID(), TaskAttemptEventType.TA_DONE));
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(firstAttempt.getTaskAttemptID()));
        MockTaskAttemptImpl specAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(specAttempt.getTaskAttemptID());
        Assert.assertEquals((long)1L, (long)this.mockTask.getAttemptList().size());
    }

    @Test(timeout=20000L)
    public void testIgnoreSpeculationAfterOriginalAttemptCommit() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstAttempt.getTaskAttemptID());
        this.updateAttemptState(firstAttempt, TaskAttemptState.RUNNING);
        this.mockTask.canCommit(firstAttempt.getTaskAttemptID());
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(firstAttempt.getTaskAttemptID()));
        MockTaskAttemptImpl specAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(specAttempt.getTaskAttemptID());
        Assert.assertEquals((long)1L, (long)this.mockTask.getAttemptList().size());
    }

    @Test
    public void testSucceededAttemptStatusWithRetroActiveFailures() throws InterruptedException {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstMockTaskAttempt = this.mockTask.getAttemptList().get(0);
        this.launchTaskAttempt(firstMockTaskAttempt.getTaskAttemptID());
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl secondMockTaskAttempt = this.mockTask.getAttemptList().get(1);
        this.launchTaskAttempt(secondMockTaskAttempt.getTaskAttemptID());
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), 10, 10));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), 10, 10));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString())));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString())));
        secondMockTaskAttempt.handle(new TaskAttemptEvent(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), TaskAttemptEventType.TA_DONE));
        firstMockTaskAttempt.handle(new TaskAttemptEvent(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), TaskAttemptEventType.TA_DONE));
        this.mockTask.handle((TaskEvent)new TaskEventTASucceeded(secondMockTaskAttempt.getTaskAttemptID()));
        this.mockTask.handle((TaskEvent)new TaskEventTASucceeded(firstMockTaskAttempt.getTaskAttemptID()));
        Assert.assertTrue((String)"Attempts should have succeeded!", (firstMockTaskAttempt.getInternalState() == TaskAttemptStateInternal.SUCCEEDED && secondMockTaskAttempt.getInternalState() == TaskAttemptStateInternal.SUCCEEDED ? 1 : 0) != 0);
        Assert.assertEquals((String)"Task should have no uncompleted attempts!", (long)0L, (long)this.mockTask.getUncompletedAttemptsCount());
        Assert.assertTrue((String)"Task should have Succeeded!", (this.mockTask.getState() == TaskState.SUCCEEDED ? 1 : 0) != 0);
        this.failAttempt(firstMockTaskAttempt, 0, 0);
        this.assertTaskSucceededState();
        this.failAttempt(secondMockTaskAttempt, 1, 1);
        this.assertTaskScheduledState();
    }

    @Test
    public void testFailedAttemptStatus() throws InterruptedException {
        Configuration newConf = new Configuration(this.conf);
        newConf.setInt("tez.am.task.max.failed.attempts", 1);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(newConf)).when((Object)vertex)).getVertexConfig();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.taskResource, this.containerContext, vertex);
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstMockTaskAttempt = this.mockTask.getAttemptList().get(0);
        this.launchTaskAttempt(firstMockTaskAttempt.getTaskAttemptID());
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl secondMockTaskAttempt = this.mockTask.getAttemptList().get(1);
        this.launchTaskAttempt(secondMockTaskAttempt.getTaskAttemptID());
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), 10, 10));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), 10, 10));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString())));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString())));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptFailed(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), TaskAttemptEventType.TA_FAILED, TaskFailureType.NON_FATAL, "test", TaskAttemptTerminationCause.NO_PROGRESS));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptFailed(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), TaskAttemptEventType.TA_FAILED, TaskFailureType.NON_FATAL, "test", TaskAttemptTerminationCause.NO_PROGRESS));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(this.mockContainerId, firstMockTaskAttempt.getTaskAttemptID(), "test", TaskAttemptTerminationCause.NO_PROGRESS));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(this.mockContainerId, secondMockTaskAttempt.getTaskAttemptID(), "test", TaskAttemptTerminationCause.NO_PROGRESS));
        this.mockTask.handle((TaskEvent)new TaskEventTAFailed(secondMockTaskAttempt.getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)Mockito.mock(TaskAttemptEvent.class)));
        this.mockTask.handle((TaskEvent)new TaskEventTAFailed(firstMockTaskAttempt.getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)Mockito.mock(TaskAttemptEvent.class)));
        Assert.assertTrue((String)"Attempts should have failed!", (firstMockTaskAttempt.getInternalState() == TaskAttemptStateInternal.FAILED && secondMockTaskAttempt.getInternalState() == TaskAttemptStateInternal.FAILED ? 1 : 0) != 0);
        Assert.assertEquals((String)"Task should have no uncompleted attempts!", (long)0L, (long)this.mockTask.getUncompletedAttemptsCount());
        Assert.assertTrue((String)"Task should have failed!", (this.mockTask.getState() == TaskState.FAILED ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSucceededLeafTaskWithRetroFailures() throws InterruptedException {
        Configuration newConf = new Configuration(this.conf);
        newConf.setInt("tez.am.task.max.failed.attempts", 1);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(newConf)).when((Object)vertex)).getVertexConfig();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, true, this.taskResource, this.containerContext, vertex);
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstMockTaskAttempt = this.mockTask.getAttemptList().get(0);
        this.launchTaskAttempt(firstMockTaskAttempt.getTaskAttemptID());
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl secondMockTaskAttempt = this.mockTask.getAttemptList().get(1);
        this.launchTaskAttempt(secondMockTaskAttempt.getTaskAttemptID());
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), 10, 10));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), 10, 10));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString())));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString())));
        secondMockTaskAttempt.handle(new TaskAttemptEvent(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), TaskAttemptEventType.TA_DONE));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptFailed(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), TaskAttemptEventType.TA_FAILED, TaskFailureType.NON_FATAL, "test", TaskAttemptTerminationCause.CONTAINER_EXITED));
        this.mockTask.handle((TaskEvent)new TaskEventTASucceeded(secondMockTaskAttempt.getTaskAttemptID()));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(this.mockContainerId, firstMockTaskAttempt.getTaskAttemptID(), "test", TaskAttemptTerminationCause.NO_PROGRESS));
        InputReadErrorEvent mockReEvent = InputReadErrorEvent.create((String)"", (int)0, (int)0);
        TezTaskAttemptID mockDestId = firstMockTaskAttempt.getTaskAttemptID();
        EventMetaData meta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, "Vertex", "Edge", mockDestId);
        TezEvent tzEvent = new TezEvent((org.apache.tez.runtime.api.Event)mockReEvent, meta);
        TaskAttemptEventOutputFailed outputFailedEvent = new TaskAttemptEventOutputFailed(mockDestId, tzEvent, 1);
        firstMockTaskAttempt.handle((TaskAttemptEvent)outputFailedEvent);
        this.mockTask.handle((TaskEvent)new TaskEventTAFailed(firstMockTaskAttempt.getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)Mockito.mock(TaskAttemptEvent.class)));
        Assert.assertEquals((Object)this.mockTask.getInternalState(), (Object)TaskStateInternal.SUCCEEDED);
    }

    private void failAttempt(MockTaskAttemptImpl taskAttempt, int index, int expectedIncompleteAttempts) {
        InputReadErrorEvent mockReEvent = InputReadErrorEvent.create((String)"", (int)0, (int)index);
        TezTaskAttemptID mockDestId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        EventMetaData meta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, "Vertex", "Edge", mockDestId);
        TezEvent tzEvent = new TezEvent((org.apache.tez.runtime.api.Event)mockReEvent, meta);
        TaskAttemptEventOutputFailed outputFailedEvent = new TaskAttemptEventOutputFailed(mockDestId, tzEvent, 1);
        taskAttempt.handle((TaskAttemptEvent)outputFailedEvent);
        TaskEventTAFailed tEventFail1 = new TaskEventTAFailed(taskAttempt.getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)outputFailedEvent);
        this.mockTask.handle((TaskEvent)tEventFail1);
        Assert.assertEquals((String)"Unexpected number of incomplete attempts!", (long)expectedIncompleteAttempts, (long)this.mockTask.getUncompletedAttemptsCount());
    }

    @Test(timeout=30000L)
    public void testFailedTaskTransitionWithLaunchedAttempt() throws InterruptedException {
        Configuration newConf = new Configuration(this.conf);
        newConf.setInt("tez.am.task.max.failed.attempts", 1);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)new VertexImpl.VertexConfigImpl(newConf)).when((Object)vertex)).getVertexConfig();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskCommunicatorManagerInterface, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.taskResource, this.containerContext, vertex);
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstMockTaskAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstMockTaskAttempt.getTaskAttemptID());
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl secondMockTaskAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(secondMockTaskAttempt.getTaskAttemptID());
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), 10, 10));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), 10, 10));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString())));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString())));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptFailed(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), TaskAttemptEventType.TA_FAILED, TaskFailureType.NON_FATAL, "test", TaskAttemptTerminationCause.NO_PROGRESS));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptFailed(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), TaskAttemptEventType.TA_FAILED, TaskFailureType.NON_FATAL, "test", TaskAttemptTerminationCause.NO_PROGRESS));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(this.mockContainerId, firstMockTaskAttempt.getTaskAttemptID(), "test", TaskAttemptTerminationCause.NO_PROGRESS));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(this.mockContainerId, secondMockTaskAttempt.getTaskAttemptID(), "test", TaskAttemptTerminationCause.NO_PROGRESS));
        this.mockTask.handle((TaskEvent)new TaskEventTAFailed(secondMockTaskAttempt.getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)Mockito.mock(TaskAttemptEvent.class)));
        this.mockTask.handle((TaskEvent)new TaskEventTAFailed(firstMockTaskAttempt.getTaskAttemptID(), TaskFailureType.NON_FATAL, (TezAbstractEvent)Mockito.mock(TaskAttemptEvent.class)));
        Assert.assertTrue((String)"Attempts should have failed!", (firstMockTaskAttempt.getInternalState() == TaskAttemptStateInternal.FAILED && secondMockTaskAttempt.getInternalState() == TaskAttemptStateInternal.FAILED ? 1 : 0) != 0);
        Assert.assertEquals((String)"Task should have no uncompleted attempts!", (long)0L, (long)this.mockTask.getUncompletedAttemptsCount());
        Assert.assertTrue((String)"Task should have failed!", (this.mockTask.getState() == TaskState.FAILED ? 1 : 0) != 0);
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl thirdMockTaskAttempt = this.mockTask.getLastAttempt();
        this.mockTask.handle((TaskEvent)this.createTaskTALauncherEvent(thirdMockTaskAttempt.getTaskAttemptID()));
    }

    @Test(timeout=30000L)
    public void testKilledTaskTransitionWithLaunchedAttempt() throws InterruptedException {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        MockTaskAttemptImpl firstMockTaskAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(firstMockTaskAttempt.getTaskAttemptID());
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl secondMockTaskAttempt = this.mockTask.getLastAttempt();
        this.launchTaskAttempt(secondMockTaskAttempt.getTaskAttemptID());
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), 10, 10));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), 10, 10));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventSubmitted(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), this.mockContainer.getId()));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString())));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString())));
        this.mockTask.handle((TaskEvent)new TaskEventTermination(this.mockTask.getTaskID(), TaskAttemptTerminationCause.FRAMEWORK_ERROR, "test"));
        secondMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptKilled(TezTaskAttemptID.fromString((String)secondMockTaskAttempt.toString()), "test", TaskAttemptTerminationCause.FRAMEWORK_ERROR));
        this.mockTask.handle((TaskEvent)new TaskEventTAKilled(secondMockTaskAttempt.getTaskAttemptID(), (TezAbstractEvent)new TaskAttemptEvent(secondMockTaskAttempt.getTaskAttemptID(), TaskAttemptEventType.TA_KILLED)));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptKilled(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), "test", TaskAttemptTerminationCause.FRAMEWORK_ERROR));
        this.mockTask.handle((TaskEvent)new TaskEventTAKilled(firstMockTaskAttempt.getTaskAttemptID(), (TezAbstractEvent)new TaskAttemptEvent(firstMockTaskAttempt.getTaskAttemptID(), TaskAttemptEventType.TA_KILLED)));
        firstMockTaskAttempt.handle((TaskAttemptEvent)new TaskAttemptEventAttemptKilled(TezTaskAttemptID.fromString((String)firstMockTaskAttempt.toString()), "test", TaskAttemptTerminationCause.FRAMEWORK_ERROR));
        Assert.assertEquals((String)"Task should have been killed!", (Object)this.mockTask.getInternalState(), (Object)TaskStateInternal.KILLED);
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl thirdMockTaskAttempt = this.mockTask.getLastAttempt();
        this.mockTask.handle((TaskEvent)this.createTaskTALauncherEvent(thirdMockTaskAttempt.getTaskAttemptID()));
        this.mockTask.handle(this.createTaskTAAddSpecAttempt(this.mockTask.getLastAttempt().getTaskAttemptID()));
        MockTaskAttemptImpl fourthMockTaskAttempt = this.mockTask.getLastAttempt();
        this.mockTask.handle((TaskEvent)this.createTaskTASucceededEvent(fourthMockTaskAttempt.getTaskAttemptID()));
        MockTaskAttemptImpl fifthMockTaskAttempt = this.mockTask.getLastAttempt();
        this.mockTask.handle((TaskEvent)this.createTaskTAFailedEvent(fifthMockTaskAttempt.getTaskAttemptID()));
    }

    private void verifyOutgoingEvents(List<Event> events, Enum<?> ... expectedTypes) {
        LinkedList expectedTypeList = new LinkedList();
        for (Enum<?> enum_ : expectedTypes) {
            expectedTypeList.add(enum_);
        }
        block1: for (Event event : events) {
            Iterator typeIter = expectedTypeList.iterator();
            while (typeIter.hasNext()) {
                Enum enum_ = (Enum)typeIter.next();
                if (event.getType() != enum_) continue;
                typeIter.remove();
                continue block1;
            }
        }
        Assert.assertTrue((String)("Did not find types : " + expectedTypeList + " in outgoing event list"), (boolean)expectedTypeList.isEmpty());
    }

    public class ServiceBusyEvent
    extends TezAbstractEvent<TaskAttemptEventType>
    implements TaskAttemptEventTerminationCauseEvent {
        public ServiceBusyEvent() {
            super((Enum)TaskAttemptEventType.TA_KILLED);
        }

        public TaskAttemptTerminationCause getTerminationCause() {
            return TaskAttemptTerminationCause.SERVICE_BUSY;
        }
    }

    public class MockTaskAttemptImpl
    extends TaskAttemptImpl {
        private float progress;
        private TaskAttemptState state;

        public MockTaskAttemptImpl(TezTaskAttemptID attemptId, EventHandler eventHandler, TaskCommunicatorManagerInterface tal, Configuration conf, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, boolean isRescheduled, Resource resource, ContainerContext containerContext, TezTaskAttemptID schedCausalTA) {
            super(attemptId, eventHandler, tal, conf, clock, thh, appContext, isRescheduled, resource, containerContext, false, (Task)TestTaskImpl.this.mockTask, TestTaskImpl.this.locationHint, TestTaskImpl.this.mockTaskSpec, schedCausalTA);
            this.progress = 0.0f;
            this.state = TaskAttemptState.NEW;
        }

        protected Vertex getVertex() {
            return TestTaskImpl.this.mockVertex;
        }

        public float getProgress() {
            return this.progress;
        }

        public void setProgress(float progress) {
            this.progress = progress;
        }

        public void setState(TaskAttemptState state) {
            this.state = state;
        }

        public TaskAttemptState getState() {
            return this.state;
        }

        public TaskAttemptState getStateNoLock() {
            return this.state;
        }

        public ContainerId getAssignedContainerID() {
            return TestTaskImpl.this.mockContainerId;
        }

        public NodeId getNodeId() {
            return TestTaskImpl.this.mockNodeId;
        }
    }

    private class MockTaskImpl
    extends TaskImpl {
        public int taskStartedEventLogged;
        public int taskFinishedEventLogged;
        private List<MockTaskAttemptImpl> taskAttempts;
        private Vertex vertex;

        public MockTaskImpl(TezVertexID vertexId, int partition, EventHandler eventHandler, Configuration conf, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, boolean leafVertex, Resource resource, ContainerContext containerContext, Vertex vertex) {
            super(vertexId, partition, eventHandler, conf, taskCommunicatorManagerInterface, clock, thh, appContext, leafVertex, resource, containerContext, (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class), vertex);
            this.taskStartedEventLogged = 0;
            this.taskFinishedEventLogged = 0;
            this.taskAttempts = new LinkedList<MockTaskAttemptImpl>();
            this.vertex = vertex;
        }

        protected TaskAttemptImpl createAttempt(int attemptNumber, TezTaskAttemptID schedCausalTA) {
            MockTaskAttemptImpl attempt = new MockTaskAttemptImpl(TezBuilderUtils.newTaskAttemptId((TezTaskID)this.getTaskID(), (int)attemptNumber), this.eventHandler, this.taskCommunicatorManagerInterface, this.conf, this.clock, this.taskHeartbeatHandler, this.appContext, true, TestTaskImpl.this.taskResource, TestTaskImpl.this.containerContext, schedCausalTA);
            this.taskAttempts.add(attempt);
            return attempt;
        }

        protected void internalError(TaskEventType type) {
            super.internalError(type);
            Assert.fail((String)("Internal error: " + type));
        }

        MockTaskAttemptImpl getLastAttempt() {
            return this.taskAttempts.get(this.taskAttempts.size() - 1);
        }

        List<MockTaskAttemptImpl> getAttemptList() {
            return this.taskAttempts;
        }

        public Vertex getVertex() {
            return this.vertex;
        }

        protected void logJobHistoryTaskStartedEvent() {
            ++this.taskStartedEventLogged;
        }

        protected void logJobHistoryTaskFinishedEvent() {
            super.logJobHistoryTaskFinishedEvent();
            ++this.taskFinishedEventLogged;
        }

        protected void logJobHistoryTaskFailedEvent(TaskState finalState) {
            ++this.taskFinishedEventLogged;
        }
    }

    class TestEventHandler
    implements EventHandler<Event> {
        List<Event> events = new ArrayList<Event>();

        TestEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
        }
    }
}

