/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.ServicePluginInfo;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.records.VertexIDAware;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexFinishedEvent
implements HistoryEvent,
SummaryEvent,
VertexIDAware {
    private static final Logger LOG = LoggerFactory.getLogger(VertexFinishedEvent.class);
    private TezVertexID vertexID;
    private String vertexName;
    private int numTasks;
    private long initRequestedTime;
    private long initedTime;
    private long startRequestedTime;
    private long startTime;
    private long finishTime;
    private VertexState state;
    private String diagnostics;
    private TezCounters tezCounters;
    private boolean fromSummary = false;
    private VertexStats vertexStats;
    private Map<String, Integer> vertexTaskStats;
    private ServicePluginInfo servicePluginInfo;

    public VertexFinishedEvent(TezVertexID vertexId, String vertexName, int numTasks, long initRequestedTime, long initedTime, long startRequestedTime, long startedTime, long finishTime, VertexState state, String diagnostics, TezCounters counters, VertexStats vertexStats, Map<String, Integer> vertexTaskStats, ServicePluginInfo servicePluginInfo) {
        this.vertexName = vertexName;
        this.vertexID = vertexId;
        this.numTasks = numTasks;
        this.initRequestedTime = initRequestedTime;
        this.initedTime = initedTime;
        this.startRequestedTime = startRequestedTime;
        this.startTime = startedTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
        this.vertexStats = vertexStats;
        this.vertexTaskStats = vertexTaskStats;
        this.servicePluginInfo = servicePluginInfo;
    }

    public VertexFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexFinishedProto toProto() {
        RecoveryProtos.VertexFinishedProto.Builder builder = RecoveryProtos.VertexFinishedProto.newBuilder();
        builder.setVertexName(this.vertexName).setVertexId(this.vertexID.toString()).setNumTasks(this.numTasks).setState(this.state.ordinal()).setFinishTime(this.finishTime);
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.VertexFinishedProto proto) {
        this.vertexName = proto.getVertexName();
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.numTasks = proto.getNumTasks();
        this.finishTime = proto.getFinishTime();
        this.state = VertexState.values()[proto.getState()];
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.VertexFinishedProto proto = (RecoveryProtos.VertexFinishedProto)inputStream.readMessage(RecoveryProtos.VertexFinishedProto.PARSER, ExtensionRegistryLite.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", vertexId=" + this.vertexID + ", initRequestedTime=" + this.initRequestedTime + ", initedTime=" + this.initedTime + ", startRequestedTime=" + this.startRequestedTime + ", startedTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", diagnostics=" + this.diagnostics + ", counters=" + (this.tezCounters == null ? "null" : this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ")) + ", vertexStats=" + (this.vertexStats == null ? "null" : this.vertexStats.toString()) + ", vertexTaskStats=" + (this.vertexTaskStats == null ? "null" : this.vertexTaskStats.toString()) + ", servicePluginInfo=" + (this.servicePluginInfo != null ? this.servicePluginInfo : "null");
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public VertexState getState() {
        return this.state;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public TezCounters getTezCounters() {
        return this.tezCounters;
    }

    public VertexStats getVertexStats() {
        return this.vertexStats;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Map<String, Integer> getVertexTaskStats() {
        return this.vertexTaskStats;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        RecoveryProtos.VertexFinishStateProto finishStateProto = RecoveryProtos.VertexFinishStateProto.newBuilder().setState(this.state.ordinal()).setVertexId(this.vertexID.toString()).setNumTasks(this.numTasks).build();
        RecoveryProtos.SummaryEventProto.Builder builder = RecoveryProtos.SummaryEventProto.newBuilder().setDagId(this.vertexID.getDAGID().toString()).setTimestamp(this.finishTime).setEventType(this.getEventType().ordinal()).setEventPayload(finishStateProto.toByteString());
        builder.build().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromSummaryProtoStream(RecoveryProtos.SummaryEventProto proto) throws IOException {
        RecoveryProtos.VertexFinishStateProto finishStateProto = RecoveryProtos.VertexFinishStateProto.parseFrom(proto.getEventPayload());
        this.vertexID = TezVertexID.fromString((String)finishStateProto.getVertexId());
        this.state = VertexState.values()[finishStateProto.getState()];
        this.numTasks = finishStateProto.getNumTasks();
        this.finishTime = proto.getTimestamp();
        this.fromSummary = true;
    }

    @Override
    public boolean writeToRecoveryImmediately() {
        return false;
    }

    public boolean isFromSummary() {
        return this.fromSummary;
    }

    public ServicePluginInfo getServicePluginInfo() {
        return this.servicePluginInfo;
    }
}

