/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.AsyncDispatcher;
import org.junit.Assert;
import org.junit.Test;

public class TestAsyncDispatcher {
    @Test(timeout=5000L)
    public void testBasic() throws Exception {
        CountDownLatch latch;
        CountDownEventHandler.latch = latch = new CountDownLatch(4);
        AsyncDispatcher central = new AsyncDispatcher("Type1");
        central.register(TestEventType1.class, (EventHandler)new TestEventHandler1());
        central.registerAndCreateDispatcher(TestEventType2.class, (EventHandler)new TestEventHandler2(), "Type2");
        central.registerAndCreateDispatcher(TestEventType3.class, (EventHandler)new TestEventHandler3(), "Type3");
        central.init(new Configuration());
        central.start();
        central.getEventHandler().handle((Event)new TestEvent1(TestEventType1.TYPE1));
        central.getEventHandler().handle((Event)new TestEvent2(TestEventType2.TYPE2));
        central.getEventHandler().handle((Event)new TestEvent3(TestEventType3.TYPE3));
        latch.countDown();
        latch.await();
        central.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testMultipleRegisterFail() throws Exception {
        try (AsyncDispatcher central = new AsyncDispatcher("Type1");){
            central.register(TestEventType1.class, (EventHandler)new TestEventHandler1());
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2");
            Assert.fail();
        }
        central = new AsyncDispatcher("Type1");
        try {
            central.registerAndCreateDispatcher(TestEventType1.class, (EventHandler)new TestEventHandler2(), "Type2");
            central.register(TestEventType1.class, (EventHandler)new TestEventHandler1());
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Multiple dispatchers cannot be registered for"));
        }
        finally {
            central.close();
        }
    }

    class TestEventHandler3
    extends CountDownEventHandler
    implements EventHandler<TestEvent3> {
        TestEventHandler3() {
        }

        public void handle(TestEvent3 event) {
            this.handle();
        }
    }

    public class TestEvent3
    extends AbstractEvent<TestEventType3> {
        public TestEvent3(TestEventType3 type) {
            super((Enum)type);
        }
    }

    public static enum TestEventType3 {
        TYPE3;

    }

    class TestEventHandler2
    extends CountDownEventHandler
    implements EventHandler<TestEvent2> {
        TestEventHandler2() {
        }

        public void handle(TestEvent2 event) {
            this.handle();
        }
    }

    public class TestEvent2
    extends AbstractEvent<TestEventType2> {
        public TestEvent2(TestEventType2 type) {
            super((Enum)type);
        }
    }

    public static enum TestEventType2 {
        TYPE2;

    }

    class TestEventHandler1
    extends CountDownEventHandler
    implements EventHandler<TestEvent1> {
        TestEventHandler1() {
        }

        public void handle(TestEvent1 event) {
            this.handle();
        }
    }

    public class TestEvent1
    extends AbstractEvent<TestEventType1> {
        public TestEvent1(TestEventType1 type) {
            super((Enum)type);
        }
    }

    public static enum TestEventType1 {
        TYPE1;

    }

    static class CountDownEventHandler {
        static CountDownLatch latch;

        CountDownEventHandler() {
        }

        public void handle() {
            latch.countDown();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

