/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DagStatusSource;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Public
public class DAGStatus {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    final DagStatusSource source;
    DAGProtos.DAGStatusProtoOrBuilder proxy = null;
    Progress progress = null;
    LinkedHashMap<String, Progress> vertexProgress = null;
    TezCounters dagCounters = null;
    AtomicBoolean countersInitialized = new AtomicBoolean(false);

    @InterfaceAudience.Private
    public DAGStatus(DAGProtos.DAGStatusProtoOrBuilder proxy, DagStatusSource source) {
        this.proxy = proxy;
        this.source = source;
    }

    public State getState() {
        switch (this.proxy.getState()) {
            case DAG_SUBMITTED: {
                return State.SUBMITTED;
            }
            case DAG_INITING: 
            case DAG_TERMINATING: 
            case DAG_RUNNING: 
            case DAG_COMMITTING: {
                return State.RUNNING;
            }
            case DAG_SUCCEEDED: {
                return State.SUCCEEDED;
            }
            case DAG_FAILED: {
                return State.FAILED;
            }
            case DAG_KILLED: {
                return State.KILLED;
            }
            case DAG_ERROR: {
                return State.ERROR;
            }
        }
        throw new TezUncheckedException("Unsupported value for DAGStatus.State : " + this.proxy.getState());
    }

    public boolean isCompleted() {
        State state = this.getState();
        return state == State.SUCCEEDED || state == State.FAILED || state == State.KILLED || state == State.ERROR;
    }

    public List<String> getDiagnostics() {
        return this.proxy.getDiagnosticsList();
    }

    public Progress getDAGProgress() {
        if (this.progress == null && this.proxy.hasDAGProgress()) {
            this.progress = new Progress(this.proxy.getDAGProgress());
        }
        return this.progress;
    }

    public Map<String, Progress> getVertexProgress() {
        if (this.vertexProgress == null && this.proxy.getVertexProgressList() != null) {
            List<DAGProtos.StringProgressPairProto> kvList = this.proxy.getVertexProgressList();
            this.vertexProgress = new LinkedHashMap(kvList.size());
            for (DAGProtos.StringProgressPairProto kv : kvList) {
                this.vertexProgress.put(kv.getKey(), new Progress(kv.getProgress()));
            }
        }
        return this.vertexProgress;
    }

    public TezCounters getDAGCounters() {
        if (this.countersInitialized.get()) {
            return this.dagCounters;
        }
        if (this.proxy.hasDagCounters()) {
            this.dagCounters = DagTypeConverters.convertTezCountersFromProto(this.proxy.getDagCounters());
        }
        this.countersInitialized.set(true);
        return this.dagCounters;
    }

    public long getMemoryUsedByAM() {
        return this.proxy.getMemoryUsedByAM();
    }

    public long getMemoryUsedByTasks() {
        return this.proxy.getMemoryUsedByTasks();
    }

    @InterfaceAudience.Private
    DagStatusSource getSource() {
        return this.source;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DAGStatus) {
            DAGStatus other = (DAGStatus)obj;
            return this.getState() == other.getState() && this.getDiagnostics().equals(other.getDiagnostics()) && this.getDAGProgress().equals(other.getDAGProgress()) && this.getVertexProgress().equals(other.getVertexProgress()) && (this.getDAGCounters() == null && other.getDAGCounters() == null || this.getDAGCounters().equals(other.getDAGCounters()));
        }
        return false;
    }

    public int hashCode() {
        int prime = 44017;
        int result = 1;
        result = 44017 + this.getState().hashCode();
        List<String> diagnostics = this.getDiagnostics();
        Progress dagProgress = this.getDAGProgress();
        Map<String, Progress> vProgress = this.getVertexProgress();
        TezCounters counters = this.getDAGCounters();
        result = 44017 * result + (diagnostics == null ? 0 : diagnostics.hashCode());
        result = 44017 * result + (dagProgress == null ? 0 : dagProgress.hashCode());
        result = 44017 * result + (vProgress == null ? 0 : vProgress.hashCode());
        result = 44017 * result + (counters == null ? 0 : counters.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("status=" + this.getState());
        sb.append(", progress=" + this.getDAGProgress());
        sb.append(", diagnostics=" + StringUtils.join(this.getDiagnostics(), (String)LINE_SEPARATOR));
        sb.append(", memoryUsedByAM=").append(this.proxy.getMemoryUsedByAM());
        sb.append(", memoryUsedByTasks=").append(this.proxy.getMemoryUsedByTasks());
        sb.append(", counters=" + (this.getDAGCounters() == null ? "null" : this.getDAGCounters().toString()));
        return sb.toString();
    }

    public static enum State {
        SUBMITTED,
        INITING,
        RUNNING,
        SUCCEEDED,
        KILLED,
        FAILED,
        ERROR;

    }
}

