/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.Inflater;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.serviceplugins.api.ContainerLauncherDescriptor;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.apache.tez.serviceplugins.api.TaskCommunicatorDescriptor;
import org.apache.tez.serviceplugins.api.TaskSchedulerDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TestDagTypeConverters {
    static final String testScheduler = "testScheduler";
    static final String testLauncher = "testLauncher";
    static final String testComm = "testComm";
    static final String classSuffix = "_class";

    @Test(timeout=5000L)
    public void testTezEntityDescriptorSerialization() throws IOException {
        UserPayload payload = UserPayload.create((ByteBuffer)ByteBuffer.wrap(new String("Foobar").getBytes()), (int)100);
        String historytext = "Bar123";
        EntityDescriptor entityDescriptor = ((InputDescriptor)InputDescriptor.create((String)"inputClazz").setUserPayload(payload)).setHistoryText(historytext);
        DAGProtos.TezEntityDescriptorProto proto = DagTypeConverters.convertToDAGPlan((EntityDescriptor)entityDescriptor);
        Assert.assertEquals((long)payload.getVersion(), (long)proto.getTezUserPayload().getVersion());
        Assert.assertArrayEquals((byte[])payload.deepCopyAsArray(), (byte[])proto.getTezUserPayload().getUserPayload().toByteArray());
        Assert.assertTrue((boolean)proto.hasHistoryText());
        Assert.assertNotEquals((Object)historytext, (Object)proto.getHistoryText());
        Assert.assertEquals((Object)historytext, (Object)new String(TezCommonUtils.decompressByteStringToByteArray((ByteString)proto.getHistoryText())));
        InputDescriptor inputDescriptor = DagTypeConverters.convertInputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)proto);
        Assert.assertNull((Object)inputDescriptor.getHistoryText());
        String actualHistoryText = DagTypeConverters.getHistoryTextFromProto((DAGProtos.TezEntityDescriptorProto)proto, (Inflater)TezCommonUtils.newInflater());
        Assert.assertEquals((Object)historytext, (Object)actualHistoryText);
    }

    @Test(timeout=5000L)
    public void testYarnPathTranslation() {
        String p1String = "hdfs://mycluster/file";
        Path p1Path = new Path(p1String);
        URL lr1Url = ConverterUtils.getYarnUrlFromPath((Path)p1Path);
        String p1StringSerialized = DagTypeConverters.convertToDAGPlan((URL)lr1Url);
        URL lr1UrlDeserialized = DagTypeConverters.convertToYarnURL((String)p1StringSerialized);
        Assert.assertEquals((Object)"mycluster", (Object)lr1UrlDeserialized.getHost());
        Assert.assertEquals((Object)"/file", (Object)lr1UrlDeserialized.getFile());
        Assert.assertEquals((Object)"hdfs", (Object)lr1UrlDeserialized.getScheme());
        String p2String = "hdfs://mycluster:2311/file";
        Path p2Path = new Path(p2String);
        URL lr2Url = ConverterUtils.getYarnUrlFromPath((Path)p2Path);
        String p2StringSerialized = DagTypeConverters.convertToDAGPlan((URL)lr2Url);
        URL lr2UrlDeserialized = DagTypeConverters.convertToYarnURL((String)p2StringSerialized);
        Assert.assertEquals((Object)"mycluster", (Object)lr2UrlDeserialized.getHost());
        Assert.assertEquals((Object)"/file", (Object)lr2UrlDeserialized.getFile());
        Assert.assertEquals((Object)"hdfs", (Object)lr2UrlDeserialized.getScheme());
        Assert.assertEquals((long)2311L, (long)lr2UrlDeserialized.getPort());
    }

    @Test(timeout=5000L)
    public void testVertexExecutionContextTranslation() {
        Vertex.VertexExecutionContext originalContext = Vertex.VertexExecutionContext.createExecuteInAm((boolean)true);
        DAGProtos.VertexExecutionContextProto contextProto = DagTypeConverters.convertToProto((Vertex.VertexExecutionContext)originalContext);
        Vertex.VertexExecutionContext retrievedContext = DagTypeConverters.convertFromProto((DAGProtos.VertexExecutionContextProto)contextProto);
        Assert.assertEquals((Object)originalContext, (Object)retrievedContext);
        originalContext = Vertex.VertexExecutionContext.createExecuteInContainers((boolean)true);
        contextProto = DagTypeConverters.convertToProto((Vertex.VertexExecutionContext)originalContext);
        retrievedContext = DagTypeConverters.convertFromProto((DAGProtos.VertexExecutionContextProto)contextProto);
        Assert.assertEquals((Object)originalContext, (Object)retrievedContext);
        originalContext = Vertex.VertexExecutionContext.create((String)"plugin", (String)"plugin", (String)"plugin");
        contextProto = DagTypeConverters.convertToProto((Vertex.VertexExecutionContext)originalContext);
        retrievedContext = DagTypeConverters.convertFromProto((DAGProtos.VertexExecutionContextProto)contextProto);
        Assert.assertEquals((Object)originalContext, (Object)retrievedContext);
    }

    @Test(timeout=5000L)
    public void testServiceDescriptorTranslation() {
        ServicePluginsDescriptor servicePluginsDescriptor = ServicePluginsDescriptor.create((boolean)true);
        DAGProtos.AMPluginDescriptorProto proto = DagTypeConverters.convertServicePluginDescriptorToProto((ServicePluginsDescriptor)servicePluginsDescriptor);
        Assert.assertTrue((boolean)proto.hasUberEnabled());
        Assert.assertTrue((boolean)proto.hasContainersEnabled());
        Assert.assertTrue((boolean)proto.getUberEnabled());
        Assert.assertTrue((boolean)proto.getContainersEnabled());
        Assert.assertEquals((long)0L, (long)proto.getTaskSchedulersCount());
        Assert.assertEquals((long)0L, (long)proto.getContainerLaunchersCount());
        Assert.assertEquals((long)0L, (long)proto.getTaskCommunicatorsCount());
        TaskSchedulerDescriptor[] taskSchedulers = this.createTaskScheduelrs(1, false);
        ContainerLauncherDescriptor[] containerLaunchers = this.createContainerLaunchers(1, false);
        TaskCommunicatorDescriptor[] taskComms = this.createTaskCommunicators(1, true);
        servicePluginsDescriptor = ServicePluginsDescriptor.create((TaskSchedulerDescriptor[])taskSchedulers, (ContainerLauncherDescriptor[])containerLaunchers, (TaskCommunicatorDescriptor[])taskComms);
        proto = DagTypeConverters.convertServicePluginDescriptorToProto((ServicePluginsDescriptor)servicePluginsDescriptor);
        Assert.assertTrue((boolean)proto.hasUberEnabled());
        Assert.assertTrue((boolean)proto.hasContainersEnabled());
        Assert.assertFalse((boolean)proto.getUberEnabled());
        Assert.assertTrue((boolean)proto.getContainersEnabled());
        this.verifyPlugins(proto.getTaskSchedulersList(), 1, testScheduler, false);
        this.verifyPlugins(proto.getContainerLaunchersList(), 1, testLauncher, false);
        this.verifyPlugins(proto.getTaskCommunicatorsList(), 1, testComm, true);
        taskSchedulers = this.createTaskScheduelrs(3, true);
        containerLaunchers = this.createContainerLaunchers(3, true);
        taskComms = this.createTaskCommunicators(3, true);
        servicePluginsDescriptor = ServicePluginsDescriptor.create((TaskSchedulerDescriptor[])taskSchedulers, (ContainerLauncherDescriptor[])containerLaunchers, (TaskCommunicatorDescriptor[])taskComms);
        proto = DagTypeConverters.convertServicePluginDescriptorToProto((ServicePluginsDescriptor)servicePluginsDescriptor);
        Assert.assertTrue((boolean)proto.hasUberEnabled());
        Assert.assertTrue((boolean)proto.hasContainersEnabled());
        Assert.assertFalse((boolean)proto.getUberEnabled());
        Assert.assertTrue((boolean)proto.getContainersEnabled());
        this.verifyPlugins(proto.getTaskSchedulersList(), 3, testScheduler, true);
        this.verifyPlugins(proto.getContainerLaunchersList(), 3, testLauncher, true);
        this.verifyPlugins(proto.getTaskCommunicatorsList(), 3, testComm, true);
        taskSchedulers = this.createTaskScheduelrs(1, false);
        containerLaunchers = this.createContainerLaunchers(1, false);
        taskComms = this.createTaskCommunicators(1, true);
        servicePluginsDescriptor = ServicePluginsDescriptor.create((boolean)false, (boolean)true, (TaskSchedulerDescriptor[])taskSchedulers, (ContainerLauncherDescriptor[])containerLaunchers, (TaskCommunicatorDescriptor[])taskComms);
        proto = DagTypeConverters.convertServicePluginDescriptorToProto((ServicePluginsDescriptor)servicePluginsDescriptor);
        Assert.assertTrue((boolean)proto.hasUberEnabled());
        Assert.assertTrue((boolean)proto.hasContainersEnabled());
        Assert.assertTrue((boolean)proto.getUberEnabled());
        Assert.assertFalse((boolean)proto.getContainersEnabled());
        this.verifyPlugins(proto.getTaskSchedulersList(), 1, testScheduler, false);
        this.verifyPlugins(proto.getContainerLaunchersList(), 1, testLauncher, false);
        this.verifyPlugins(proto.getTaskCommunicatorsList(), 1, testComm, true);
    }

    @Test
    public void testAclConversions() {
        DAGAccessControls dagAccessControls = new DAGAccessControls("u1,u2 g1,g2", "u3,u4 g3,g4");
        DAGProtos.ACLInfo aclInfo = DagTypeConverters.convertDAGAccessControlsToProto((DAGAccessControls)dagAccessControls);
        this.assertSame(dagAccessControls, aclInfo);
        this.assertSame(DagTypeConverters.convertDAGAccessControlsFromProto((DAGProtos.ACLInfo)aclInfo), aclInfo);
        dagAccessControls = new DAGAccessControls("u1 ", "u2 ");
        aclInfo = DagTypeConverters.convertDAGAccessControlsToProto((DAGAccessControls)dagAccessControls);
        this.assertSame(dagAccessControls, aclInfo);
        this.assertSame(DagTypeConverters.convertDAGAccessControlsFromProto((DAGProtos.ACLInfo)aclInfo), aclInfo);
        dagAccessControls = new DAGAccessControls(" g1", " g3,g4");
        aclInfo = DagTypeConverters.convertDAGAccessControlsToProto((DAGAccessControls)dagAccessControls);
        this.assertSame(dagAccessControls, aclInfo);
        this.assertSame(DagTypeConverters.convertDAGAccessControlsFromProto((DAGProtos.ACLInfo)aclInfo), aclInfo);
        dagAccessControls = new DAGAccessControls("*", "*");
        aclInfo = DagTypeConverters.convertDAGAccessControlsToProto((DAGAccessControls)dagAccessControls);
        this.assertSame(dagAccessControls, aclInfo);
        this.assertSame(DagTypeConverters.convertDAGAccessControlsFromProto((DAGProtos.ACLInfo)aclInfo), aclInfo);
    }

    @Test
    public void testConvertStatusGetOptsToProtoCoverage() {
        DAGProtos.StatusGetOptsProto[] optProtos;
        StatusGetOpts[] opts;
        for (StatusGetOpts opt : opts = StatusGetOpts.values()) {
            DagTypeConverters.convertStatusGetOptsToProto((StatusGetOpts)opt);
        }
        for (DAGProtos.StatusGetOptsProto proto : optProtos = DAGProtos.StatusGetOptsProto.values()) {
            DagTypeConverters.convertStatusGetOptsFromProto((DAGProtos.StatusGetOptsProto)proto);
        }
    }

    private void assertSame(DAGAccessControls dagAccessControls, DAGProtos.ACLInfo aclInfo) {
        Assert.assertEquals((Object)dagAccessControls.getUsersWithViewACLs(), (Object)Sets.newHashSet((Iterable)aclInfo.getUsersWithViewAccessList()));
        Assert.assertEquals((Object)dagAccessControls.getUsersWithModifyACLs(), (Object)Sets.newHashSet((Iterable)aclInfo.getUsersWithModifyAccessList()));
        Assert.assertEquals((Object)dagAccessControls.getGroupsWithViewACLs(), (Object)Sets.newHashSet((Iterable)aclInfo.getGroupsWithViewAccessList()));
        Assert.assertEquals((Object)dagAccessControls.getGroupsWithModifyACLs(), (Object)Sets.newHashSet((Iterable)aclInfo.getGroupsWithModifyAccessList()));
    }

    private void verifyPlugins(List<DAGProtos.TezNamedEntityDescriptorProto> entities, int expectedCount, String baseString, boolean hasPayload) {
        Assert.assertEquals((long)expectedCount, (long)entities.size());
        for (int i = 0; i < expectedCount; ++i) {
            Assert.assertEquals((Object)this.indexedEntity(baseString, i), (Object)entities.get(i).getName());
            DAGProtos.TezEntityDescriptorProto subEntityProto = entities.get(i).getEntityDescriptor();
            Assert.assertEquals((Object)this.append(this.indexedEntity(baseString, i), classSuffix), (Object)subEntityProto.getClassName());
            Assert.assertEquals((Object)hasPayload, (Object)subEntityProto.hasTezUserPayload());
            if (!hasPayload) continue;
            UserPayload userPayload = UserPayload.create((ByteBuffer)subEntityProto.getTezUserPayload().getUserPayload().asReadOnlyByteBuffer(), (int)subEntityProto.getTezUserPayload().getVersion());
            ByteBuffer bb = userPayload.getPayload();
            Assert.assertNotNull((Object)bb);
            Assert.assertEquals((long)i, (long)bb.getInt());
        }
    }

    private TaskSchedulerDescriptor[] createTaskScheduelrs(int count, boolean withUserPayload) {
        TaskSchedulerDescriptor[] descriptors = new TaskSchedulerDescriptor[count];
        for (int i = 0; i < count; ++i) {
            descriptors[i] = TaskSchedulerDescriptor.create((String)this.indexedEntity(testScheduler, i), (String)this.append(this.indexedEntity(testScheduler, i), classSuffix));
            if (!withUserPayload) continue;
            descriptors[i].setUserPayload(TestDagTypeConverters.createPayload(i));
        }
        return descriptors;
    }

    private ContainerLauncherDescriptor[] createContainerLaunchers(int count, boolean withUserPayload) {
        ContainerLauncherDescriptor[] descriptors = new ContainerLauncherDescriptor[count];
        for (int i = 0; i < count; ++i) {
            descriptors[i] = ContainerLauncherDescriptor.create((String)this.indexedEntity(testLauncher, i), (String)this.append(this.indexedEntity(testLauncher, i), classSuffix));
            if (!withUserPayload) continue;
            descriptors[i].setUserPayload(TestDagTypeConverters.createPayload(i));
        }
        return descriptors;
    }

    private TaskCommunicatorDescriptor[] createTaskCommunicators(int count, boolean withUserPayload) {
        TaskCommunicatorDescriptor[] descriptors = new TaskCommunicatorDescriptor[count];
        for (int i = 0; i < count; ++i) {
            descriptors[i] = TaskCommunicatorDescriptor.create((String)this.indexedEntity(testComm, i), (String)this.append(this.indexedEntity(testComm, i), classSuffix));
            if (!withUserPayload) continue;
            descriptors[i].setUserPayload(TestDagTypeConverters.createPayload(i));
        }
        return descriptors;
    }

    private static UserPayload createPayload(int i) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, i);
        UserPayload payload = UserPayload.create((ByteBuffer)bb);
        return payload;
    }

    private String indexedEntity(String name, int index) {
        return name + index;
    }

    private String append(String s1, String s2) {
        return s1 + s2;
    }
}

