/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClientTimelineImpl;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestATSHttpClient {
    @Before
    public void setup() {
        String hadoopVersion = System.getProperty("tez.hadoop.version");
        Assume.assumeFalse((hadoopVersion.startsWith("2.2.") || hadoopVersion.startsWith("2.3.") ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testGetDagStatusThrowsExceptionOnEmptyJson() throws TezException {
        ApplicationId mockAppId = (ApplicationId)Mockito.mock(ApplicationId.class);
        DAGClientTimelineImpl httpClient = new DAGClientTimelineImpl(mockAppId, "EXAMPLE_DAG_ID", new TezConfiguration(), null, 0);
        DAGClientTimelineImpl spyClient = (DAGClientTimelineImpl)Mockito.spy((Object)httpClient);
        spyClient.baseUri = "http://yarn.ats.webapp/ws/v1/timeline";
        String expectedDagUrl = "http://yarn.ats.webapp/ws/v1/timeline/TEZ_DAG_ID/EXAMPLE_DAG_ID?fields=primaryfilters,otherinfo";
        ((DAGClientTimelineImpl)Mockito.doReturn((Object)new JSONObject()).when((Object)spyClient)).getJsonRootEntity("http://yarn.ats.webapp/ws/v1/timeline/TEZ_DAG_ID/EXAMPLE_DAG_ID?fields=primaryfilters,otherinfo");
        boolean exceptionHappened = false;
        try {
            spyClient.getDAGStatus(null);
        }
        catch (TezException e) {
            exceptionHappened = true;
        }
        catch (IOException e) {
            TestCase.fail((String)"should not come here");
        }
        Assert.assertTrue((String)"Expected TezException but did not happen", (boolean)exceptionHappened);
        ((DAGClientTimelineImpl)Mockito.verify((Object)spyClient)).getJsonRootEntity("http://yarn.ats.webapp/ws/v1/timeline/TEZ_DAG_ID/EXAMPLE_DAG_ID?fields=primaryfilters,otherinfo");
    }

    @Test(timeout=5000L)
    public void testGetDagStatusSimple() throws TezException, JSONException, IOException {
        DAGClientTimelineImpl httpClient = new DAGClientTimelineImpl((ApplicationId)Mockito.mock(ApplicationId.class), "EXAMPLE_DAG_ID", new TezConfiguration(), null, 0);
        DAGClientTimelineImpl spyClient = (DAGClientTimelineImpl)Mockito.spy((Object)httpClient);
        spyClient.baseUri = "http://yarn.ats.webapp/ws/v1/timeline";
        String expectedDagUrl = "http://yarn.ats.webapp/ws/v1/timeline/TEZ_DAG_ID/EXAMPLE_DAG_ID?fields=primaryfilters,otherinfo";
        String expectedVertexUrl = "http://yarn.ats.webapp/ws/v1/timeline/TEZ_VERTEX_ID?primaryFilter=TEZ_DAG_ID:EXAMPLE_DAG_ID&fields=primaryfilters,otherinfo";
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        String jsonDagData = "{   otherinfo: {     status: 'SUCCEEDED',    diagnostics: 'SAMPLE_DIAGNOSTICS',    counters: { counterGroups: [       { counterGroupName: 'CG1', counterGroupDisplayName: 'CGD1', counters: [        {counterName:'C1', counterDisplayName: 'CD1', counterValue: 1 },        {counterName:'C2', counterDisplayName: 'CD2', counterValue: 2 }      ]}    ]}  }}";
        String jsonVertexData = "{entities:[ {otherinfo: {vertexName:'v1', numTasks:5,numFailedTasks:1,numSucceededTasks:2,numKilledTasks:3,numCompletedTasks:3}},{otherinfo: {vertexName:'v2',numTasks:10,numFailedTasks:1,numSucceededTasks:5,numKilledTasks:3,numCompletedTasks:4}}]}";
        ((DAGClientTimelineImpl)Mockito.doReturn((Object)new JSONObject("{   otherinfo: {     status: 'SUCCEEDED',    diagnostics: 'SAMPLE_DIAGNOSTICS',    counters: { counterGroups: [       { counterGroupName: 'CG1', counterGroupDisplayName: 'CGD1', counters: [        {counterName:'C1', counterDisplayName: 'CD1', counterValue: 1 },        {counterName:'C2', counterDisplayName: 'CD2', counterValue: 2 }      ]}    ]}  }}")).when((Object)spyClient)).getJsonRootEntity("http://yarn.ats.webapp/ws/v1/timeline/TEZ_DAG_ID/EXAMPLE_DAG_ID?fields=primaryfilters,otherinfo");
        ((DAGClientTimelineImpl)Mockito.doReturn((Object)new JSONObject("{entities:[ {otherinfo: {vertexName:'v1', numTasks:5,numFailedTasks:1,numSucceededTasks:2,numKilledTasks:3,numCompletedTasks:3}},{otherinfo: {vertexName:'v2',numTasks:10,numFailedTasks:1,numSucceededTasks:5,numKilledTasks:3,numCompletedTasks:4}}]}")).when((Object)spyClient)).getJsonRootEntity("http://yarn.ats.webapp/ws/v1/timeline/TEZ_VERTEX_ID?primaryFilter=TEZ_DAG_ID:EXAMPLE_DAG_ID&fields=primaryfilters,otherinfo");
        DAGStatus dagStatus = spyClient.getDAGStatus(statusOptions);
        Assert.assertEquals((String)"DAG State", (Object)DAGStatus.State.SUCCEEDED, (Object)dagStatus.getState());
        Assert.assertEquals((String)"DAG Diagnostics size", (long)1L, (long)dagStatus.getDiagnostics().size());
        Assert.assertEquals((String)"DAG diagnostics detail", (Object)"SAMPLE_DIAGNOSTICS", dagStatus.getDiagnostics().get(0));
        Assert.assertEquals((String)"Counters Size", (long)2L, (long)dagStatus.getDAGCounters().countCounters());
        Assert.assertEquals((String)"Counter Value", (long)1L, (long)((CounterGroup)dagStatus.getDAGCounters().getGroup("CG1")).findCounter("C1").getValue());
        Assert.assertEquals((String)"total tasks", (long)15L, (long)dagStatus.getDAGProgress().getTotalTaskCount());
        Assert.assertEquals((String)"failed tasks", (long)2L, (long)dagStatus.getDAGProgress().getFailedTaskCount());
        Assert.assertEquals((String)"killed tasks", (long)6L, (long)dagStatus.getDAGProgress().getKilledTaskCount());
        Assert.assertEquals((String)"succeeded tasks", (long)7L, (long)dagStatus.getDAGProgress().getSucceededTaskCount());
        Assert.assertEquals((String)"running tasks", (long)8L, (long)dagStatus.getDAGProgress().getRunningTaskCount());
        Map vertexProgress = dagStatus.getVertexProgress();
        Assert.assertEquals((String)"vertex progress count", (long)2L, (long)vertexProgress.size());
        Assert.assertTrue((String)"vertex name1", (boolean)vertexProgress.containsKey("v1"));
        Assert.assertTrue((String)"vertex name2", (boolean)vertexProgress.containsKey("v2"));
    }

    @Test(timeout=5000L)
    public void testGetVertexStatusSimple() throws JSONException, TezException, IOException {
        DAGClientTimelineImpl httpClient = new DAGClientTimelineImpl((ApplicationId)Mockito.mock(ApplicationId.class), "EXAMPLE_DAG_ID", new TezConfiguration(), null, 0);
        DAGClientTimelineImpl spyClient = (DAGClientTimelineImpl)Mockito.spy((Object)httpClient);
        spyClient.baseUri = "http://yarn.ats.webapp/ws/v1/timeline";
        String expectedVertexUrl = "http://yarn.ats.webapp/ws/v1/timeline/TEZ_VERTEX_ID?primaryFilter=TEZ_DAG_ID:EXAMPLE_DAG_ID&secondaryFilter=vertexName:vertex1name&fields=primaryfilters,otherinfo";
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        String jsonData = "{entities:[ {otherinfo:{numFailedTasks:1,numSucceededTasks:2,status:'SUCCEEDED', vertexName:'vertex1name', numTasks:4, numKilledTasks: 3, numCompletedTasks: 4, diagnostics: 'diagnostics1', counters: { counterGroups: [       { counterGroupName: 'CG1', counterGroupDisplayName: 'CGD1', counters: [        {counterName:'C1', counterDisplayName: 'CD1', counterValue: 1 },        {counterName:'C2', counterDisplayName: 'CD2', counterValue: 2 }      ]}    ]}}}]}";
        ((DAGClientTimelineImpl)Mockito.doReturn((Object)new JSONObject("{entities:[ {otherinfo:{numFailedTasks:1,numSucceededTasks:2,status:'SUCCEEDED', vertexName:'vertex1name', numTasks:4, numKilledTasks: 3, numCompletedTasks: 4, diagnostics: 'diagnostics1', counters: { counterGroups: [       { counterGroupName: 'CG1', counterGroupDisplayName: 'CGD1', counters: [        {counterName:'C1', counterDisplayName: 'CD1', counterValue: 1 },        {counterName:'C2', counterDisplayName: 'CD2', counterValue: 2 }      ]}    ]}}}]}")).when((Object)spyClient)).getJsonRootEntity("http://yarn.ats.webapp/ws/v1/timeline/TEZ_VERTEX_ID?primaryFilter=TEZ_DAG_ID:EXAMPLE_DAG_ID&secondaryFilter=vertexName:vertex1name&fields=primaryfilters,otherinfo");
        VertexStatus vertexStatus = spyClient.getVertexStatus("vertex1name", statusOptions);
        Assert.assertEquals((String)"status check", (Object)VertexStatus.State.SUCCEEDED, (Object)vertexStatus.getState());
        Assert.assertEquals((String)"diagnostics", (Object)"diagnostics1", vertexStatus.getDiagnostics().get(0));
        Progress progress = vertexStatus.getProgress();
        TezCounters vertexCounters = vertexStatus.getVertexCounters();
        Assert.assertEquals((String)"failed task count", (long)1L, (long)progress.getFailedTaskCount());
        Assert.assertEquals((String)"suceeded task count", (long)2L, (long)progress.getSucceededTaskCount());
        Assert.assertEquals((String)"killed task count", (long)3L, (long)progress.getKilledTaskCount());
        Assert.assertEquals((String)"total task count", (long)4L, (long)progress.getTotalTaskCount());
        Assert.assertEquals((String)"Counters Size", (long)2L, (long)vertexCounters.countCounters());
        Assert.assertEquals((String)"Counter Value", (long)1L, (long)((CounterGroup)vertexCounters.getGroup("CG1")).findCounter("C1").getValue());
    }
}

