/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.ConfigurationScope;
import org.apache.tez.dag.api.TezConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestTezConfiguration {
    private static final String expectedValue = "tez.tar.gz";

    @Test(timeout=5000L)
    public void testConstruction() {
        TezConfiguration tezConf1 = new TezConfiguration();
        Assert.assertEquals((Object)expectedValue, (Object)tezConf1.get("tez.lib.uris"));
        Configuration tezConf2 = new Configuration(true);
        Assert.assertNull((Object)tezConf2.get("tez.lib.uris"));
        TezConfiguration tezConf3 = new TezConfiguration(new Configuration());
        Assert.assertEquals((Object)expectedValue, (Object)tezConf3.get("tez.lib.uris"));
        TezConfiguration tezConf4 = new TezConfiguration(false);
        Assert.assertNull((Object)tezConf4.get("tez.lib.uris"));
        Configuration tezConf5 = new Configuration(true);
        Assert.assertNull((Object)tezConf5.get("tez.lib.uris"));
    }

    @Test(timeout=5000L)
    public void testKeySet() throws IllegalAccessException {
        Class<TezConfiguration> c = TezConfiguration.class;
        HashSet<String> expectedKeys = new HashSet<String>();
        for (Field f : c.getFields()) {
            String value;
            if (f.getName().endsWith("DEFAULT") || f.getType() != String.class || f.getName().equals("TEZ_SITE_XML") || (value = (String)f.get(null)).endsWith(".")) continue;
            expectedKeys.add((String)f.get(null));
            Assert.assertNotNull((String)("field " + f.getName() + " do not have annotation of ConfigurationScope."), (Object)f.getAnnotation(ConfigurationScope.class));
        }
        Set actualKeySet = TezConfiguration.getPropertySet();
        for (String key : actualKeySet) {
            if (expectedKeys.remove(key)) continue;
            Assert.fail((String)("Found unexpected key: " + key + " in key set"));
        }
        Assert.assertTrue((String)("Missing keys in key set: " + expectedKeys), (expectedKeys.size() == 0 ? 1 : 0) != 0);
    }
}

