/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.security.ACLConfigurationParser;
import org.apache.tez.common.security.ACLType;
import org.junit.Assert;
import org.junit.Test;

public class TestACLConfigurationParser {
    @Test(timeout=5000L)
    public void testACLConfigParser() {
        Configuration conf = new Configuration(false);
        String adminACLs = "admin1,admin4,       admgrp3,admgrp4,admgrp5  ";
        String viewACLs = "user1,user4,       grp3,grp4,grp5  ";
        String modifyACLs = "user3 ";
        conf.set("yarn.admin.acl", adminACLs);
        conf.set("tez.am.view-acls", viewACLs);
        ACLConfigurationParser parser = new ACLConfigurationParser(conf);
        Assert.assertTrue((boolean)parser.getAllowedUsers().containsKey(ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)parser.getAllowedUsers().containsKey(ACLType.AM_MODIFY_ACL));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_VIEW_ACL)).contains("user1"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_VIEW_ACL)).contains("user3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_VIEW_ACL)).contains("user4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin1"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin4"));
        Assert.assertFalse((boolean)parser.getAllowedGroups().isEmpty());
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp3"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp6"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp5"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp5"));
        conf.set("tez.am.modify-acls", modifyACLs);
        parser = new ACLConfigurationParser(conf);
        Assert.assertTrue((boolean)parser.getAllowedUsers().containsKey(ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)parser.getAllowedUsers().containsKey(ACLType.AM_MODIFY_ACL));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_VIEW_ACL)).contains("user1"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_VIEW_ACL)).contains("user3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_VIEW_ACL)).contains("user4"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_MODIFY_ACL)).contains("user1"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.AM_MODIFY_ACL)).contains("user3"));
        Assert.assertFalse((boolean)parser.getAllowedGroups().isEmpty());
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp3"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp6"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp5"));
        Assert.assertFalse((boolean)parser.getAllowedGroups().isEmpty());
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp5"));
    }

    @Test(timeout=5000L)
    public void testGroupsOnly() {
        Configuration conf = new Configuration(false);
        String adminACLs = "admin1,admin4,       admgrp3,admgrp4,admgrp5  ";
        String viewACLs = "     grp3,grp4,grp5";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("yarn.admin.acl", adminACLs);
        ACLConfigurationParser parser = new ACLConfigurationParser(conf);
        Assert.assertFalse((boolean)parser.getAllowedUsers().isEmpty());
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin1"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin4"));
        Assert.assertFalse((boolean)parser.getAllowedGroups().isEmpty());
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp3"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp6"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.AM_VIEW_ACL)).contains("grp5"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp5"));
    }

    @Test(timeout=5000L)
    public void testDAGACLConfigParser() {
        Configuration conf = new Configuration(false);
        String adminACLs = "admin1,admin4,       admgrp3,admgrp4,admgrp5  ";
        String viewACLs = "user1,user4 grp3,grp4,grp5";
        String modifyACLs = "user3 grp4";
        conf.set("tez.am.dag.view-acls", viewACLs);
        conf.set("yarn.admin.acl", adminACLs);
        ACLConfigurationParser parser = new ACLConfigurationParser(conf, true);
        Assert.assertTrue((boolean)parser.getAllowedUsers().containsKey(ACLType.DAG_VIEW_ACL));
        Assert.assertFalse((boolean)parser.getAllowedUsers().containsKey(ACLType.DAG_MODIFY_ACL));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_VIEW_ACL)).contains("user1"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_VIEW_ACL)).contains("user3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_VIEW_ACL)).contains("user4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin1"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin4"));
        Assert.assertFalse((boolean)parser.getAllowedGroups().isEmpty());
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp3"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp6"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp5"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp5"));
        conf.set("tez.am.dag.modify-acls", modifyACLs);
        parser = new ACLConfigurationParser(conf, true);
        Assert.assertTrue((boolean)parser.getAllowedUsers().containsKey(ACLType.DAG_VIEW_ACL));
        Assert.assertTrue((boolean)parser.getAllowedUsers().containsKey(ACLType.DAG_MODIFY_ACL));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_VIEW_ACL)).contains("user1"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_VIEW_ACL)).contains("user3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_VIEW_ACL)).contains("user4"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_MODIFY_ACL)).contains("user1"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.DAG_MODIFY_ACL)).contains("user3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin1"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedUsers().get(ACLType.YARN_ADMIN_ACL)).contains("admin4"));
        Assert.assertFalse((boolean)parser.getAllowedGroups().isEmpty());
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp3"));
        Assert.assertFalse((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp6"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_VIEW_ACL)).contains("grp5"));
        Assert.assertNotNull(parser.getAllowedGroups().get(ACLType.DAG_MODIFY_ACL));
        Assert.assertFalse((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_MODIFY_ACL)).contains("grp6"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.DAG_MODIFY_ACL)).contains("grp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp3"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp4"));
        Assert.assertTrue((boolean)((Set)parser.getAllowedGroups().get(ACLType.YARN_ADMIN_ACL)).contains("admgrp5"));
    }
}

