/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.hadoop.shim;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.tez.hadoop.shim.HadoopShim;

public class HadoopShim28
extends HadoopShim {
    static final CallerContext nullCallerContext = new CallerContext.Builder("").build();

    public void setHadoopCallerContext(String context) {
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder(context).build());
    }

    public void clearHadoopCallerContext() {
        CallerContext.setCurrent((CallerContext)nullCallerContext);
    }

    public Set<String> getSupportedResourceTypes(RegisterApplicationMasterResponse response) {
        EnumSet supportedResourceTypes = response.getSchedulerResourceTypes();
        HashSet<String> supportedTypes = new HashSet<String>();
        for (YarnServiceProtos.SchedulerResourceTypes resourceType : supportedResourceTypes) {
            supportedTypes.add(resourceType.name());
        }
        return supportedTypes;
    }

    public FinalApplicationStatus applyFinalApplicationStatusCorrection(FinalApplicationStatus orig, boolean isSessionMode, boolean isError) {
        switch (orig) {
            case FAILED: {
                return !isSessionMode || isError ? FinalApplicationStatus.FAILED : FinalApplicationStatus.ENDED;
            }
            case SUCCEEDED: {
                return isSessionMode ? FinalApplicationStatus.ENDED : FinalApplicationStatus.SUCCEEDED;
            }
        }
        return orig;
    }
}

