/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.hadoop.shim;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim28;
import org.apache.tez.hadoop.shim.HadoopShim28Provider;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.junit.Assert;
import org.junit.Test;

public class TestHadoopShim28Provider {
    @Test
    public void testShimProvider() {
        HadoopShim28Provider provider = new HadoopShim28Provider();
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 2));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 7));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 5));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 2, 6));
        Assert.assertNull((Object)provider.createHadoopShim("foo", 3, 3));
        Assert.assertNotNull((Object)provider.createHadoopShim("foo", 2, 8));
        Assert.assertNotNull((Object)provider.createHadoopShim("foo", 2, 111));
        Assert.assertEquals(HadoopShim28.class, provider.createHadoopShim("foo", 2, 9).getClass());
    }

    @Test
    public void testLoaderOverride() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.provider.class", HadoopShim28Provider.class.getName());
        conf.set("tez.hadoop.shim.hadoop.version.override", "2.8.0");
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(HadoopShim28.class, shim.getClass());
    }

    @Test
    public void testInvalidVersion() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.hadoop.version.override", "2.2.0");
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(DefaultHadoopShim.class, shim.getClass());
    }

    @Test
    public void testLoaderOverrideInvalidVersion() {
        Configuration conf = new Configuration(false);
        conf.set("tez.hadoop.shim.provider.class", HadoopShim28Provider.class.getName());
        conf.set("tez.hadoop.shim.hadoop.version.override", "2.1.0");
        HadoopShimsLoader loader = new HadoopShimsLoader(conf, true);
        HadoopShim shim = loader.getHadoopShim();
        Assert.assertNotNull((Object)shim);
        Assert.assertEquals(DefaultHadoopShim.class, shim.getClass());
    }
}

