/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.conftool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.tez.conftool.ConfCli;
import org.apache.tez.conftool.ConfTool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestConfCli {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void printHelpTest() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ConfCli.main((String[])new String[]{"--help"});
        String output = baos.toString();
        Assert.assertTrue((boolean)output.contains("Print help information"));
    }

    @Test
    public void testNoArguments() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ConfCli.main((String[])new String[]{""});
        String output = baos.toString();
        Assert.assertTrue((boolean)output.contains("Print help information"));
    }

    @Test
    public void testNullArguments() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ConfCli.main(null);
        String output = baos.toString();
        Assert.assertTrue((boolean)output.contains("Print help information"));
    }

    @Test
    public void testParsingError() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Parsing failed");
        ConfCli.main((String[])new String[]{"--lhjlk", "-/--l)9"});
    }

    @Test
    public void testSecurityTrue() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "true"});
        String output = baos.toString();
        Assert.assertFalse((boolean)output.contains("Print help information"));
    }

    @Test
    public void testSecurityFalse() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "false"});
        String output = baos.toString();
        Assert.assertFalse((boolean)output.contains("Print help information"));
    }

    @Test
    public void testSecurityCustom() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "custom"});
        String output = baos.toString();
        Assert.assertFalse((boolean)output.contains("Print help information"));
    }

    @Test
    public void testSecurityIllegalArgument() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-01.xml");
        String pathToTezSite = url.getPath();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Incorrect security configuration options");
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "wrong"});
    }

    @Test
    public void testSetHeadersMaprSASL() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-03.xml");
        String testHeadersPath = "test/header/file";
        String pathToTezSite = url.getPath();
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "true", "--headers", testHeadersPath});
        Assert.assertEquals((Object)testHeadersPath, (Object)this.getProperty(pathToTezSite, "tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testNotSetHeadersNoneSecurity() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-03.xml");
        String pathToTezSite = url.getPath();
        String testHeadersPath = "test/header/file";
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "false", "--headers", testHeadersPath});
        Assert.assertFalse((boolean)this.propertyExists(pathToTezSite, "tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testRemoveHeadersNoneSecurity() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-04.xml");
        String pathToTezSite = url.getPath();
        String testHeadersPath = "test/header/file";
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "false", "--headers", testHeadersPath});
        Assert.assertFalse((boolean)this.propertyExists(pathToTezSite, "tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testNotRemoveHeadersCustom() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-04.xml");
        String pathToTezSite = url.getPath();
        String beforeHeadersPath = this.getProperty(pathToTezSite, "tez.ui.tomcat.response.headers.file");
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "custom", "--headers", "test/headers/path"});
        Assert.assertEquals((Object)beforeHeadersPath, (Object)this.getProperty(pathToTezSite, "tez.ui.tomcat.response.headers.file"));
    }

    @Test
    public void testNotSetHeadersCustom() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("tez-site-03.xml");
        String pathToTezSite = url.getPath();
        String testHeadersPath = "test/header/file";
        ConfCli.main((String[])new String[]{"--path", pathToTezSite, "--security", "custom", "--headers", testHeadersPath});
        Assert.assertFalse((boolean)this.propertyExists(pathToTezSite, "tez.ui.tomcat.response.headers.file"));
    }

    private String getProperty(String pathToTezSite, String property) throws IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument((String)pathToTezSite);
        return ConfTool.getProperty((Document)doc, (String)property);
    }

    private boolean propertyExists(String pathToTezSite, String property) throws IOException, SAXException, ParserConfigurationException {
        Document doc = ConfTool.readDocument((String)pathToTezSite);
        return ConfTool.propertyExists((Document)doc, (String)property);
    }
}

