/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.yarn;

import com.codahale.metrics.MetricSet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.network.shuffle.ExternalBlockHandler;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.MergedShuffleFileManager;
import org.apache.spark.network.shuffle.NoOpMergedShuffleFileManager;
import org.apache.spark.network.shuffle.RemoteBlockPushResolver;
import org.apache.spark.network.shuffle.ShuffleTestAccessor$;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.network.yarn.YarnShuffleService;
import org.apache.spark.network.yarn.YarnShuffleServiceMetrics;
import org.apache.spark.tags.ExtendedLevelDBTest;
import org.apache.spark.util.Utils$;
import org.iq80.leveldb.DB;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Entry;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Collecting;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.dsl.BeWord;
import org.scalatest.matchers.dsl.ContainWord;
import org.scalatest.matchers.dsl.DefinedWord;
import org.scalatest.matchers.dsl.EmptyWord;
import org.scalatest.matchers.dsl.EndWithWord;
import org.scalatest.matchers.dsl.ExistWord;
import org.scalatest.matchers.dsl.FullyMatchWord;
import org.scalatest.matchers.dsl.HaveWord;
import org.scalatest.matchers.dsl.IncludeWord;
import org.scalatest.matchers.dsl.LengthWord;
import org.scalatest.matchers.dsl.MatchPatternWord;
import org.scalatest.matchers.dsl.MatcherFactory1;
import org.scalatest.matchers.dsl.MatcherWords;
import org.scalatest.matchers.dsl.NoExceptionWord;
import org.scalatest.matchers.dsl.NotWord;
import org.scalatest.matchers.dsl.ReadableWord;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAllElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfAllOfApplication;
import org.scalatest.matchers.dsl.ResultOfAnTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfDefinedAt;
import org.scalatest.matchers.dsl.ResultOfGreaterThanComparison;
import org.scalatest.matchers.dsl.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfInOrderApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfLessThanComparison;
import org.scalatest.matchers.dsl.ResultOfLessThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfMessageWordApplication;
import org.scalatest.matchers.dsl.ResultOfNoElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfNoneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOfTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfThrownByApplication;
import org.scalatest.matchers.dsl.SizeWord;
import org.scalatest.matchers.dsl.SortedWord;
import org.scalatest.matchers.dsl.StartWithWord;
import org.scalatest.matchers.dsl.WritableWord;
import org.scalatest.matchers.must.Matchers;
import org.scalatest.matchers.must.Matchers$AtLeastCollected$;
import org.scalatest.matchers.must.Matchers$AtMostCollected$;
import org.scalatest.matchers.must.Matchers$BetweenCollected$;
import org.scalatest.matchers.must.Matchers$ExactlyCollected$;
import org.scalatest.matchers.should.Matchers$;
import org.scalatest.time.Span$;
import org.scalatest.verbs.CompileWord;
import org.scalatest.verbs.MustVerb;
import org.scalatest.verbs.TypeCheckWord;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SetLike;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ExtendedLevelDBTest
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\f\u0018\u0001\tBQ!\u000e\u0001\u0005\u0002YB\u0001\"\u000f\u0001A\u0002\u0013\u0005qC\u000f\u0005\t\t\u0002\u0001\r\u0011\"\u0001\u0018\u000b\"1a\n\u0001Q!\nmB\u0001b\u0014\u0001C\u0002\u0013\u0005q\u0003\u0015\u0005\u00073\u0002\u0001\u000b\u0011B)\t\u0013i\u0003\u0001\u0019!a\u0001\n\u0013Y\u0006\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0003d\u0011%)\u0007\u00011A\u0001B\u0003&A\fC\u0003g\u0001\u0011\u0005s\rC\u0004i\u0001\u0001\u0007I\u0011A5\t\u000f5\u0004\u0001\u0019!C\u0001]\"1\u0001\u000f\u0001Q!\n)Dq!\u001d\u0001A\u0002\u0013\u0005\u0011\u000eC\u0004s\u0001\u0001\u0007I\u0011A:\t\rU\u0004\u0001\u0015)\u0003k\u0011\u001d1\b\u00011A\u0005\u0002%Dqa\u001e\u0001A\u0002\u0013\u0005\u0001\u0010\u0003\u0004{\u0001\u0001\u0006KA\u001b\u0005\u0006w\u0002!\te\u001a\u0005\u0006y\u0002!I! \u0002\u00183\u0006\u0014hn\u00155vM\u001adWmU3sm&\u001cWmU;ji\u0016T!\u0001G\r\u0002\te\f'O\u001c\u0006\u00035m\tqA\\3uo>\u00148N\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0012(cA\u0011A%J\u0007\u00027%\u0011ae\u0007\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013\u0001B7vgRT!\u0001L\u0017\u0002\u00115\fGo\u00195feNT!AL\u0010\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u0019*\u0005!i\u0015\r^2iKJ\u001c\bC\u0001\u001a4\u001b\u0005i\u0013B\u0001\u001b.\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0002\rqJg.\u001b;?)\u00059\u0004C\u0001\u001d\u0001\u001b\u00059\u0012AC=be:\u001cuN\u001c4jOV\t1\b\u0005\u0002=\u00056\tQH\u0003\u0002?\u007f\u0005!1m\u001c8g\u0015\tA\u0002I\u0003\u0002B;\u00051\u0001.\u00193p_BL!aQ\u001f\u0003#e\u000b'O\\\"p]\u001aLw-\u001e:bi&|g.\u0001\bzCJt7i\u001c8gS\u001e|F%Z9\u0015\u0005\u0019c\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%\u0001B+oSRDq!T\u0002\u0002\u0002\u0003\u00071(A\u0002yIE\n1\"_1s]\u000e{gNZ5hA\u0005a1k\u0014*U?6\u000be*Q$F%V\t\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006!A.\u00198h\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003\rM#(/\u001b8h\u00035\u0019vJ\u0015+`\u001b\u0006s\u0015iR#SA\u0005\u0001\"/Z2pm\u0016\u0014\u0018\u0010T8dC2$\u0015N]\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011q,V\u0001\u0003S>L!!\u00190\u0003\t\u0019KG.Z\u0001\u0015e\u0016\u001cwN^3ss2{7-\u00197ESJ|F%Z9\u0015\u0005\u0019#\u0007bB'\t\u0003\u0003\u0005\r\u0001X\u0001\u0012e\u0016\u001cwN^3ss2{7-\u00197ESJ\u0004\u0013A\u00032fM>\u0014X-R1dQR\ta)\u0001\u0002tcU\t!\u000e\u0005\u00029W&\u0011An\u0006\u0002\u00133\u0006\u0014hn\u00155vM\u001adWmU3sm&\u001cW-\u0001\u0004tc}#S-\u001d\u000b\u0003\r>Dq!\u0014\u0007\u0002\u0002\u0003\u0007!.A\u0002tc\u0001\n!a\u001d\u001a\u0002\rM\u0014t\fJ3r)\t1E\u000fC\u0004N\u001f\u0005\u0005\t\u0019\u00016\u0002\u0007M\u0014\u0004%\u0001\u0002tg\u000511oM0%KF$\"AR=\t\u000f5\u0013\u0012\u0011!a\u0001U\u0006\u00191o\r\u0011\u0002\u0013\u00054G/\u001a:FC\u000eD\u0017aC7bW\u0016\f\u0005\u000f]%oM>$RA`A\u0007\u0003K\u00012a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011aA1qS*\u0019\u0011qA \u0002\rM,'O^3s\u0013\u0011\tY!!\u0001\u0003A\u0005\u0003\b\u000f\\5dCRLwN\\%oSRL\u0017\r\\5{CRLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u001f)\u0002\u0019AA\t\u0003\u0011)8/\u001a:\u0011\t\u0005M\u0011\u0011\u0005\b\u0005\u0003+\ti\u0002E\u0002\u0002\u0018!k!!!\u0007\u000b\u0007\u0005m\u0011%\u0001\u0004=e>|GOP\u0005\u0004\u0003?A\u0015A\u0002)sK\u0012,g-C\u0002Y\u0003GQ1!a\bI\u0011\u001d\t9#\u0006a\u0001\u0003S\tQ!\u00199q\u0013\u0012\u0004B!a\u000b\u000245\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0004sK\u000e|'\u000fZ:\u000b\u0007\u0005\rq(\u0003\u0003\u00026\u00055\"!D!qa2L7-\u0019;j_:LE\rK\u0002\u0001\u0003s\u0001B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fY\u0012\u0001\u0002;bONLA!a\u0011\u0002>\t\u0019R\t\u001f;f]\u0012,G\rT3wK2$%\tV3ti\u0002")
public class YarnShuffleServiceSuite
extends SparkFunSuite
implements Matchers {
    private YarnConfiguration yarnConfig;
    private final String SORT_MANAGER;
    private File recoveryLocalDir;
    private YarnShuffleService s1;
    private YarnShuffleService s2;
    private YarnShuffleService s3;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private final Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyMustWrapper<T> convertToAnyMustWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyMustWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringMustWrapper convertToStringMustWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringMustWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public MustVerb.StringMustWrapperForVerb convertToStringMustWrapperForVerb(String o, Position position) {
        return MustVerb.convertToStringMustWrapperForVerb$((MustVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected() {
        return this.org$scalatest$matchers$must$Matchers$$AllCollected;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected() {
        return this.org$scalatest$matchers$must$Matchers$$EveryCollected;
    }

    public Matchers$BetweenCollected$ org$scalatest$matchers$must$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$matchers$must$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$matchers$must$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected() {
        return this.org$scalatest$matchers$must$Matchers$$NoCollected;
    }

    public Matchers$ExactlyCollected$ org$scalatest$matchers$must$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper() {
        return this.org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$AllCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$AllCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$EveryCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$EveryCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$NoCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$NoCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$MustMethodHelper_$eq(Matchers.MustMethodHelperClass x$1) {
        this.org$scalatest$matchers$must$Matchers$$MustMethodHelper = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public YarnConfiguration yarnConfig() {
        return this.yarnConfig;
    }

    public void yarnConfig_$eq(YarnConfiguration x$1) {
        this.yarnConfig = x$1;
    }

    public String SORT_MANAGER() {
        return this.SORT_MANAGER;
    }

    private File recoveryLocalDir() {
        return this.recoveryLocalDir;
    }

    private void recoveryLocalDir_$eq(File x$1) {
        this.recoveryLocalDir = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        DefaultMetricsSystem.shutdown();
        DefaultMetricsSystem.setInstance((MetricsSystem)new MetricsSystemImpl());
        this.yarnConfig_$eq(new YarnConfiguration());
        this.yarnConfig().set("yarn.nodemanager.aux-services", "spark_shuffle");
        this.yarnConfig().set(new StringOps(Predef$.MODULE$.augmentString("yarn.nodemanager.aux-services.%s.class")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark_shuffle"})), YarnShuffleService.class.getCanonicalName());
        this.yarnConfig().setInt(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_PORT().key(), 0);
        this.yarnConfig().setBoolean("spark.yarn.shuffle.stopOnFailure", true);
        File localDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        this.yarnConfig().set("yarn.nodemanager.local-dirs", localDir.getAbsolutePath());
        this.recoveryLocalDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
    }

    public YarnShuffleService s1() {
        return this.s1;
    }

    public void s1_$eq(YarnShuffleService x$1) {
        this.s1 = x$1;
    }

    public YarnShuffleService s2() {
        return this.s2;
    }

    public void s2_$eq(YarnShuffleService x$1) {
        this.s2 = x$1;
    }

    public YarnShuffleService s3() {
        return this.s3;
    }

    public void s3_$eq(YarnShuffleService x$1) {
        this.s3 = x$1;
    }

    public void afterEach() {
        try {
            if (this.s1() != null) {
                this.s1().stop();
                this.s1_$eq(null);
            }
            if (this.s2() != null) {
                this.s2().stop();
                this.s2_$eq(null);
            }
            if (this.s3() != null) {
                this.s3().stop();
                this.s3_$eq(null);
            }
        }
        finally {
            BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        }
    }

    private ApplicationInitializationContext makeAppInfo(String user, ApplicationId appId) {
        ByteBuffer secret = ByteBuffer.wrap(new byte[0]);
        return new ApplicationInitializationContext(user, appId, secret);
    }

    private final void org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1() {
        YarnShuffleServiceSuite yarnShuffleServiceSuite = this;
        synchronized (yarnShuffleServiceSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final File findExistingParent$1(File file) {
        while (file != null) {
            if (file.exists()) {
                return file;
            }
            file = file.getParentFile();
        }
        return file;
    }

    public YarnShuffleServiceSuite() {
        Tolerance.$init$((Tolerance)this);
        MustVerb.$init$((MustVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.yarnConfig = null;
        this.SORT_MANAGER = "org.apache.spark.shuffle.sort.SortShuffleManager";
        this.s1 = null;
        this.s2 = null;
        this.s3 = null;
        this.test("executor state kept across NM restart", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.yarnConfig().setBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), true);
            this.s1().init((Configuration)this.yarnConfig());
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s1().initializeApplication(app2Data);
            File execStateFile = $this.s1().registeredExecutorFile;
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)execStateFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            File secretsFile = $this.s1().secretsFile;
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            blockResolver.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            if (!execStateFile.exists()) {
                File existingParent = this.findExistingParent$1(execStateFile);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(46).append(execStateFile).append(" does not exist -- closest existing parent is ").append(existingParent).toString(), Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(14).append(execStateFile).append(" did not exist").toString(), Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            this.s1().stop();
            this.s2_$eq(new YarnShuffleService());
            this.s2().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s2().init((Configuration)this.yarnConfig());
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s2().secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146), Prettifier$.MODULE$.default()).should(this.be().apply((Object)secretsFile));
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s2().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            ExternalBlockHandler handler2 = $this.s2().blockHandler;
            ExternalShuffleBlockResolver resolver2 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler2);
            this.s2().initializeApplication(app1Data);
            this.s2().stopApplication(new ApplicationTerminationContext(app2Id));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            this.s2().stop();
            this.s3_$eq(new YarnShuffleService());
            this.s3().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s3().init((Configuration)this.yarnConfig());
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s3().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s3().secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165), Prettifier$.MODULE$.default()).should(this.be().apply((Object)secretsFile));
            ExternalBlockHandler handler3 = $this.s3().blockHandler;
            ExternalShuffleBlockResolver resolver3 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler3);
            this.s3().initializeApplication(app1Data);
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", resolver3), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver3), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            this.s3().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("removed applications should not be in registered executor file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.yarnConfig().setBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), false);
            this.s1().init((Configuration)this.yarnConfig());
            File secretsFile = $this.s1().secretsFile;
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183), Prettifier$.MODULE$.default()).should(this.be().apply(null));
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s1().initializeApplication(app2Data);
            File execStateFile = $this.s1().registeredExecutorFile;
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)execStateFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            blockResolver.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            DB db = ShuffleTestAccessor$.MODULE$.shuffleServiceLevelDB(blockResolver);
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.reloadRegisteredExecutors(db), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204), Prettifier$.MODULE$.default()).should(this.not()).be(this.empty(), Emptiness$.MODULE$.emptinessOfJavaMap());
            this.s1().stopApplication(new ApplicationTerminationContext(app1Id));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.reloadRegisteredExecutors(db), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207), Prettifier$.MODULE$.default()).should(this.not()).be(this.empty(), Emptiness$.MODULE$.emptinessOfJavaMap());
            this.s1().stopApplication(new ApplicationTerminationContext(app2Id));
            return Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.reloadRegisteredExecutors(db), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209), Prettifier$.MODULE$.default()).shouldBe(this.empty(), Emptiness$.MODULE$.emptinessOfJavaMap());
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("shuffle service should be robust to corrupt registered executor file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s1().init((Configuration)this.yarnConfig());
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            File execStateFile = $this.s1().registeredExecutorFile;
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            this.s1().stop();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])execStateFile.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.delete()));
            DataOutputStream out = new DataOutputStream(new FileOutputStream(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)execStateFile), "/CURRENT")));
            out.writeInt(42);
            out.close();
            this.s2_$eq(new YarnShuffleService());
            this.s2().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s2().init((Configuration)this.yarnConfig());
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s2().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            ExternalBlockHandler handler2 = $this.s2().blockHandler;
            ExternalShuffleBlockResolver resolver2 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler2);
            this.s2().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s2().initializeApplication(app2Data);
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            resolver2.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            this.s2().stop();
            this.s3_$eq(new YarnShuffleService());
            this.s3().setRecoveryPath(new Path(this.recoveryLocalDir().toURI()));
            this.s3().init((Configuration)this.yarnConfig());
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s3().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            ExternalBlockHandler handler3 = $this.s3().blockHandler;
            ExternalShuffleBlockResolver resolver3 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler3);
            this.s3().initializeApplication(app2Data);
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver3), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            this.s3().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("get correct recovery path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            Path recoveryPath = new Path(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI());
            this.s1().setRecoveryPath(recoveryPath);
            this.s1().init((Configuration)this.yarnConfig());
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s1()._recoveryPath, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279), Prettifier$.MODULE$.default()).should(this.be().apply((Object)recoveryPath));
            this.s1().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("moving recovery file from NM local dir to recovery path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().setRecoveryPath(new Path(this.yarnConfig().getTrimmedStrings("yarn.nodemanager.local-dirs")[0]));
            this.yarnConfig().setBoolean(SecurityManager$.MODULE$.SPARK_AUTH_CONF(), true);
            this.s1().init((Configuration)this.yarnConfig());
            ApplicationId app1Id = ApplicationId.newInstance((long)0L, (int)1);
            ApplicationInitializationContext app1Data = this.makeAppInfo("user", app1Id);
            this.s1().initializeApplication(app1Data);
            ApplicationId app2Id = ApplicationId.newInstance((long)0L, (int)2);
            ApplicationInitializationContext app2Data = this.makeAppInfo("user", app2Id);
            this.s1().initializeApplication(app2Data);
            String $org_scalatest_assert_macro_left = $this.s1().secretManager.getSecretKey(app1Id.toString());
            Object $org_scalatest_assert_macro_right = null;
            String string = $org_scalatest_assert_macro_left;
            Object var8_7 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, string == null ? var8_7 != null : !string.equals(var8_7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            String $org_scalatest_assert_macro_left2 = $this.s1().secretManager.getSecretKey(app2Id.toString());
            Object $org_scalatest_assert_macro_right2 = null;
            String string2 = $org_scalatest_assert_macro_left2;
            Object var12_11 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, string2 == null ? var12_11 != null : !string2.equals(var12_11), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            File execStateFile = $this.s1().registeredExecutorFile;
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)execStateFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            File secretsFile = $this.s1().secretsFile;
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307), Prettifier$.MODULE$.default()).should(this.not()).be(null, Predef$.MODULE$.$conforms());
            ExecutorShuffleInfo shuffleInfo1 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/foo", "/bar"}), 3, this.SORT_MANAGER());
            ExecutorShuffleInfo shuffleInfo2 = new ExecutorShuffleInfo((String[])((Object[])new String[]{"/bippy"}), 5, this.SORT_MANAGER());
            ExternalBlockHandler blockHandler = $this.s1().blockHandler;
            ExternalShuffleBlockResolver blockResolver = ShuffleTestAccessor$.MODULE$.getBlockResolver(blockHandler);
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)ShuffleTestAccessor$.MODULE$.registeredExecutorFile(blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313), Prettifier$.MODULE$.default()).should(this.be().apply((Object)execStateFile));
            blockResolver.registerExecutor(app1Id.toString(), "exec-1", shuffleInfo1);
            blockResolver.registerExecutor(app2Id.toString(), "exec-2", shuffleInfo2);
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", blockResolver), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo2)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(14).append(execStateFile).append(" did not exist").toString(), Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            this.s1().stop();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            Path recoveryPath = new Path(this.recoveryLocalDir().toURI());
            this.s2_$eq(new YarnShuffleService());
            this.s2().setRecoveryPath(recoveryPath);
            this.s2().init((Configuration)this.yarnConfig());
            String $org_scalatest_assert_macro_left3 = $this.s2().secretManager.getSecretKey(app1Id.toString());
            Object $org_scalatest_assert_macro_right3 = null;
            String string3 = $org_scalatest_assert_macro_left3;
            Object var25_24 = null;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, string3 == null ? var25_24 != null : !string3.equals(var25_24), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            String $org_scalatest_assert_macro_left4 = $this.s2().secretManager.getSecretKey(app2Id.toString());
            Object $org_scalatest_assert_macro_right4 = null;
            String string4 = $org_scalatest_assert_macro_left4;
            Object var29_28 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", null, string4 == null ? var29_28 != null : !string4.equals(var29_28), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            File execStateFile2 = $this.s2().registeredExecutorFile;
            File secretsFile2 = $this.s2().secretsFile;
            Matchers$.MODULE$.convertToStringShouldWrapper(recoveryPath.toString(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Path(execStateFile2.getParentFile().toURI()).toString()));
            Matchers$.MODULE$.convertToStringShouldWrapper(recoveryPath.toString(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Path(secretsFile2.getParentFile().toURI()).toString()));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(execStateFile.exists(), "execStateFile.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).milliseconds())), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(secretsFile.exists(), "secretsFile.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            ExternalBlockHandler handler2 = $this.s2().blockHandler;
            ExternalShuffleBlockResolver resolver2 = ShuffleTestAccessor$.MODULE$.getBlockResolver(handler2);
            this.s2().initializeApplication(app1Data);
            this.s2().stopApplication(new ApplicationTerminationContext(app2Id));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app1Id, "exec-1", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)shuffleInfo1)));
            Matchers$.MODULE$.convertToAnyShouldWrapper(ShuffleTestAccessor$.MODULE$.getExecutorInfo(app2Id, "exec-2", resolver2), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            this.s2().stop();
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("service throws error if cannot start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            File roDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            Files.setPosixFilePermissions(roDir.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE));
            YarnShuffleService service = new YarnShuffleService();
            service.setRecoveryPath(new Path(roDir.toURI()));
            try {
                ServiceStateException error = (ServiceStateException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.init((Configuration)this.yarnConfig()), ClassTag$.MODULE$.apply(ServiceStateException.class), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
                Throwable $org_scalatest_assert_macro_left = error.getCause();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.io.IOException", $org_scalatest_assert_macro_left instanceof IOException, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            }
            finally {
                service.stop();
                Files.setPosixFilePermissions(roDir.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
            }
            return assertion;
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("recovery db should not be created if NM recovery is not enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().init((Configuration)this.yarnConfig());
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s1()._recoveryPath, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392), Prettifier$.MODULE$.default()).should(this.be().apply(null));
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s1().registeredExecutorFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393), Prettifier$.MODULE$.default()).should(this.be().apply(null));
            return Matchers$.MODULE$.convertToAnyShouldWrapper((Object)$this.s1().secretsFile, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394), Prettifier$.MODULE$.default()).should(this.be().apply(null));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        this.test("SPARK-31646: metrics should be registered into Node Manager's metrics system", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.s1().init((Configuration)this.yarnConfig());
            YarnShuffleServiceMetrics metricsSource = (YarnShuffleServiceMetrics)((MetricsSystemImpl)DefaultMetricsSystem.instance()).getSource("sparkShuffleService");
            Field metricSetRef = YarnShuffleServiceMetrics.class.getDeclaredField("metricSet");
            metricSetRef.setAccessible(true);
            java.util.Map metrics = ((MetricSet)metricSetRef.get(metricsSource)).getMetrics();
            Seq $org_scalatest_assert_macro_left = (Seq)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
            Seq $org_scalatest_assert_macro_right = (Seq)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"blockTransferRate", "blockTransferMessageRate", "blockTransferRateBytes", "blockTransferAvgSize_1min", "numActiveConnections", "numCaughtExceptions", "numRegisteredConnections", "openBlockRequestLatencyMillis", "registeredExecutorsSize", "registerExecutorRequestLatencyMillis", "finalizeShuffleMergeLatencyMillis", "shuffle-server.usedDirectMemory", "shuffle-server.usedHeapMemory", "fetchMergedBlocksMetaLatencyMillis"}))).sorted((Ordering)Ordering.String$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.test("SPARK-34828: metrics should be registered with configured name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.s1_$eq(new YarnShuffleService());
            this.yarnConfig().set("spark.yarn.shuffle.service.metrics.namespace", "fooMetrics");
            this.s1().init((Configuration)this.yarnConfig());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DefaultMetricsSystem.instance().getSource("sparkShuffleService"));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            MetricsSource $org_scalatest_assert_macro_left2 = DefaultMetricsSystem.instance().getSource("fooMetrics");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.network.yarn.YarnShuffleServiceMetrics", $org_scalatest_assert_macro_left2 instanceof YarnShuffleServiceMetrics, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("create default merged shuffle file manager instance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MergedShuffleFileManager mergeMgr;
            TransportConf mockConf = (TransportConf)Mockito.mock(TransportConf.class);
            Mockito.when((Object)mockConf.mergedShuffleFileManagerImpl()).thenReturn((Object)"org.apache.spark.network.shuffle.NoOpMergedShuffleFileManager");
            MergedShuffleFileManager $org_scalatest_assert_macro_left = mergeMgr = YarnShuffleService.newMergedShuffleFileManagerInstance((TransportConf)mockConf);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.network.shuffle.NoOpMergedShuffleFileManager", $org_scalatest_assert_macro_left instanceof NoOpMergedShuffleFileManager, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        this.test("create remote block push resolver instance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MergedShuffleFileManager mergeMgr;
            TransportConf mockConf = (TransportConf)Mockito.mock(TransportConf.class);
            Mockito.when((Object)mockConf.mergedShuffleFileManagerImpl()).thenReturn((Object)"org.apache.spark.network.shuffle.RemoteBlockPushResolver");
            MergedShuffleFileManager $org_scalatest_assert_macro_left = mergeMgr = YarnShuffleService.newMergedShuffleFileManagerInstance((TransportConf)mockConf);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.network.shuffle.RemoteBlockPushResolver", $org_scalatest_assert_macro_left instanceof RemoteBlockPushResolver, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        this.test("invalid class name of merge manager will use noop instance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MergedShuffleFileManager mergeMgr;
            TransportConf mockConf = (TransportConf)Mockito.mock(TransportConf.class);
            Mockito.when((Object)mockConf.mergedShuffleFileManagerImpl()).thenReturn((Object)"org.apache.spark.network.shuffle.NotExistent");
            MergedShuffleFileManager $org_scalatest_assert_macro_left = mergeMgr = YarnShuffleService.newMergedShuffleFileManagerInstance((TransportConf)mockConf);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.network.shuffle.NoOpMergedShuffleFileManager", $org_scalatest_assert_macro_left instanceof NoOpMergedShuffleFileManager, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        }, new Position("YarnShuffleServiceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
    }
}

