/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import com.google.common.base.Objects;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnAppReport;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Client$
implements Logging {
    public static Client$ MODULE$;
    private final String APP_JAR_NAME;
    private final String SPARK_STAGING;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final FsPermission APP_FILE_PERMISSION;
    private final String ENV_DIST_CLASSPATH;
    private final String LOCALIZED_CONF_DIR;
    private final String LOCALIZED_HADOOP_CONF_DIR;
    private final String LOCALIZED_CONF_ARCHIVE;
    private final String SPARK_CONF_FILE;
    private final String DIST_CACHE_CONF_FILE;
    private final String LOCALIZED_PYTHON_DIR;
    private final String LOCALIZED_LIB_DIR;
    private final String SPARK_TESTING;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Client$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String APP_JAR_NAME() {
        return this.APP_JAR_NAME;
    }

    public String SPARK_STAGING() {
        return this.SPARK_STAGING;
    }

    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    public FsPermission APP_FILE_PERMISSION() {
        return this.APP_FILE_PERMISSION;
    }

    public String ENV_DIST_CLASSPATH() {
        return this.ENV_DIST_CLASSPATH;
    }

    public String LOCALIZED_CONF_DIR() {
        return this.LOCALIZED_CONF_DIR;
    }

    public String LOCALIZED_HADOOP_CONF_DIR() {
        return this.LOCALIZED_HADOOP_CONF_DIR;
    }

    public String LOCALIZED_CONF_ARCHIVE() {
        return this.LOCALIZED_CONF_ARCHIVE;
    }

    public String SPARK_CONF_FILE() {
        return this.SPARK_CONF_FILE;
    }

    public String DIST_CACHE_CONF_FILE() {
        return this.DIST_CACHE_CONF_FILE;
    }

    public String LOCALIZED_PYTHON_DIR() {
        return this.LOCALIZED_PYTHON_DIR;
    }

    public String LOCALIZED_LIB_DIR() {
        return this.LOCALIZED_LIB_DIR;
    }

    public String SPARK_TESTING() {
        return this.SPARK_TESTING;
    }

    public String org$apache$spark$deploy$yarn$Client$$getAppStagingDir(ApplicationId appId) {
        return this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SPARK_STAGING(), appId.toString()}));
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        Seq classPathElementsToAdd = (Seq)this.getYarnAppClasspath(conf).$plus$plus(this.getMRAppClasspath(conf), Seq$.MODULE$.canBuildFrom());
        classPathElementsToAdd.foreach((Function1 & Serializable & scala.Serializable)c -> {
            YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)env, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
            return BoxedUnit.UNIT;
        });
    }

    private Seq<String> getYarnAppClasspath(Configuration conf) {
        Option option = Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String[] s = (String[])some.value();
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s)).toSeq();
        }
        if (None$.MODULE$.equals(option)) {
            return this.getDefaultYarnApplicationClasspath();
        }
        throw new MatchError((Object)option);
    }

    private Seq<String> getMRAppClasspath(Configuration conf) {
        Option option = Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String[] s = (String[])some.value();
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s)).toSeq();
        }
        if (None$.MODULE$.equals(option)) {
            return this.getDefaultMRApplicationClasspath();
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> getDefaultYarnApplicationClasspath() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)).toSeq();
    }

    public Seq<String> getDefaultMRApplicationClasspath() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH))).toSeq();
    }

    public void populateClasspath(ClientArguments args, Configuration conf, SparkConf sparkConf, HashMap<String, String> env, Option<String> extraClassPath) {
        extraClassPath.foreach((Function1 & Serializable & scala.Serializable)cp -> {
            Client$.MODULE$.addClasspathEntry(Client$.MODULE$.getClusterPath(sparkConf, cp), (HashMap<String, String>)env);
            return BoxedUnit.UNIT;
        });
        this.addClasspathEntry(ApplicationConstants.Environment.PWD.$$(), env);
        this.addClasspathEntry(new StringBuilder(1).append(ApplicationConstants.Environment.PWD.$$()).append("/").append(this.LOCALIZED_CONF_DIR()).toString(), env);
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.USER_CLASS_PATH_FIRST()))) {
            Option<URI> mainJar = args != null ? this.getMainJarUri((Option<String>)Option$.MODULE$.apply((Object)args.userJar())) : this.getMainJarUri((Option<String>)((Option)sparkConf.get(package$.MODULE$.APP_JAR())));
            mainJar.foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
                Client$.MODULE$.addFileToClasspath(sparkConf, conf, x$19, Client$.MODULE$.APP_JAR_NAME(), (HashMap<String, String>)env);
                return BoxedUnit.UNIT;
            });
            Seq<URI> secondaryJars = args != null ? this.getSecondaryJarUris((Option<Seq<String>>)Option$.MODULE$.apply(sparkConf.get(package$.MODULE$.JARS_TO_DISTRIBUTE()))) : this.getSecondaryJarUris((Option<Seq<String>>)((Option)sparkConf.get(package$.MODULE$.SECONDARY_JARS())));
            secondaryJars.foreach((Function1 & Serializable & scala.Serializable)x -> {
                Client$.MODULE$.addFileToClasspath(sparkConf, conf, x, null, (HashMap<String, String>)env);
                return BoxedUnit.UNIT;
            });
        }
        this.addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_LIB_DIR(), "*"})), env);
        if (((Option)sparkConf.get(package$.MODULE$.SPARK_ARCHIVE())).isEmpty()) {
            ((Option)sparkConf.get(package$.MODULE$.SPARK_JARS())).foreach((Function1 & Serializable & scala.Serializable)jars -> {
                Client$.$anonfun$populateClasspath$4(sparkConf, env, jars);
                return BoxedUnit.UNIT;
            });
        }
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.POPULATE_HADOOP_CLASSPATH()))) {
            this.populateHadoopClasspath(conf, env);
        }
        scala.sys.package$.MODULE$.env().get((Object)this.ENV_DIST_CLASSPATH()).foreach((Function1 & Serializable & scala.Serializable)cp -> {
            Client$.MODULE$.addClasspathEntry(Client$.MODULE$.getClusterPath(sparkConf, cp), (HashMap<String, String>)env);
            return BoxedUnit.UNIT;
        });
        this.addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR(), this.LOCALIZED_HADOOP_CONF_DIR()})), env);
    }

    public Option<String> populateClasspath$default$5() {
        return None$.MODULE$;
    }

    public URI[] getUserClasspath(SparkConf conf) {
        Option<URI> mainUri = this.getMainJarUri((Option<String>)((Option)conf.get(package$.MODULE$.APP_JAR())));
        Seq<URI> secondaryUris = this.getSecondaryJarUris((Option<Seq<String>>)((Option)conf.get(package$.MODULE$.SECONDARY_JARS())));
        return (URI[])((TraversableOnce)Option$.MODULE$.option2Iterable(mainUri).$plus$plus(secondaryUris, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URI.class));
    }

    public URL[] getUserClasspathUrls(SparkConf conf, boolean useClusterPath) {
        return (URL[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getUserClasspath(conf))).map(arg_0 -> Client$.$anonfun$getUserClasspathUrls$1(useClusterPath, conf, arg_0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class)));
    }

    private Option<URI> getMainJarUri(Option<String> mainJar) {
        return mainJar.flatMap((Function1 & Serializable & scala.Serializable)path -> {
            URI uri = Utils$.MODULE$.resolveURI(path);
            String string = uri.getScheme();
            String string2 = Utils$.MODULE$.LOCAL_SCHEME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Some((Object)uri);
            }
            return None$.MODULE$;
        }).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)new URI(MODULE$.APP_JAR_NAME())));
    }

    private Seq<URI> getSecondaryJarUris(Option<Seq<String>> secondaryJars) {
        return (Seq)((TraversableLike)secondaryJars.getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$20 -> new URI((String)x$20), Seq$.MODULE$.canBuildFrom());
    }

    private void addFileToClasspath(SparkConf conf, Configuration hadoopConf, URI uri, String fileName, HashMap<String, String> env) {
        if (uri != null) {
            String string = uri.getScheme();
            String string2 = Utils$.MODULE$.LOCAL_SCHEME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.addClasspathEntry(this.getClusterPath(conf, uri.getPath()), env);
                return;
            }
        }
        if (fileName != null) {
            this.addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), fileName})), env);
            return;
        }
        if (uri != null) {
            Path localPath = this.org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(uri, hadoopConf);
            String linkName = (String)Option$.MODULE$.apply((Object)uri.getFragment()).getOrElse((Function0 & Serializable & scala.Serializable)() -> localPath.getName());
            this.addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), linkName})), env);
            return;
        }
    }

    private void addClasspathEntry(String path, HashMap<String, String> env) {
        YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path);
    }

    public String getClusterPath(SparkConf conf, String path) {
        String localPath = (String)conf.get(package$.MODULE$.GATEWAY_ROOT_PATH());
        String clusterPath = (String)conf.get(package$.MODULE$.REPLACEMENT_ROOT_PATH());
        if (localPath != null && clusterPath != null) {
            return path.replace(localPath, clusterPath);
        }
        return path;
    }

    public boolean compareUri(URI srcUri, URI dstUri) {
        block9: {
            block8: {
                if (srcUri.getScheme() == null) break block8;
                String string = srcUri.getScheme();
                String string2 = dstUri.getScheme();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block9;
            }
            return false;
        }
        String srcAuthority = srcUri.getAuthority();
        String dstAuthority = dstUri.getAuthority();
        if (srcAuthority != null && !srcAuthority.equalsIgnoreCase(dstAuthority)) {
            return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            String string = srcHost;
            String string3 = dstHost;
            if (string == null ? string3 != null : !string.equals(string3)) {
                try {
                    srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                    dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
        }
        return Objects.equal((Object)srcHost, (Object)dstHost) && srcUri.getPort() == dstUri.getPort();
    }

    public boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        return this.compareUri(srcUri, dstUri);
    }

    public Path org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(URI localURI, Configuration hadoopConf) {
        URI qualifiedURI = localURI.getScheme() == null ? new URI(FileSystem.getLocal((Configuration)hadoopConf).makeQualified(new Path(localURI)).toString()) : localURI;
        return new Path(qualifiedURI);
    }

    public boolean isUserClassPathFirst(SparkConf conf, boolean isDriver) {
        if (isDriver) {
            return BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_USER_CLASS_PATH_FIRST()));
        }
        return BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
    }

    public String buildPath(Seq<String> components) {
        return components.mkString("/");
    }

    public YarnAppReport createAppReport(ApplicationReport report) {
        String diags = report.getDiagnostics();
        None$ diagsOpt = diags != null && new StringOps(Predef$.MODULE$.augmentString(diags)).nonEmpty() ? new Some((Object)diags) : None$.MODULE$;
        return new YarnAppReport(report.getYarnApplicationState(), report.getFinalApplicationStatus(), (Option<String>)diagsOpt);
    }

    public String createLibraryPathPrefix(String libpath, SparkConf conf) {
        String string;
        if (Utils$.MODULE$.isWindows()) {
            string = Utils$.MODULE$.libraryPathEnvPrefix((Seq)new .colon.colon((Object)libpath, (List)Nil$.MODULE$));
        } else {
            String envName = Utils$.MODULE$.libraryPathEnvName();
            String quoted = libpath.replace("\"", "\\\\\\\"");
            string = new StringBuilder(6).append(envName).append("=\\\"").append(quoted).append(File.pathSeparator).append("$").append(envName).append("\\\"").toString();
        }
        String cmdPrefix = string;
        return this.getClusterPath(conf, cmdPrefix);
    }

    public Properties confToProperties(SparkConf conf) {
        Properties props = new Properties();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.setProperty(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        return props;
    }

    public void writePropertiesToArchive(Properties props, String name, ZipOutputStream out) {
        out.putNextEntry(new ZipEntry(name));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        props.store(writer, "Spark configuration.");
        writer.flush();
        out.closeEntry();
    }

    public static final /* synthetic */ void $anonfun$populateClasspath$6(SparkConf sparkConf$1, HashMap env$3, String jar) {
        URI uri = new URI(jar);
        MODULE$.addClasspathEntry(MODULE$.getClusterPath(sparkConf$1, uri.getPath()), (HashMap<String, String>)env$3);
    }

    public static final /* synthetic */ void $anonfun$populateClasspath$4(SparkConf sparkConf$1, HashMap env$3, Seq jars) {
        ((IterableLike)jars.filter((Function1 & Serializable & scala.Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isLocalUri(uri)))).foreach((Function1 & Serializable & scala.Serializable)jar -> {
            Client$.$anonfun$populateClasspath$6(sparkConf$1, env$3, jar);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$getUserClasspathUrls$2(URI uri$2) {
        return new StringBuilder(70).append("getUserClasspath should only return 'file' or 'local' URIs but found: ").append(uri$2).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ URL $anonfun$getUserClasspathUrls$1(boolean useClusterPath$1, SparkConf conf$2, URI uri) {
        block3: {
            block2: {
                inputPath = uri.getPath();
                if (!Utils$.MODULE$.isLocalUri(uri.toString()) || !useClusterPath$1) break block2;
                v0 = Client$.MODULE$.getClusterPath(conf$2, inputPath);
                break block3;
            }
            if (uri.getScheme() == null) ** GOTO lbl-1000
            v1 = uri.getScheme();
            var5_4 = "file";
            if (!(v1 == null ? var5_4 != null : v1.equals(var5_4) == false) || Utils$.MODULE$.isLocalUri(uri.toString())) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            Predef$.MODULE$.assert(v2, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getUserClasspathUrls$2(java.net.URI ), ()Ljava/lang/String;)((URI)uri));
            v0 = inputPath;
        }
        replacedFilePath = v0;
        envVarResolvedFilePath = YarnSparkHadoopUtil$.MODULE$.replaceEnvVars(replacedFilePath, (Map<String, String>)scala.sys.package$.MODULE$.env(), YarnSparkHadoopUtil$.MODULE$.replaceEnvVars$default$3());
        return Paths.get(envVarResolvedFilePath, new String[0]).toAbsolutePath().toUri().toURL();
    }

    private Client$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.APP_JAR_NAME = "__app__.jar";
        this.SPARK_STAGING = ".sparkStaging";
        this.STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8)));
        this.APP_FILE_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8)));
        this.ENV_DIST_CLASSPATH = "SPARK_DIST_CLASSPATH";
        this.LOCALIZED_CONF_DIR = "__spark_conf__";
        this.LOCALIZED_HADOOP_CONF_DIR = "__hadoop_conf__";
        this.LOCALIZED_CONF_ARCHIVE = new StringBuilder(4).append(this.LOCALIZED_CONF_DIR()).append(".zip").toString();
        this.SPARK_CONF_FILE = "__spark_conf__.properties";
        this.DIST_CACHE_CONF_FILE = "__spark_dist_cache__.properties";
        this.LOCALIZED_PYTHON_DIR = "__pyfiles__";
        this.LOCALIZED_LIB_DIR = "__spark_libs__";
        this.SPARK_TESTING = "SPARK_TESTING";
    }
}

