/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.spark.deploy.yarn.ResourceRequestHelper$;
import org.apache.spark.deploy.yarn.ResourceRequestTestHelper;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ResourceRequestTestHelper$ {
    public static ResourceRequestTestHelper$ MODULE$;

    static {
        new ResourceRequestTestHelper$();
    }

    public void initializeResourceTypes(Seq<String> resourceTypes) {
        if (!ResourceRequestHelper$.MODULE$.isYarnResourceTypesAvailable()) {
            throw new IllegalStateException("This method should not be invoked since YARN resource types is not available because of old Hadoop version!");
        }
        .colon.colon defaultResourceTypes = new .colon.colon(this.createResourceTypeInfo("memory-mb"), (List)new .colon.colon(this.createResourceTypeInfo("vcores"), (List)Nil$.MODULE$));
        Seq customResourceTypes = (Seq)resourceTypes.map((Function1 & Serializable & scala.Serializable)resourceName -> MODULE$.createResourceTypeInfo((String)resourceName), Seq$.MODULE$.canBuildFrom());
        List allResourceTypes = (List)defaultResourceTypes.$plus$plus((GenTraversableOnce)customResourceTypes, List$.MODULE$.canBuildFrom());
        Class resourceUtilsClass = Utils$.MODULE$.classForName("org.apache.hadoop.yarn.util.resource.ResourceUtils", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Method reinitializeResourcesMethod = resourceUtilsClass.getMethod("reinitializeResources", java.util.List.class);
        reinitializeResourcesMethod.invoke(null, JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allResourceTypes).asJava());
    }

    private Object createResourceTypeInfo(String resourceName) {
        Class resTypeInfoClass = Utils$.MODULE$.classForName("org.apache.hadoop.yarn.api.records.ResourceTypeInfo", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Method resTypeInfoNewInstanceMethod = resTypeInfoClass.getMethod("newInstance", String.class);
        return resTypeInfoNewInstanceMethod.invoke(null, resourceName);
    }

    public Object getRequestedValue(Resource res, String rtype) {
        Object resourceInformation = this.getResourceInformation(res, rtype);
        return this.invokeMethod(resourceInformation, "getValue");
    }

    public ResourceRequestTestHelper.ResourceInformation getResourceInformationByName(Resource res, String nameParam) {
        Object resourceInformation = this.getResourceInformation(res, nameParam);
        String name = (String)this.invokeMethod(resourceInformation, "getName");
        long value = BoxesRunTime.unboxToLong((Object)this.invokeMethod(resourceInformation, "getValue"));
        String units = (String)this.invokeMethod(resourceInformation, "getUnits");
        return new ResourceRequestTestHelper.ResourceInformation(name, value, units);
    }

    private Object getResourceInformation(Resource res, String name) {
        if (!ResourceRequestHelper$.MODULE$.isYarnResourceTypesAvailable()) {
            throw new IllegalStateException("assertResourceTypeValue() should not be invoked since yarn resource types is not available because of old Hadoop version!");
        }
        Method getResourceInformationMethod = res.getClass().getMethod("getResourceInformation", String.class);
        Object resourceInformation = getResourceInformationMethod.invoke((Object)res, name);
        return resourceInformation;
    }

    private Object invokeMethod(Object resourceInformation, String methodName) {
        Method getValueMethod = resourceInformation.getClass().getMethod(methodName, new Class[0]);
        return getValueMethod.invoke(resourceInformation, new Object[0]);
    }

    public ResourceRequestTestHelper.ResourceInformation[] getResources(Resource res) {
        Method getResourceInformationMethod = res.getClass().getMethod("getResources", new Class[0]);
        Object[] rInfoArray = (Object[])getResourceInformationMethod.invoke((Object)res, new Object[0]);
        return (ResourceRequestTestHelper.ResourceInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rInfoArray)).map((Function1 & Serializable & scala.Serializable)rInfo -> {
            String name = (String)MODULE$.invokeMethod(rInfo, "getName");
            long value = BoxesRunTime.unboxToLong((Object)MODULE$.invokeMethod(rInfo, "getValue"));
            String units = (String)MODULE$.invokeMethod(rInfo, "getUnits");
            return new ResourceRequestTestHelper.ResourceInformation(name, value, units);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResourceRequestTestHelper.ResourceInformation.class)));
    }

    private ResourceRequestTestHelper$() {
        MODULE$ = this;
    }
}

