/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A3QAB\u0004\u0001\u000f=A\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tm\u0001\u0011\t\u0011)A\u0005o!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003E\u0001\u0011\u0005Q\tC\u0003L\u0001\u0011\u0005CJ\u0001\u000bGS2,w)\u001a8fe\u0006$\u0018N\\4UQJ,\u0017\r\u001a\u0006\u0003\u0011%\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c2\u0001\u0001\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011a\u0001\u00165sK\u0006$\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\n\u0003!Ig\u000e^3s]\u0006d\u0017BA\u000f\u001b\u0005\u001daunZ4j]\u001e\fQ!\u001b8qkR\u001c\u0001\u0001E\u0002\"W9r!A\t\u0015\u000f\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015z\u0012A\u0002\u001fs_>$h(C\u0001(\u0003\u0015\u00198-\u00197b\u0013\tI#&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u001dJ!\u0001L\u0017\u0003\u0007M+\u0017O\u0003\u0002*UA\u0011qf\r\b\u0003aE\u0002\"a\t\u0016\n\u0005IR\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!A\r\u0016\u0002\u000fQ,7\u000f\u001e#jeB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0003MNT!\u0001P\u0006\u0002\r!\fGm\\8q\u0013\tq\u0014H\u0001\u0003QCRD\u0017\u0001C5oi\u0016\u0014h/\u00197\u0011\u0005\u0005\u0013U\"\u0001\u0016\n\u0005\rS#\u0001\u0002'p]\u001e\fa\u0001P5oSRtD\u0003\u0002$I\u0013*\u0003\"a\u0012\u0001\u000e\u0003\u001dAQA\b\u0003A\u0002\u0001BQA\u000e\u0003A\u0002]BQa\u0010\u0003A\u0002\u0001\u000b1A];o)\u0005i\u0005CA!O\u0013\ty%F\u0001\u0003V]&$\b")
public class FileGeneratingThread
extends Thread
implements Logging {
    private final Seq<String> input;
    private final Path testDir;
    private final long interval;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public void run() {
        File localTestDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        ObjectRef fs = ObjectRef.create((Object)this.testDir.getFileSystem(new Configuration()));
        int maxTries = 3;
        try {
            try {
                Thread.sleep(5000L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.input.size()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
                    File localFile = new File(localTestDir, Integer.toString(i + 1));
                    Path hadoopFile = new Path($this.testDir, Integer.toString(i + 1));
                    Path tempHadoopFile = new Path($this.testDir, new StringBuilder(5).append(".tmp_").append(Integer.toString(i + 1)).toString());
                    Files.write((CharSequence)new StringBuilder(1).append((String)$this.input.apply(i)).append("\n").toString(), (File)localFile, (Charset)StandardCharsets.UTF_8);
                    IntRef tries = IntRef.create((int)0);
                    boolean done = false;
                    while (!done && tries.elem < maxTries) {
                        ++tries.elem;
                        try {
                            ((FileSystem)fs$1.elem).copyFromLocalFile(new Path(localFile.toString()), tempHadoopFile);
                            ((FileSystem)fs$1.elem).rename(tempHadoopFile, hadoopFile);
                            done = true;
                        }
                        catch (IOException ioe) {
                            fs$1.elem = $this.testDir.getFileSystem(new Configuration());
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Attempt ").append(tries$1.elem).append(" at generating file ").append(hadoopFile).append(" failed.").toString(), ioe);
                        }
                    }
                    if (!done) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Could not generate file ").append(hadoopFile).toString());
                    } else {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Generated file ").append(hadoopFile).append(" at ").append(System.currentTimeMillis()).toString());
                    }
                    Thread.sleep($this.interval);
                    return localFile.delete();
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "File generating thread finished normally");
            }
            catch (InterruptedException ie) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "File generating thread interrupted");
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "File generating in killing thread", e);
            }
        }
        finally {
            ((FileSystem)fs.elem).close();
            Utils$.MODULE$.deleteRecursively(localTestDir);
        }
    }

    public FileGeneratingThread(Seq<String> input, Path testDir, long interval) {
        this.input = input;
        this.testDir = testDir;
        this.interval = interval;
        Logging.$init$((Logging)this);
    }
}

