/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.DummyInputDStream;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestException;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.PairDStreamFunctions;
import org.apache.spark.util.ReturnStatementInClosureException;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\u000b\u0016\u0001yAQ!\f\u0001\u0005\u00029BQ\u0001\r\u0001\u0005REBQ\u0001\u000f\u0001\u0005\neBQa\u0010\u0001\u0005\n\u0001CQ\u0001\u0014\u0001\u0005\n5CQa\u0014\u0001\u0005\nACQA\u0015\u0001\u0005\nMCQ!\u0016\u0001\u0005\nYCQ\u0001\u0017\u0001\u0005\neCQa\u0017\u0001\u0005\nqCQA\u0018\u0001\u0005\n}CQ!\u0019\u0001\u0005\n\tDQ\u0001\u001a\u0001\u0005\n\u0015DQa\u001b\u0001\u0005\n1DQA\u001c\u0001\u0005\n=DQ!\u001d\u0001\u0005\nIDQ\u0001\u001e\u0001\u0005\nUDQa\u001e\u0001\u0005\naDQA\u001f\u0001\u0005\nm\u00141\u0003R*ue\u0016\fWn\u00117pgV\u0014XmU;ji\u0016T!AF\f\u0002\u0013M$(/Z1nS:<'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M!\u0001aH\u0012(!\t\u0001\u0013%D\u0001\u0018\u0013\t\u0011sCA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003I\u0015j\u0011!F\u0005\u0003MU\u0011Q\u0003T8dC2\u001cFO]3b[&twmQ8oi\u0016DH\u000f\u0005\u0002)W5\t\u0011F\u0003\u0002+7\u0005I1oY1mCR,7\u000f^\u0005\u0003Y%\u0012\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u0002%\u0001\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012A!\u00168ji\u00061R\r\u001f9fGR\u001cuN\u001d:fGR,\u0005pY3qi&|g\u000e\u0006\u00023u!11h\u0001CA\u0002q\nAAY8esB\u00191'\u0010\u001a\n\u0005y\"$\u0001\u0003\u001fcs:\fW.\u001a \u0002\u000fQ,7\u000f^'baR\u0011!'\u0011\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u0003IN\u00042\u0001R$J\u001b\u0005)%B\u0001$\u0016\u0003\u001d!7\u000f\u001e:fC6L!\u0001S#\u0003\u000f\u0011\u001bFO]3b[B\u00111GS\u0005\u0003\u0017R\u00121!\u00138u\u0003-!Xm\u001d;GY\u0006$X*\u00199\u0015\u0005Ir\u0005\"\u0002\"\u0006\u0001\u0004\u0019\u0015A\u0003;fgR4\u0015\u000e\u001c;feR\u0011!'\u0015\u0005\u0006\u0005\u001a\u0001\raQ\u0001\u0012i\u0016\u001cH/T1q!\u0006\u0014H/\u001b;j_:\u001cHC\u0001\u001aU\u0011\u0015\u0011u\u00011\u0001D\u0003)!Xm\u001d;SK\u0012,8-\u001a\u000b\u0003e]CQA\u0011\u0005A\u0002\r\u000ba\u0002^3ti\u001a{'/Z1dQJ#E\t\u0006\u000235\")!)\u0003a\u0001\u0007\u0006iA/Z:u)J\fgn\u001d4pe6$\"AM/\t\u000b\tS\u0001\u0019A\"\u0002#Q,7\u000f\u001e+sC:\u001chm\u001c:n/&$\b\u000e\u0006\u00023A\")!i\u0003a\u0001\u0007\u0006\u0011B/Z:u%\u0016$WoY3Cs^Kg\u000eZ8x)\t\u00114\rC\u0003C\u0019\u0001\u00071)A\buKN$(+\u001a3vG\u0016\u0014\u0015pS3z)\t\u0011d\rC\u0003C\u001b\u0001\u0007q\rE\u0002E\u000f\"\u0004BaM5J\u0013&\u0011!\u000e\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0002!Q,7\u000f^\"p[\nLg.\u001a\"z\u0017\u0016LHC\u0001\u001an\u0011\u0015\u0011e\u00021\u0001h\u0003a!Xm\u001d;SK\u0012,8-\u001a\"z\u0017\u0016L\u0018I\u001c3XS:$wn\u001e\u000b\u0003eADQAQ\bA\u0002\u001d\fA\u0003^3tiV\u0003H-\u0019;f'R\fG/\u001a\"z\u0017\u0016LHC\u0001\u001at\u0011\u0015\u0011\u0005\u00031\u0001h\u00035!Xm\u001d;NCB4\u0016\r\\;fgR\u0011!G\u001e\u0005\u0006\u0005F\u0001\raZ\u0001\u0012i\u0016\u001cHO\u00127bi6\u000b\u0007OV1mk\u0016\u001cHC\u0001\u001az\u0011\u0015\u0011%\u00031\u0001h\u00039!Xm\u001d;Ue\u0006t7OZ8s[J\"BA\r?\u0002\u0004!)Qp\u0005a\u0001}\u0006\u00191o]2\u0011\u0005\u0011z\u0018bAA\u0001+\t\u00012\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\u0006\u0005N\u0001\ra\u0011")
public class DStreamClosureSuite
extends SparkFunSuite
implements LocalStreamingContext {
    private transient StreamingContext ssc;
    private final transient boolean stopSparkContext;

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterEach() {
        LocalStreamingContext.afterEach$(this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        SparkContext sc = new SparkContext("local", "test");
        this.ssc_$eq(new StreamingContext(sc, Seconds$.MODULE$.apply(1L)));
    }

    private void expectCorrectException(Function0<BoxedUnit> body) {
        try {
            body.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ReturnStatementInClosureException) {
            }
            if (throwable2 instanceof NotSerializableException ? true : throwable2 instanceof SparkException) {
                throw new TestException(new StringBuilder(118).append("Expected ReturnStatementInClosureException, but got ").append(throwable2).append(".\n").append("This means the closure provided by user is not actually cleaned.").toString());
            }
            throw throwable;
        }
    }

    private void testMap(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testFlatMap(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> DStreamClosureSuite.$anonfun$testFlatMap$2(object, BoxesRunTime.unboxToInt((Object)x$2)), ClassTag$.MODULE$.Nothing()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testFilter(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testMapPartitions(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.mapPartitions((Function1 & Serializable & scala.Serializable)x$4 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }, ds.mapPartitions$default$2(), ClassTag$.MODULE$.Nothing()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduce(DStream<Object> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.reduce((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
                if (sp2 != null) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                throw new MatchError((Object)sp2);
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testForeachRDD(DStream<Object> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable foreachRDDF1 = (Function2 & Serializable & scala.Serializable)(rdd, t) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function1 & Serializable & scala.Serializable foreachRDDF2 = (Function1 & Serializable & scala.Serializable)rdd -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.foreachRDD(foreachRDDF1));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.foreachRDD(foreachRDDF2));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testTransform(DStream<Object> ds) {
        Object object = new Object();
        try {
            Function1 & Serializable & scala.Serializable transformF1 = (Function1 & Serializable & scala.Serializable)rdd -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function2 & Serializable & scala.Serializable transformF2 = (Function2 & Serializable & scala.Serializable)(rdd, time) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transform(transformF1, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transform(transformF2, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testTransformWith(DStream<Object> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable transformF1 = (Function2 & Serializable & scala.Serializable)(rdd1, rdd2) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function3 & Serializable & scala.Serializable transformF2 = (Function3 & Serializable & scala.Serializable)(rdd1, rdd2, time) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transformWith(ds, transformF1, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ds.transformWith(ds, transformF2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduceByWindow(DStream<Object> ds) {
        Object object = new Object();
        try {
            JFunction2.mcIII.sp & Serializable & scala.Serializable reduceF = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByWindow$2(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByWindow$3(ds, (Function2)reduceF)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduceByKey(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            JFunction2.mcIII.sp & Serializable & scala.Serializable reduceF = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$7, x$8) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKey$2(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKey$3(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKey$4(ds, (Function2)reduceF)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testCombineByKey(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                PairDStreamFunctions qual$1 = DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                JFunction1.mcII.sp & Serializable & scala.Serializable x$1 = (JFunction1.mcII.sp & Serializable & scala.Serializable)x$9 -> {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                };
                JFunction2.mcIII.sp & Serializable & scala.Serializable x$2 = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
                    if (sp2 != null && true) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new MatchError((Object)sp2);
                };
                JFunction2.mcIII.sp & Serializable & scala.Serializable x$3 = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$2, x1$2);
                    if (sp2 != null && true) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new MatchError((Object)sp2);
                };
                HashPartitioner x$4 = new HashPartitioner(5);
                boolean x$5 = qual$1.combineByKey$default$5();
                qual$1.combineByKey((Function1)x$1, (Function2)x$2, (Function2)x$3, (Partitioner)x$4, x$5, ClassTag$.MODULE$.Int());
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testReduceByKeyAndWindow(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            JFunction2.mcIII.sp & Serializable & scala.Serializable reduceF = (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$10, x$11) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function1 & Serializable & scala.Serializable filterF = (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$2(object, x$12));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$3(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$4(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$5(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$6(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$7(ds, (Function2)reduceF)));
            this.expectCorrectException((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStreamClosureSuite.$anonfun$testReduceByKeyAndWindow$8(ds, (Function2)reduceF, filterF)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testUpdateStateByKey(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable updateF1 = (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function1 & Serializable & scala.Serializable updateF2 = (Function1 & Serializable & scala.Serializable)x$15 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            Function4 & Serializable & scala.Serializable updateF3 = (Function4 & Serializable & scala.Serializable)(x$16, x$17, x$18, x$19) -> DStreamClosureSuite.$anonfun$testUpdateStateByKey$3(object, x$16, BoxesRunTime.unboxToInt((Object)x$17), x$18, x$19);
            RDD initialRDD = ds.ssc().sparkContext().emptyRDD(ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)i -> DStreamClosureSuite.$anonfun$testUpdateStateByKey$4(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, 5, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, (Partitioner)new HashPartitioner(5), ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF1, (Partitioner)new HashPartitioner(5), initialRDD, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF2, (Partitioner)new HashPartitioner(5), true, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF2, (Partitioner)new HashPartitioner(5), true, initialRDD, ClassTag$.MODULE$.Int()));
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateF3, (Partitioner)new HashPartitioner(5), true, Option$.MODULE$.apply((Object)initialRDD), ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testMapValues(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$20 -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            }, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testFlatMapValues(DStream<Tuple2<Object, Object>> ds) {
        Object object = new Object();
        try {
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DStream$.MODULE$.toPairDStreamFunctions(ds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).flatMapValues((Function1 & Serializable & scala.Serializable)x$21 -> DStreamClosureSuite.$anonfun$testFlatMapValues$2(object, BoxesRunTime.unboxToInt((Object)x$21)), ClassTag$.MODULE$.Nothing()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void testTransform2(StreamingContext ssc, DStream<Object> ds) {
        Object object = new Object();
        try {
            Function2 & Serializable & scala.Serializable transformF = (Function2 & Serializable & scala.Serializable)(rdds, time) -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            this.expectCorrectException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ssc.transform((Seq)new .colon.colon((Object)ds, (List)Nil$.MODULE$), transformF, ClassTag$.MODULE$.Int()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$2(int i) {
        return new Tuple2.mcII.sp(i, i);
    }

    public static final /* synthetic */ Seq $anonfun$testFlatMap$2(Object nonLocalReturnKey2$1, int x$2) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$testReduceByWindow$2(DStream ds$9, Function2 reduceF$1) {
        ds$9.reduceByWindow(reduceF$1, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByWindow$3(DStream ds$9, Function2 reduceF$1) {
        ds$9.reduceByWindow(reduceF$1, reduceF$1, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKey$2(DStream ds$10, Function2 reduceF$2) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$10, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey(reduceF$2);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKey$3(DStream ds$10, Function2 reduceF$2) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$10, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey(reduceF$2, 5);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKey$4(DStream ds$10, Function2 reduceF$2) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$10, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey(reduceF$2, (Partitioner)new HashPartitioner(5));
    }

    public static final /* synthetic */ boolean $anonfun$testReduceByKeyAndWindow$2(Object nonLocalReturnKey12$1, Tuple2 x$12) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey12$1, BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$3(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$4(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$5(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L), 5);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$6(DStream ds$12, Function2 reduceF$3) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, Seconds$.MODULE$.apply(1L), Seconds$.MODULE$.apply(2L), (Partitioner)new HashPartitioner(5));
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$7(DStream ds$12, Function2 reduceF$3) {
        PairDStreamFunctions qual$1 = DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
        Function2 x$1 = reduceF$3;
        Function2 x$2 = reduceF$3;
        Duration x$3 = Seconds$.MODULE$.apply(2L);
        Duration x$4 = qual$1.reduceByKeyAndWindow$default$4();
        int x$5 = qual$1.reduceByKeyAndWindow$default$5();
        Function1 x$6 = qual$1.reduceByKeyAndWindow$default$6();
        qual$1.reduceByKeyAndWindow(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public static final /* synthetic */ void $anonfun$testReduceByKeyAndWindow$8(DStream ds$12, Function2 reduceF$3, Function1 filterF$1) {
        DStream$.MODULE$.toPairDStreamFunctions(ds$12, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKeyAndWindow(reduceF$3, reduceF$3, Seconds$.MODULE$.apply(2L), Seconds$.MODULE$.apply(3L), (Partitioner)new HashPartitioner(5), filterF$1);
    }

    public static final /* synthetic */ Option $anonfun$testUpdateStateByKey$3(Object nonLocalReturnKey13$1, Time x$16, int x$17, Seq x$18, Option x$19) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey13$1, BoxedUnit.UNIT);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testUpdateStateByKey$4(int i) {
        return new Tuple2.mcII.sp(i, i);
    }

    public static final /* synthetic */ Seq $anonfun$testFlatMapValues$2(Object nonLocalReturnKey15$1, int x$21) {
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey15$1, BoxedUnit.UNIT);
    }

    public DStreamClosureSuite() {
        LocalStreamingContext.$init$(this);
        this.test("user provided closures are actually cleaned", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyInputDStream dstream = new DummyInputDStream(this.ssc());
            DStream pairDstream = dstream.map((Function1 & Serializable & scala.Serializable)i -> DStreamClosureSuite.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
            this.testMap((DStream<Object>)dstream);
            this.testFlatMap((DStream<Object>)dstream);
            this.testFilter((DStream<Object>)dstream);
            this.testMapPartitions((DStream<Object>)dstream);
            this.testReduce((DStream<Object>)dstream);
            this.testForeachRDD((DStream<Object>)dstream);
            this.testTransform((DStream<Object>)dstream);
            this.testTransformWith((DStream<Object>)dstream);
            this.testReduceByWindow((DStream<Object>)dstream);
            this.testReduceByKey((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testCombineByKey((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testReduceByKeyAndWindow((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testUpdateStateByKey((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testMapValues((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testFlatMapValues((DStream<Tuple2<Object, Object>>)pairDstream);
            this.testTransform2(this.ssc(), (DStream<Object>)dstream);
        }, new Position("DStreamClosureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
    }
}

