/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.kafka010.package$;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005b!\u0002\u001e<\u0001}*\u0005\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011a\u0004!\u0011!Q\u0001\neD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033A\u0001\"!\t\u0001A\u0003%\u00111\u0004\u0005\n\u0003G\u0001\u0001\u0019!C\u0001\u0003KA\u0011\"!\f\u0001\u0001\u0004%\t!a\f\t\u0011\u0005m\u0002\u0001)Q\u0005\u0003OA\u0011\"!\u0010\u0001\u0005\u0004%\t!a\u0010\t\u0011\u0005M\u0004\u0001)A\u0005\u0003\u0003B\u0011\"!\u001e\u0001\u0001\u0004%\t\"a\u001e\t\u0013\u0005U\u0005\u00011A\u0005\u0012\u0005]\u0005\u0002CAN\u0001\u0001\u0006K!!\u001f\t\u0013\u0005u\u0005\u00011A\u0005\n\u0005}\u0005\"CAT\u0001\u0001\u0007I\u0011BAU\u0011!\ti\u000b\u0001Q!\n\u0005\u0005\u0006B\u0002)\u0001\t\u0003\t9\fC\u0005\u0002:\u0002\u0001\r\u0011\"\u0003\u0002 \"I\u00111\u0018\u0001A\u0002\u0013%\u0011Q\u0018\u0005\t\u0003\u0003\u0004\u0001\u0015)\u0003\u0002\"\"9\u0011Q\u0019\u0001\u0005\u0002\u0005}\u0005bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003C\u0004A\u0011CAr\u0011\u001d\t9\u000f\u0001C\t\u0003SD\u0001\"a<\u0001\t\u0003j\u0014\u0011\u001f\u0005\u000b\u0003g\u0004!\u0019!C){\u0005U\b\u0002\u0003B \u0001\u0001\u0006I!a>\t\u0015\t\u0005\u0003A1A\u0005Ru\u0012\u0019\u0005\u0003\u0005\u0003X\u0001\u0001\u000b\u0011\u0002B#\u0011!\u0011I\u0006\u0001C\t{\tm\u0003b\u0002B4\u0001\u0011%!\u0011\u000e\u0005\b\u0005_\u0002A\u0011\u0002B9\u0011\u001d\u0011I\n\u0001C\t\u00057CqA!(\u0001\t#\u0011y\nC\u0004\u0003$\u0002!\tE!*\t\u000f\tM\u0006\u0001\"\u0011\u0003>!9!Q\u0017\u0001\u0005B\tu\u0002\"\u0003B\\\u0001\t\u0007I\u0011\u0003B]\u0011!\u0011i\r\u0001Q\u0001\n\tm\u0006\"\u0003Bh\u0001\t\u0007I\u0011\u0003Bi\u0011!\u0011)\u000f\u0001Q\u0001\n\tM\u0007b\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005O\u0004A\u0011\u0001By\u0011\u001d\u0011I\u0010\u0001C\t\u0005{1q!a?\u0001\u0001u\ni\u0010C\u0004\u0002\n=\"\tA!\u0002\t\u000f\t\u001dq\u0006\"\u0001\u0003\n!9!QF\u0018\u0005B\t=\u0002b\u0002B\u001b_\u0011\u0005#q\u0007\u0005\b\u0005wyC\u0011\tB\u001f\r\u001d\u0011Y\u0010\u0001\u0001>\u0005{DABa@6\u0005\u0003\u0005\u000b\u0011\u0002B\u0014\u0007\u0003A!b!\u00026\u0005\u0003\u0005\u000b\u0011BB\u0004\u0011\u001d\tI!\u000eC\u0001\u0007'Aqaa\u00076\t\u0003\u001aiBA\fESJ,7\r^&bM.\f\u0017J\u001c9vi\u0012\u001bFO]3b[*\u0011A(P\u0001\tW\u000647.\u0019\u00192a)\u0011ahP\u0001\ngR\u0014X-Y7j]\u001eT!\u0001Q!\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u000b\u0004\rf;7\u0003\u0002\u0001HS>\u00042\u0001S&N\u001b\u0005I%B\u0001&>\u0003\u001d!7\u000f\u001e:fC6L!\u0001T%\u0003\u0019%s\u0007/\u001e;E'R\u0014X-Y7\u0011\t9+vKZ\u0007\u0002\u001f*\u0011\u0001+U\u0001\tG>t7/^7fe*\u0011!kU\u0001\bG2LWM\u001c;t\u0015\t!\u0016)A\u0003lC\u001a\\\u0017-\u0003\u0002W\u001f\nq1i\u001c8tk6,'OU3d_J$\u0007C\u0001-Z\u0019\u0001!QA\u0017\u0001C\u0002q\u0013\u0011aS\u0002\u0001#\ti6\r\u0005\u0002_C6\tqLC\u0001a\u0003\u0015\u00198-\u00197b\u0013\t\u0011wLA\u0004O_RD\u0017N\\4\u0011\u0005y#\u0017BA3`\u0005\r\te.\u001f\t\u00031\u001e$Q\u0001\u001b\u0001C\u0002q\u0013\u0011A\u0016\t\u0003U6l\u0011a\u001b\u0006\u0003Y~\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003].\u0014q\u0001T8hO&tw\r\u0005\u0002qc6\t1(\u0003\u0002sw\t\u00012)\u00198D_6l\u0017\u000e^(gMN,Go]\u0001\u0005?N\u001c8\r\u0005\u0002vm6\tQ(\u0003\u0002x{\t\u00012\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010^\u0001\u0011Y>\u001c\u0017\r^5p]N#(/\u0019;fOf\u0004\"\u0001\u001d>\n\u0005m\\$\u0001\u0005'pG\u0006$\u0018n\u001c8TiJ\fG/Z4z\u0003A\u0019wN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0003q}^3\u0017BA@<\u0005A\u0019uN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u00170A\u0002qa\u000e\u00042\u0001]A\u0003\u0013\r\t9a\u000f\u0002\u0013!\u0016\u0014\b+\u0019:uSRLwN\\\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0001\u0003\u00029\u0001/\u001aDQa]\u0003A\u0002QDQ\u0001_\u0003A\u0002eDQ\u0001`\u0003A\u0002uDq!!\u0001\u0006\u0001\u0004\t\u0019!A\u0006j]&$\u0018.\u00197SCR,WCAA\u000e!\rq\u0016QD\u0005\u0004\u0003?y&\u0001\u0002'p]\u001e\fA\"\u001b8ji&\fGNU1uK\u0002\na\"[:GSJ\u001cHoQ8naV$X-\u0006\u0002\u0002(A\u0019a,!\u000b\n\u0007\u0005-rLA\u0004C_>dW-\u00198\u0002%%\u001ch)\u001b:ti\u000e{W\u000e];uK~#S-\u001d\u000b\u0005\u0003c\t9\u0004E\u0002_\u0003gI1!!\u000e`\u0005\u0011)f.\u001b;\t\u0013\u0005e\u0012\"!AA\u0002\u0005\u001d\u0012a\u0001=%c\u0005y\u0011n\u001d$jeN$8i\\7qkR,\u0007%A\nfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7/\u0006\u0002\u0002BAA\u00111IA'\u0003#\n9'\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011)H/\u001b7\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006LA!a\u0014\u0002F\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA*\u0003CrA!!\u0016\u0002^A\u0019\u0011qK0\u000e\u0005\u0005e#bAA.7\u00061AH]8pizJ1!a\u0018`\u0003\u0019\u0001&/\u001a3fM&!\u00111MA3\u0005\u0019\u0019FO]5oO*\u0019\u0011qL0\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WRA!!\u001c\u0002J\u0005!A.\u00198h\u0013\u0011\t\t(a\u001b\u0003\r=\u0013'.Z2u\u0003Q)\u00070Z2vi>\u00148*\u00194lCB\u000b'/Y7tA\u0005q1-\u001e:sK:$xJ\u001a4tKR\u001cXCAA=!!\tY(!\"\u0002\n\u0006mQBAA?\u0015\u0011\ty(!!\u0002\u0013%lW.\u001e;bE2,'bAAB?\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0015Q\u0010\u0002\u0004\u001b\u0006\u0004\b\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=5+\u0001\u0004d_6lwN\\\u0005\u0005\u0003'\u000biI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002%\r,(O]3oi>3gm]3ug~#S-\u001d\u000b\u0005\u0003c\tI\nC\u0005\u0002:9\t\t\u00111\u0001\u0002z\u0005y1-\u001e:sK:$xJ\u001a4tKR\u001c\b%\u0001\u0002lGV\u0011\u0011\u0011\u0015\t\u0006\u001d\u0006\rvKZ\u0005\u0004\u0003K{%\u0001C\"p]N,X.\u001a:\u0002\r-\u001cw\fJ3r)\u0011\t\t$a+\t\u0013\u0005e\u0012#!AA\u0002\u0005\u0005\u0016aA6dA!\u001a!#!-\u0011\u0007y\u000b\u0019,C\u0002\u00026~\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0015\u0005\u0005\u0005\u0016AA:d\u0003\u0019\u00198m\u0018\u0013fcR!\u0011\u0011GA`\u0011%\tI$FA\u0001\u0002\u0004\t\t+A\u0002tG\u0002B3AFAY\u0003=\u0019XM\u001d<jG\u0016\u001cuN\\:v[\u0016\u0014\u0018a\u00029feNL7\u000f\u001e\u000b\u0005\u0003\u0017\f\t\u000e\u0005\u0003I\u0003\u001bl\u0015bAAh\u0013\n9Ai\u0015;sK\u0006l\u0007bBAj1\u0001\u0007\u0011Q[\u0001\t]\u0016<H*\u001a<fYB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\~\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002`\u0006e'\u0001D*u_J\fw-\u001a'fm\u0016d\u0017AC4fi\n\u0013xn[3sgV\u0011\u0011Q\u001d\t\t\u0003\u0007\ni%!#\u0002R\u0005\tr-\u001a;Qe\u00164WM\u001d:fI\"{7\u000f^:\u0016\u0005\u0005-\b\u0003CA\"\u0003[\fI)!\u0015\n\t\u0005\u001d\u0015QI\u0001\u0005]\u0006lW-\u0006\u0002\u0002R\u0005q1\r[3dWB|\u0017N\u001c;ECR\fWCAA|!\r\tIpL\u0007\u0002\u0001\t)C)\u001b:fGR\\\u0015MZ6b\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/Y\n\u0004_\u0005}\b\u0003\u0002%\u0003\u00025K1Aa\u0001J\u0005U!5\u000b\u001e:fC6\u001c\u0005.Z2la>Lg\u000e\u001e#bi\u0006$\"!a>\u0002\u0019\t\fGo\u00195G_J$\u0016.\\3\u0016\u0005\t-\u0001\u0003\u0003B\u0007\u0005'\u0011)Ba\u0007\u000e\u0005\t=!\u0002\u0002B\t\u0003\u0003\u000bq!\\;uC\ndW-\u0003\u0003\u0002P\t=\u0001cA;\u0003\u0018%\u0019!\u0011D\u001f\u0003\tQKW.\u001a\t\u0006=\nu!\u0011E\u0005\u0004\u0005?y&!B!se\u0006L\bc\u00030\u0003$\u0005E#qEA\u000e\u00037I1A!\n`\u0005\u0019!V\u000f\u001d7fiA\u0019aL!\u000b\n\u0007\t-rLA\u0002J]R\fa!\u001e9eCR,G\u0003BA\u0019\u0005cAqAa\r3\u0001\u0004\u0011)\"\u0001\u0003uS6,\u0017aB2mK\u0006tW\u000f\u001d\u000b\u0005\u0003c\u0011I\u0004C\u0004\u00034M\u0002\rA!\u0006\u0002\u000fI,7\u000f^8sKR\u0011\u0011\u0011G\u0001\u0010G\",7m\u001b9pS:$H)\u0019;bA\u0005q!/\u0019;f\u0007>tGO]8mY\u0016\u0014XC\u0001B#!\u0015q&q\tB&\u0013\r\u0011Ie\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t5#1K\u0007\u0003\u0005\u001fR1A!\u0015>\u0003%\u00198\r[3ek2,'/\u0003\u0003\u0003V\t=#A\u0004*bi\u0016\u001cuN\u001c;s_2dWM]\u0001\u0010e\u0006$XmQ8oiJ|G\u000e\\3sA\u00059R.\u0019=NKN\u001c\u0018mZ3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0005;\u0012\u0019\u0007E\u0003_\u0005\u000f\u0012y\u0006\u0005\u0005\u0002T\t\u0005\u0014\u0011RA\u000e\u0013\u0011\t9)!\u001a\t\u000f\t\u0015\u0004\u00051\u0001\u0003`\u00059qN\u001a4tKR\u001c\u0018\u0001\u00049be\u0006tw.\u001b3Q_2dG\u0003BA\u0019\u0005WBqA!\u001c\"\u0001\u0004\t\t+A\u0001d\u0003-9\u0018\u000e\u001e5SKR\u0014\u0018.Z:\u0016\t\tM$\u0011\u0010\u000b\u0005\u0005k\u00129\t\u0006\u0003\u0003x\tu\u0004c\u0001-\u0003z\u00111!1\u0010\u0012C\u0002q\u0013\u0011\u0001\u0016\u0005\t\u0005\u007f\u0012C\u00111\u0001\u0003\u0002\u0006\ta\rE\u0003_\u0005\u0007\u00139(C\u0002\u0003\u0006~\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0005\u0013\u0013\u0003\u0019AA\u000e\u0003\u0005!\bf\u0001\u0012\u0003\u000eB!!q\u0012BK\u001b\t\u0011\tJC\u0002\u0003\u0014~\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119J!%\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006iA.\u0019;fgR|eMZ:fiN$\"Aa\u0018\u0002\u000b\rd\u0017-\u001c9\u0015\t\t}#\u0011\u0015\u0005\b\u0005K\"\u0003\u0019\u0001B0\u0003\u001d\u0019w.\u001c9vi\u0016$BAa*\u00030B)aLa\u0012\u0003*B)\u0001Oa+XM&\u0019!QV\u001e\u0003\u0011-\u000bgm[1S\t\u0012CqA!-&\u0001\u0004\u0011)\"A\u0005wC2LG\rV5nK\u0006)1\u000f^1si\u0006!1\u000f^8q\u0003-\u0019w.\\7jiF+X-^3\u0016\u0005\tm\u0006C\u0002B_\u0005\u0007\u00149-\u0004\u0002\u0003@*!!\u0011YA#\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005\u000b\u0014yLA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0007A\u0014I-C\u0002\u0003Ln\u00121b\u00144gg\u0016$(+\u00198hK\u0006a1m\\7nSR\fV/Z;fA\u0005q1m\\7nSR\u001c\u0015\r\u001c7cC\u000e\\WC\u0001Bj!\u0019\u0011)Na7\u0003`6\u0011!q\u001b\u0006\u0005\u00053\u0014y,\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005;\u00149NA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\rq%\u0011]\u0005\u0004\u0005G|%\u0001F(gMN,GoQ8n[&$8)\u00197mE\u0006\u001c7.A\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6!\u0003-\u0019w.\\7ji\u0006\u001b\u0018P\\2\u0015\t\u0005E\"1\u001e\u0005\b\u0005[d\u0003\u0019\u0001Bx\u00031ygMZ:fiJ\u000bgnZ3t!\u0015q&Q\u0004Bd)\u0019\t\tDa=\u0003v\"9!Q^\u0017A\u0002\t=\bb\u0002B|[\u0001\u0007!q\\\u0001\tG\u0006dGNY1dW\u0006I1m\\7nSR\fE\u000e\u001c\u0002\u001a\t&\u0014Xm\u0019;LC\u001a\\\u0017MU1uK\u000e{g\u000e\u001e:pY2,'oE\u00026\u0005\u0017\n!!\u001b3\n\t\r\r!1K\u0001\ngR\u0014X-Y7V\u0013\u0012\u000b\u0011\"Z:uS6\fGo\u001c:\u0011\t\r%1qB\u0007\u0003\u0007\u0017QAa!\u0004\u0003P\u0005!!/\u0019;f\u0013\u0011\u0019\tba\u0003\u0003\u001bI\u000bG/Z#ti&l\u0017\r^8s)\u0019\u0019)ba\u0006\u0004\u001aA\u0019\u0011\u0011`\u001b\t\u000f\t}\b\b1\u0001\u0003(!91Q\u0001\u001dA\u0002\r\u001d\u0011a\u00029vE2L7\u000f\u001b\u000b\u0005\u0003c\u0019y\u0002C\u0004\u0004\u000ee\u0002\r!a\u0007")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final PerPartitionConfig ppc;
    private final long initialRate;
    private boolean isFirstCompute;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private transient Consumer<K, V> sc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    private long initialRate() {
        return this.initialRate;
    }

    public boolean isFirstCompute() {
        return this.isFirstCompute;
    }

    public void isFirstCompute_$eq(boolean x$1) {
        this.isFirstCompute = x$1;
    }

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        block0: {
            if (this.kc() != null) break block0;
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.unboxToLong((Object)l)).toMap(Predef$.MODULE$.$conforms())).asJava()));
        }
        return this.kc();
    }

    private Consumer<K, V> sc() {
        return this.sc;
    }

    private void sc_$eq(Consumer<K, V> x$1) {
        this.sc = x$1;
    }

    public synchronized Consumer<K, V> serviceConsumer() {
        block0: {
            if (this.sc() != null) break block0;
            this.sc_$eq(this.consumerStrategy.serviceConsumer());
        }
        return this.sc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return super.persist(newLevel);
    }

    public HashMap<TopicPartition, String> getBrokers() {
        Consumer<K, V> c = this.consumer();
        HashMap<TopicPartition, String> result = new HashMap<TopicPartition, String>();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, (String)hosts.get(tp));
        }
        return result;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        LocationStrategy locationStrategy = this.locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy)) {
            return this.getBrokers();
        }
        if (PreferConsistent$.MODULE$.equals(locationStrategy)) {
            return Collections.emptyMap();
        }
        if (locationStrategy instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy;
            java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            return hostMap;
        }
        throw new MatchError((Object)locationStrategy);
    }

    public String name() {
        return new StringBuilder(27).append("Kafka 0.10 direct stream [").append(this.id()).append("]").toString();
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        scala.collection.immutable.Map map;
        Option estimatedRateLimit = this.rateController().map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)DirectKafkaInputDStream.$anonfun$maxMessagesPerPartition$1(this, x)));
        Option option = estimatedRateLimit.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L);
        if (option instanceof Some) {
            Some some = (Some)option;
            long rate = BoxesRunTime.unboxToLong((Object)some.value());
            scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)), 0L)));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
            long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            map = (scala.collection.immutable.Map)lagPerPartition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long lag = tuple2._2$mcJ$sp();
                    long maxRateLimitPerPartition = $this.ppc.maxRatePerPartition(tp);
                    double backpressureRate = (double)lag / (double)totalLag * (double)rate;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToDouble((double)Math.min(backpressureRate, (double)maxRateLimitPerPartition)) : BoxesRunTime.boxToDouble((double)backpressureRate)));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            map = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToDouble((double)$this.ppc.maxRatePerPartition(tp)));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
        if (BoxesRunTime.unboxToDouble((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) > 0.0) {
            double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
            return new Some(effectiveRateLimitPerPartition.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    double limit = tuple2._2$mcD$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max((long)(secsPerBatch * limit), $this.ppc.minRatePerPartition(tp))));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom()));
        }
        return None$.MODULE$;
    }

    private void paranoidPoll(Consumer<K, V> c) {
        java.util.Set parts;
        c.pause((Collection)c.assignment());
        ConsumerRecords msgs = c.poll(0L);
        java.util.Set newAssignment = c.assignment();
        java.util.Set set = parts = this.currentOffsets().size() < newAssignment.size() ? newAssignment : (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava();
        if (this.serviceConsumer().assignment().size() < parts.size()) {
            this.serviceConsumer().assign((Collection)parts);
        }
        if (!msgs.isEmpty()) {
            long waitingForAssigmentTimeout = SparkEnv$.MODULE$.get().conf().getLong("spark.mapr.WaitingForAssignmentTimeout", 600000L);
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, m) -> {
                TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> Math.min(o, m.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> m.offset()));
                return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
            })).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DirectKafkaInputDStream.$anonfun$paranoidPoll$4(this, waitingForAssigmentTimeout, c, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private <T> T withRetries(long t, Function0<T> f) {
        Try try_;
        while (true) {
            if ((try_ = Try$.MODULE$.apply(f)) instanceof Success) {
                Success success = (Success)try_;
                Object v = success.value();
                return (T)v;
            }
            if (t <= 0L) break;
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(500L));
            t -= 500L;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        scala.collection.mutable.Set parts;
        block3: {
            Consumer<K, V> c = this.consumer();
            this.paranoidPoll(c);
            parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(KafkaUtils$.MODULE$.waitForConsumerAssignment(c, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava())).asScala();
            if (parts.size() < this.currentOffsets().keySet().size()) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Assignment() returned fewer partitions than the previous call");
            }
            if (this.serviceConsumer().assignment().size() < parts.size()) {
                this.serviceConsumer().assign((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(parts).asJava());
            }
            scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
            scala.collection.immutable.Set revokedPartitions = (scala.collection.immutable.Set)this.currentOffsets().keySet().diff((GenSet)parts);
            if (revokedPartitions.nonEmpty()) {
                throw new IllegalStateException(new StringBuilder(300).append("Previously tracked partitions ").append(revokedPartitions.mkString("[", ",", "]")).append(" been revoked by Kafka because of consumer ").append("rebalance. This is mostly due to another stream with same group id joined, ").append("please check if there're different streaming application misconfigure to use same ").append("group id. Fundamentally different stream should use different group id").toString());
            }
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            c.pause((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(newPartitions).asJava());
            if (this.serviceConsumer().assignment().isEmpty()) break block3;
            this.serviceConsumer().seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        }
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1 & Serializable & scala.Serializable)mmp -> (scala.collection.immutable.Map)mmp.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long messages = tuple2._2$mcJ$sp();
                long uo = BoxesRunTime.unboxToLong((Object)offsets.apply((Object)tp));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)) + messages, uo)));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> offsets);
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                long uo = tuple2._2$mcJ$sp();
                long fo = BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp));
                if (this.isFirstCompute() && KafkaUtils$.MODULE$.isStreams(untilOffsets) && uo - fo == 1L && $this.consumerStrategy.executorKafkaParams().get("auto.offset.reset").toString().equals("latest")) {
                    fo = uo;
                    this.isFirstCompute_$eq(false);
                }
                return OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        boolean useConsumerCache = BoxesRunTime.unboxToBoolean((Object)this.context().conf().get(package$.MODULE$.CONSUMER_CACHE_ENABLED()));
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), useConsumerCache);
        String description = ((TraversableOnce)((TraversableLike)((TraversableOnce)offsetRanges.filter((Function1 & Serializable & scala.Serializable)offsetRange -> BoxesRunTime.boxToBoolean((boolean)DirectKafkaInputDStream.$anonfun$compute$2(offsetRange)))).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)DirectKafkaInputDStream.$anonfun$compute$3(x$2)), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)offsetRange -> new StringBuilder(41).append("topic: ").append(offsetRange.topic()).append("\tpartition: ").append(offsetRange.partition()).append("\t").append("offsets: ").append(offsetRange.fromOffset()).append(" to ").append(offsetRange.untilOffset()).append("\t").append("count: ").append(offsetRange.count()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer c = this.consumer();
        this.paranoidPoll(c);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
        this.serviceConsumer().close();
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetRange osr = this.commitQueue().poll();
        while (osr != null) {
            TopicPartition tp = osr.topicPartition();
            OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
            long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
            m.put(tp, new OffsetAndMetadata(offset));
            osr = this.commitQueue().poll();
        }
        if (!m.isEmpty()) {
            if (KafkaUtils$.MODULE$.isStreams(this.currentOffsets())) {
                this.serviceConsumer().commitAsync(m, this.commitCallback().get());
                return;
            }
            this.consumer().commitAsync(m, this.commitCallback().get());
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$maxMessagesPerPartition$1(DirectKafkaInputDStream $this, RateController x) {
        long lr = x.getLatestRate();
        if (lr > 0L) {
            return lr;
        }
        return $this.initialRate();
    }

    public static final /* synthetic */ void $anonfun$paranoidPoll$4(DirectKafkaInputDStream $this, long waitingForAssigmentTimeout$1, Consumer c$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long off = tuple2._2$mcJ$sp();
            $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("poll(0) returned messages, seeking ").append(tp).append(" to ").append(off).append(" to compensate").toString());
            $this.serviceConsumer().seek(tp, off);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)$this.withRetries(waitingForAssigmentTimeout$1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c$1.seek(tp, off));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$compute$2(OffsetRange offsetRange) {
        return offsetRange.fromOffset() != offsetRange.untilOffset();
    }

    public static final /* synthetic */ long $anonfun$compute$3(OffsetRange x$2) {
        return -x$2.count();
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        this.initialRate = this.context().sparkContext().getConf().getLong("spark.streaming.backpressure.initialRate", 0L);
        this.isFirstCompute = true;
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.sc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Tuple4[] a = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toTuple(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)));
                return this.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> (Time)x$4._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Time t = (Time)tuple2._1();
                    Tuple4[] b = (Tuple4[])tuple2._2();
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Restoring KafkaRDD for time ").append(t).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).mkString("[", ", ", "]")).toString());
                    return this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD(this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).map((Function1 & Serializable & scala.Serializable)x$5 -> OffsetRange$.MODULE$.apply((Tuple4<String, Object, Object, Object>)x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super((DStream)DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

