/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Time;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]h!\u0002+V\u0001U{\u0006\"\u00027\u0001\t\u0003q\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B:\t\u000fq\u0004\u0001\u0019!C\u0005{\"I\u00111\u0001\u0001A\u0002\u0013%\u0011Q\u0001\u0005\b\u0003#\u0001\u0001\u0015)\u0003\u007f\u0011!\t\u0019\u0002\u0001b\u0001\n\u0013i\bbBA\u000b\u0001\u0001\u0006IA \u0005\t\u0003/\u0001!\u0019!C\u0005{\"9\u0011\u0011\u0004\u0001!\u0002\u0013q\bbCA\u000e\u0001\u0001\u0007\t\u0019!C\u0005\u0003;A1\"!%\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0014\"Y\u00111\u000e\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0010\u0011-\t9\n\u0001a\u0001\u0002\u0004%I!!'\t\u0017\u0005-\u0006\u00011AA\u0002\u0013%\u0011Q\u0016\u0005\f\u0003c\u0003\u0001\u0019!A!B\u0013\tY\nC\u0006\u00024\u0002\u0001\r\u00111A\u0005\n\u0005U\u0006bCA_\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007fC1\"a1\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00028\"A\u0011Q\u0019\u0001C\u0002\u0013%!\u000fC\u0004\u0002H\u0002\u0001\u000b\u0011B:\t\u0011\u0005%\u0007\u00011A\u0005\nuD\u0011\"a3\u0001\u0001\u0004%I!!4\t\u000f\u0005E\u0007\u0001)Q\u0005}\"Y\u00111\u001b\u0001A\u0002\u0003\u0007I\u0011BAk\u0011-\t\t\u000f\u0001a\u0001\u0002\u0004%I!a9\t\u0017\u0005\u001d\b\u00011A\u0001B\u0003&\u0011q\u001b\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\tI\u000fC\u0006\u0002r\u0002\u0001\r\u00111A\u0005\n\u0005M\bbCA|\u0001\u0001\u0007\t\u0011)Q\u0005\u0003WD1\"!?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002|\"Y!Q\u0002\u0001A\u0002\u0003\u0007I\u0011\u0002B\b\u0011-\u0011\u0019\u0002\u0001a\u0001\u0002\u0003\u0006K!!@\t\u0013\tU\u0001\u00011A\u0005\n\t]\u0001\"\u0003B\u0010\u0001\u0001\u0007I\u0011\u0002B\u0011\u0011!\u0011)\u0003\u0001Q!\n\te\u0001\"\u0003B\u0014\u0001\u0001\u0007I\u0011\u0002B\f\u0011%\u0011I\u0003\u0001a\u0001\n\u0013\u0011Y\u0003\u0003\u0005\u00030\u0001\u0001\u000b\u0015\u0002B\r\u0011%\u0011\t\u0004\u0001a\u0001\n\u0013\u0011\u0019\u0004C\u0005\u00036\u0001\u0001\r\u0011\"\u0003\u00038!9!1\b\u0001!B\u0013\u0001\u0007b\u0002B\u001f\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0005\u007f\u0001A\u0011AA\u0015\u0011\u001d\u0011\t\u0005\u0001C\u0001\u00033CqAa\u0011\u0001\t\u0003\t)\fC\u0004\u0003F\u0001!I!a$\t\u000f\t\u001d\u0003\u0001\"\u0003\u0002\u0010\"9!\u0011\n\u0001\u0005\u0002\u0005=\u0005b\u0002B&\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005SBqA!\u0014\u0001\t\u0003\u0011y\u0007C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\tM\u0004\u0001\"\u0001\u0003\n\"9!1\u000f\u0001\u0005\u0002\tM\u0005b\u0002B:\u0001\u0011\u0005!\u0011\u0015\u0005\t\u0005W\u0003!\u0019!C\u0001e\"9!Q\u0016\u0001!\u0002\u0013\u0019\bb\u0002BX\u0001\u0011%!\u0011\u0017\u0005\b\u0005g\u0003A\u0011\u0002BY\u0011\u001d\u0011)\f\u0001C\u0001\u0005oCqA!<\u0001\t\u0013\u0011yO\u0002\u0004\u0002$\u0001!\u0011Q\u0005\u0005\u000b\u0003O\u0001%Q1A\u0005\u0002\u0005%\u0002BCA \u0001\n\u0005\t\u0015!\u0003\u0002,!1A\u000e\u0011C\u0001\u0003\u0003B\u0011\"!\u0012A\u0005\u0004%\t!a\u0012\t\u0011\u0005U\u0003\t)A\u0005\u0003\u0013B\u0011\"a\u0016A\u0005\u0004%\t!a\u0012\t\u0011\u0005e\u0003\t)A\u0005\u0003\u0013B\u0011\"a\u0007A\u0005\u0004%\t!a\u0017\t\u0011\u0005-\u0004\t)A\u0005\u0003;BA\"!\u001cA!\u0003\u0005\u0019\u0011)A\u0005\u0003_B\u0001\"!\u001eA\u0005\u0004%\tA\u001d\u0005\b\u0003o\u0002\u0005\u0015!\u0003t\u0011!\tI\b\u0011b\u0001\n\u0003i\bbBA>\u0001\u0002\u0006IA \u0005\n\u0003{\u0002%\u0019!C\u0001\u0003\u007fB\u0001\"a\"AA\u0003%\u0011\u0011\u0011\u0005\t\u0003\u0013\u0003%\u0019!C\u0001{\"9\u00111\u0012!!\u0002\u0013q\bbBAG\u0001\u0012\u0005\u0011q\u0012\u0002\u000f\u0017\u000647.\u0019+fgR,F/\u001b7t\u0015\t1v+\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\tA\u0016,A\u0005tiJ,\u0017-\\5oO*\u0011!lW\u0001\u0006gB\f'o\u001b\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014xmE\u0002\u0001A\u001a\u0004\"!\u00193\u000e\u0003\tT\u0011aY\u0001\u0006g\u000e\fG.Y\u0005\u0003K\n\u0014a!\u00118z%\u00164\u0007CA4k\u001b\u0005A'BA5Z\u0003!Ig\u000e^3s]\u0006d\u0017BA6i\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002_B\u0011\u0001\u000fA\u0007\u0002+\u00061!p\u001b%pgR,\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019\u0019FO]5oO\u00069!p\u001b%pgR\u0004\u0013A\u0002>l!>\u0014H/F\u0001\u007f!\t\tw0C\u0002\u0002\u0002\t\u00141!\u00138u\u0003)Q8\u000eU8si~#S-\u001d\u000b\u0005\u0003\u000f\ti\u0001E\u0002b\u0003\u0013I1!a\u0003c\u0005\u0011)f.\u001b;\t\u0011\u0005=Q!!AA\u0002y\f1\u0001\u001f\u00132\u0003\u001dQ8\u000eU8si\u0002\n1C_6D_:tWm\u0019;j_:$\u0016.\\3pkR\fAC_6D_:tWm\u0019;j_:$\u0016.\\3pkR\u0004\u0013\u0001\u0005>l'\u0016\u001c8/[8o)&lWm\\;u\u0003EQ8nU3tg&|g\u000eV5nK>,H\u000fI\u0001\nu>|7.Z3qKJ,\"!a\b\u0011\u0007\u0005\u0005\u0002)D\u0001\u0001\u0005E)UNY3eI\u0016$'l\\8lK\u0016\u0004XM]\n\u0003\u0001\u0002\f\u0011B_6D_:tWm\u0019;\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003wqA!a\f\u00028A\u0019\u0011\u0011\u00072\u000e\u0005\u0005M\"bAA\u001b[\u00061AH]8pizJ1!!\u000fc\u0003\u0019\u0001&/\u001a3fM&\u0019!0!\u0010\u000b\u0007\u0005e\"-\u0001\u0006{W\u000e{gN\\3di\u0002\"B!a\b\u0002D!9\u0011qE\"A\u0002\u0005-\u0012aC:oCB\u001c\bn\u001c;ESJ,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014x\u0003\tIw.\u0003\u0003\u0002T\u00055#\u0001\u0002$jY\u0016\fAb\u001d8baNDw\u000e\u001e#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u000b\u0003\u0003;\u0002B!a\u0018\u0002h5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0004tKJ4XM\u001d\u0006\u0004\u00037Y\u0016\u0002BA5\u0003C\u0012qBW8p\u0017\u0016,\u0007/\u001a:TKJ4XM]\u0001\u000bu>|7.Z3qKJ\u0004\u0013a\u0001=%eA)\u0011-!\u001dt}&\u0019\u00111\u000f2\u0003\rQ+\b\u000f\\33\u0003\tI\u0007/A\u0002ja\u0002\nA\u0001]8si\u0006)\u0001o\u001c:uA\u00059a-Y2u_JLXCAAA!\u0011\ty&a!\n\t\u0005\u0015\u0015\u0011\r\u0002\u0015\u001d&{5+\u001a:wKJ\u001ce\u000e\u001f8GC\u000e$xN]=\u0002\u0011\u0019\f7\r^8ss\u0002\n!\"Y2uk\u0006d\u0007k\u001c:u\u0003-\t7\r^;bYB{'\u000f\u001e\u0011\u0002\u0011MDW\u000f\u001e3po:$\"!a\u0002\u0002\u001bi|wn[3fa\u0016\u0014x\fJ3r)\u0011\t9!!&\t\u0013\u0005=A\"!AA\u0002\u0005}\u0011\u0001\u0003>l\u00072LWM\u001c;\u0016\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0003u.T!!!*\u0002\u000b-\fgm[1\n\t\u0005%\u0016q\u0014\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0019i\\7\t\\5f]R|F%Z9\u0015\t\u0005\u001d\u0011q\u0016\u0005\n\u0003\u001fy\u0011\u0011!a\u0001\u00037\u000b\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u0013\u0005$Wn\u00117jK:$XCAA\\!\u0011\ti*!/\n\t\u0005m\u0016q\u0014\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0002\u001b\u0005$Wn\u00117jK:$x\fJ3r)\u0011\t9!!1\t\u0013\u0005=!#!AA\u0002\u0005]\u0016AC1e[\u000ec\u0017.\u001a8uA\u0005Q!M]8lKJDun\u001d;\u0002\u0017\t\u0014xn[3s\u0011>\u001cH\u000fI\u0001\u000bEJ|7.\u001a:Q_J$\u0018A\u00042s_.,'\u000fU8si~#S-\u001d\u000b\u0005\u0003\u000f\ty\r\u0003\u0005\u0002\u0010]\t\t\u00111\u0001\u007f\u0003-\u0011'o\\6feB{'\u000f\u001e\u0011\u0002\u0015\t\u0014xn[3s\u0007>tg-\u0006\u0002\u0002XB!\u0011\u0011\\Ao\u001b\t\tYN\u0003\u0003\u0002d\u0005\r\u0016\u0002BAp\u00037\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006q!M]8lKJ\u001cuN\u001c4`I\u0015\fH\u0003BA\u0004\u0003KD\u0011\"a\u0004\u001b\u0003\u0003\u0005\r!a6\u0002\u0017\t\u0014xn[3s\u0007>tg\rI\u000b\u0003\u0003W\u0004B!!7\u0002n&!\u0011q^An\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005U\b\"CA\b;\u0005\u0005\t\u0019AAv\u0003\u001d\u0019XM\u001d<fe\u0002\n\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0003\u0003{\u0004\u0002\"a@\u0003\n\u0005-\u00121F\u0007\u0003\u0005\u0003QA!!?\u0003\u0004)!!Q\u0001B\u0004\u0003\u001d\u0019G.[3oiNT1!!*\\\u0013\u0011\u0011YA!\u0001\u0003\u001b-\u000bgm[1Qe>$WoY3s\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\u0011\t9A!\u0005\t\u0013\u0005=\u0001%!AA\u0002\u0005u\u0018!\u00039s_\u0012,8-\u001a:!\u0003\u001dQ8NU3bIf,\"A!\u0007\u0011\u0007\u0005\u0014Y\"C\u0002\u0003\u001e\t\u0014qAQ8pY\u0016\fg.A\u0006{WJ+\u0017\rZ=`I\u0015\fH\u0003BA\u0004\u0005GA\u0011\"a\u0004$\u0003\u0003\u0005\rA!\u0007\u0002\u0011i\\'+Z1es\u0002\n1B\u0019:pW\u0016\u0014(+Z1es\u0006y!M]8lKJ\u0014V-\u00193z?\u0012*\u0017\u000f\u0006\u0003\u0002\b\t5\u0002\"CA\bM\u0005\u0005\t\u0019\u0001B\r\u00031\u0011'o\\6feJ+\u0017\rZ=!\u00031aW-Y6EKR,7\r^8s+\u0005\u0001\u0017\u0001\u00057fC.$U\r^3di>\u0014x\fJ3r)\u0011\t9A!\u000f\t\u0011\u0005=\u0011&!AA\u0002\u0001\fQ\u0002\\3bW\u0012+G/Z2u_J\u0004\u0013!\u0003>l\u0003\u0012$'/Z:t\u00035\u0011'o\\6fe\u0006#GM]3tg\u0006y!p\\8lK\u0016\u0004XM]\"mS\u0016tG/A\u0006bI6Lgn\u00117jK:$\u0018AF:fiV\u0004X)\u001c2fI\u0012,GMW8pW\u0016,\u0007/\u001a:\u00021M,G/\u001e9F[\n,G\rZ3e\u0017\u000647.Y*feZ,'/A\u0003tKR,\b/\u0001\u0005uK\u0006\u0014Hm\\<o\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0011\u0005\u001d!\u0011\u000bB+\u00053BqAa\u00154\u0001\u0004\tY#A\u0003u_BL7\r\u0003\u0004\u0003XM\u0002\rA`\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bb\u0002B.g\u0001\u0007!QL\u0001\u0007G>tg-[4\u0011\t\t}#QM\u0007\u0003\u0005CR1Aa\u0019x\u0003\u0011)H/\u001b7\n\t\t\u001d$\u0011\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001cHCBA\u0004\u0005W\u0012i\u0007C\u0004\u0003TQ\u0002\r!a\u000b\t\r\t]C\u00071\u0001\u007f)\u0011\t9A!\u001d\t\u000f\tMS\u00071\u0001\u0002,\u0005a1/\u001a8e\u001b\u0016\u001c8/Y4fgR1\u0011q\u0001B<\u0005sBqAa\u00157\u0001\u0004\tY\u0003C\u0004\u0003|Y\u0002\rA! \u0002\u001b5,7o]1hKR{gI]3r!!\u0011yFa \u0002,\t\r\u0015\u0002\u0002BA\u0005C\u00121!T1q!\r!(QQ\u0005\u0004\u0005\u000f+(aB%oi\u0016<WM\u001d\u000b\u0007\u0003\u000f\u0011YI!$\t\u000f\tMs\u00071\u0001\u0002,!9!1P\u001cA\u0002\t=\u0005cBA\u0017\u0005#\u000bYC`\u0005\u0005\u0005\u0003\u000bi\u0004\u0006\u0004\u0002\b\tU%q\u0013\u0005\b\u0005'B\u0004\u0019AA\u0016\u0011\u001d\u0011I\n\u000fa\u0001\u00057\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0006C\nu\u00151F\u0005\u0004\u0005?\u0013'!B!se\u0006LHCBA\u0004\u0005G\u0013)\u000bC\u0004\u0003Te\u0002\r!a\u000b\t\u000f\te\u0015\b1\u0001\u0003(B)\u0011M!(\u0003*B9\u0011-!\u001d\u0002,\u0005-\u0012\u0001\u00042s_.,'\u000fT8h\t&\u0014\u0018!\u00042s_.,'\u000fT8h\t&\u0014\b%A\nce>\\WM]\"p]\u001aLw-\u001e:bi&|g.\u0006\u0002\u0003^\u0005)\u0002O]8ek\u000e,'oQ8oM&<WO]1uS>t\u0017AC3wK:$X/\u00197msV!!\u0011\u0018Ba)\u0019\u0011YL!8\u0003jR!!Q\u0018Bj!\u0011\u0011yL!1\r\u0001\u00119!1\u0019 C\u0002\t\u0015'!\u0001+\u0012\t\t\u001d'Q\u001a\t\u0004C\n%\u0017b\u0001BfE\n9aj\u001c;iS:<\u0007cA1\u0003P&\u0019!\u0011\u001b2\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003Vz\"\t\u0019\u0001Bl\u0003\u00111WO\\2\u0011\u000b\u0005\u0014IN!0\n\u0007\tm'M\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0011yN\u0010a\u0001\u0005C\fq\u0001^5nK>,H\u000f\u0005\u0003\u0003d\n\u0015X\"A,\n\u0007\t\u001dxK\u0001\u0003US6,\u0007b\u0002Bv}\u0001\u0007!\u0011]\u0001\tS:$XM\u001d<bY\u0006ir/Y5u+:$\u0018\u000e\\'fi\u0006$\u0017\r^1JgB\u0013x\u000e]1hCR,G\r\u0006\u0004\u0002\b\tE(1\u001f\u0005\b\u0005'z\u0004\u0019AA\u0016\u0011\u0019\u0011)p\u0010a\u0001}\u0006I\u0001/\u0019:uSRLwN\u001c")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private KafkaZkClient zkClient;
    private AdminZkClient admClient;
    private final String brokerHost;
    private int brokerPort;
    private KafkaConfig brokerConf;
    private KafkaServer server;
    private KafkaProducer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private Object leakDetector;
    private final String brokerLogDir;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    private AdminZkClient admClient() {
        return this.admClient;
    }

    private void admClient_$eq(AdminZkClient x$1) {
        this.admClient = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int brokerPort() {
        return this.brokerPort;
    }

    private void brokerPort_$eq(int x$1) {
        this.brokerPort = x$1;
    }

    private KafkaConfig brokerConf() {
        return this.brokerConf;
    }

    private void brokerConf_$eq(KafkaConfig x$1) {
        this.brokerConf = x$1;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    private Object leakDetector() {
        return this.leakDetector;
    }

    private void leakDetector_$eq(Object x$1) {
        this.leakDetector = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper not setup yet or already torn down, cannot get zookeeper address");
        return new StringBuilder(1).append(this.zkHost()).append(":").append(this.zkPort()).toString();
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0 & Serializable & scala.Serializable)() -> "Kafka not setup yet or already torn down, cannot get broker address");
        return new StringBuilder(1).append(this.brokerHost()).append(":").append(this.brokerPort()).toString();
    }

    public KafkaZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper not setup yet or already torn down, cannot get zookeeper client");
        return (KafkaZkClient)Option$.MODULE$.apply((Object)this.zkClient()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Zookeeper client is not yet initialized");
        });
    }

    public AdminZkClient adminClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper not setup yet or already torn down, cannot get zookeeper client");
        return (AdminZkClient)Option$.MODULE$.apply((Object)this.admClient()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Admin client is not yet initialized");
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringBuilder(1).append(this.zkHost()).append(":").append(this.zkPort()).toString()));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkClient_$eq(KafkaZkClient$.MODULE$.apply(new StringBuilder(1).append(this.zkHost()).append(":").append(this.zkPort()).toString(), false, this.zkSessionTimeout(), this.zkConnectionTimeout(), 1, org.apache.kafka.common.utils.Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10()));
        this.admClient_$eq(new AdminZkClient(this.zkClient()));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper should be set up beforehand");
        Utils$.MODULE$.startServiceOnPort(this.brokerPort(), (Function1 & Serializable & scala.Serializable)port -> KafkaTestUtils.$anonfun$setupEmbeddedKafkaServer$2(this, BoxesRunTime.unboxToInt((Object)port)), new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        SparkException exception = new SparkException("It was created at: ");
        this.leakDetector_$eq(ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Found a leak KafkaTestUtils.", (Throwable)exception)));
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        Object object = this.leakDetector() != null ? BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.leakDetector())) : BoxedUnit.UNIT;
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.server() != null) {
            this.server().shutdown();
            this.server().awaitShutdown();
            this.server_$eq(null);
        }
        this.brokerConf().logDirs().foreach((Function1 & Serializable & scala.Serializable)f -> {
            KafkaTestUtils.$anonfun$teardown$1(this, f);
            return BoxedUnit.UNIT;
        });
        if (this.zkClient() != null) {
            this.zkClient().close();
            this.zkClient_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
            return;
        }
    }

    public void createTopic(String topic, int partitions, Properties config) {
        AdminZkClient qual$1 = this.adminClient();
        String x$1 = topic;
        int x$2 = partitions;
        int x$3 = 1;
        Properties x$4 = config;
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)p -> this.waitUntilMetadataIsPropagated(topic, p));
    }

    public void createTopic(String topic, int partitions) {
        this.createTopic(topic, partitions, new Properties());
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1, new Properties());
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String s = (String)tuple2._1();
                int freq = tuple2._2$mcI$sp();
                return (Seq)Seq$.MODULE$.fill(freq, (Function0 & Serializable & scala.Serializable)() -> s);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((KafkaProducer<String, String>)new KafkaProducer(this.producerConfiguration()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).foreach((Function1 & Serializable & scala.Serializable)message -> this.producer().send(new ProducerRecord(topic, message)));
        this.producer().close();
        this.producer_$eq(null);
    }

    public void sendMessages(String topic, Tuple2<String, String>[] messages) {
        this.producer_$eq((KafkaProducer<String, String>)new KafkaProducer(this.producerConfiguration()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).foreach((Function1 & Serializable & scala.Serializable)message -> this.producer().send(new ProducerRecord(topic, message._1(), message._2())));
        this.producer().close();
        this.producer_$eq(null);
    }

    public String brokerLogDir() {
        return this.brokerLogDir;
    }

    private Properties brokerConfiguration() {
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "127.0.0.1");
        props.put("advertised.host.name", "127.0.0.1");
        props.put("port", Integer.toString(this.brokerPort()));
        props.put("log.dir", this.brokerLogDir());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("zookeeper.connection.timeout.ms", "60000");
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        props.put("delete.topic.enable", "true");
        props.put("offsets.topic.num.partitions", "1");
        props.put("offsets.topic.replication.factor", "1");
        props.put("group.initial.rebalance.delay.ms", "10");
        return props;
    }

    private Properties producerConfiguration() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerAddress());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("acks", "all");
        return props;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTimeNs = System.nanoTime();
        return (T)this.tryAgain$1(1, startTimeNs, timeout, interval, func);
    }

    private void waitUntilMetadataIsPropagated(String topic, int partition) {
    }

    public static final /* synthetic */ Tuple2 $anonfun$setupEmbeddedKafkaServer$2(KafkaTestUtils $this, int port) {
        $this.brokerPort_$eq(port);
        $this.brokerConf_$eq(new KafkaConfig((Map)$this.brokerConfiguration(), false));
        $this.server_$eq(new KafkaServer($this.brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4()));
        $this.server().startup();
        $this.brokerPort_$eq($this.server().boundPort(new ListenerName("PLAINTEXT")));
        return new Tuple2((Object)$this.server(), (Object)BoxesRunTime.boxToInteger((int)$this.brokerPort()));
    }

    public static final /* synthetic */ void $anonfun$teardown$1(KafkaTestUtils $this, String f) {
        try {
            Utils$.MODULE$.deleteRecursively(new File(f));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                if (Utils$.MODULE$.isWindows()) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                }
            }
            throw throwable;
        }
    }

    private static final Either makeAttempt$1(Function0 func$1) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(func$1.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                right = package$.MODULE$.Left().apply((Object)throwable2);
            }
            throw throwable;
        }
        return right;
    }

    private final Object tryAgain$1(int attempt, long startTimeNs$1, Time timeout$1, Time interval$1, Function0 func$1) {
        Either either;
        while (true) {
            if ((either = KafkaTestUtils.makeAttempt$1(func$1)) instanceof Right) {
                Right right = (Right)either;
                Object result = right.value();
                return result;
            }
            if (!(either instanceof Left)) break;
            Left left = (Left)either;
            Throwable e = (Throwable)left.value();
            long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs$1);
            if (durationMs >= timeout$1.milliseconds()) {
                throw new TimeoutException(e.getMessage());
            }
            Thread.sleep(interval$1.milliseconds());
            ++attempt;
        }
        throw new MatchError((Object)either);
    }

    public KafkaTestUtils() {
        Logging.$init$((Logging)this);
        this.zkHost = "127.0.0.1";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 10000;
        this.brokerHost = "127.0.0.1";
        this.brokerPort = 0;
        this.zkReady = false;
        this.brokerReady = false;
        this.leakDetector = null;
        this.brokerLogDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
    }

    private class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$2;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            try {
                Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    if (Utils$.MODULE$.isWindows()) {
                        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                    }
                }
                throw throwable;
            }
            try {
                Utils$.MODULE$.deleteRecursively(this.logDir());
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                if (throwable3 instanceof IOException) {
                    IOException iOException = (IOException)throwable3;
                    if (Utils$.MODULE$.isWindows()) {
                        this.org$apache$spark$streaming$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                    }
                }
                throw throwable;
            }
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String ip = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            this.x$2 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
            this.ip = (String)this.x$2._1();
            this.port = this.x$2._2$mcI$sp();
            this.factory = new NIOServerCnxnFactory();
            this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
            this.factory().startup(this.zookeeper());
            this.actualPort = this.factory().getLocalPort();
        }
    }
}

