/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kafka010.CachedKafkaConsumer$;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t=h!\u0002 @\u0001}J\u0005\u0002C,\u0001\u0005\u000b\u0007I\u0011A-\t\u0011\u0015\u0004!\u0011!Q\u0001\niC\u0001B\u001a\u0001\u0003\u0006\u0004%\t!\u0017\u0005\tO\u0002\u0011\t\u0011)A\u00055\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\r}\u0004A\u0011BA\u0001\u0011%\tY\u0003\u0001b\u0001\n\u0003\ti\u0003\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u0018\u0011%\t\t\u0005\u0001b\u0001\n#\t\u0019\u0005\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA#\u0011%\t)\u0006\u0001a\u0001\n#\t9\u0006C\u0005\u0002f\u0001\u0001\r\u0011\"\u0005\u0002h!A\u00111\u000f\u0001!B\u0013\tI\u0006C\u0005\u0002v\u0001\u0001\r\u0011\"\u0005\u0002x!I\u0011q\u0010\u0001A\u0002\u0013E\u0011\u0011\u0011\u0005\t\u0003\u000b\u0003\u0001\u0015)\u0003\u0002z!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a-\u0001\t\u0013\t)l\u0002\u0005\u0002:~B\taPA^\r\u001dqt\b#\u0001@\u0003{Caa \u000e\u0005\u0002\u0005}fABAa5\u0011\u000b\u0019\r\u0003\u0005X9\tU\r\u0011\"\u0001Z\u0011!)GD!E!\u0002\u0013Q\u0006\u0002\u00034\u001d\u0005+\u0007I\u0011A-\t\u0011\u001dd\"\u0011#Q\u0001\niC\u0001\u0002\u001b\u000f\u0003\u0016\u0004%\t!\u001b\u0005\t[r\u0011\t\u0012)A\u0005U\"1q\u0010\bC\u0001\u0003#D\u0011\"!8\u001d\u0003\u0003%\t!a8\t\u0013\u0005\u001dH$%A\u0005\u0002\u0005%\b\"CA~9E\u0005I\u0011AAu\u0011%\ti\u0010HI\u0001\n\u0003\ty\u0010C\u0005\u0003\u0004q\t\t\u0011\"\u0011\u0003\u0006!A!1\u0002\u000f\u0002\u0002\u0013\u0005\u0011\u000eC\u0005\u0003\u000eq\t\t\u0011\"\u0001\u0003\u0010!I!1\u0003\u000f\u0002\u0002\u0013\u0005#Q\u0003\u0005\n\u0005Ca\u0012\u0011!C\u0001\u0005GA\u0011B!\f\u001d\u0003\u0003%\tEa\f\t\u0013\tEB$!A\u0005B\tM\u0002\"\u0003B\u001b9\u0005\u0005I\u0011\tB\u001c\u000f%\u0011YDGA\u0001\u0012\u0013\u0011iDB\u0005\u0002Bj\t\t\u0011#\u0003\u0003@!1q0\rC\u0001\u0005\u001bB\u0011B!\r2\u0003\u0003%)Ea\r\t\u0013\t=\u0013'!A\u0005\u0002\nE\u0003\"\u0003B-c\u0005\u0005I\u0011\u0011B.\u0011%\u0011i'MA\u0001\n\u0013\u0011y\u0007C\u0005\u0003ri\u0001\r\u0011\"\u0003\u0003t!I!Q\u0012\u000eA\u0002\u0013%!q\u0012\u0005\t\u0005\u000bS\u0002\u0015)\u0003\u0003v!9!\u0011\u0015\u000e\u0005\u0002\t\r\u0006bBAF5\u0011\u0005!q\u0017\u0005\b\u0005\u001bTB\u0011\u0001Bh\u0011\u001d\u0011)O\u0007C\u0001\u0005O\u00141cQ1dQ\u0016$7*\u00194lC\u000e{gn];nKJT!\u0001Q!\u0002\u0011-\fgm[11cAR!AQ\"\u0002\u0013M$(/Z1nS:<'B\u0001#F\u0003\u0015\u0019\b/\u0019:l\u0015\t1u)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0011\u0006\u0019qN]4\u0016\u000b)\u000bY!a\b\u0014\u0007\u0001Y\u0015\u000b\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0004B]f\u0014VM\u001a\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u000e\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003-N\u0013q\u0001T8hO&tw-A\u0004he>,\b/\u00133\u0004\u0001U\t!\f\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;6k\u0011A\u0018\u0006\u0003?b\u000ba\u0001\u0010:p_Rt\u0014BA1N\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005l\u0015\u0001C4s_V\u0004\u0018\n\u001a\u0011\u0002\u000bQ|\u0007/[2\u0002\rQ|\u0007/[2!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001k!\ta5.\u0003\u0002m\u001b\n\u0019\u0011J\u001c;\u0002\u0015A\f'\u000f^5uS>t\u0007%A\u0006lC\u001a\\\u0017\rU1sC6\u001cX#\u00019\u0011\tE4(\f_\u0007\u0002e*\u00111\u000f^\u0001\u0005kRLGNC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(aA'baB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010^\u0001\u0005Y\u0006tw-\u0003\u0002~u\n1qJ\u00196fGR\fAb[1gW\u0006\u0004\u0016M]1ng\u0002\na\u0001P5oSRtDCCA\u0002\u0003G\t)#a\n\u0002*A9\u0011Q\u0001\u0001\u0002\b\u0005uQ\"A \u0011\t\u0005%\u00111\u0002\u0007\u0001\t\u001d\ti\u0001\u0001b\u0001\u0003\u001f\u0011\u0011aS\t\u0005\u0003#\t9\u0002E\u0002M\u0003'I1!!\u0006N\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001TA\r\u0013\r\tY\"\u0014\u0002\u0004\u0003:L\b\u0003BA\u0005\u0003?!q!!\t\u0001\u0005\u0004\tyAA\u0001W\u0011\u00159\u0016\u00021\u0001[\u0011\u00151\u0017\u00021\u0001[\u0011\u0015A\u0017\u00021\u0001k\u0011\u0015q\u0017\u00021\u0001q\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u000511m\\7n_:T1!!\u000fF\u0003\u0015Y\u0017MZ6b\u0013\u0011\ti$a\r\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0005d_:\u001cX/\\3s+\t\t)\u0005\u0005\u0005\u0002H\u0005=\u0013qAA\u000f\u001b\t\tIE\u0003\u0003\u0002B\u0005-#\u0002BA'\u0003o\tqa\u00197jK:$8/\u0003\u0003\u0002R\u0005%#!D&bM.\f7i\u001c8tk6,'/A\u0005d_:\u001cX/\\3sA\u00051!-\u001e4gKJ,\"!!\u0017\u0011\u000bE\fY&a\u0018\n\u0007\u0005u#O\u0001\u0005Ji\u0016\u0014\u0018\r^8s!!\t9%!\u0019\u0002\b\u0005u\u0011\u0002BA2\u0003\u0013\u0012abQ8ogVlWM\u001d*fG>\u0014H-\u0001\u0006ck\u001a4WM]0%KF$B!!\u001b\u0002pA\u0019A*a\u001b\n\u0007\u00055TJ\u0001\u0003V]&$\b\"CA9\u001f\u0005\u0005\t\u0019AA-\u0003\rAH%M\u0001\bEV4g-\u001a:!\u0003)qW\r\u001f;PM\u001a\u001cX\r^\u000b\u0003\u0003s\u00022\u0001TA>\u0013\r\ti(\u0014\u0002\u0005\u0019>tw-\u0001\boKb$xJ\u001a4tKR|F%Z9\u0015\t\u0005%\u00141\u0011\u0005\n\u0003c\u0012\u0012\u0011!a\u0001\u0003s\n1B\\3yi>3gm]3uA\u0005)1\r\\8tKR\u0011\u0011\u0011N\u0001\u0004O\u0016$HCBA0\u0003\u001f\u000b\u0019\nC\u0004\u0002\u0012V\u0001\r!!\u001f\u0002\r=4gm]3u\u0011\u001d\t)*\u0006a\u0001\u0003s\nq\u0001^5nK>,H/A\ntW&\u0004h*Z4bi&4Xm\u00144gg\u0016$8\u000f\u0006\u0003\u0002`\u0005m\u0005bBAO-\u0001\u0007\u0011qL\u0001\u0007e\u0016\u001cwN\u001d3)\u0007Y\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9+T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAV\u0003K\u0013q\u0001^1jYJ,7-\u0001\u0003tK\u0016\\G\u0003BA5\u0003cCq!!%\u0018\u0001\u0004\tI(\u0001\u0003q_2dG\u0003BA5\u0003oCq!!&\u0019\u0001\u0004\tI(A\nDC\u000eDW\rZ&bM.\f7i\u001c8tk6,'\u000fE\u0002\u0002\u0006i\u00192AG&R)\t\tYL\u0001\u0005DC\u000eDWmS3z'\u0019a2*!2\u0002LB\u0019A*a2\n\u0007\u0005%WJA\u0004Qe>$Wo\u0019;\u0011\u00071\u000bi-C\u0002\u0002P6\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\u0002\"a5\u0002X\u0006e\u00171\u001c\t\u0004\u0003+dR\"\u0001\u000e\t\u000b]\u001b\u0003\u0019\u0001.\t\u000b\u0019\u001c\u0003\u0019\u0001.\t\u000b!\u001c\u0003\u0019\u00016\u0002\t\r|\u0007/\u001f\u000b\t\u0003'\f\t/a9\u0002f\"9q\u000b\nI\u0001\u0002\u0004Q\u0006b\u00024%!\u0003\u0005\rA\u0017\u0005\bQ\u0012\u0002\n\u00111\u0001k\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a;+\u0007i\u000bio\u000b\u0002\u0002pB!\u0011\u0011_A|\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006\u0015\u0016!C;oG\",7m[3e\u0013\u0011\tI0a=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0001\u0016\u0004U\u00065\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\bA\u0019\u0011P!\u0003\n\u0005\rT\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003/\u0011\t\u0002\u0003\u0005\u0002r)\n\t\u00111\u0001k\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\f!\u0019\u0011IBa\b\u0002\u00185\u0011!1\u0004\u0006\u0004\u0005;i\u0015AC2pY2,7\r^5p]&!\u0011Q\fB\u000e\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0013\u0005W\u00012\u0001\u0014B\u0014\u0013\r\u0011I#\u0014\u0002\b\u0005>|G.Z1o\u0011%\t\t\bLA\u0001\u0002\u0004\t9\"\u0001\u0005iCND7i\u001c3f)\u0005Q\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u001d\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0003&\te\u0002\"CA9_\u0005\u0005\t\u0019AA\f\u0003!\u0019\u0015m\u00195f\u0017\u0016L\bcAAkcM)\u0011G!\u0011\u0002LBI!1\tB%5jS\u00171[\u0007\u0003\u0005\u000bR1Aa\u0012N\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0013\u0003F\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\tu\u0012!B1qa2LH\u0003CAj\u0005'\u0012)Fa\u0016\t\u000b]#\u0004\u0019\u0001.\t\u000b\u0019$\u0004\u0019\u0001.\t\u000b!$\u0004\u0019\u00016\u0002\u000fUt\u0017\r\u001d9msR!!Q\fB5!\u0015a%q\fB2\u0013\r\u0011\t'\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r1\u0013)G\u0017.k\u0013\r\u00119'\u0014\u0002\u0007)V\u0004H.Z\u001a\t\u0013\t-T'!AA\u0002\u0005M\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005A\u0018!B2bG\",WC\u0001B;!\u001d\t(qOAj\u0005wJ1A!\u001fs\u00055a\u0015N\\6fI\"\u000b7\u000f['baB2!Q\u0010BA\u0005\u0013\u0003r!!\u0002\u0001\u0005\u007f\u00129\t\u0005\u0003\u0002\n\t\u0005Ea\u0003BBs\u0005\u0005\t\u0011!B\u0001\u0003\u001f\u00111a\u0018\u00132\u0003\u0019\u0019\u0017m\u00195fAA!\u0011\u0011\u0002BE\t-\u0011Y)OA\u0001\u0002\u0003\u0015\t!a\u0004\u0003\u0007}##'A\u0005dC\u000eDWm\u0018\u0013fcR!\u0011\u0011\u000eBI\u0011%\t\t\bOA\u0001\u0002\u0004\u0011\u0019\nE\u0004r\u0005o\n\u0019N!&1\r\t]%1\u0014BP!\u001d\t)\u0001\u0001BM\u0005;\u0003B!!\u0003\u0003\u001c\u0012a!1\u0011BI\u0003\u0003\u0005\tQ!\u0001\u0002\u0010A!\u0011\u0011\u0002BP\t1\u0011YI!%\u0002\u0002\u0003\u0005)\u0011AA\b\u0003\u0011Ig.\u001b;\u0015\u0011\u0005%$Q\u0015BU\u0005[CaAa*;\u0001\u0004Q\u0017aD5oSRL\u0017\r\\\"ba\u0006\u001c\u0017\u000e^=\t\r\t-&\b1\u0001k\u0003-i\u0017\r_\"ba\u0006\u001c\u0017\u000e^=\t\u000f\t=&\b1\u0001\u00032\u0006QAn\\1e\r\u0006\u001cGo\u001c:\u0011\u00071\u0013\u0019,C\u0002\u000366\u0013QA\u00127pCR,bA!/\u0003@\n\rGC\u0003B^\u0005\u000b\u00149M!3\u0003LB9\u0011Q\u0001\u0001\u0003>\n\u0005\u0007\u0003BA\u0005\u0005\u007f#q!!\u0004<\u0005\u0004\ty\u0001\u0005\u0003\u0002\n\t\rGaBA\u0011w\t\u0007\u0011q\u0002\u0005\u0006/n\u0002\rA\u0017\u0005\u0006Mn\u0002\rA\u0017\u0005\u0006Qn\u0002\rA\u001b\u0005\u0006]n\u0002\r\u0001]\u0001\fO\u0016$XK\\2bG\",G-\u0006\u0004\u0003R\n]'1\u001c\u000b\u000b\u0005'\u0014iNa8\u0003b\n\r\bcBA\u0003\u0001\tU'\u0011\u001c\t\u0005\u0003\u0013\u00119\u000eB\u0004\u0002\u000eq\u0012\r!a\u0004\u0011\t\u0005%!1\u001c\u0003\b\u0003Ca$\u0019AA\b\u0011\u00159F\b1\u0001[\u0011\u00151G\b1\u0001[\u0011\u0015AG\b1\u0001k\u0011\u0015qG\b1\u0001q\u0003\u0019\u0011X-\\8wKRA\u0011\u0011\u000eBu\u0005W\u0014i\u000fC\u0003X{\u0001\u0007!\fC\u0003g{\u0001\u0007!\fC\u0003i{\u0001\u0007!\u000e")
public class CachedKafkaConsumer<K, V>
implements Logging {
    private final String groupId;
    private final String topic;
    private final int partition;
    private final Map<String, Object> kafkaParams;
    private final TopicPartition topicPartition;
    private final KafkaConsumer<K, V> consumer;
    private java.util.Iterator<ConsumerRecord<K, V>> buffer;
    private long nextOffset;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void remove(String string, String string2, int n) {
        CachedKafkaConsumer$.MODULE$.remove(string, string2, n);
    }

    public static <K, V> CachedKafkaConsumer<K, V> getUncached(String string, String string2, int n, Map<String, Object> map) {
        return CachedKafkaConsumer$.MODULE$.getUncached(string, string2, n, map);
    }

    public static void init(int n, int n2, float f) {
        CachedKafkaConsumer$.MODULE$.init(n, n2, f);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaConsumer<K, V> consumer() {
        return this.consumer;
    }

    public java.util.Iterator<ConsumerRecord<K, V>> buffer() {
        return this.buffer;
    }

    public void buffer_$eq(java.util.Iterator<ConsumerRecord<K, V>> x$1) {
        this.buffer = x$1;
    }

    public long nextOffset() {
        return this.nextOffset;
    }

    public void nextOffset_$eq(long x$1) {
        this.nextOffset = x$1;
    }

    public void close() {
        this.consumer().close();
    }

    public ConsumerRecord<K, V> get(long offset, long timeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Get ").append(this.groupId()).append(" ").append(this.topic()).append(" ").append(this.partition()).append(" nextOffset ").append(this.nextOffset()).append(" requested ").append(offset).toString());
        if (offset != this.nextOffset()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Initial fetch for ").append(this.groupId()).append(" ").append(this.topic()).append(" ").append(this.partition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(timeout);
        }
        if (!this.buffer().hasNext()) {
            this.poll(timeout);
        }
        Predef$.MODULE$.assert(this.buffer().hasNext(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Failed to get records for ").append(this.groupId()).append(" ").append(this.topic()).append(" ").append(this.partition()).append(" ").append(offset).append(" after polling for ").append(timeout).toString());
        ConsumerRecord<K, V> record = this.buffer().next();
        this.nextOffset_$eq(offset + 1L);
        return this.skipNegativeOffsets(record);
    }

    private ConsumerRecord<K, V> skipNegativeOffsets(ConsumerRecord<K, V> record) {
        while (record.offset() == (long)KafkaUtils$.MODULE$.eofOffset()) {
            this.log().debug("EOF message is received");
            if (this.buffer().hasNext()) {
                record = this.buffer().next();
                continue;
            }
            return null;
        }
        return record;
    }

    private void seek(long offset) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Seeking to ").append(this.topicPartition()).append(" ").append(offset).toString());
        this.consumer().seek(this.topicPartition(), offset);
    }

    private void poll(long timeout) {
        ConsumerRecords p = this.consumer().poll(timeout);
        List r = p.records(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Polled ").append(p.partitions()).append("  ").append(r.size()).toString());
        this.buffer_$eq(r.iterator());
    }

    public CachedKafkaConsumer(String groupId, String topic, int partition, Map<String, Object> kafkaParams) {
        this.groupId = groupId;
        this.topic = topic;
        this.partition = partition;
        this.kafkaParams = kafkaParams;
        Logging.$init$((Logging)this);
        String string = groupId;
        Object object = kafkaParams.get("group.id");
        Predef$.MODULE$.assert(!(string != null ? !string.equals(object) : object != null), (Function0 & Serializable & scala.Serializable)() -> "groupId used for cache key must match the groupId in kafkaParams");
        this.topicPartition = new TopicPartition(topic, partition);
        KafkaConsumer c = new KafkaConsumer(kafkaParams);
        ArrayList<TopicPartition> tps = new ArrayList<TopicPartition>();
        tps.add(this.topicPartition());
        c.assign(tps);
        this.consumer = c;
        this.buffer = Collections.emptyList().iterator();
        this.nextOffset = -2L;
    }

    private static class CacheKey
    implements Product,
    scala.Serializable {
        private final String groupId;
        private final String topic;
        private final int partition;

        public String groupId() {
            return this.groupId;
        }

        public String topic() {
            return this.topic;
        }

        public int partition() {
            return this.partition;
        }

        public CacheKey copy(String groupId, String topic, int partition) {
            return new CacheKey(groupId, topic, partition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public String copy$default$2() {
            return this.topic();
        }

        public int copy$default$3() {
            return this.partition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.groupId();
                }
                case 1: {
                    return this.topic();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this.partition());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.groupId()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.topic()));
            n = Statics.mix((int)n, (int)this.partition());
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.topic();
            String string4 = cacheKey.topic();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.partition() != cacheKey.partition()) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, String topic, int partition) {
            this.groupId = groupId;
            this.topic = topic;
            this.partition = partition;
            Product.$init$((Product)this);
        }
    }
}

