/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.kafka010.package$;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t}h!B\u001b7\u0001i\u0002\u0005\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011M\u0004!\u0011!Q\u0001\nQD\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\tw\u0002\u0011\t\u0011)A\u0005y\"1q\u0010\u0001C\u0001\u0003\u0003A\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003#A\u0011\"!\u0012\u0001\u0001\u0004%\t\"a\u0012\t\u0013\u0005-\u0004\u00011A\u0005\u0012\u00055\u0004\u0002CA=\u0001\u0001\u0006K!!\u0013\t\u0013\u0005m\u0004\u00011A\u0005\n\u0005u\u0004\"CAC\u0001\u0001\u0007I\u0011BAD\u0011!\tY\t\u0001Q!\n\u0005}\u0004BB&\u0001\t\u0003\t)\nC\u0005\u0002\u0018\u0002\u0001\r\u0011\"\u0003\u0002~!I\u0011\u0011\u0014\u0001A\u0002\u0013%\u00111\u0014\u0005\t\u0003?\u0003\u0001\u0015)\u0003\u0002\u0000!9\u00111\u0015\u0001\u0005\u0002\u0005u\u0004bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003\u007f\u0003A\u0011CAa\u0011\u001d\t)\r\u0001C\t\u0003\u000fD\u0001\"!4\u0001\t\u0003B\u0014q\u001a\u0005\u000b\u0003#\u0004!\u0019!C)q\u0005M\u0007\u0002\u0003B\u000f\u0001\u0001\u0006I!!6\t\u0015\t}\u0001A1A\u0005Ra\u0012\t\u0003\u0003\u0005\u00036\u0001\u0001\u000b\u0011\u0002B\u0012\u0011!\u00119\u0004\u0001C\tq\te\u0002b\u0002B#\u0001\u0011%!q\t\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011\u001d\u00119\b\u0001C\t\u0005sBqAa\u001f\u0001\t#\u0011i\bC\u0004\u0003\u0002\u0002!\tEa!\t\u000f\tE\u0005\u0001\"\u0011\u0003\u001c!9!1\u0013\u0001\u0005B\tm\u0001\"\u0003BK\u0001\t\u0007I\u0011\u0003BL\u0011!\u0011Y\u000b\u0001Q\u0001\n\te\u0005\"\u0003BW\u0001\t\u0007I\u0011\u0003BX\u0011!\u0011\u0019\r\u0001Q\u0001\n\tE\u0006b\u0002Bc\u0001\u0011\u0005!q\u0019\u0005\b\u0005\u000b\u0004A\u0011\u0001Bh\u0011\u001d\u00119\u000e\u0001C\t\u000571q!!7\u0001\u0001a\nY\u000e\u0003\u0004\u0000U\u0011\u0005\u00111\u001d\u0005\b\u0003KTC\u0011AAt\u0011\u001d\u0011YA\u000bC!\u0005\u001bAqAa\u0005+\t\u0003\u0012)\u0002C\u0004\u0003\u001a)\"\tEa\u0007\u0007\u000f\te\u0007\u0001\u0001\u001d\u0003\\\"a!Q\u001c\u0019\u0003\u0002\u0003\u0006IA!\u0002\u0003`\"Q!1\u001d\u0019\u0003\u0002\u0003\u0006IA!:\t\r}\u0004D\u0011\u0001By\u0011\u001d\u0011I\u0010\rC!\u0005w\u0014q\u0003R5sK\u000e$8*\u00194lC&s\u0007/\u001e;E'R\u0014X-Y7\u000b\u0005]B\u0014\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005eR\u0014!C:ue\u0016\fW.\u001b8h\u0015\tYD(A\u0003ta\u0006\u00148N\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<WcA!UEN!\u0001A\u00113k!\r\u0019e\tS\u0007\u0002\t*\u0011Q\tO\u0001\bIN$(/Z1n\u0013\t9EI\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003J!J\u000bW\"\u0001&\u000b\u0005-c\u0015\u0001C2p]N,X.\u001a:\u000b\u00055s\u0015aB2mS\u0016tGo\u001d\u0006\u0003\u001fr\nQa[1gW\u0006L!!\u0015&\u0003\u001d\r{gn];nKJ\u0014VmY8sIB\u00111\u000b\u0016\u0007\u0001\t\u0015)\u0006A1\u0001X\u0005\u0005Y5\u0001A\t\u00031z\u0003\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013qAT8uQ&tw\r\u0005\u0002Z?&\u0011\u0001M\u0017\u0002\u0004\u0003:L\bCA*c\t\u0015\u0019\u0007A1\u0001X\u0005\u00051\u0006CA3i\u001b\u00051'BA4;\u0003!Ig\u000e^3s]\u0006d\u0017BA5g\u0005\u001daunZ4j]\u001e\u0004\"a\u001b7\u000e\u0003YJ!!\u001c\u001c\u0003!\r\u000bgnQ8n[&$xJ\u001a4tKR\u001c\u0018\u0001B0tg\u000e\u0004\"\u0001]9\u000e\u0003aJ!A\u001d\u001d\u0003!M#(/Z1nS:<7i\u001c8uKb$\u0018\u0001\u00057pG\u0006$\u0018n\u001c8TiJ\fG/Z4z!\tYW/\u0003\u0002wm\t\u0001Bj\\2bi&|gn\u0015;sCR,w-_\u0001\u0011G>t7/^7feN#(/\u0019;fOf\u0004Ba[=SC&\u0011!P\u000e\u0002\u0011\u0007>t7/^7feN#(/\u0019;fOf\f1\u0001\u001d9d!\tYW0\u0003\u0002\u007fm\t\u0011\u0002+\u001a:QCJ$\u0018\u000e^5p]\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}QQ\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0011\t-\u0004!+\u0019\u0005\u0006]\u0016\u0001\ra\u001c\u0005\u0006g\u0016\u0001\r\u0001\u001e\u0005\u0006o\u0016\u0001\r\u0001\u001f\u0005\u0006w\u0016\u0001\r\u0001`\u0001\u0014Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn]\u000b\u0003\u0003#\u0001\u0002\"a\u0005\u0002\u001e\u0005\u0005\u0012qG\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005!Q\u000f^5m\u0015\t\tY\"\u0001\u0003kCZ\f\u0017\u0002BA\u0010\u0003+\u0011q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002$\u0005Eb\u0002BA\u0013\u0003[\u00012!a\n[\u001b\t\tICC\u0002\u0002,Y\u000ba\u0001\u0010:p_Rt\u0014bAA\u00185\u00061\u0001K]3eK\u001aLA!a\r\u00026\t11\u000b\u001e:j]\u001eT1!a\f[!\u0011\tI$a\u0010\u000e\u0005\u0005m\"\u0002BA\u001f\u00033\tA\u0001\\1oO&!\u0011\u0011IA\u001e\u0005\u0019y%M[3di\u0006!R\r_3dkR|'oS1gW\u0006\u0004\u0016M]1ng\u0002\nabY;se\u0016tGo\u00144gg\u0016$8/\u0006\u0002\u0002JAA\u00111JA+\u00033\n)'\u0004\u0002\u0002N)!\u0011qJA)\u0003%IW.\\;uC\ndWMC\u0002\u0002Ti\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9&!\u0014\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyFT\u0001\u0007G>lWn\u001c8\n\t\u0005\r\u0014Q\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\rI\u0016qM\u0005\u0004\u0003SR&\u0001\u0002'p]\u001e\f!cY;se\u0016tGo\u00144gg\u0016$8o\u0018\u0013fcR!\u0011qNA;!\rI\u0016\u0011O\u0005\u0004\u0003gR&\u0001B+oSRD\u0011\"a\u001e\n\u0003\u0003\u0005\r!!\u0013\u0002\u0007a$\u0013'A\bdkJ\u0014XM\u001c;PM\u001a\u001cX\r^:!\u0003\tY7-\u0006\u0002\u0002\u0000A)\u0011*!!SC&\u0019\u00111\u0011&\u0003\u0011\r{gn];nKJ\faa[2`I\u0015\fH\u0003BA8\u0003\u0013C\u0011\"a\u001e\r\u0003\u0003\u0005\r!a \u0002\u0007-\u001c\u0007\u0005K\u0002\u000e\u0003\u001f\u00032!WAI\u0013\r\t\u0019J\u0017\u0002\niJ\fgn]5f]R$\"!a \u0002\u0005M\u001c\u0017AB:d?\u0012*\u0017\u000f\u0006\u0003\u0002p\u0005u\u0005\"CA<!\u0005\u0005\t\u0019AA@\u0003\r\u00198\r\t\u0015\u0004#\u0005=\u0015aD:feZL7-Z\"p]N,X.\u001a:\u0002\u000fA,'o]5tiR!\u0011\u0011VAX!\u0011\u0019\u00151\u0016%\n\u0007\u00055FIA\u0004E'R\u0014X-Y7\t\u000f\u0005E6\u00031\u0001\u00024\u0006Aa.Z<MKZ,G\u000e\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tILO\u0001\bgR|'/Y4f\u0013\u0011\ti,a.\u0003\u0019M#xN]1hK2+g/\u001a7\u0002\u0015\u001d,GO\u0011:pW\u0016\u00148/\u0006\u0002\u0002DBA\u00111CA\u000f\u00033\n\t#A\thKR\u0004&/\u001a4feJ,G\rS8tiN,\"!!3\u0011\u0011\u0005M\u00111ZA-\u0003CIA!a\u0016\u0002\u0016\u0005!a.Y7f+\t\t\t#\u0001\bdQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0016\u0005\u0005U\u0007cAAlU5\t\u0001AA\u0013ESJ,7\r^&bM.\f\u0017J\u001c9vi\u0012\u001bFO]3b[\u000eCWmY6q_&tG\u000fR1uCN\u0019!&!8\u0011\t\r\u000by\u000eS\u0005\u0004\u0003C$%!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u000b\u0003\u0003+\fABY1uG\"4uN\u001d+j[\u0016,\"!!;\u0011\u0011\u0005-\u0018\u0011_Az\u0003sl!!!<\u000b\t\u0005=\u0018\u0011K\u0001\b[V$\u0018M\u00197f\u0013\u0011\ty\"!<\u0011\u0007A\f)0C\u0002\u0002xb\u0012A\u0001V5nKB)\u0011,a?\u0002\u0000&\u0019\u0011Q .\u0003\u000b\u0005\u0013(/Y=\u0011\u0017e\u0013\t!!\t\u0003\u0006\u0005\u0015\u0014QM\u0005\u0004\u0005\u0007Q&A\u0002+va2,G\u0007E\u0002Z\u0005\u000fI1A!\u0003[\u0005\rIe\u000e^\u0001\u0007kB$\u0017\r^3\u0015\t\u0005=$q\u0002\u0005\b\u0005#i\u0003\u0019AAz\u0003\u0011!\u0018.\\3\u0002\u000f\rdW-\u00198vaR!\u0011q\u000eB\f\u0011\u001d\u0011\tB\fa\u0001\u0003g\fqA]3ti>\u0014X\r\u0006\u0002\u0002p\u0005y1\r[3dWB|\u0017N\u001c;ECR\f\u0007%\u0001\bsCR,7i\u001c8ue>dG.\u001a:\u0016\u0005\t\r\u0002#B-\u0003&\t%\u0012b\u0001B\u00145\n1q\n\u001d;j_:\u0004BAa\u000b\u000325\u0011!Q\u0006\u0006\u0004\u0005_A\u0014!C:dQ\u0016$W\u000f\\3s\u0013\u0011\u0011\u0019D!\f\u0003\u001dI\u000bG/Z\"p]R\u0014x\u000e\u001c7fe\u0006y!/\u0019;f\u0007>tGO]8mY\u0016\u0014\b%A\fnCblUm]:bO\u0016\u001c\b+\u001a:QCJ$\u0018\u000e^5p]R!!1\bB!!\u0015I&Q\u0005B\u001f!!\t\u0019Ca\u0010\u0002Z\u0005\u0015\u0014\u0002BA,\u0003kAqAa\u0011\u001c\u0001\u0004\u0011i$A\u0004pM\u001a\u001cX\r^:\u0002\u0019A\f'/\u00198pS\u0012\u0004v\u000e\u001c7\u0015\t\u0005=$\u0011\n\u0005\b\u0005\u0017b\u0002\u0019AA@\u0003\u0005\u0019\u0017aC<ji\"\u0014V\r\u001e:jKN,BA!\u0015\u0003XQ!!1\u000bB3)\u0011\u0011)Fa\u0017\u0011\u0007M\u00139\u0006\u0002\u0004\u0003Zu\u0011\ra\u0016\u0002\u0002)\"A!QL\u000f\u0005\u0002\u0004\u0011y&A\u0001g!\u0015I&\u0011\rB+\u0013\r\u0011\u0019G\u0017\u0002\ty\tLh.Y7f}!9!qM\u000fA\u0002\u0005\u0015\u0014!\u0001;)\u0007u\u0011Y\u0007\u0005\u0003\u0003n\tMTB\u0001B8\u0015\r\u0011\tHW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B;\u0005_\u0012q\u0001^1jYJ,7-A\u0007mCR,7\u000f^(gMN,Go\u001d\u000b\u0003\u0005{\tQa\u00197b[B$BA!\u0010\u0003\u0000!9!1I\u0010A\u0002\tu\u0012aB2p[B,H/\u001a\u000b\u0005\u0005\u000b\u0013i\tE\u0003Z\u0005K\u00119\tE\u0003l\u0005\u0013\u0013\u0016-C\u0002\u0003\fZ\u0012\u0001bS1gW\u0006\u0014F\t\u0012\u0005\b\u0005\u001f\u0003\u0003\u0019AAz\u0003%1\u0018\r\\5e)&lW-A\u0003ti\u0006\u0014H/\u0001\u0003ti>\u0004\u0018aC2p[6LG/U;fk\u0016,\"A!'\u0011\r\tm%\u0011\u0015BS\u001b\t\u0011iJ\u0003\u0003\u0003 \u0006U\u0011AC2p]\u000e,(O]3oi&!!1\u0015BO\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\u00042a\u001bBT\u0013\r\u0011IK\u000e\u0002\f\u001f\u001a47/\u001a;SC:<W-\u0001\u0007d_6l\u0017\u000e^)vKV,\u0007%\u0001\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0016\u0005\tE\u0006C\u0002BZ\u0005s\u0013i,\u0004\u0002\u00036*!!q\u0017BO\u0003\u0019\tGo\\7jG&!!1\u0018B[\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007cA%\u0003@&\u0019!\u0011\u0019&\u0003)=3gm]3u\u0007>lW.\u001b;DC2d'-Y2l\u0003=\u0019w.\\7ji\u000e\u000bG\u000e\u001c2bG.\u0004\u0013aC2p[6LG/Q:z]\u000e$B!a\u001c\u0003J\"9!1Z\u0014A\u0002\t5\u0017\u0001D8gMN,GOU1oO\u0016\u001c\b#B-\u0002|\n\u0015FCBA8\u0005#\u0014\u0019\u000eC\u0004\u0003L\"\u0002\rA!4\t\u000f\tU\u0007\u00061\u0001\u0003>\u0006A1-\u00197mE\u0006\u001c7.A\u0005d_6l\u0017\u000e^!mY\nIB)\u001b:fGR\\\u0015MZ6b%\u0006$XmQ8oiJ|G\u000e\\3s'\r\u0001$\u0011F\u0001\u0003S\u0012LAA!9\u00032\u0005I1\u000f\u001e:fC6,\u0016\nR\u0001\nKN$\u0018.\\1u_J\u0004BAa:\u0003n6\u0011!\u0011\u001e\u0006\u0005\u0005W\u0014i#\u0001\u0003sCR,\u0017\u0002\u0002Bx\u0005S\u0014QBU1uK\u0016\u001bH/[7bi>\u0014HC\u0002Bz\u0005k\u00149\u0010E\u0002\u0002XBBqA!84\u0001\u0004\u0011)\u0001C\u0004\u0003dN\u0002\rA!:\u0002\u000fA,(\r\\5tQR!\u0011q\u000eB\u007f\u0011\u001d\u0011Y\u000f\u000ea\u0001\u0003K\u0002")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final PerPartitionConfig ppc;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private transient Consumer<K, V> sc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        block0: {
            if (this.kc() != null) break block0;
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.unboxToLong((Object)l)).toMap(Predef$.MODULE$.$conforms())).asJava()));
        }
        return this.kc();
    }

    private Consumer<K, V> sc() {
        return this.sc;
    }

    private void sc_$eq(Consumer<K, V> x$1) {
        this.sc = x$1;
    }

    public synchronized Consumer<K, V> serviceConsumer() {
        block0: {
            if (this.sc() != null) break block0;
            this.sc_$eq(this.consumerStrategy.serviceConsumer());
        }
        return this.sc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        java.util.Map<Object, String> map;
        LocationStrategy locationStrategy = this.locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy)) {
            map = this.getBrokers();
        } else if (PreferConsistent$.MODULE$.equals(locationStrategy)) {
            map = Collections.emptyMap();
        } else if (locationStrategy instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy;
            java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            map = hostMap;
        } else {
            throw new MatchError((Object)locationStrategy);
        }
        return map;
    }

    public String name() {
        return new StringBuilder(27).append("Kafka 0.10 direct stream [").append(this.id()).append("]").toString();
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        None$ none$;
        scala.collection.immutable.Map map;
        Option estimatedRateLimit = this.rateController().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getLatestRate()));
        Option option = estimatedRateLimit.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0L);
        if (option instanceof Some) {
            Some some = (Some)option;
            long rate = BoxesRunTime.unboxToLong((Object)some.value());
            scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)), 0L)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            map = (scala.collection.immutable.Map)lagPerPartition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long lag = tuple2._2$mcJ$sp();
                long maxRateLimitPerPartition = $this.ppc.maxRatePerPartition(tp);
                int backpressureRate = Math.round((float)((double)lag / (double)totalLag) * (float)rate);
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToLong((long)Math.min((long)backpressureRate, maxRateLimitPerPartition)) : BoxesRunTime.boxToLong((long)backpressureRate)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            map = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)$this.ppc.maxRatePerPartition(tp)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
        if (BoxesRunTime.unboxToLong((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L) {
            double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
            none$ = new Some(effectiveRateLimitPerPartition.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long limit = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)((long)(secsPerBatch * (double)limit))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void paranoidPoll(Consumer<K, V> c) {
        block1: {
            java.util.Set parts;
            ConsumerRecords msgs = c.poll(0L);
            java.util.Set newAssignment = c.assignment();
            java.util.Set set = parts = this.currentOffsets().size() < newAssignment.size() ? newAssignment : (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava();
            if (this.serviceConsumer().assignment().size() < parts.size()) {
                this.serviceConsumer().assign((Collection)parts);
            }
            if (msgs.isEmpty()) break block1;
            long waitingForAssigmentTimeout = SparkEnv$.MODULE$.get().conf().getLong("spark.mapr.WaitingForAssignmentTimeout", 600000L);
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, m) -> {
                TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> Math.min(o, m.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> m.offset()));
                return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
            })).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DirectKafkaInputDStream.$anonfun$paranoidPoll$4(this, waitingForAssigmentTimeout, c, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private <T> T withRetries(long t, Function0<T> f) {
        Object v;
        Try try_;
        block2: {
            while (true) {
                if ((try_ = Try$.MODULE$.apply(f)) instanceof Success) break block2;
                if (t <= 0L) break;
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(500L));
                t -= 500L;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Object object = v = success.value();
        return (T)object;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        scala.collection.mutable.Set parts;
        block3: {
            Consumer<K, V> c = this.consumer();
            this.paranoidPoll(c);
            parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
            if (parts.size() < this.currentOffsets().keySet().size()) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Assignment() returned fewer partitions than the previous call");
            }
            if (this.serviceConsumer().assignment().size() < parts.size()) {
                this.serviceConsumer().assign((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(parts).asJava());
            }
            scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
            scala.collection.immutable.Set revokedPartitions = (scala.collection.immutable.Set)this.currentOffsets().keySet().diff((GenSet)parts);
            if (revokedPartitions.nonEmpty()) {
                throw new IllegalStateException(new StringBuilder(300).append("Previously tracked partitions ").append(revokedPartitions.mkString("[", ",", "]")).append(" been revoked by Kafka because of consumer ").append("rebalance. This is mostly due to another stream with same group id joined, ").append("please check if there're different streaming application misconfigure to use same ").append("group id. Fundamentally different stream should use different group id").toString());
            }
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            c.pause((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(newPartitions).asJava());
            if (this.serviceConsumer().assignment().isEmpty()) break block3;
            this.serviceConsumer().seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        }
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1 & Serializable & scala.Serializable)mmp -> (scala.collection.immutable.Map)mmp.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long messages = tuple2._2$mcJ$sp();
            long uo = BoxesRunTime.unboxToLong((Object)offsets.apply((Object)tp));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)) + messages, uo)));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> offsets);
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long uo = tuple2._2$mcJ$sp();
            long fo = BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp));
            OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
            return offsetRange;
        }, Iterable$.MODULE$.canBuildFrom());
        boolean useConsumerCache = BoxesRunTime.unboxToBoolean((Object)this.context().conf().get(package$.MODULE$.CONSUMER_CACHE_ENABLED()));
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), useConsumerCache);
        String description = ((TraversableOnce)((TraversableLike)((TraversableOnce)offsetRanges.filter((Function1 & Serializable & scala.Serializable)offsetRange -> BoxesRunTime.boxToBoolean((boolean)DirectKafkaInputDStream.$anonfun$compute$2(offsetRange)))).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)DirectKafkaInputDStream.$anonfun$compute$3(x$3)), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)offsetRange -> new StringBuilder(41).append("topic: ").append(offsetRange.topic()).append("\tpartition: ").append(offsetRange.partition()).append("\t").append("offsets: ").append(offsetRange.fromOffset()).append(" to ").append(offsetRange.untilOffset()).append("\t").append("count: ").append(offsetRange.count()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer c = this.consumer();
        this.paranoidPoll(c);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
        this.serviceConsumer().close();
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        block3: {
            HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
            OffsetRange osr = this.commitQueue().poll();
            while (osr != null) {
                TopicPartition tp = osr.topicPartition();
                OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
                long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
                m.put(tp, new OffsetAndMetadata(offset));
                osr = this.commitQueue().poll();
            }
            if (m.isEmpty()) break block3;
            if (KafkaUtils$.MODULE$.isStreams(this.currentOffsets())) {
                this.serviceConsumer().commitAsync(m, this.commitCallback().get());
            } else {
                this.consumer().commitAsync(m, this.commitCallback().get());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$paranoidPoll$4(DirectKafkaInputDStream $this, long waitingForAssigmentTimeout$1, Consumer c$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long off = tuple2._2$mcJ$sp();
        $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("poll(0) returned messages, seeking ").append(tp).append(" to ").append(off).append(" to compensate").toString());
        $this.serviceConsumer().seek(tp, off);
        BoxedUnit boxedUnit = (BoxedUnit)$this.withRetries(waitingForAssigmentTimeout$1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c$1.seek(tp, off));
    }

    public static final /* synthetic */ boolean $anonfun$compute$2(OffsetRange offsetRange) {
        return offsetRange.fromOffset() != offsetRange.untilOffset();
    }

    public static final /* synthetic */ long $anonfun$compute$3(OffsetRange x$3) {
        return -x$3.count();
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.sc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Tuple4[] a = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toTuple(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class))))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                return this.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> (Time)x$5._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Time t = (Time)tuple2._1();
                Tuple4[] b = (Tuple4[])tuple2._2();
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Restoring KafkaRDD for time ").append(t).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).mkString("[", ", ", "]")).toString());
                scala.collection.mutable.HashMap hashMap = this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD(this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).map((Function1 & Serializable & scala.Serializable)x$6 -> OffsetRange$.MODULE$.apply((Tuple4<String, Object, Object, Object>)x$6), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                return hashMap;
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super((DStream)DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

