/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.websocket.common.frames;

import java.nio.ByteBuffer;
import org.sparkproject.jetty.websocket.api.extensions.Frame;

public class ReadOnlyDelegatedFrame
implements Frame {
    private final Frame delegate;

    public ReadOnlyDelegatedFrame(Frame frame) {
        this.delegate = frame;
    }

    @Override
    public byte[] getMask() {
        return this.delegate.getMask();
    }

    @Override
    public byte getOpCode() {
        return this.delegate.getOpCode();
    }

    @Override
    public ByteBuffer getPayload() {
        if (!this.delegate.hasPayload()) {
            return null;
        }
        return this.delegate.getPayload().asReadOnlyBuffer();
    }

    @Override
    public int getPayloadLength() {
        return this.delegate.getPayloadLength();
    }

    @Override
    public Frame.Type getType() {
        return this.delegate.getType();
    }

    @Override
    public boolean hasPayload() {
        return this.delegate.hasPayload();
    }

    @Override
    public boolean isFin() {
        return this.delegate.isFin();
    }

    @Override
    @Deprecated
    public boolean isLast() {
        return this.delegate.isLast();
    }

    @Override
    public boolean isMasked() {
        return this.delegate.isMasked();
    }

    @Override
    public boolean isRsv1() {
        return this.delegate.isRsv1();
    }

    @Override
    public boolean isRsv2() {
        return this.delegate.isRsv2();
    }

    @Override
    public boolean isRsv3() {
        return this.delegate.isRsv3();
    }
}

