/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.Twofish;
import org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.PBEScheme;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.SymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.WrapParameterSpec;

class ProvTwofish
extends SymmetricAlgorithmProvider {
    private static final String PREFIX = ProvTwofish.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(final Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            if (parameters.getAlgorithm().equals(Twofish.KW.getAlgorithm()) || parameters.getAlgorithm().equals(Twofish.KWP.getAlgorithm())) {
                return new ParametersCreator(){

                    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        if (algorithmParameterSpec instanceof WrapParameterSpec) {
                            return ((Twofish.WrapParameters)parameters).withUsingInverseFunction(((WrapParameterSpec)algorithmParameterSpec).useInverseFunction());
                        }
                        return parameters;
                    }
                };
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvTwofish() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        Twofish.AEADOperatorFactory aEADOperatorFactory = new Twofish.AEADOperatorFactory();
        Twofish.KeyWrapOperatorFactory keyWrapOperatorFactory = new Twofish.KeyWrapOperatorFactory();
        Twofish.OperatorFactory operatorFactory = new Twofish.OperatorFactory();
        Class[] classArray = GcmSpecUtil.getCipherSpecClasses();
        Class[] classArray2 = new Class[]{IvParameterSpec.class};
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.TWOFISH", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Twofish.ECBwithPKCS7, Twofish.ECB, Twofish.ECBwithISO10126_2, Twofish.ECBwithISO7816_4, Twofish.ECBwithTBC, Twofish.ECBwithX923, Twofish.CBC, Twofish.CBCwithPKCS7, Twofish.CBCwithISO10126_2, Twofish.CBCwithISO7816_4, Twofish.CBCwithTBC, Twofish.CBCwithX923, Twofish.CBCwithCS1, Twofish.CBCwithCS2, Twofish.CBCwithCS3, Twofish.CFB128, Twofish.CFB8, Twofish.OFB, Twofish.OpenPGPCFB, Twofish.CTR, Twofish.GCM, Twofish.CCM, Twofish.OCB, Twofish.EAX).withGeneralOperators(ProvTwofish.this.generalParametersCreatorProvider, operatorFactory, aEADOperatorFactory).withParameters(classArray).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.TWOFISH", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Twofish", 128, false, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Twofish.KeyGenerator(n, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.TWOFISH", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("Twofish");
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBESHA256WithTWOFISHCBC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Twofish.CBCwithPKCS7).withFixedKeySize(256).withScheme(PBEScheme.PKCS12).withGeneralOperators(ProvTwofish.this.generalParametersCreatorProvider, operatorFactory, null).withParameters(new Class[]{PBEParameterSpec.class}).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.TWOFISHGMAC", PREFIX + "$GMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(Twofish.GMAC, (MACOperatorFactory)new Twofish.MACOperatorFactory(), new AuthParametersCreator(Twofish.GMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "TWOFISHGMAC", "TWOFISH-GMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.TWOFISHCMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(Twofish.CMAC, (MACOperatorFactory)new Twofish.MACOperatorFactory(), new AuthParametersCreator(Twofish.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "TWOFISHCMAC", "TWOFISH-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.TWOFISHCCMMAC", PREFIX + "$TWOFISHCCMMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(Twofish.CCM, (MACOperatorFactory)new Twofish.MACOperatorFactory(), new AuthParametersCreator((AuthenticationParametersWithIV)Twofish.CCM.withMACSize(128)));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "TWOFISHCCMMAC", "TWOFISH-CCMMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.TWOFISHKW", PREFIX + "$Wrap", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Twofish.KW).withGeneralOperators(ProvTwofish.this.generalParametersCreatorProvider, keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "TWOFISHKW", "TWOFISHWRAP");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.TWOFISHKWP", PREFIX + "$WrapWithPad", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Twofish.KWP).withGeneralOperators(ProvTwofish.this.generalParametersCreatorProvider, keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "TWOFISHKWP", "TWOFISHWRAPPAD");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.TWOFISH", PREFIX + "$TWOFISHKFACT", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("Twofish", Twofish.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    @Override
                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n < 64 || n > 256) {
                            throw new InvalidKeySpecException("Twofish key must be of length 64-256 bits");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAAND256BITTWOFISH-BC", PREFIX + "PBE128TWOFISH", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ProvPKCS12.KeyFactory("Twofish", PasswordBasedDeriver.KeyType.CIPHER, 256);
            }
        }));
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "PBEWITHSHAAND256BITTWOFISH-BC", "PBEWITHSHA1AND256BITTWOFISH-BC", "PBEWITHSHA-1AND256BITTWOFISH-BC", "PBEWITHSHAANDTWOFISH");
    }
}

