/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.AsymmetricOperatorFactory;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.KeyWrapOperatorFactory;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.SignatureWithMessageRecoveryOperatorFactory;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEncapsulatedSecretExtractor;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.RSA;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.internal.asn1.cms.GenericHybridParameters;
import org.bouncycastle.internal.asn1.cms.RsaKemParameters;
import org.bouncycastle.jcajce.AgreedKeyWithMacKey;
import org.bouncycastle.jcajce.KTSKeyWithEncapsulation;
import org.bouncycastle.jcajce.ZeroizableSecretKey;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BaseSingleBlockCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DigestUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyIvSizeProvider;
import org.bouncycastle.jcajce.provider.KtsCipherSpi;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvRSAPrivateCrtKey;
import org.bouncycastle.jcajce.provider.ProvRSAPrivateKey;
import org.bouncycastle.jcajce.provider.ProvRSAPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.provider.X509AlgorithmParameters;
import org.bouncycastle.jcajce.spec.KTSExtractKeySpec;
import org.bouncycastle.jcajce.spec.KTSGenerateKeySpec;
import org.bouncycastle.jcajce.spec.KTSKeySpec;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.jcajce.spec.KTSWithKEMKWSKeySpec;
import org.bouncycastle.jcajce.util.MessageDigestUtils;
import org.bouncycastle.util.Arrays;

class ProvRSA
extends AsymmetricAlgorithmProvider {
    private static final KeyIvSizeProvider keySizeProvider = new KeyIvSizeProvider();
    private final SignatureOperatorFactory fipsRsaSigFactory = new FipsRSA.SignatureOperatorFactory();
    private SignatureOperatorFactory generalRsaSigFactory = this.getGeneralSigFactory();
    private SignatureWithMessageRecoveryOperatorFactory recoveryRsaSigFactory = this.getRecoverySigFactory();
    private AsymmetricOperatorFactory singleBlockFactory;
    private KeyWrapOperatorFactory generalKeyWrapFactory;
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.rsa.";
    private final FipsAlgorithm[] fipsAlgorithms = new FipsAlgorithm[]{FipsRSA.WRAP_PKCS1v1_5.getAlgorithm(), FipsRSA.WRAP_OAEP.getAlgorithm()};
    private final GeneralAlgorithm[] generalAlgorithms = new GeneralAlgorithm[]{RSA.ALGORITHM, (GeneralAlgorithm)RSA.WRAP_PKCS1v1_5.getAlgorithm(), (GeneralAlgorithm)RSA.WRAP_OAEP.getAlgorithm()};
    private static final PublicKeyConverter<AsymmetricRSAPublicKey> publicKeyConverter = new PublicKeyConverter<AsymmetricRSAPublicKey>(){

        @Override
        public AsymmetricRSAPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
            if (publicKey instanceof RSAPublicKey) {
                if (publicKey instanceof ProvRSAPublicKey) {
                    return ((ProvRSAPublicKey)publicKey).getBaseKey();
                }
                return new ProvRSAPublicKey(algorithm, (RSAPublicKey)publicKey).getBaseKey();
            }
            try {
                return new AsymmetricRSAPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify RSA public key: " + exception.getMessage(), exception);
            }
        }
    };
    private static final PrivateKeyConverter<AsymmetricRSAPrivateKey> privateKeyConverter = new PrivateKeyConverter<AsymmetricRSAPrivateKey>(){

        @Override
        public AsymmetricRSAPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
            if (privateKey instanceof RSAPrivateCrtKey) {
                if (privateKey instanceof ProvRSAPrivateCrtKey) {
                    return ((ProvRSAPrivateCrtKey)privateKey).getBaseKey();
                }
                return new ProvRSAPrivateCrtKey(algorithm, (RSAPrivateCrtKey)privateKey).getBaseKey();
            }
            if (privateKey instanceof RSAPrivateKey) {
                if (privateKey instanceof ProvRSAPrivateKey) {
                    return ((ProvRSAPrivateKey)privateKey).getBaseKey();
                }
                return new ProvRSAPrivateKey(algorithm, (RSAPrivateKey)privateKey).getBaseKey();
            }
            try {
                return new AsymmetricRSAPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot identify RSA private key: " + exception.getMessage(), exception);
            }
        }
    };
    private static final Map<ASN1ObjectIdentifier, FipsKDF.AgreementKDFPRF> kdfPRF = new HashMap<ASN1ObjectIdentifier, FipsKDF.AgreementKDFPRF>();
    private static final Map<ASN1ObjectIdentifier, String> wrapNames = new HashMap<ASN1ObjectIdentifier, String>();
    private static final Map<String, String> generalRsaAttributes = new HashMap<String, String>();

    ProvRSA() {
    }

    private AsymmetricOperatorFactory getGeneralEncryptionFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.singleBlockFactory == null) {
            this.singleBlockFactory = new RSA.OperatorFactory();
        }
        return this.singleBlockFactory;
    }

    private KeyWrapOperatorFactory getGeneralWrappingFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.generalKeyWrapFactory == null) {
            this.generalKeyWrapFactory = new RSA.KeyWrapOperatorFactory();
        }
        return this.generalKeyWrapFactory;
    }

    private SignatureOperatorFactory getGeneralSigFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.generalRsaSigFactory == null) {
            this.generalRsaSigFactory = new RSA.SignatureOperatorFactory();
        }
        return this.generalRsaSigFactory;
    }

    private SignatureWithMessageRecoveryOperatorFactory getRecoverySigFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (this.recoveryRsaSigFactory == null) {
            this.recoveryRsaSigFactory = new RSA.SignatureWithMessageRecoveryOperatorFactory();
        }
        return this.recoveryRsaSigFactory;
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.OAEP", "org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi$OAEP", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new OAEPAlgorithmParameters();
            }
        });
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "OAEP", PKCSObjectIdentifiers.id_RSAES_OAEP);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi$PSS", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new PSSAlgorithmParameters();
            }
        });
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PSS", "RSAPSS", "RSA-PSS", "RSASSA-PSS");
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PSS", PKCSObjectIdentifiers.id_RSASSA_PSS);
        EngineCreator engineCreator = new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    return this.build(ProvRSA.this.fipsAlgorithms);
                }
                return this.build(ProvRSA.this.generalAlgorithms);
            }

            private BaseSingleBlockCipher build(Algorithm[] algorithmArray) {
                return new BaseSingleBlockCipher.Builder(bouncyCastleFipsProvider, algorithmArray).setWrapModeOnly(CryptoServicesRegistrar.isInApprovedOnlyMode()).withFipsOperators(null, new FipsRSA.KeyWrapOperatorFactory()).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(final Parameters parameters) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
                                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                                    if (parameters.getAlgorithm() == FipsRSA.WRAP_OAEP.getAlgorithm()) {
                                        return ProvRSA.createFipsOaepParameters((OAEPParameterSpec)algorithmParameterSpec);
                                    }
                                    return FipsRSA.WRAP_PKCS1v1_5;
                                }
                                if (parameters.getAlgorithm() == RSA.WRAP_OAEP.getAlgorithm()) {
                                    OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
                                    DigestAlgorithm digestAlgorithm = Utils.digestNameToAlgMap.get(oAEPParameterSpec.getDigestAlgorithm());
                                    MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
                                    DigestAlgorithm digestAlgorithm2 = Utils.digestNameToAlgMap.get(mGF1ParameterSpec.getDigestAlgorithm());
                                    return RSA.WRAP_OAEP.withDigest(digestAlgorithm).withMGFDigest(digestAlgorithm2).withEncodingParams(((PSource.PSpecified)oAEPParameterSpec.getPSource()).getValue());
                                }
                                if (parameters.getAlgorithm() == RSA.WRAP_PKCS1v1_5.getAlgorithm()) {
                                    return RSA.WRAP_PKCS1v1_5;
                                }
                                return RSA.RAW;
                            }
                        };
                    }
                }).build();
            }
        };
        GuardedEngineCreator guardedEngineCreator = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSingleBlockCipher.Builder(bouncyCastleFipsProvider, RSA.WRAP_PKCS1v1_5).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters parameters) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
                                return RSA.WRAP_PKCS1v1_5;
                            }
                        };
                    }
                }).build();
            }
        });
        GuardedEngineCreator guardedEngineCreator2 = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSingleBlockCipher.Builder(bouncyCastleFipsProvider, RSA.WRAP_PKCS1v1_5).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).setPrivateKeyOnly(true).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters parameters) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
                                return RSA.WRAP_PKCS1v1_5;
                            }
                        };
                    }
                }).build();
            }
        });
        GuardedEngineCreator guardedEngineCreator3 = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSingleBlockCipher.Builder(bouncyCastleFipsProvider, RSA.WRAP_PKCS1v1_5).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), ProvRSA.this.getGeneralWrappingFactory()).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).setPublicKeyOnly(true).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters parameters) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
                                return RSA.WRAP_PKCS1v1_5;
                            }
                        };
                    }
                }).build();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.RSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$NoPadding", engineCreator);
        bouncyCastleFipsProvider.addAttributes("Cipher.RSA", generalRsaAttributes);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", PKCSObjectIdentifiers.rsaEncryption, "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding", (EngineCreator)guardedEngineCreator);
            bouncyCastleFipsProvider.addAttributes("Cipher", PKCSObjectIdentifiers.rsaEncryption, generalRsaAttributes);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", X509ObjectIdentifiers.id_ea_rsa, "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding", (EngineCreator)guardedEngineCreator);
            bouncyCastleFipsProvider.addAttributes("Cipher", X509ObjectIdentifiers.id_ea_rsa, generalRsaAttributes);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.RSA/1/PKCS1PADDING", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding_PrivateOnly", guardedEngineCreator2);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.RSA/2/PKCS1PADDING", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$PKCS1v1_5Padding_PublicOnly", guardedEngineCreator3);
        }
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", PKCSObjectIdentifiers.id_RSAES_OAEP, "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi$OAEPPadding", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    return new BaseSingleBlockCipher.Builder(bouncyCastleFipsProvider, FipsRSA.WRAP_OAEP).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).setWrapModeOnly(true).withParameters(new Class[]{OAEPParameterSpec.class}).withFipsOperators(null, new FipsRSA.KeyWrapOperatorFactory()).withParametersCreatorProvider(new ParametersCreatorProvider(){

                        public ParametersCreator get(Parameters parameters) {
                            return new ParametersCreator(){

                                public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
                                    if (algorithmParameterSpec == null) {
                                        return FipsRSA.WRAP_OAEP;
                                    }
                                    return ProvRSA.createFipsOaepParameters((OAEPParameterSpec)algorithmParameterSpec);
                                }
                            };
                        }
                    }).build();
                }
                return new BaseSingleBlockCipher.Builder(bouncyCastleFipsProvider, RSA.WRAP_OAEP).withPublicKeyConverter(publicKeyConverter).withPrivateKeyConverter(privateKeyConverter).withParameters(new Class[]{OAEPParameterSpec.class}).withGeneralOperators(ProvRSA.this.getGeneralEncryptionFactory(), new RSA.KeyWrapOperatorFactory()).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(Parameters parameters) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                                if (algorithmParameterSpec == null) {
                                    return RSA.WRAP_OAEP;
                                }
                                if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
                                    throw new InvalidAlgorithmParameterException("OAEP can only accept OAEPParameterSpec");
                                }
                                OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
                                DigestAlgorithm digestAlgorithm = Utils.digestNameToAlgMap.get(oAEPParameterSpec.getDigestAlgorithm());
                                MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
                                DigestAlgorithm digestAlgorithm2 = Utils.digestNameToAlgMap.get(mGF1ParameterSpec.getDigestAlgorithm());
                                return RSA.WRAP_OAEP.withDigest(digestAlgorithm).withMGFDigest(digestAlgorithm2).withEncodingParams(((PSource.PSpecified)oAEPParameterSpec.getPSource()).getValue());
                            }
                        };
                    }
                }).build();
            }
        });
        bouncyCastleFipsProvider.addAttributes("Cipher", PKCSObjectIdentifiers.id_RSAES_OAEP, generalRsaAttributes);
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.RSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new RSAKeyFactory(ProvRSA.getAlgorithmType());
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.RSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyPairGenerator(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.RSASSA-PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactoryPSSSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new RSAKeyFactory(ProvRSA.getPssAlgorithmType());
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.RSASSA-PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorPSSSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyPairGenerator(bouncyCastleFipsProvider, "RSASSA-PSS");
            }
        });
        RSAKeyFactory rSAKeyFactory = new RSAKeyFactory(ProvRSA.getAlgorithmType());
        this.registerOid(bouncyCastleFipsProvider, PKCSObjectIdentifiers.rsaEncryption, "RSA", rSAKeyFactory);
        this.registerOid(bouncyCastleFipsProvider, X509ObjectIdentifiers.id_ea_rsa, "RSA", rSAKeyFactory);
        this.registerOid(bouncyCastleFipsProvider, PKCSObjectIdentifiers.id_RSAES_OAEP, "RSA", rSAKeyFactory);
        this.registerOid(bouncyCastleFipsProvider, PKCSObjectIdentifiers.id_RSASSA_PSS, "RSA", rSAKeyFactory);
        this.registerOid(bouncyCastleFipsProvider, PKCSObjectIdentifiers.id_rsa_KEM, "RSA", rSAKeyFactory);
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.RSA-KAS-KEM", "org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAKTSKEM", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KTSSKeyFactory(new ParametersCreator(){

                    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        InternalKtsSpec internalKtsSpec = (InternalKtsSpec)algorithmParameterSpec;
                        if (internalKtsSpec.parameterSpec != null) {
                            throw new InvalidAlgorithmParameterException("RSA-KAS-KEM does not accept an AlgorithmParameterSpec");
                        }
                        return FipsRSA.KTS_SVE;
                    }
                }, bouncyCastleFipsProvider, publicKeyConverter, privateKeyConverter);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.RSA-KTS-KEM-KWS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAKTSKEMKWS", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KEMKTSSKeyFactory(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.RSA-KTS-KEM-KWS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherRSAKTSKEM", new EngineCreator(){

            @Override
            public Object createInstance(Object object) throws NoSuchAlgorithmException {
                return new KtsCipherSpi(bouncyCastleFipsProvider, "RSA-KTS-KEM-KWS");
            }
        });
        bouncyCastleFipsProvider.addAttributes("Cipher.RSA-KTS-KEM-KWS", generalRsaAttributes);
        bouncyCastleFipsProvider.addAlias("Cipher", "RSA-KTS-KEM-KWS", PKCSObjectIdentifiers.id_rsa_KEM);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.RSA-KTS-KEM-KWS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgParamsRSAKTSKEM", new EngineCreator(){

            @Override
            public Object createInstance(Object object) throws NoSuchAlgorithmException {
                return new KtsAlgParams();
            }
        });
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "RSA-KTS-KEM-KWS", PKCSObjectIdentifiers.id_rsa_KEM);
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.RSA-KTS-OAEP", "org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAKTSOEAP", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KTSSKeyFactory(new ParametersCreator(){

                    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        InternalKtsSpec internalKtsSpec = (InternalKtsSpec)algorithmParameterSpec;
                        if (internalKtsSpec.parameterSpec == null) {
                            return FipsRSA.KTS_OAEP.withKeySizeInBits(internalKtsSpec.keySize).withMacKeySizeInBits(internalKtsSpec.macKeySize);
                        }
                        if (!(internalKtsSpec.parameterSpec instanceof OAEPParameterSpec)) {
                            throw new InvalidAlgorithmParameterException("KTS-OAEP can only accept OAEPParameterSpec");
                        }
                        OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)internalKtsSpec.parameterSpec;
                        return FipsRSA.KTS_OAEP.withOAEPParameters(ProvRSA.createFipsOaepParameters(oAEPParameterSpec)).withKeySizeInBits(internalKtsSpec.keySize).withMacKeySizeInBits(internalKtsSpec.macKeySize);
                    }
                }, bouncyCastleFipsProvider, publicKeyConverter, privateKeyConverter);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$PSSwithRSA", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.PSS, PSSParameterSpec.DEFAULT);
            }
        });
        bouncyCastleFipsProvider.addAttributes("Signature.PSS", generalRsaAttributes);
        bouncyCastleFipsProvider.addAlias("Signature", "PSS", PKCSObjectIdentifiers.id_RSASSA_PSS);
        bouncyCastleFipsProvider.addAlias("Signature", "PSS", "RSAPSS", "RSA-PSS", "RSASSA-PSS");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.NONEWITHRSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.SignatureSpi$NONEwithRSA", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.PKCS1v1_5.withDigestAlgorithm(null));
            }
        });
        bouncyCastleFipsProvider.addAttributes("Signature.NONEWITHRSA", generalRsaAttributes);
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.RAWRSA", "NONEWITHRSA");
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA1", FipsSHS.Algorithm.SHA1, new PSSParameterSpec("SHA-1", "MGF1", new MGF1ParameterSpec("SHA-1"), 20, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA224", FipsSHS.Algorithm.SHA224, new PSSParameterSpec("SHA-224", "MGF1", new MGF1ParameterSpec("SHA-224"), 28, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA256", FipsSHS.Algorithm.SHA256, new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA384", FipsSHS.Algorithm.SHA384, new PSSParameterSpec("SHA-384", "MGF1", new MGF1ParameterSpec("SHA-384"), 48, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA512", FipsSHS.Algorithm.SHA512, new PSSParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec("SHA-512"), 64, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224, new PSSParameterSpec("SHA-512(224)", "MGF1", new MGF1ParameterSpec("SHA-512(224)"), 28, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256, new PSSParameterSpec("SHA-512(256)", "MGF1", new MGF1ParameterSpec("SHA-512(256)"), 32, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA3-224", FipsSHS.Algorithm.SHA3_224, new PSSParameterSpec("SHA3-224", "MGF1", new MGF1ParameterSpec("SHA3-224"), 28, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA3-256", FipsSHS.Algorithm.SHA3_256, new PSSParameterSpec("SHA3-256", "MGF1", new MGF1ParameterSpec("SHA3-256"), 32, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA3-384", FipsSHS.Algorithm.SHA3_384, new PSSParameterSpec("SHA3-384", "MGF1", new MGF1ParameterSpec("SHA3-384"), 48, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHA3-512", FipsSHS.Algorithm.SHA3_512, new PSSParameterSpec("SHA3-512", "MGF1", new MGF1ParameterSpec("SHA3-512"), 64, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHAKE128", FipsSHS.Algorithm.SHAKE128, new PSSParameterSpec("SHAKE128", "SHAKE128", null, 32, 1));
        this.addPSSSignature(bouncyCastleFipsProvider, "SHAKE256", FipsSHS.Algorithm.SHAKE256, new PSSParameterSpec("SHAKE256", "SHAKE256", null, 64, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA1", FipsSHS.Algorithm.SHA1, new PSSParameterSpec("SHA-1", "SHAKE128", null, 20, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA224", FipsSHS.Algorithm.SHA224, new PSSParameterSpec("SHA-224", "SHAKE128", null, 28, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA256", FipsSHS.Algorithm.SHA256, new PSSParameterSpec("SHA-256", "SHAKE128", null, 32, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA384", FipsSHS.Algorithm.SHA384, new PSSParameterSpec("SHA-384", "SHAKE128", null, 48, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA512", FipsSHS.Algorithm.SHA512, new PSSParameterSpec("SHA-512", "SHAKE128", null, 64, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224, new PSSParameterSpec("SHA-512(224)", "SHAKE128", null, 28, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256, new PSSParameterSpec("SHA-512(256)", "SHAKE128", null, 32, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-224", FipsSHS.Algorithm.SHA3_224, new PSSParameterSpec("SHA3-224", "SHAKE128", null, 28, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-256", FipsSHS.Algorithm.SHA3_256, new PSSParameterSpec("SHA3-256", "SHAKE128", null, 32, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-384", FipsSHS.Algorithm.SHA3_384, new PSSParameterSpec("SHA3-384", "SHAKE128", null, 48, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-512", FipsSHS.Algorithm.SHA3_512, new PSSParameterSpec("SHA3-512", "SHAKE128", null, 64, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA1", FipsSHS.Algorithm.SHA1, new PSSParameterSpec("SHA-1", "SHAKE256", null, 20, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA224", FipsSHS.Algorithm.SHA224, new PSSParameterSpec("SHA-224", "SHAKE256", null, 28, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA256", FipsSHS.Algorithm.SHA256, new PSSParameterSpec("SHA-256", "SHAKE256", null, 32, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA384", FipsSHS.Algorithm.SHA384, new PSSParameterSpec("SHA-384", "SHAKE256", null, 48, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA512", FipsSHS.Algorithm.SHA512, new PSSParameterSpec("SHA-512", "SHAKE256", null, 64, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224, new PSSParameterSpec("SHA-512(224)", "SHAKE256", null, 28, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256, new PSSParameterSpec("SHA-512(256)", "SHAKE256", null, 32, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-224", FipsSHS.Algorithm.SHA3_224, new PSSParameterSpec("SHA3-224", "SHAKE256", null, 28, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-256", FipsSHS.Algorithm.SHA3_256, new PSSParameterSpec("SHA3-256", "SHAKE256", null, 32, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-384", FipsSHS.Algorithm.SHA3_384, new PSSParameterSpec("SHA3-384", "SHAKE256", null, 48, 1));
        this.addPSSShakeSignature(bouncyCastleFipsProvider, "SHA3-512", FipsSHS.Algorithm.SHA3_512, new PSSParameterSpec("SHA3-512", "SHAKE256", null, 64, 1));
        this.addX931Signature(bouncyCastleFipsProvider, "SHA1", FipsSHS.Algorithm.SHA1);
        this.addX931Signature(bouncyCastleFipsProvider, "SHA224", FipsSHS.Algorithm.SHA224);
        this.addX931Signature(bouncyCastleFipsProvider, "SHA256", FipsSHS.Algorithm.SHA256);
        this.addX931Signature(bouncyCastleFipsProvider, "SHA384", FipsSHS.Algorithm.SHA384);
        this.addX931Signature(bouncyCastleFipsProvider, "SHA512", FipsSHS.Algorithm.SHA512);
        this.addX931Signature(bouncyCastleFipsProvider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224);
        this.addX931Signature(bouncyCastleFipsProvider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addX931Signature(bouncyCastleFipsProvider, "RIPEMD128", SecureHash.Algorithm.RIPEMD128);
            this.addX931Signature(bouncyCastleFipsProvider, "RIPEMD160", SecureHash.Algorithm.RIPEMD160);
            this.addX931Signature(bouncyCastleFipsProvider, "WHIRLPOOL", SecureHash.Algorithm.WHIRLPOOL);
        }
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addIso9796Signature(bouncyCastleFipsProvider, "MD5", SecureHash.Algorithm.MD5);
            this.addIso9796Signature(bouncyCastleFipsProvider, "SHA1", FipsSHS.Algorithm.SHA1);
            this.addIso9796Signature(bouncyCastleFipsProvider, "SHA224", FipsSHS.Algorithm.SHA224);
            this.addIso9796Signature(bouncyCastleFipsProvider, "SHA256", FipsSHS.Algorithm.SHA256);
            this.addIso9796Signature(bouncyCastleFipsProvider, "SHA384", FipsSHS.Algorithm.SHA384);
            this.addIso9796Signature(bouncyCastleFipsProvider, "SHA512", FipsSHS.Algorithm.SHA512);
            this.addIso9796Signature(bouncyCastleFipsProvider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224);
            this.addIso9796Signature(bouncyCastleFipsProvider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256);
            this.addIso9796Signature(bouncyCastleFipsProvider, "RIPEMD128", SecureHash.Algorithm.RIPEMD128);
            this.addIso9796Signature(bouncyCastleFipsProvider, "RIPEMD160", SecureHash.Algorithm.RIPEMD160);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "SHA1", FipsSHS.Algorithm.SHA1);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "SHA224", FipsSHS.Algorithm.SHA224);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "SHA256", FipsSHS.Algorithm.SHA256);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "SHA384", FipsSHS.Algorithm.SHA384);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "SHA512", FipsSHS.Algorithm.SHA512);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "SHA512(224)", FipsSHS.Algorithm.SHA512_224);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "SHA512(256)", FipsSHS.Algorithm.SHA512_256);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "RIPEMD128", SecureHash.Algorithm.RIPEMD128);
            this.addIso9796PSSSignature(bouncyCastleFipsProvider, "RIPEMD160", SecureHash.Algorithm.RIPEMD160);
        }
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA1), "SHA1", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA1", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHRSA", OIWObjectIdentifiers.sha1WithRSA);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA224), "SHA224", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA224", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA256), "SHA256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA256", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA384), "SHA384", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA384", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA512), "SHA512", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224), "SHA512(224)", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512_224", PKCSObjectIdentifiers.sha512_224WithRSAEncryption);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256), "SHA512(256)", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA512_256", PKCSObjectIdentifiers.sha512_256WithRSAEncryption);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_224), "SHA3-224", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_224", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_256), "SHA3-256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_256", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_384), "SHA3-384", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_384", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
        this.addDigestSignature(bouncyCastleFipsProvider, FipsRSA.PKCS1v1_5.withDigestAlgorithm(FipsSHS.Algorithm.SHA3_512), "SHA3-512", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$SHA3_512", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addDigestSignature(bouncyCastleFipsProvider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.MD5), "MD5", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$MD5", PKCSObjectIdentifiers.md5WithRSAEncryption);
            bouncyCastleFipsProvider.addAlias("Signature", "MD5WITHRSA", OIWObjectIdentifiers.md5WithRSA);
            this.addDigestSignature(bouncyCastleFipsProvider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD128), "RIPEMD128", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD128", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
            this.addDigestSignature(bouncyCastleFipsProvider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD128), "RMD128", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD128", null);
            this.addDigestSignature(bouncyCastleFipsProvider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD160), "RIPEMD160", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD160", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
            this.addDigestSignature(bouncyCastleFipsProvider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD160), "RMD160", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD160", null);
            this.addDigestSignature(bouncyCastleFipsProvider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD256), "RIPEMD256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD256", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
            this.addDigestSignature(bouncyCastleFipsProvider, RSA.PKCS1v1_5.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD256), "RMD256", "org.bouncycastle.jcajce.provider.asymmetric.rsa.DigestSignatureSpi$RIPEMD256", null);
        }
    }

    private void addPSSSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, Algorithm algorithm, PSSParameterSpec pSSParameterSpec) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string + "WITHRSA/PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$" + string, new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.PSS.withDigestAlgorithm((FipsDigestAlgorithm)algorithm), pSSParameterSpec);
            }
        });
        bouncyCastleFipsProvider.addAttributes("Signature." + string + "WITHRSA/PSS", generalRsaAttributes);
        if (string.startsWith("SHAKE")) {
            bouncyCastleFipsProvider.addAlias("Signature", string + "WITHRSA/PSS", string + "WITHRSASSA-PSS");
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PSS", string + "WITHRSA/PSS", string + "WITHRSASSA-PSS");
        } else {
            bouncyCastleFipsProvider.addAlias("Signature", string + "WITHRSA/PSS", string + "WITHRSAANDMGF1", string + "WITHRSASSA-PSS");
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PSS", string + "WITHRSA/PSS", string + "WITHRSAANDMGF1", string + "WITHRSASSA-PSS");
        }
    }

    private void addPSSShakeSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, Algorithm algorithm, PSSParameterSpec pSSParameterSpec) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string + "WITHRSAAND" + pSSParameterSpec.getMGFAlgorithm(), "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$" + string + pSSParameterSpec.getMGFAlgorithm(), new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.PSS.withDigestAlgorithm((FipsDigestAlgorithm)algorithm).withMGFDigest(pSSParameterSpec.getMGFAlgorithm().equals("SHAKE128") ? FipsSHS.Algorithm.SHAKE128 : FipsSHS.Algorithm.SHAKE256), pSSParameterSpec);
            }
        });
        bouncyCastleFipsProvider.addAttributes("Signature." + string + "WITHRSAAND" + pSSParameterSpec.getMGFAlgorithm(), generalRsaAttributes);
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "PSS", string + "WITHRSAAND" + pSSParameterSpec.getMGFAlgorithm());
    }

    private void addX931Signature(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm instanceof FipsAlgorithm) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string + "WITHRSA/X9.31", "org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$" + string, new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.fipsRsaSigFactory, publicKeyConverter, privateKeyConverter, FipsRSA.X931.withDigestAlgorithm((FipsDigestAlgorithm)digestAlgorithm));
                }
            });
        } else {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string + "WITHRSA/X9.31", "org.bouncycastle.jcajce.provider.asymmetric.rsa.X931SignatureSpi$" + string, new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.generalRsaSigFactory, publicKeyConverter, privateKeyConverter, new RSA.X931SignatureParameters(digestAlgorithm));
                }
            }));
        }
        bouncyCastleFipsProvider.addAttributes("Signature." + string + "WITHRSA/X9.31", generalRsaAttributes);
    }

    private void addIso9796Signature(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, DigestAlgorithm digestAlgorithm) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string + "WITHRSA/ISO9796-2", "org.bouncycastle.jcajce.provider.asymmetric.rsa.ISO9796-2SignatureSpi$" + string, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.recoveryRsaSigFactory, publicKeyConverter, privateKeyConverter, RSA.ISO9796d2.withDigestAlgorithm(digestAlgorithm));
            }
        }));
        bouncyCastleFipsProvider.addAttributes("Signature." + string + "WITHRSA/ISO9796-2", generalRsaAttributes);
    }

    private void addIso9796PSSSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, DigestAlgorithm digestAlgorithm) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string + "WITHRSA/ISO9796-2PSS", "org.bouncycastle.jcajce.provider.asymmetric.rsa.ISO9796-2PSSSignatureSpi$" + string, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.recoveryRsaSigFactory, publicKeyConverter, privateKeyConverter, RSA.ISO9796d2PSS.withDigestAlgorithm(digestAlgorithm));
            }
        }));
        bouncyCastleFipsProvider.addAttributes("Signature." + string + "WITHRSA/ISO9796-2PSS", generalRsaAttributes);
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature." + string + "WITHRSAANDMGF1/ISO9796-2", string + "WITHRSA/ISO9796-2PSS");
    }

    private void addDigestSignature(BouncyCastleFipsProvider bouncyCastleFipsProvider, Parameters parameters, String string, String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string3 = string + "WITHRSA";
        String string4 = string + "/RSA";
        String string5 = string + "WITHRSAENCRYPTION";
        if (parameters instanceof FipsParameters) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string3, string2, new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, new AdaptiveSignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, parameters);
                }
            });
        } else {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string3, string2, new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvRSA.this.getGeneralSigFactory(), publicKeyConverter, privateKeyConverter, parameters);
                }
            }));
        }
        bouncyCastleFipsProvider.addAttributes("Signature." + string3, generalRsaAttributes);
        bouncyCastleFipsProvider.addAlias("Signature", string3, string4, string5);
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("Signature", string3, aSN1ObjectIdentifier);
        }
    }

    private static FipsRSA.OAEPParameters createFipsOaepParameters(OAEPParameterSpec oAEPParameterSpec) {
        OAEPParameterSpec oAEPParameterSpec2 = oAEPParameterSpec;
        FipsDigestAlgorithm fipsDigestAlgorithm = (FipsDigestAlgorithm)Utils.digestNameToAlgMap.get(oAEPParameterSpec2.getDigestAlgorithm());
        MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec2.getMGFParameters();
        FipsDigestAlgorithm fipsDigestAlgorithm2 = (FipsDigestAlgorithm)Utils.digestNameToAlgMap.get(mGF1ParameterSpec.getDigestAlgorithm());
        return FipsRSA.WRAP_OAEP.withDigest(fipsDigestAlgorithm).withMGFDigest(fipsDigestAlgorithm2).withEncodingParams(((PSource.PSpecified)oAEPParameterSpec2.getPSource()).getValue());
    }

    private static Algorithm getAlgorithmType() {
        return CryptoServicesRegistrar.isInApprovedOnlyMode() ? FipsRSA.ALGORITHM : RSA.ALGORITHM;
    }

    private static Algorithm getPssAlgorithmType() {
        return CryptoServicesRegistrar.isInApprovedOnlyMode() ? FipsRSA.PSS.getAlgorithm() : RSA.PSS.getAlgorithm();
    }

    private static String getMGFName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (PKCSObjectIdentifiers.id_mgf1.equals(aSN1ObjectIdentifier)) {
            return "MGF1";
        }
        if (NISTObjectIdentifiers.id_shake128.equals(aSN1ObjectIdentifier)) {
            return "SHAKE128";
        }
        if (NISTObjectIdentifiers.id_shake256.equals(aSN1ObjectIdentifier)) {
            return "SHAKE256";
        }
        return aSN1ObjectIdentifier.getId();
    }

    static {
        kdfPRF.put(OIWObjectIdentifiers.idSHA1, FipsKDF.AgreementKDFPRF.SHA1);
        kdfPRF.put(NISTObjectIdentifiers.id_sha224, FipsKDF.AgreementKDFPRF.SHA224);
        kdfPRF.put(NISTObjectIdentifiers.id_sha256, FipsKDF.AgreementKDFPRF.SHA256);
        kdfPRF.put(NISTObjectIdentifiers.id_sha384, FipsKDF.AgreementKDFPRF.SHA384);
        kdfPRF.put(NISTObjectIdentifiers.id_sha512, FipsKDF.AgreementKDFPRF.SHA512);
        kdfPRF.put(NISTObjectIdentifiers.id_sha512_224, FipsKDF.AgreementKDFPRF.SHA512_224);
        kdfPRF.put(NISTObjectIdentifiers.id_sha512_256, FipsKDF.AgreementKDFPRF.SHA512_256);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_224, FipsKDF.AgreementKDFPRF.SHA3_224);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_256, FipsKDF.AgreementKDFPRF.SHA3_256);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_384, FipsKDF.AgreementKDFPRF.SHA3_384);
        kdfPRF.put(NISTObjectIdentifiers.id_sha3_512, FipsKDF.AgreementKDFPRF.SHA3_512);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA1, FipsKDF.AgreementKDFPRF.SHA1_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA224, FipsKDF.AgreementKDFPRF.SHA224_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA256, FipsKDF.AgreementKDFPRF.SHA256_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA384, FipsKDF.AgreementKDFPRF.SHA384_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA512, FipsKDF.AgreementKDFPRF.SHA512_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA512_224, FipsKDF.AgreementKDFPRF.SHA512_224_HMAC);
        kdfPRF.put(PKCSObjectIdentifiers.id_hmacWithSHA512_256, FipsKDF.AgreementKDFPRF.SHA512_256_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, FipsKDF.AgreementKDFPRF.SHA3_224_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, FipsKDF.AgreementKDFPRF.SHA3_256_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, FipsKDF.AgreementKDFPRF.SHA3_384_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, FipsKDF.AgreementKDFPRF.SHA3_512_HMAC);
        kdfPRF.put(NISTObjectIdentifiers.id_KmacWithSHAKE128, FipsKDF.AgreementKDFPRF.KMAC_128);
        kdfPRF.put(NISTObjectIdentifiers.id_KmacWithSHAKE256, FipsKDF.AgreementKDFPRF.KMAC_256);
        wrapNames.put(NISTObjectIdentifiers.id_aes128_wrap, "AES");
        wrapNames.put(NISTObjectIdentifiers.id_aes192_wrap, "AES");
        wrapNames.put(NISTObjectIdentifiers.id_aes256_wrap, "AES");
        wrapNames.put(NTTObjectIdentifiers.id_camellia128_wrap, "Camellia");
        wrapNames.put(NTTObjectIdentifiers.id_camellia192_wrap, "Camellia");
        wrapNames.put(NTTObjectIdentifiers.id_camellia256_wrap, "Camellia");
        generalRsaAttributes.put("SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        generalRsaAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    static class KeyPairGenerator
    extends java.security.KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        AsymmetricKeyPairGenerator engine;

        public KeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string) {
            super(string);
            this.fipsProvider = bouncyCastleFipsProvider;
        }

        public KeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this(bouncyCastleFipsProvider, "RSA");
        }

        @Override
        public void initialize(int n) {
            this.initialize(n, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.engine = n < 2048 ? (this.getAlgorithm().equals("RSASSA-PSS") ? new RSA.KeyPairGenerator(new RSA.KeyGenParameters(RSA.PSS, defaultPublicExponent, n), secureRandom) : new RSA.KeyPairGenerator(new RSA.KeyGenParameters(defaultPublicExponent, n), secureRandom)) : (this.getAlgorithm().equals("RSASSA-PSS") ? new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(FipsRSA.PSS, defaultPublicExponent, n), secureRandom) : new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(defaultPublicExponent, n), secureRandom));
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
            if (rSAKeyGenParameterSpec.getKeysize() < 2048) {
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    throw new InvalidAlgorithmParameterException("RSA key size too small for FIPS mode operation");
                }
                this.engine = this.getAlgorithm().equals("RSASSA-PSS") ? new RSA.KeyPairGenerator(new RSA.KeyGenParameters(RSA.PSS, rSAKeyGenParameterSpec.getPublicExponent(), rSAKeyGenParameterSpec.getKeysize()), secureRandom) : new RSA.KeyPairGenerator(new RSA.KeyGenParameters(rSAKeyGenParameterSpec.getPublicExponent(), rSAKeyGenParameterSpec.getKeysize()), secureRandom);
            } else {
                this.engine = this.getAlgorithm().equals("RSASSA-PSS") ? new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(FipsRSA.PSS, rSAKeyGenParameterSpec.getPublicExponent(), rSAKeyGenParameterSpec.getKeysize()), secureRandom) : new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(rSAKeyGenParameterSpec.getPublicExponent(), rSAKeyGenParameterSpec.getKeysize()), secureRandom);
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (this.engine == null) {
                this.engine = this.getAlgorithm().equals("RSASSA-PSS") ? new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(FipsRSA.PSS, defaultPublicExponent, 2048), this.fipsProvider.getDefaultSecureRandom()) : new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(defaultPublicExponent, 2048), this.fipsProvider.getDefaultSecureRandom());
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvRSAPublicKey(asymmetricRSAPublicKey), new ProvRSAPrivateCrtKey(asymmetricRSAPrivateKey));
        }
    }

    public static class KtsAlgParams
    extends X509AlgorithmParameters {
        private GenericHybridParameters params;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded();
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            this.params = GenericHybridParameters.getInstance(byArray);
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == KTSParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                RsaKemParameters rsaKemParameters = RsaKemParameters.getInstance(this.params.getKem().getParameters());
                String string = (String)wrapNames.get(this.params.getDem().getAlgorithm());
                if (string == null) {
                    string = this.params.getDem().getAlgorithm().getId();
                }
                return new KTSParameterSpec.Builder(string, rsaKemParameters.getKeyLength().intValue() * 8).withKdfAlgorithm(rsaKemParameters.getKeyDerivationFunction()).build();
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            int n;
            int n2;
            KTSParameterSpec kTSParameterSpec;
            block16: {
                block17: {
                    block15: {
                        if (!(algorithmParameterSpec instanceof KTSParameterSpec)) {
                            throw new InvalidParameterSpecException("KTSParameterSpec required to initialise a KTS AlgorithmParameters object");
                        }
                        kTSParameterSpec = (KTSParameterSpec)algorithmParameterSpec;
                        n2 = kTSParameterSpec.getKeySize();
                        n = -1;
                        aSN1ObjectIdentifier = null;
                        if (!kTSParameterSpec.getKeyAlgorithmName().equalsIgnoreCase("AES")) break block15;
                        switch (n2) {
                            case 128: {
                                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
                                n = 16;
                                break block16;
                            }
                            case 192: {
                                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
                                n = 24;
                                break block16;
                            }
                            case 256: {
                                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
                                n = 32;
                                break block16;
                            }
                            default: {
                                throw new InvalidParameterSpecException("Unknown key size for AES: " + n2);
                            }
                        }
                    }
                    if (!kTSParameterSpec.getKeyAlgorithmName().equalsIgnoreCase("Camellia")) break block17;
                    switch (n2) {
                        case 128: {
                            aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia128_wrap;
                            n = 16;
                            break block16;
                        }
                        case 192: {
                            aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia192_wrap;
                            n = 24;
                            break block16;
                        }
                        case 256: {
                            aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia256_wrap;
                            n = 32;
                            break block16;
                        }
                        default: {
                            throw new InvalidParameterSpecException("Unknown key size for Camellia: " + n2);
                        }
                    }
                }
                n = keySizeProvider.getKeySize(kTSParameterSpec.getKeyAlgorithmName());
                try {
                    aSN1ObjectIdentifier = new ASN1ObjectIdentifier(kTSParameterSpec.getKeyAlgorithmName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidParameterSpecException("Cannot recognise key algorithm: " + kTSParameterSpec.getKeyAlgorithmName());
                }
            }
            if (n < 0) {
                throw new InvalidParameterSpecException("Unavailable key length for algorithm: " + kTSParameterSpec.getKeyAlgorithmName());
            }
            if (n * 8 != n2) {
                throw new InvalidParameterSpecException("Expected key size and key length do not match: " + n2 + " != (8 * " + n + ")");
            }
            this.params = new GenericHybridParameters(new AlgorithmIdentifier(ISOIECObjectIdentifiers.id_kem_rsa, new RsaKemParameters(kTSParameterSpec.getKdfAlgorithm(), n)), new AlgorithmIdentifier(aSN1ObjectIdentifier));
        }

        @Override
        protected String engineToString() {
            return "KTS AlgParams";
        }
    }

    public static class PSSAlgorithmParameters
    extends X509AlgorithmParameters {
        PSSParameterSpec currentSpec;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            PSSParameterSpec pSSParameterSpec = this.currentSpec;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = DigestUtil.getOID(pSSParameterSpec.getDigestAlgorithm());
            AlgorithmIdentifier algorithmIdentifier = NISTObjectIdentifiers.id_shake128.equals(aSN1ObjectIdentifier) || NISTObjectIdentifiers.id_shake256.equals(aSN1ObjectIdentifier) ? new AlgorithmIdentifier(aSN1ObjectIdentifier) : new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)pSSParameterSpec.getMGFParameters();
            AlgorithmIdentifier algorithmIdentifier2 = mGF1ParameterSpec != null ? new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, new AlgorithmIdentifier(DigestUtil.getOID(mGF1ParameterSpec.getDigestAlgorithm()), DERNull.INSTANCE)) : new AlgorithmIdentifier(DigestUtil.getOID(pSSParameterSpec.getMGFAlgorithm()));
            RSASSAPSSparams rSASSAPSSparams = new RSASSAPSSparams(algorithmIdentifier, algorithmIdentifier2, new ASN1Integer(pSSParameterSpec.getSaltLength()), new ASN1Integer(pSSParameterSpec.getTrailerField()));
            return rSASSAPSSparams.getEncoded("DER");
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == PSSParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS AlgorithmParameters object");
            }
            this.currentSpec = (PSSParameterSpec)algorithmParameterSpec;
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(byArray);
            this.currentSpec = PKCSObjectIdentifiers.id_mgf1.equals(rSASSAPSSparams.getMaskGenAlgorithm().getAlgorithm()) ? new PSSParameterSpec(MessageDigestUtils.getDigestName(rSASSAPSSparams.getHashAlgorithm().getAlgorithm()), ProvRSA.getMGFName(rSASSAPSSparams.getMaskGenAlgorithm().getAlgorithm()), new MGF1ParameterSpec(MessageDigestUtils.getDigestName(AlgorithmIdentifier.getInstance(rSASSAPSSparams.getMaskGenAlgorithm().getParameters()).getAlgorithm())), rSASSAPSSparams.getSaltLength().intValue(), rSASSAPSSparams.getTrailerField().intValue()) : new PSSParameterSpec(MessageDigestUtils.getDigestName(rSASSAPSSparams.getHashAlgorithm().getAlgorithm()), ProvRSA.getMGFName(rSASSAPSSparams.getMaskGenAlgorithm().getAlgorithm()), null, rSASSAPSSparams.getSaltLength().intValue(), rSASSAPSSparams.getTrailerField().intValue());
        }

        @Override
        protected String engineToString() {
            return "PSS Parameters";
        }
    }

    public static class OAEPAlgorithmParameters
    extends X509AlgorithmParameters {
        OAEPParameterSpec currentSpec;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(DigestUtil.getOID(this.currentSpec.getDigestAlgorithm()), DERNull.INSTANCE);
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)this.currentSpec.getMGFParameters();
            AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, new AlgorithmIdentifier(DigestUtil.getOID(mGF1ParameterSpec.getDigestAlgorithm()), DERNull.INSTANCE));
            PSource.PSpecified pSpecified = (PSource.PSpecified)this.currentSpec.getPSource();
            AlgorithmIdentifier algorithmIdentifier3 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, new DEROctetString(pSpecified.getValue()));
            RSAESOAEPparams rSAESOAEPparams = new RSAESOAEPparams(algorithmIdentifier, algorithmIdentifier2, algorithmIdentifier3);
            return rSAESOAEPparams.getEncoded("DER");
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == OAEPParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
                throw new InvalidParameterSpecException("OAEPParameterSpec required to initialise an OAEP AlgorithmParameters object");
            }
            this.currentSpec = (OAEPParameterSpec)algorithmParameterSpec;
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            RSAESOAEPparams rSAESOAEPparams = RSAESOAEPparams.getInstance(byArray);
            this.currentSpec = new OAEPParameterSpec(MessageDigestUtils.getDigestName(rSAESOAEPparams.getHashAlgorithm().getAlgorithm()), ProvRSA.getMGFName(rSAESOAEPparams.getMaskGenAlgorithm().getAlgorithm()), new MGF1ParameterSpec(MessageDigestUtils.getDigestName(AlgorithmIdentifier.getInstance(rSAESOAEPparams.getMaskGenAlgorithm().getParameters()).getAlgorithm())), new PSource.PSpecified(ASN1OctetString.getInstance(rSAESOAEPparams.getPSourceAlgorithm().getParameters()).getOctets()));
        }

        @Override
        protected String engineToString() {
            return "OAEP Parameters";
        }
    }

    static class RSAKeyFactory
    extends BaseKeyFactory {
        private final Algorithm algorithm;

        public RSAKeyFactory(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if ((clazz.isAssignableFrom(KeySpec.class) || clazz.isAssignableFrom(RSAPublicKeySpec.class)) && key instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            if ((clazz.isAssignableFrom(KeySpec.class) || clazz.isAssignableFrom(RSAPrivateCrtKeySpec.class)) && key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            }
            if ((clazz.isAssignableFrom(KeySpec.class) || clazz.isAssignableFrom(RSAPrivateKeySpec.class)) && key instanceof RSAPrivateKey) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvRSAPublicKey((AsymmetricRSAPublicKey)publicKeyConverter.convertKey(this.algorithm, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return this.toProviderKey((AsymmetricRSAPrivateKey)privateKeyConverter.convertKey(this.algorithm, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
                try {
                    return this.generatePrivate(pKCS8EncodedKeySpec.getEncoded());
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(exception.getMessage(), exception);
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                return new ProvRSAPrivateCrtKey(this.algorithm, (RSAPrivateCrtKeySpec)keySpec);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                return new ProvRSAPrivateKey(this.algorithm, (RSAPrivateKeySpec)keySpec);
            }
            if (keySpec != null) {
                throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
            }
            throw new InvalidKeySpecException("null keySpec passed for PrivateKey");
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof RSAPublicKeySpec) {
                return new ProvRSAPublicKey(this.algorithm, (RSAPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(byte[] byArray) throws IOException {
            return this.generatePrivate(PrivateKeyInfo.getInstance(byArray));
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return this.toProviderKey(new AsymmetricRSAPrivateKey(this.algorithm, privateKeyInfo));
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvRSAPublicKey(new AsymmetricRSAPublicKey(this.algorithm, subjectPublicKeyInfo));
        }

        private RSAPrivateKey toProviderKey(AsymmetricRSAPrivateKey asymmetricRSAPrivateKey) {
            if (asymmetricRSAPrivateKey.getP().equals(BigInteger.ZERO)) {
                return new ProvRSAPrivateKey(asymmetricRSAPrivateKey);
            }
            return new ProvRSAPrivateCrtKey(asymmetricRSAPrivateKey);
        }
    }

    static class KEMKTSSKeyFactory
    extends SecretKeyFactorySpi {
        private final BouncyCastleFipsProvider fipsProvider;

        public KEMKTSSKeyFactory(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.fipsProvider = bouncyCastleFipsProvider;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            try {
                if (keySpec instanceof KTSWithKEMKWSKeySpec) {
                    KTSWithKEMKWSKeySpec kTSWithKEMKWSKeySpec = (KTSWithKEMKWSKeySpec)keySpec;
                    KTSKeySpec kTSKeySpec = kTSWithKEMKWSKeySpec.getKTSKeySpec();
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("RSA-KAS-KEM", this.fipsProvider);
                    if (kTSKeySpec instanceof KTSGenerateKeySpec) {
                        KTSKeyWithEncapsulation kTSKeyWithEncapsulation = (KTSKeyWithEncapsulation)secretKeyFactory.generateSecret(kTSKeySpec);
                        KeyGenerator keyGenerator = KeyGenerator.getInstance(kTSWithKEMKWSKeySpec.getTransportedKeyAlgorithm(), this.fipsProvider);
                        keyGenerator.init(kTSWithKEMKWSKeySpec.getTransportedKeySize(), ((KTSGenerateKeySpec)kTSKeySpec).getSecureRandom());
                        Cipher cipher = Cipher.getInstance(kTSKeySpec.getKeyAlgorithmName(), this.fipsProvider);
                        cipher.init(3, (Key)kTSKeyWithEncapsulation, ((KTSGenerateKeySpec)kTSKeySpec).getSecureRandom());
                        SecretKey secretKey = keyGenerator.generateKey();
                        ZeroizableSecretKey zeroizableSecretKey = kTSKeyWithEncapsulation.getMacKey();
                        byte[] byArray = Arrays.concatenate(kTSKeyWithEncapsulation.getEncapsulation(), cipher.wrap(secretKey));
                        if (zeroizableSecretKey != null) {
                            return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(secretKey, zeroizableSecretKey.getAlgorithm(), zeroizableSecretKey.getEncoded()), byArray);
                        }
                        return new KTSKeyWithEncapsulation(secretKey, byArray);
                    }
                    KTSExtractKeySpec kTSExtractKeySpec = (KTSExtractKeySpec)kTSKeySpec;
                    byte[] byArray = kTSExtractKeySpec.getEncapsulation();
                    byte[] byArray2 = new byte[(((RSAPrivateKey)kTSExtractKeySpec.getPrivateKey()).getModulus().bitLength() + 7) / 8];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                    KTSExtractKeySpec kTSExtractKeySpec2 = new KTSExtractKeySpec.Builder(kTSExtractKeySpec.getPrivateKey(), byArray2, kTSExtractKeySpec.getKeyAlgorithmName(), kTSExtractKeySpec.getKeySize(), kTSExtractKeySpec.getOtherInfo()).withKdfAlgorithm(kTSExtractKeySpec.getKdfAlgorithmId()).withMac(kTSExtractKeySpec.getMacAlgorithmName(), kTSExtractKeySpec.getMacKeySize()).build();
                    KTSKeyWithEncapsulation kTSKeyWithEncapsulation = (KTSKeyWithEncapsulation)secretKeyFactory.generateSecret(kTSExtractKeySpec2);
                    Cipher cipher = Cipher.getInstance(kTSExtractKeySpec.getKeyAlgorithmName(), this.fipsProvider);
                    cipher.init(4, (Key)kTSKeyWithEncapsulation, (SecureRandom)null);
                    byte[] byArray3 = new byte[byArray.length - byArray2.length];
                    System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
                    SecretKey secretKey = (SecretKey)cipher.unwrap(byArray3, kTSWithKEMKWSKeySpec.getTransportedKeyAlgorithm(), 3);
                    ZeroizableSecretKey zeroizableSecretKey = kTSKeyWithEncapsulation.getMacKey();
                    int n = secretKey.getEncoded().length;
                    if (n != (kTSWithKEMKWSKeySpec.getTransportedKeySize() + 7) / 8) {
                        throw new InvalidKeySpecException("KEM transported key the incorrect size: found " + n + " bytes");
                    }
                    if (zeroizableSecretKey != null) {
                        return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(secretKey, zeroizableSecretKey.getAlgorithm(), zeroizableSecretKey.getEncoded()), byArray2);
                    }
                    return new KTSKeyWithEncapsulation(secretKey, byArray2);
                }
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw invalidKeySpecException;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Unable to process RSA key: " + generalSecurityException.getMessage(), generalSecurityException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidKeySpecException("Unable to process KDF AlgorithmIdentifier: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
            throw new InvalidKeySpecException("Unknown KeySpec passed");
        }

        protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
            throw new InvalidKeySpecException("Operation not supported");
        }

        @Override
        protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
            throw new InvalidKeyException("Operation not supported");
        }
    }

    static class KTSSKeyFactory
    extends SecretKeyFactorySpi {
        private final BouncyCastleFipsProvider fipsProvider;
        private final PublicKeyConverter publicKeyConverter;
        private final PrivateKeyConverter privateKeyConverter;
        private final ParametersCreator parametersCreator;

        public KTSSKeyFactory(ParametersCreator parametersCreator, BouncyCastleFipsProvider bouncyCastleFipsProvider, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter) {
            this.parametersCreator = parametersCreator;
            this.fipsProvider = bouncyCastleFipsProvider;
            this.publicKeyConverter = publicKeyConverter;
            this.privateKeyConverter = privateKeyConverter;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            FipsRSA.KTSOperatorFactory kTSOperatorFactory = new FipsRSA.KTSOperatorFactory(this.fipsProvider.getDefaultSecureRandom());
            try {
                if (keySpec instanceof KTSGenerateKeySpec) {
                    KTSGenerateKeySpec kTSGenerateKeySpec = (KTSGenerateKeySpec)keySpec;
                    FipsRSA.KTSParameters kTSParameters = (FipsRSA.KTSParameters)this.parametersCreator.createParameters(true, new InternalKtsSpec(kTSGenerateKeySpec.getKeySize(), kTSGenerateKeySpec.getMacKeySize(), kTSGenerateKeySpec.getParameterSpec()), kTSGenerateKeySpec.getSecureRandom());
                    Object object = kTSOperatorFactory.createGenerator((org.bouncycastle.crypto.Key)this.publicKeyConverter.convertKey(kTSParameters.getAlgorithm(), kTSGenerateKeySpec.getPublicKey()), kTSParameters);
                    if (kTSGenerateKeySpec.getSecureRandom() != null) {
                        object = object.withSecureRandom(kTSGenerateKeySpec.getSecureRandom());
                    }
                    try {
                        SecretWithEncapsulation secretWithEncapsulation = object.generate();
                        byte[] byArray = secretWithEncapsulation.getSecret();
                        if (kTSGenerateKeySpec.getMacAlgorithmName() != null) {
                            byte[] byArray2 = new byte[(kTSGenerateKeySpec.getMacKeySize() + 7) / 8];
                            if (byArray2.length > byArray.length) {
                                throw new InvalidKeySpecException("MAC key length larger than available key material");
                            }
                            byte[] byArray3 = this.makeKeyBytes(kTSParameters, kTSGenerateKeySpec.getKdfAlgorithmId(), byArray, kTSGenerateKeySpec.getKeySize() + kTSGenerateKeySpec.getMacKeySize(), kTSGenerateKeySpec.getOtherInfo(), kTSGenerateKeySpec.getKdfSalt());
                            byte[] byArray4 = new byte[byArray3.length - byArray2.length];
                            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
                            System.arraycopy(byArray3, byArray2.length, byArray4, 0, byArray4.length);
                            Arrays.fill(byArray, (byte)0);
                            Arrays.fill(byArray3, (byte)0);
                            return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(new SecretKeySpec(byArray4, kTSGenerateKeySpec.getKeyAlgorithmName()), kTSGenerateKeySpec.getMacAlgorithmName(), byArray2), secretWithEncapsulation.getEncapsulation());
                        }
                        return new KTSKeyWithEncapsulation(new SecretKeySpec(this.makeKeyBytes(kTSParameters, kTSGenerateKeySpec.getKdfAlgorithmId(), byArray, kTSGenerateKeySpec.getKeySize(), kTSGenerateKeySpec.getOtherInfo(), kTSGenerateKeySpec.getKdfSalt()), kTSGenerateKeySpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
                    }
                    catch (PlainInputProcessingException plainInputProcessingException) {
                        throw new InvalidKeySpecException("Unable to create secret: " + plainInputProcessingException.getMessage(), plainInputProcessingException);
                    }
                }
                if (keySpec instanceof KTSExtractKeySpec) {
                    KTSExtractKeySpec kTSExtractKeySpec = (KTSExtractKeySpec)keySpec;
                    FipsRSA.KTSParameters kTSParameters = (FipsRSA.KTSParameters)this.parametersCreator.createParameters(true, new InternalKtsSpec(kTSExtractKeySpec.getKeySize(), kTSExtractKeySpec.getMacKeySize(), kTSExtractKeySpec.getParameterSpec()), null);
                    FipsEncapsulatedSecretExtractor<FipsRSA.KTSParameters> fipsEncapsulatedSecretExtractor = kTSOperatorFactory.createExtractor((org.bouncycastle.crypto.Key)this.privateKeyConverter.convertKey(kTSParameters.getAlgorithm(), kTSExtractKeySpec.getPrivateKey()), kTSParameters);
                    byte[] byArray = kTSExtractKeySpec.getEncapsulation();
                    try {
                        byte[] byArray5 = fipsEncapsulatedSecretExtractor.extractSecret(byArray, 0, byArray.length).getSecret();
                        if (kTSExtractKeySpec.getMacAlgorithmName() != null) {
                            byte[] byArray6 = new byte[(kTSExtractKeySpec.getMacKeySize() + 7) / 8];
                            if (byArray6.length > byArray5.length) {
                                throw new InvalidKeySpecException("MAC key length larger than available key material");
                            }
                            byte[] byArray7 = this.makeKeyBytes(kTSParameters, kTSExtractKeySpec.getKdfAlgorithmId(), byArray5, kTSExtractKeySpec.getKeySize() + kTSExtractKeySpec.getMacKeySize(), kTSExtractKeySpec.getOtherInfo(), kTSExtractKeySpec.getKdfSalt());
                            byte[] byArray8 = new byte[byArray7.length - byArray6.length];
                            System.arraycopy(byArray7, 0, byArray6, 0, byArray6.length);
                            System.arraycopy(byArray7, byArray6.length, byArray8, 0, byArray8.length);
                            Arrays.fill(byArray5, (byte)0);
                            Arrays.fill(byArray7, (byte)0);
                            return new KTSKeyWithEncapsulation(new AgreedKeyWithMacKey(new SecretKeySpec(byArray8, kTSExtractKeySpec.getKeyAlgorithmName()), kTSExtractKeySpec.getMacAlgorithmName(), byArray6), byArray);
                        }
                        return new KTSKeyWithEncapsulation(new SecretKeySpec(this.makeKeyBytes(kTSParameters, kTSExtractKeySpec.getKdfAlgorithmId(), byArray5, kTSExtractKeySpec.getKeySize(), kTSExtractKeySpec.getOtherInfo(), kTSExtractKeySpec.getKdfSalt()), kTSExtractKeySpec.getKeyAlgorithmName()), byArray);
                    }
                    catch (InvalidCipherTextException invalidCipherTextException) {
                        throw new InvalidKeySpecException("Unable to extract secret: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                    }
                }
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeySpecException("Unable to process RSA key: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException("Unable to process RSA key: " + invalidKeyException.getMessage(), invalidKeyException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidKeySpecException("Unable to process KDF AlgorithmIdentifier: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
            throw new InvalidKeySpecException("Unknown KeySpec passed");
        }

        private byte[] makeKeyBytes(FipsRSA.KTSParameters kTSParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws InvalidKeySpecException {
            KDFCalculator<FipsKDF.AgreementKDFParameters> kDFCalculator;
            if (kTSParameters instanceof FipsRSA.OAEPKTSParameters) {
                return byArray;
            }
            AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(algorithmIdentifier.getParameters());
            if (Utils.isNotNull(algorithmIdentifier2.getParameters())) {
                throw new InvalidKeySpecException("Digest algorithm identifier cannot have parameters");
            }
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && (byArray2 == null || byArray2.length == 0)) {
                throw new FipsUnapprovedOperationError("OtherInfo/IV for KDF must be present in approved mode");
            }
            if (X9ObjectIdentifiers.id_kdf_kdf2.equals(algorithmIdentifier.getAlgorithm())) {
                kDFCalculator = new FipsKDF.AgreementOperatorFactory().createKDFCalculator(FipsKDF.X963.withPRF(KTSSKeyFactory.getPrfAlgorithm(algorithmIdentifier2.getAlgorithm())).using(byArray).withIV(byArray2));
            } else if (X9ObjectIdentifiers.id_kdf_kdf3.equals(algorithmIdentifier.getAlgorithm())) {
                kDFCalculator = new FipsKDF.AgreementOperatorFactory().createKDFCalculator(FipsKDF.CONCATENATION.withPRF(KTSSKeyFactory.getPrfAlgorithm(algorithmIdentifier2.getAlgorithm())).using(byArray).withIV(byArray2).withSalt(byArray3));
            } else {
                throw new InvalidKeySpecException("Unrecognized KDF: " + algorithmIdentifier.getAlgorithm());
            }
            byte[] byArray4 = new byte[(n + 7) / 8];
            kDFCalculator.generateBytes(byArray4);
            Arrays.fill(byArray, (byte)0);
            return byArray4;
        }

        private static FipsKDF.AgreementKDFPRF getPrfAlgorithm(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws InvalidKeySpecException {
            FipsKDF.AgreementKDFPRF agreementKDFPRF = (FipsKDF.AgreementKDFPRF)((Object)kdfPRF.get(aSN1ObjectIdentifier));
            if (agreementKDFPRF == null) {
                throw new InvalidKeySpecException("Unrecognized digest in KDF: " + aSN1ObjectIdentifier);
            }
            return agreementKDFPRF;
        }

        protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
            throw new InvalidKeySpecException("Operation not supported");
        }

        @Override
        protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
            throw new InvalidKeyException("Operation not supported");
        }
    }

    static class InternalKtsSpec
    implements AlgorithmParameterSpec {
        private final int keySize;
        private final int macKeySize;
        private final AlgorithmParameterSpec parameterSpec;

        public InternalKtsSpec(int n, int n2, AlgorithmParameterSpec algorithmParameterSpec) {
            this.keySize = n;
            this.macKeySize = n2;
            this.parameterSpec = algorithmParameterSpec;
        }
    }

    private class AdaptiveSignatureOperatorFactory<T extends Parameters>
    implements SignatureOperatorFactory<FipsRSA.PKCS1v15SignatureParameters> {
        private AdaptiveSignatureOperatorFactory() {
        }

        @Override
        public final OutputSigner createSigner(AsymmetricPrivateKey asymmetricPrivateKey, FipsRSA.PKCS1v15SignatureParameters pKCS1v15SignatureParameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                return ProvRSA.this.fipsRsaSigFactory.createSigner(asymmetricPrivateKey, pKCS1v15SignatureParameters);
            }
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)asymmetricPrivateKey;
            if (asymmetricRSAPrivateKey.getModulus().bitLength() < 2048) {
                RSA.PKCS1v15SignatureParameters pKCS1v15SignatureParameters2 = RSA.PKCS1v1_5.withDigestAlgorithm(pKCS1v15SignatureParameters.getDigestAlgorithm());
                return ProvRSA.this.getGeneralSigFactory().createSigner(asymmetricPrivateKey, pKCS1v15SignatureParameters2);
            }
            return ProvRSA.this.fipsRsaSigFactory.createSigner(asymmetricPrivateKey, pKCS1v15SignatureParameters);
        }

        @Override
        public final OutputVerifier createVerifier(AsymmetricPublicKey asymmetricPublicKey, FipsRSA.PKCS1v15SignatureParameters pKCS1v15SignatureParameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                return ProvRSA.this.fipsRsaSigFactory.createVerifier(asymmetricPublicKey, pKCS1v15SignatureParameters);
            }
            AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)asymmetricPublicKey;
            if (asymmetricRSAPublicKey.getModulus().bitLength() < 1024) {
                RSA.PKCS1v15SignatureParameters pKCS1v15SignatureParameters2 = RSA.PKCS1v1_5.withDigestAlgorithm(pKCS1v15SignatureParameters.getDigestAlgorithm());
                return ProvRSA.this.getGeneralSigFactory().createVerifier(asymmetricPublicKey, pKCS1v15SignatureParameters2);
            }
            return ProvRSA.this.fipsRsaSigFactory.createVerifier(asymmetricPublicKey, pKCS1v15SignatureParameters);
        }

        @Override
        public final OutputValidator createValidator(AsymmetricPublicKey asymmetricPublicKey, FipsRSA.PKCS1v15SignatureParameters pKCS1v15SignatureParameters, byte[] byArray) {
            throw new IllegalStateException("not implemented");
        }
    }
}

