/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStoreParameters;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.CertStoreCollectionSpi;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.PKIXCertPathBuilderSpi;
import org.bouncycastle.jcajce.provider.PKIXCertPathBuilderSpi_8;
import org.bouncycastle.jcajce.provider.PKIXCertPathValidatorSpi;
import org.bouncycastle.jcajce.provider.PKIXCertPathValidatorSpi_8;

class ProvPKIX
extends AsymmetricAlgorithmProvider {
    private static final Class revChkClass = ClassUtil.lookup("java.security.cert.PKIXRevocationChecker");

    ProvPKIX() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        if (revChkClass != null) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("CertPathValidator.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new PKIXCertPathValidatorSpi_8(bouncyCastleFipsProvider);
                }
            });
            bouncyCastleFipsProvider.addAlgorithmImplementation("CertPathBuilder.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new PKIXCertPathBuilderSpi_8(bouncyCastleFipsProvider);
                }
            });
        } else {
            bouncyCastleFipsProvider.addAlgorithmImplementation("CertPathValidator.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new PKIXCertPathValidatorSpi(bouncyCastleFipsProvider);
                }
            });
            bouncyCastleFipsProvider.addAlgorithmImplementation("CertPathBuilder.PKIX", "org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi", new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new PKIXCertPathBuilderSpi(bouncyCastleFipsProvider);
                }
            });
        }
        bouncyCastleFipsProvider.addAlgorithmImplementation("CertStore.COLLECTION", "org.bouncycastle.jce.provider.CertStoreCollectionSpi", new EngineCreator(){

            @Override
            public Object createInstance(Object object) throws NoSuchAlgorithmException {
                try {
                    return new CertStoreCollectionSpi((CertStoreParameters)object);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new NoSuchAlgorithmException("Unable to construct CertStore implementation: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
            }
        });
    }
}

