/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.pkcs.PBEParameter;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.general.PBKD;
import org.bouncycastle.jcajce.PBKDF1Key;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PBKDFPBEKey;

class ProvPBEPBKDF1
extends AlgorithmProvider {
    private static final String PREFIX = ProvPBEPBKDF1.class.getName();

    ProvPBEPBKDF1() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.PBKDF1", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
    }

    static byte[] getSecretKey(SecretKey secretKey, PBEParameterSpec pBEParameterSpec, DigestAlgorithm digestAlgorithm, PasswordBasedDeriver.KeyType keyType, int n) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(digestAlgorithm, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKey(keyType, (n + 7) / 8);
    }

    static byte[][] getSecretKeyAndIV(SecretKey secretKey, PBEParameterSpec pBEParameterSpec, DigestAlgorithm digestAlgorithm, PasswordBasedDeriver.KeyType keyType, int n, int n2) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(digestAlgorithm, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKeyAndIV(keyType, (n + 7) / 8, (n2 + 7) / 8);
    }

    public static class FixedPBKDF1
    extends BaseKDFSecretKeyFactory {
        private final String algorithm;
        private final PasswordConverter passwordConverter;
        private final DigestAlgorithm prfAlg;
        private final int keySizeInBits;

        public FixedPBKDF1(String string, PasswordConverter passwordConverter, DigestAlgorithm digestAlgorithm, int n) {
            this.algorithm = string;
            this.passwordConverter = passwordConverter;
            this.prfAlg = digestAlgorithm;
            this.keySizeInBits = n;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    return new PBKDF1Key(((PBEKeySpec)keySpec).getPassword(), this.passwordConverter);
                }
                PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(this.prfAlg, this.passwordConverter, pBEKeySpec.getPassword()).withSalt(pBEKeySpec.getSalt()).withIterationCount(pBEKeySpec.getIterationCount()));
                return new PBKDFPBEKey(passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, (this.keySizeInBits + 7) / 8), this.algorithm, pBEKeySpec);
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("KeySpec cannot be null");
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBEParameter params;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded("DER");
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == PBEParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF1 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            try {
                this.params = new PBEParameter(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException(exception.getMessage());
            }
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            this.params = PBEParameter.getInstance(byArray);
        }

        @Override
        protected String engineToString() {
            return "PBKDF1 Parameters";
        }
    }
}

