/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.general.ElGamal;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSingleBlockCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DHAlgorithmParameterGeneratorSpi;
import org.bouncycastle.jcajce.provider.DHAlgorithmParametersSpi;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.ProvDH;
import org.bouncycastle.jcajce.provider.ProvDHPrivateKey;
import org.bouncycastle.jcajce.provider.ProvDHPublicKey;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.DHDomainParameterSpec;

class ProvElgamal
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalDhAttributes = new HashMap<String, String>();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.elgamal.";

    ProvElgamal() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.ELGAMAL", "org.bouncycastle.jcajce.provider.asymmetric.elgamal.AlgorithmParameterGeneratorSpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new DHAlgorithmParameterGeneratorSpi(bouncyCastleFipsProvider, "ELGAMAL");
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.ELGAMAL", "org.bouncycastle.jcajce.provider.asymmetric.elgamal.AlgorithmParametersSpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new AlgorithmParametersSpi();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.ELGAMAL", "org.bouncycastle.jcajce.provider.asymmetric.elgamal.CipherSpi", generalDhAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSingleBlockCipher.Builder(bouncyCastleFipsProvider, new Algorithm[]{ElGamal.ALGORITHM, ElGamal.WRAP_PKCS1v1_5.getAlgorithm(), ElGamal.WRAP_OAEP.getAlgorithm()}).withGeneralOperators(new ElGamal.OperatorFactory(), new ElGamal.KeyWrapOperatorFactory()).withPublicKeyConverter(ProvDH.publicKeyConverter).withPrivateKeyConverter(ProvDH.privateKeyConverter).withParametersCreatorProvider(new ParametersCreatorProvider(){

                    public ParametersCreator get(final Parameters parameters) {
                        return new ParametersCreator(){

                            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                                if (parameters.getAlgorithm() == ElGamal.WRAP_OAEP.getAlgorithm()) {
                                    if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
                                        throw new InvalidAlgorithmParameterException("OAEP can only accept OAEPParameterSpec");
                                    }
                                    OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
                                    DigestAlgorithm digestAlgorithm = Utils.digestNameToAlgMap.get(oAEPParameterSpec.getDigestAlgorithm());
                                    MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
                                    DigestAlgorithm digestAlgorithm2 = Utils.digestNameToAlgMap.get(mGF1ParameterSpec.getDigestAlgorithm());
                                    return ElGamal.WRAP_OAEP.withDigest(digestAlgorithm).withMGFDigest(digestAlgorithm2).withEncodingParams(((PSource.PSpecified)oAEPParameterSpec.getPSource()).getValue());
                                }
                                if (parameters.getAlgorithm() == ElGamal.WRAP_PKCS1v1_5.getAlgorithm()) {
                                    return ElGamal.WRAP_PKCS1v1_5;
                                }
                                return ElGamal.RAW;
                            }
                        };
                    }
                }).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "ELGAMAL", OIWObjectIdentifiers.elGamalAlgorithm);
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ELGAMAL", "org.bouncycastle.jcajce.provider.asymmetric.elgamal.KeyFactorySpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyFactorySpi();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ELGAMAL", "org.bouncycastle.jcajce.provider.asymmetric.elgamal.KeyPairGeneratorSpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider);
            }
        }));
        KeyFactorySpi keyFactorySpi = new KeyFactorySpi();
        this.registerOid(bouncyCastleFipsProvider, OIWObjectIdentifiers.elGamalAlgorithm, "ELGAMAL", keyFactorySpi);
        this.registerOidAlgorithmParameters(bouncyCastleFipsProvider, OIWObjectIdentifiers.elGamalAlgorithm, "ELGAMAL");
    }

    static {
        generalDhAttributes.put("SupportedKeyClasses", "javax.crypto.interfaces.DHPublicKey|javax.crypto.interfaces.DHPrivateKey");
        generalDhAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    static class AlgorithmParametersSpi
    extends DHAlgorithmParametersSpi {
        AlgorithmParametersSpi() {
            super("ELGAMAL");
        }

        @Override
        protected byte[] localGetEncoded() throws IOException {
            ElGamalParameter elGamalParameter = new ElGamalParameter(this.currentSpec.getP(), this.currentSpec.getG());
            return elGamalParameter.getEncoded("DER");
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            ElGamalParameter elGamalParameter = ElGamalParameter.getInstance(byArray);
            this.currentSpec = new DHDomainParameterSpec(elGamalParameter.getP(), null, elGamalParameter.getG());
        }

        @Override
        protected String engineToString() {
            return "ElGamal Parameters";
        }
    }

    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider provider;
        ElGamal.KeyGenParameters param;
        ElGamal.KeyPairGenerator engine;
        int strength = 2048;
        SecureRandom random;
        boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super("ElGamal");
            this.provider = bouncyCastleFipsProvider;
        }

        @Override
        public void initialize(int n) {
            this.initialize(n, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = new ElGamal.KeyGenParameters(new DHDomainParameters(dHParameterSpec.getP(), null, dHParameterSpec.getG(), dHParameterSpec.getL()));
            this.engine = new ElGamal.KeyPairGenerator(this.param, secureRandom);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            Object object;
            Object object2;
            if (!this.initialised) {
                object2 = (DHDomainParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DH_DEFAULT_PARAMS, this.strength);
                if (object2 != null) {
                    this.param = new ElGamal.KeyGenParameters((DHDomainParameters)object2);
                } else {
                    object = new FipsDH.DomainParametersGenerator(new FipsDH.DomainGenParameters(this.strength), this.random);
                    this.param = new ElGamal.KeyGenParameters(((FipsDH.DomainParametersGenerator)object).generateDomainParameters());
                }
                this.engine = new ElGamal.KeyPairGenerator(this.param, this.random);
                this.initialised = true;
            }
            object2 = this.engine.generateKeyPair();
            object = (AsymmetricDHPublicKey)((AsymmetricKeyPair)object2).getPublicKey();
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)((AsymmetricKeyPair)object2).getPrivateKey();
            return new KeyPair(new ProvDHPublicKey((AsymmetricDHPublicKey)object), new ProvDHPrivateKey(asymmetricDHPrivateKey));
        }
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPrivateKeySpec) {
                return new ProvDHPrivateKey((Algorithm)ElGamal.ALGORITHM, (DHPrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPublicKeySpec) {
                return new ProvDHPublicKey((Algorithm)ElGamal.ALGORITHM, (DHPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (clazz.isAssignableFrom(DHPrivateKeySpec.class) && key instanceof DHPrivateKey) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
                return new DHPrivateKeySpec(dHPrivateKey.getX(), dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
            }
            if (clazz.isAssignableFrom(DHPublicKeySpec.class) && key instanceof DHPublicKey) {
                DHPublicKey dHPublicKey = (DHPublicKey)key;
                return new DHPublicKeySpec(dHPublicKey.getY(), dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvDHPublicKey(ProvDH.publicKeyConverter.convertKey(ElGamal.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvDHPrivateKey(ProvDH.privateKeyConverter.convertKey(ElGamal.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return new ProvDHPrivateKey(new AsymmetricDHPrivateKey((Algorithm)ElGamal.ALGORITHM, privateKeyInfo));
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvDHPublicKey(new AsymmetricDHPublicKey((Algorithm)ElGamal.ALGORITHM, subjectPublicKeyInfo));
        }
    }
}

