/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEdEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvEC;
import org.bouncycastle.jcajce.provider.ProvEdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.ProvEdDSAPublicKey;
import org.bouncycastle.jcajce.provider.ProvXDHPrivateKey;
import org.bouncycastle.jcajce.provider.ProvXDHPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;

class ProvEdEC
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalEdDSAAttributes = new HashMap<String, String>();
    private static final Map<String, String> generalXDHAttributes = new HashMap<String, String>();
    private static AgreementFactory xdhFactory;
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.edec.";
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    private static final PublicKeyConverter<AsymmetricEdDSAPublicKey> edPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricEdDSAPrivateKey> edPrivateKeyConverter;
    private static final PublicKeyConverter<AsymmetricXDHPublicKey> xPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricXDHPrivateKey> xPrivateKeyConverter;

    ProvEdEC() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            xdhFactory = new EdEC.XDHAgreementFactory();
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.XDH", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$XDH", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new KeyFactorySpi.XDH();
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X448", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new KeyFactorySpi.X448();
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X25519", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new KeyFactorySpi.X25519();
                }
            }));
        }
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$EdDH", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyFactorySpi.EdDSA();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed448", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyFactorySpi.Ed448();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed25519", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyFactorySpi.Ed25519();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$EdDSA", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, false, null);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed448", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, false, FipsEdEC.Ed448);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed25519", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, false, FipsEdEC.Ed25519);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.XDH", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$XDH", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, true, null);
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X448", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, true, EdEC.X448);
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X25519", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new KeyPairGeneratorSpi(bouncyCastleFipsProvider, true, EdEC.X25519);
                }
            }));
        }
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$EDDSA", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new FipsEdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, FipsEdEC.EdDSA);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.EDDSAPH", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$EDDSAPH", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new FipsEdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, FipsEdEC.EdDSAph);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed448", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new FipsEdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, FipsEdEC.Ed448);
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "ED448", EdECObjectIdentifiers.id_Ed448);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.ED448PH", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed448Ph", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new FipsEdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, FipsEdEC.Ed448ph);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed25519", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new FipsEdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, FipsEdEC.Ed25519);
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "ED25519", EdECObjectIdentifiers.id_Ed25519);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.ED25519PH", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed25519Ph", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, new FipsEdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, FipsEdEC.Ed25519ph);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseAgreement(xdhFactory, xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X448));
                }
            }));
            bouncyCastleFipsProvider.addAlias("KeyAgreement", "X448", EdECObjectIdentifiers.id_X448);
            ParametersCreator parametersCreator = new ParametersCreator(){

                public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                    if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
                        throw new InvalidAlgorithmParameterException("X448 can only take a UserKeyingMaterialSpec");
                    }
                    return EdEC.X448;
                }
            };
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA224", FipsKDF.AgreementKDFPRF.SHA224, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA256", FipsKDF.AgreementKDFPRF.SHA256, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA384", FipsKDF.AgreementKDFPRF.SHA384, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA512", FipsKDF.AgreementKDFPRF.SHA512, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, parametersCreator);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X448", "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, parametersCreator);
            this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X25519));
                }
            }));
            bouncyCastleFipsProvider.addAlias("KeyAgreement", "X25519", EdECObjectIdentifiers.id_X25519);
            ParametersCreator parametersCreator2 = new ParametersCreator(){

                public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                    if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
                        throw new InvalidAlgorithmParameterException("X25519 can only take a UserKeyingMaterialSpec");
                    }
                    return EdEC.X25519;
                }
            };
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA224", FipsKDF.AgreementKDFPRF.SHA224, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA256", FipsKDF.AgreementKDFPRF.SHA256, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA384", FipsKDF.AgreementKDFPRF.SHA384, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA512", FipsKDF.AgreementKDFPRF.SHA512, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, parametersCreator2);
            this.addCDHAlgorithm(bouncyCastleFipsProvider, "X25519", "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, parametersCreator2);
            this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_X448, "X448", new KeyFactorySpi.X448());
            this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_X25519, "X25519", new KeyFactorySpi.X25519());
        }
        this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_Ed448, "ED448", new KeyFactorySpi.Ed448());
        this.registerOid(bouncyCastleFipsProvider, EdECObjectIdentifiers.id_Ed25519, "ED25519", new KeyFactorySpi.Ed25519());
    }

    private void addCDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, String string2, FipsKDF.AgreementKDFPRF agreementKDFPRF, ParametersCreator parametersCreator) {
        String string3 = string + "WITH" + string2 + "CKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string3, "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$" + string3, generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseAgreement(xdhFactory, xPublicKeyConverter, xPrivateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        }));
    }

    static {
        generalEdDSAAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.EdDSAKey");
        generalEdDSAAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        generalXDHAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.XDHKey");
        generalXDHAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        edPublicKeyConverter = new PublicKeyConverter<AsymmetricEdDSAPublicKey>(){

            @Override
            public AsymmetricEdDSAPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof ProvEdDSAPublicKey) {
                    return ((ProvEdDSAPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPublicKey(Utils.getKeyEncoding(publicKey));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EdDSA public key: " + exception.getMessage(), exception);
                }
            }
        };
        edPrivateKeyConverter = new PrivateKeyConverter<AsymmetricEdDSAPrivateKey>(){

            @Override
            public AsymmetricEdDSAPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof ProvEdDSAPrivateKey) {
                    return ((ProvEdDSAPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EdDSA private key: " + exception.getMessage(), exception);
                }
            }
        };
        xPublicKeyConverter = new PublicKeyConverter<AsymmetricXDHPublicKey>(){

            @Override
            public AsymmetricXDHPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof ProvXDHPublicKey) {
                    return ((ProvXDHPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricXDHPublicKey(Utils.getKeyEncoding(publicKey));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify XDH public key: " + exception.getMessage(), exception);
                }
            }
        };
        xPrivateKeyConverter = new PrivateKeyConverter<AsymmetricXDHPrivateKey>(){

            @Override
            public AsymmetricXDHPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof ProvXDHPrivateKey) {
                    return ((ProvXDHPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricXDHPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify XDH private key: " + exception.getMessage(), exception);
                }
            }
        };
    }

    static class XDHParametersCreator
    implements ParametersCreator {
        private final EdEC.Parameters params;

        XDHParametersCreator(EdEC.Parameters parameters) {
            this.params = parameters;
        }

        public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("unable to take parameter specs");
            }
            return this.params;
        }
    }

    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider provider;
        private final boolean isXDH;
        private Parameters params;
        private AsymmetricKeyPairGenerator engine;
        private SecureRandom random;
        private boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider, boolean bl, Parameters parameters) {
            super(parameters != null ? parameters.getAlgorithm().getName() : (bl ? "XDH" : "EdDSA"));
            this.params = parameters;
            this.provider = bouncyCastleFipsProvider;
            this.isXDH = bl;
        }

        @Override
        public void initialize(int n) {
            this.initialize(n, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.random = secureRandom;
            switch (n) {
                case 255: 
                case 256: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X25519) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X25519;
                        break;
                    }
                    if (this.params != null && this.params != FipsEdEC.Ed25519) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = FipsEdEC.Ed25519;
                    break;
                }
                case 448: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X448) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X448;
                        break;
                    }
                    if (this.params != null && this.params != FipsEdEC.Ed448) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = FipsEdEC.Ed448;
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown key size.");
                }
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                this.params = this.getParams(((ECGenParameterSpec)algorithmParameterSpec).getName());
            } else if (!this.isXDH && algorithmParameterSpec instanceof EdDSAParameterSpec) {
                this.params = this.getParams(((EdDSAParameterSpec)algorithmParameterSpec).getCurveName());
            } else if (this.isXDH && algorithmParameterSpec instanceof XDHParameterSpec) {
                this.params = this.getParams(((XDHParameterSpec)algorithmParameterSpec).getCurveName());
            } else {
                if (algorithmParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("parameterSpec cannot be null");
                }
                String string = ProvEC.getNameFrom(algorithmParameterSpec);
                if (string != null) {
                    this.params = this.getParams(string);
                } else {
                    throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
                }
            }
            this.random = secureRandom;
        }

        private Parameters getParams(String string) throws InvalidAlgorithmParameterException {
            if (this.isXDH) {
                if (string.equalsIgnoreCase("X448") || string.equals(EdECObjectIdentifiers.id_X448.getId())) {
                    return EdEC.X448;
                }
                if (string.equalsIgnoreCase("X25519") || string.equals(EdECObjectIdentifiers.id_X25519.getId())) {
                    return EdEC.X25519;
                }
                throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
            }
            if (string.equalsIgnoreCase("Ed448") || string.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
                return FipsEdEC.Ed448;
            }
            if (string.equalsIgnoreCase("Ed25519") || string.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
                return FipsEdEC.Ed25519;
            }
            throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                if (this.params == null) {
                    throw new IllegalStateException("generator not correctly initialized");
                }
                if (this.random == null) {
                    this.random = this.provider.getDefaultSecureRandom();
                }
                this.engine = this.isXDH ? new EdEC.XDHKeyPairGenerator((EdEC.Parameters)this.params, this.random) : new FipsEdEC.EdDSAKeyPairGenerator((FipsEdEC.Parameters)this.params, this.random);
                this.initialised = true;
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            if (this.isXDH) {
                AsymmetricXDHPublicKey asymmetricXDHPublicKey = (AsymmetricXDHPublicKey)asymmetricKeyPair.getPublicKey();
                AsymmetricXDHPrivateKey asymmetricXDHPrivateKey = (AsymmetricXDHPrivateKey)asymmetricKeyPair.getPrivateKey();
                return new KeyPair(new ProvXDHPublicKey(asymmetricXDHPublicKey), new ProvXDHPrivateKey(asymmetricXDHPrivateKey));
            }
            AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey = (AsymmetricEdDSAPublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey = (AsymmetricEdDSAPrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvEdDSAPublicKey(asymmetricEdDSAPublicKey), new ProvEdDSAPrivateKey(asymmetricEdDSAPrivateKey, asymmetricEdDSAPublicKey));
        }
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        String algorithm;
        private final boolean isXdh;
        private final int specificBase;

        public KeyFactorySpi(String string, boolean bl, int n) {
            this.algorithm = string;
            this.isXdh = bl;
            this.specificBase = n;
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                if (this.isXdh) {
                    GeneralAlgorithm generalAlgorithm = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new ProvXDHPublicKey((AsymmetricXDHPublicKey)xPublicKeyConverter.convertKey(generalAlgorithm, (PublicKey)key));
                }
                FipsAlgorithm fipsAlgorithm = key.getAlgorithm().equals("Ed448") ? FipsEdEC.Algorithm.Ed448 : FipsEdEC.Algorithm.Ed25519;
                return new ProvEdDSAPublicKey((AsymmetricEdDSAPublicKey)edPublicKeyConverter.convertKey(fipsAlgorithm, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                if (this.isXdh) {
                    GeneralAlgorithm generalAlgorithm = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new ProvXDHPrivateKey((AsymmetricXDHPrivateKey)xPrivateKeyConverter.convertKey(generalAlgorithm, (PrivateKey)key));
                }
                FipsAlgorithm fipsAlgorithm = key.getAlgorithm().equals("Ed448") ? FipsEdEC.Algorithm.Ed448 : FipsEdEC.Algorithm.Ed25519;
                AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey = (AsymmetricEdDSAPrivateKey)edPrivateKeyConverter.convertKey(fipsAlgorithm, (PrivateKey)key);
                return new ProvEdDSAPrivateKey(asymmetricEdDSAPrivateKey, new AsymmetricEdDSAPublicKey(fipsAlgorithm, asymmetricEdDSAPrivateKey.getPublicData()));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            return super.engineGetKeySpec(key, clazz);
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                if (byArray[9] == 5 && byArray[10] == 0) {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(byArray);
                    subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithm().getAlgorithm()), subjectPublicKeyInfo.getPublicKeyData().getBytes());
                    try {
                        byArray = subjectPublicKeyInfo.getEncoded("DER");
                    }
                    catch (IOException iOException) {
                        throw new InvalidKeySpecException("attempt to reconstruct key failed: " + iOException.getMessage());
                    }
                }
                if (this.specificBase == 0 || this.specificBase == byArray[8]) {
                    try {
                        switch (byArray[8]) {
                            case 111: {
                                return new ProvXDHPublicKey(byArray);
                            }
                            case 110: {
                                return new ProvXDHPublicKey(byArray);
                            }
                            case 113: {
                                return new ProvEdDSAPublicKey(byArray);
                            }
                            case 112: {
                                return new ProvEdDSAPublicKey(byArray);
                            }
                        }
                        return super.engineGeneratePublic(keySpec);
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        throw invalidKeySpecException;
                    }
                    catch (Exception exception) {
                        throw new InvalidKeySpecException(exception.getMessage(), exception);
                    }
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                    return new ProvXDHPrivateKey(privateKeyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new ProvXDHPrivateKey(privateKeyInfo);
                }
            } else if (aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new ProvEdDSAPrivateKey(privateKeyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new ProvEdDSAPrivateKey(privateKeyInfo);
                }
            }
            throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                    return new ProvXDHPublicKey(subjectPublicKeyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new ProvXDHPublicKey(subjectPublicKeyInfo.getEncoded());
                }
            } else if (aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new ProvEdDSAPublicKey(subjectPublicKeyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new ProvEdDSAPublicKey(subjectPublicKeyInfo.getEncoded());
                }
            }
            throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
        }

        static class Ed25519
        extends KeyFactorySpi {
            public Ed25519() {
                super("Ed25519", false, 112);
            }
        }

        static class Ed448
        extends KeyFactorySpi {
            public Ed448() {
                super("Ed448", false, 113);
            }
        }

        static class EdDSA
        extends KeyFactorySpi {
            public EdDSA() {
                super("EdDSA", false, 0);
            }
        }

        static class X25519
        extends KeyFactorySpi {
            public X25519() {
                super("X25519", true, 110);
            }
        }

        static class X448
        extends KeyFactorySpi {
            public X448() {
                super("X448", true, 111);
            }
        }

        static class XDH
        extends KeyFactorySpi {
            public XDH() {
                super("XDH", true, 0);
            }
        }
    }
}

