/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.CAST5;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.Utils;

final class ProvCAST5
extends AlgorithmProvider {
    private static final String PREFIX = ProvCAST5.class.getName();
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class};
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvCAST5() {
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        Class[] classArray = new Class[]{IvParameterSpec.class};
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.CAST5", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "CAST5", MiscObjectIdentifiers.cast5CBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.CAST5", PREFIX + "$AlgParamGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new AlgParamGen(bouncyCastleFipsProvider);
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameterGenerator", "CAST5", MiscObjectIdentifiers.cast5CBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.CAST5", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, CAST5.ECBwithPKCS7, CAST5.ECB, CAST5.ECBwithISO10126_2, CAST5.ECBwithISO7816_4, CAST5.ECBwithTBC, CAST5.ECBwithX923, CAST5.CBC, CAST5.CBCwithPKCS7, CAST5.CBCwithISO10126_2, CAST5.CBCwithISO7816_4, CAST5.CBCwithTBC, CAST5.CBCwithX923, CAST5.CBCwithCS1, CAST5.CBCwithCS2, CAST5.CBCwithCS3, CAST5.CTR, CAST5.CFB64, CAST5.CFB8, CAST5.OFB, CAST5.OpenPGPCFB, CAST5.EAX).withGeneralOperators(ProvCAST5.this.generalParametersCreatorProvider, new CAST5.OperatorFactory(), new CAST5.AEADOperatorFactory()).withParameters(ProvCAST5.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", MiscObjectIdentifiers.cast5CBC, PREFIX + "$CBC", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, CAST5.CBCwithPKCS7).withParameters(classArray).withGeneralOperators(ProvCAST5.this.generalParametersCreatorProvider, new CAST5.OperatorFactory(), new CAST5.AEADOperatorFactory()).withParameters(ProvCAST5.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.CAST5CMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(CAST5.CMAC, (MACOperatorFactory)new CAST5.MACOperatorFactory(), new AuthParametersCreator(CAST5.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "CAST5CMAC", "CAST5-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.CAST5", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "CAST5", 128, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new CAST5.KeyGenerator(n, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "CAST5", MiscObjectIdentifiers.cast5CBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.CAST5", PREFIX + "$CAST5KFACT", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("CAST5", CAST5.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    @Override
                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n < 40 || n > 128) {
                            throw new InvalidKeySpecException("CAST5 key must be of length 40-128 bits");
                        }
                        return byArray;
                    }
                });
            }
        }));
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        private byte[] iv;
        private int keyLength = 128;

        @Override
        protected byte[] localGetEncoded() throws IOException {
            return new CAST5CBCParameters(this.iv, this.keyLength).getEncoded();
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == IvParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a CAST5 parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }

        @Override
        protected void localInit(byte[] byArray) throws IOException {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(byArray);
            if (aSN1Primitive instanceof ASN1OctetString) {
                this.iv = ASN1OctetString.getInstance(aSN1Primitive).getOctets();
            } else if (aSN1Primitive instanceof ASN1Sequence) {
                CAST5CBCParameters cAST5CBCParameters = CAST5CBCParameters.getInstance(aSN1Primitive);
                this.iv = cAST5CBCParameters.getIV();
                this.keyLength = cAST5CBCParameters.getKeyLength();
            } else {
                throw new IOException("Unable to recognize parameters");
            }
        }

        @Override
        protected String engineToString() {
            return "CAST5 Parameters";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        public AlgParamGen(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super(bouncyCastleFipsProvider, 128);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for CAST5 parameter generation");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[8];
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = AlgorithmParameters.getInstance("CAST5", this.fipsProvider);
                algorithmParameters.init(new CAST5CBCParameters(byArray, this.strength).toASN1Primitive().getEncoded());
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.getMessage(), exception);
            }
            return algorithmParameters;
        }
    }
}

