/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.bc.EncryptedObjectStoreData;
import org.bouncycastle.asn1.bc.EncryptedPrivateKeyData;
import org.bouncycastle.asn1.bc.EncryptedSecretKeyData;
import org.bouncycastle.asn1.bc.ObjectData;
import org.bouncycastle.asn1.bc.ObjectDataSequence;
import org.bouncycastle.asn1.bc.ObjectStore;
import org.bouncycastle.asn1.bc.ObjectStoreData;
import org.bouncycastle.asn1.bc.ObjectStoreIntegrityCheck;
import org.bouncycastle.asn1.bc.PbkdMacIntegrityCheck;
import org.bouncycastle.asn1.bc.SecretKeyData;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.ScryptParams;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.nsri.NSRIObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsOutputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputAEADEncryptor;
import org.bouncycastle.crypto.fips.FipsPBKD;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.Scrypt;
import org.bouncycastle.crypto.util.PBKDF2Config;
import org.bouncycastle.crypto.util.PBKDFConfig;
import org.bouncycastle.crypto.util.ScryptConfig;
import org.bouncycastle.internal.asn1.cms.CCMParameters;
import org.bouncycastle.jcajce.BCFKSLoadStoreParameter;
import org.bouncycastle.jcajce.BCLoadStoreParameter;
import org.bouncycastle.jcajce.ConsistentKeyPair;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.JcaJceKeyHelper;
import org.bouncycastle.jcajce.provider.ProvIOException;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.provider.X509CertificateObject;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

class ProvBCFKS
extends AlgorithmProvider {
    private static final Map<String, ASN1ObjectIdentifier> oidMap = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<ASN1ObjectIdentifier, String> publicAlgMap = new HashMap<ASN1ObjectIdentifier, String>();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.keystore.bcfks.";

    ProvBCFKS() {
    }

    private static String getPublicKeyAlg(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = publicAlgMap.get(aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        return aSN1ObjectIdentifier.getId();
    }

    @Override
    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.BCFKS", "org.bouncycastle.jcajce.provider.keystore.bcfks.BCFKSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BCFIPSKeyStoreSpi(true, bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.IBCFKS", "org.bouncycastle.jcajce.provider.keystore.bcfks.IBCFKSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BCFIPSImmutableKeyStoreSpi(bouncyCastleFipsProvider);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.BCFKS-DEF", "org.bouncycastle.jcajce.provider.keystore.bcfks.BCSFKSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BCFIPSKeyStoreSpi(false, null);
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.IBCFKS-DEF", "org.bouncycastle.jcajce.provider.keystore.bcfks.IBCFKSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new BCFIPSImmutableKeyStoreSpi(null);
                }
            }));
        }
    }

    static {
        oidMap.put("DESEDE", OIWObjectIdentifiers.desEDE);
        oidMap.put("TRIPLEDES", OIWObjectIdentifiers.desEDE);
        oidMap.put("TDEA", OIWObjectIdentifiers.desEDE);
        oidMap.put("HMACSHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        oidMap.put("HMACSHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        oidMap.put("HMACSHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        oidMap.put("HMACSHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        oidMap.put("HMACSHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        oidMap.put("HMACSHA512/224", PKCSObjectIdentifiers.id_hmacWithSHA512_224);
        oidMap.put("HMACSHA512/256", PKCSObjectIdentifiers.id_hmacWithSHA512_256);
        oidMap.put("HMACSHA512(224)", PKCSObjectIdentifiers.id_hmacWithSHA512_224);
        oidMap.put("HMACSHA512(256)", PKCSObjectIdentifiers.id_hmacWithSHA512_256);
        oidMap.put("HMACSHA3-224", NISTObjectIdentifiers.id_hmacWithSHA3_224);
        oidMap.put("HMACSHA3-256", NISTObjectIdentifiers.id_hmacWithSHA3_256);
        oidMap.put("HMACSHA3-384", NISTObjectIdentifiers.id_hmacWithSHA3_384);
        oidMap.put("HMACSHA3-512", NISTObjectIdentifiers.id_hmacWithSHA3_512);
        oidMap.put("KMAC128", NISTObjectIdentifiers.id_Kmac128);
        oidMap.put("KMAC256", NISTObjectIdentifiers.id_Kmac256);
        oidMap.put("SEED", KISAObjectIdentifiers.id_seedCBC);
        oidMap.put("CAMELLIA.128", NTTObjectIdentifiers.id_camellia128_cbc);
        oidMap.put("CAMELLIA.192", NTTObjectIdentifiers.id_camellia192_cbc);
        oidMap.put("CAMELLIA.256", NTTObjectIdentifiers.id_camellia256_cbc);
        oidMap.put("ARIA.128", NSRIObjectIdentifiers.id_aria128_cbc);
        oidMap.put("ARIA.192", NSRIObjectIdentifiers.id_aria192_cbc);
        oidMap.put("ARIA.256", NSRIObjectIdentifiers.id_aria256_cbc);
        publicAlgMap.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        publicAlgMap.put(X9ObjectIdentifiers.id_ecPublicKey, "EC");
        publicAlgMap.put(OIWObjectIdentifiers.elGamalAlgorithm, "DH");
        publicAlgMap.put(PKCSObjectIdentifiers.dhKeyAgreement, "DH");
        publicAlgMap.put(X9ObjectIdentifiers.id_dsa, "DSA");
    }

    static class BCFIPSImmutableKeyStoreSpi
    extends BCFIPSKeyStoreSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private final Map<String, byte[]> cache;
        private final byte[] seedKey;
        private boolean isLoaded;

        public BCFIPSImmutableKeyStoreSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super(false, bouncyCastleFipsProvider);
            try {
                this.seedKey = new byte[32];
                if (bouncyCastleFipsProvider != null) {
                    SecureRandom.getInstance("DEFAULT", bouncyCastleFipsProvider).nextBytes(this.seedKey);
                } else {
                    SecureRandom.getInstance("DEFAULT").nextBytes(this.seedKey);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException("can't create cert factory - " + noSuchAlgorithmException.toString());
            }
            this.cache = new HashMap<String, byte[]>();
        }

        @Override
        public void engineDeleteEntry(String string) throws KeyStoreException {
            throw new KeyStoreException("delete operation not supported in immutable mode");
        }

        @Override
        public void engineSetKeyEntry(String string, Key key, char[] cArray, java.security.cert.Certificate[] certificateArray) throws KeyStoreException {
            throw new KeyStoreException("set operation not supported in immutable mode");
        }

        @Override
        public void engineSetKeyEntry(String string, byte[] byArray, java.security.cert.Certificate[] certificateArray) throws KeyStoreException {
            throw new KeyStoreException("set operation not supported in immutable mode");
        }

        @Override
        public void engineSetCertificateEntry(String string, java.security.cert.Certificate certificate) throws KeyStoreException {
            throw new KeyStoreException("set operation not supported in immutable mode");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            BCFIPSImmutableKeyStoreSpi bCFIPSImmutableKeyStoreSpi = this;
            synchronized (bCFIPSImmutableKeyStoreSpi) {
                if (this.isLoaded) {
                    throw new IOException("immutable keystore already loaded");
                }
                this.isLoaded = true;
            }
            super.engineLoad(loadStoreParameter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            BCFIPSImmutableKeyStoreSpi bCFIPSImmutableKeyStoreSpi = this;
            synchronized (bCFIPSImmutableKeyStoreSpi) {
                if (this.isLoaded) {
                    throw new IOException("immutable keystore already loaded");
                }
                this.isLoaded = true;
            }
            super.engineLoad(inputStream, cArray);
        }

        @Override
        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            Object object;
            byte[] byArray = this.calculateMac(string, cArray);
            if (this.cache.containsKey(string) && !Arrays.constantTimeAreEqual((byte[])(object = (Object)this.cache.get(string)), byArray)) {
                throw new UnrecoverableKeyException("unable to recover key (" + string + ")");
            }
            object = super.engineGetKey(string, cArray);
            if (object != null && !this.cache.containsKey(string)) {
                this.cache.put(string, byArray);
            }
            return object;
        }

        private byte[] calculateMac(String string, char[] cArray) {
            byte[] byArray = cArray != null ? Arrays.concatenate(Strings.toUTF8ByteArray(cArray), Strings.toUTF8ByteArray(string)) : Arrays.concatenate(this.seedKey, Strings.toUTF8ByteArray(string));
            byte[] byArray2 = new byte[32];
            new Scrypt.KDFFactory().createKDFCalculator(Scrypt.ALGORITHM.using(this.seedKey, 16384, 8, 1, byArray)).generateBytes(byArray2);
            return byArray2;
        }
    }

    static class BCFIPSKeyStoreSpi
    extends KeyStoreSpi {
        private static final BigInteger CERTIFICATE = BigInteger.valueOf(0L);
        private static final BigInteger PRIVATE_KEY = BigInteger.valueOf(1L);
        private static final BigInteger SECRET_KEY = BigInteger.valueOf(2L);
        private static final BigInteger PROTECTED_PRIVATE_KEY = BigInteger.valueOf(3L);
        private static final BigInteger PROTECTED_SECRET_KEY = BigInteger.valueOf(4L);
        private final boolean matchOnProbe;
        private final BouncyCastleFipsProvider fipsProvider;
        private final Map<String, ObjectData> entries = new HashMap<String, ObjectData>();
        private final Map<String, PrivateKey> privateKeyCache = new HashMap<String, PrivateKey>();
        private AlgorithmIdentifier hmacAlgorithm;
        private KeyDerivationFunc hmacPkbdAlgorithm;
        private Date creationDate;
        private Date lastModifiedDate;
        private ASN1ObjectIdentifier storeEncryptionAlgorithm = NISTObjectIdentifiers.id_aes256_CCM;

        BCFIPSKeyStoreSpi(boolean bl, BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.matchOnProbe = bl;
            this.fipsProvider = bouncyCastleFipsProvider;
        }

        @Override
        public boolean engineProbe(InputStream inputStream) throws IOException {
            if (!this.matchOnProbe) {
                return false;
            }
            BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
            bufferedInputStream.mark(10);
            int n = bufferedInputStream.read();
            if (n != 48) {
                return false;
            }
            bufferedInputStream.reset();
            ASN1InputStream aSN1InputStream = new ASN1InputStream(bufferedInputStream);
            try {
                ObjectStore.getInstance(aSN1InputStream.readObject());
            }
            catch (Exception exception) {
                return false;
            }
            return aSN1InputStream.available() == 0;
        }

        @Override
        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                if (objectData.getType().equals(PRIVATE_KEY) || objectData.getType().equals(PROTECTED_PRIVATE_KEY)) {
                    PrivateKey privateKey = this.privateKeyCache.get(string);
                    if (privateKey != null) {
                        return privateKey;
                    }
                    EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(encryptedPrivateKeyData.getEncryptedPrivateKeyInfo());
                    try {
                        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(this.decryptData("PRIVATE_KEY_ENCRYPTION", encryptedPrivateKeyInfo.getEncryptionAlgorithm(), cArray, encryptedPrivateKeyInfo.getEncryptedData()));
                        KeyFactory keyFactory = this.fipsProvider != null ? KeyFactory.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.fipsProvider) : KeyFactory.getInstance(ProvBCFKS.getPublicKeyAlg(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()));
                        PrivateKey privateKey2 = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
                        if (this.fipsProvider != null) {
                            new ConsistentKeyPair(this.engineGetCertificate(string).getPublicKey(), privateKey2);
                        }
                        this.privateKeyCache.put(string, privateKey2);
                        return privateKey2;
                    }
                    catch (Exception exception) {
                        throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover private key (" + string + "): " + exception.getMessage());
                    }
                }
                if (objectData.getType().equals(SECRET_KEY) || objectData.getType().equals(PROTECTED_SECRET_KEY)) {
                    EncryptedSecretKeyData encryptedSecretKeyData = EncryptedSecretKeyData.getInstance(objectData.getData());
                    try {
                        SecretKeyData secretKeyData = SecretKeyData.getInstance(this.decryptData("SECRET_KEY_ENCRYPTION", encryptedSecretKeyData.getKeyEncryptionAlgorithm(), cArray, encryptedSecretKeyData.getEncryptedKeyData()));
                        SecretKeyFactory secretKeyFactory = this.fipsProvider != null ? SecretKeyFactory.getInstance(secretKeyData.getKeyAlgorithm().getId(), this.fipsProvider) : SecretKeyFactory.getInstance(secretKeyData.getKeyAlgorithm().getId());
                        return secretKeyFactory.generateSecret(new SecretKeySpec(secretKeyData.getKeyBytes(), secretKeyData.getKeyAlgorithm().getId()));
                    }
                    catch (Exception exception) {
                        throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + string + "): " + exception.getMessage());
                    }
                }
                throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + string + "): type not recognized");
            }
            return null;
        }

        @Override
        public java.security.cert.Certificate[] engineGetCertificateChain(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null && (objectData.getType().equals(PRIVATE_KEY) || objectData.getType().equals(PROTECTED_PRIVATE_KEY))) {
                EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                Certificate[] certificateArray = encryptedPrivateKeyData.getCertificateChain();
                java.security.cert.Certificate[] certificateArray2 = new X509Certificate[certificateArray.length];
                for (int i = 0; i != certificateArray2.length; ++i) {
                    certificateArray2[i] = this.decodeCertificate(certificateArray[i]);
                }
                return certificateArray2;
            }
            return null;
        }

        @Override
        public java.security.cert.Certificate engineGetCertificate(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                if (objectData.getType().equals(PRIVATE_KEY) || objectData.getType().equals(PROTECTED_PRIVATE_KEY)) {
                    EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                    Certificate[] certificateArray = encryptedPrivateKeyData.getCertificateChain();
                    return this.decodeCertificate(certificateArray[0]);
                }
                if (objectData.getType().equals(CERTIFICATE)) {
                    return this.decodeCertificate(objectData.getData());
                }
            }
            return null;
        }

        private java.security.cert.Certificate decodeCertificate(Object object) {
            try {
                if (this.fipsProvider != null) {
                    return new X509CertificateObject(new JcaJceKeyHelper(this.fipsProvider), Certificate.getInstance(object));
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    return certificateFactory.generateCertificate(new ByteArrayInputStream(Certificate.getInstance(object).getEncoded()));
                }
                catch (Exception exception) {
                    return new X509CertificateObject(null, Certificate.getInstance(object));
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                return null;
            }
        }

        @Override
        public Date engineGetCreationDate(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                try {
                    return objectData.getLastModifiedDate().getDate();
                }
                catch (ParseException parseException) {
                    return new Date();
                }
            }
            return null;
        }

        @Override
        public void engineSetKeyEntry(String string, Key key, char[] cArray, java.security.cert.Certificate[] certificateArray) throws KeyStoreException {
            Date date;
            Date date2 = date = new Date();
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                date = this.extractCreationDate(objectData, date);
            }
            this.privateKeyCache.remove(string);
            if (key instanceof PrivateKey) {
                if (certificateArray == null) {
                    throw new KeyStoreException("BCFKS KeyStore requires a certificate chain for private key storage.");
                }
                try {
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
                    Object object;
                    if (this.fipsProvider != null) {
                        new ConsistentKeyPair(certificateArray[0].getPublicKey(), (PrivateKey)key);
                    }
                    byte[] byArray = key.getEncoded();
                    KeyDerivationFunc keyDerivationFunc = this.generatePkbdAlgorithmIdentifier(32);
                    byte[] byArray2 = this.generateKey(keyDerivationFunc, "PRIVATE_KEY_ENCRYPTION", cArray != null ? cArray : new char[]{}, 32);
                    if (this.storeEncryptionAlgorithm.equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                        object = new FipsAES.AEADOperatorFactory();
                        FipsAES.AuthParameters authParameters = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                        FipsOutputAEADEncryptor<FipsAES.AuthParameters> fipsOutputAEADEncryptor = ((FipsAES.AEADOperatorFactory)object).createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray2), authParameters);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        CipherOutputStream cipherOutputStream = fipsOutputAEADEncryptor.getEncryptingStream(byteArrayOutputStream);
                        cipherOutputStream.write(byArray);
                        ((OutputStream)cipherOutputStream).close();
                        PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(authParameters.getIV(), authParameters.getMACSizeInBits() / 8)));
                        encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), byteArrayOutputStream.toByteArray());
                    } else {
                        object = new FipsAES.KeyWrapOperatorFactory();
                        FipsAES.WrapParameters wrapParameters = FipsAES.KWP;
                        FipsKeyWrapper<FipsAES.WrapParameters> fipsKeyWrapper = ((FipsAES.KeyWrapOperatorFactory)object).createKeyWrapper(new SymmetricSecretKey(FipsAES.KWP, byArray2), wrapParameters);
                        PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad));
                        encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), fipsKeyWrapper.wrap(byArray, 0, byArray.length));
                    }
                    object = this.createPrivateKeySequence(encryptedPrivateKeyInfo, certificateArray);
                    this.entries.put(string, new ObjectData(PRIVATE_KEY, string, date, date2, ((ASN1Object)object).getEncoded(), null));
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing private key: " + exception.toString(), exception);
                }
            } else if (key instanceof SecretKey) {
                if (certificateArray != null) {
                    throw new KeyStoreException("BCFKS KeyStore cannot store certificate chain with secret key.");
                }
                try {
                    EncryptedSecretKeyData encryptedSecretKeyData;
                    ASN1Object aSN1Object;
                    SecretKeyData secretKeyData;
                    byte[] byArray = key.getEncoded();
                    String string2 = Strings.toUpperCase(key.getAlgorithm());
                    if (string2.indexOf("AES") > -1) {
                        secretKeyData = new SecretKeyData(NISTObjectIdentifiers.aes, byArray);
                    } else {
                        aSN1Object = (ASN1ObjectIdentifier)oidMap.get(string2);
                        if (aSN1Object != null) {
                            secretKeyData = new SecretKeyData((ASN1ObjectIdentifier)aSN1Object, byArray);
                        } else {
                            aSN1Object = (ASN1ObjectIdentifier)oidMap.get(string2 + "." + byArray.length * 8);
                            if (aSN1Object != null) {
                                secretKeyData = new SecretKeyData((ASN1ObjectIdentifier)aSN1Object, byArray);
                            } else {
                                throw new KeyStoreException("BCFKS KeyStore cannot recognize secret key (" + string2 + ") for storage.");
                            }
                        }
                    }
                    aSN1Object = this.generatePkbdAlgorithmIdentifier(32);
                    byte[] byArray3 = this.generateKey((KeyDerivationFunc)aSN1Object, "SECRET_KEY_ENCRYPTION", cArray != null ? cArray : new char[]{}, 32);
                    if (this.storeEncryptionAlgorithm.equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                        FipsAES.AEADOperatorFactory aEADOperatorFactory = new FipsAES.AEADOperatorFactory();
                        FipsAES.AuthParameters authParameters = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                        FipsOutputAEADEncryptor<FipsAES.AuthParameters> fipsOutputAEADEncryptor = aEADOperatorFactory.createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray3), authParameters);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        CipherOutputStream cipherOutputStream = fipsOutputAEADEncryptor.getEncryptingStream(byteArrayOutputStream);
                        cipherOutputStream.write(secretKeyData.getEncoded());
                        ((OutputStream)cipherOutputStream).close();
                        PBES2Parameters pBES2Parameters = new PBES2Parameters((KeyDerivationFunc)aSN1Object, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(authParameters.getIV(), authParameters.getMACSizeInBits() / 8)));
                        encryptedSecretKeyData = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), byteArrayOutputStream.toByteArray());
                    } else {
                        FipsAES.KeyWrapOperatorFactory keyWrapOperatorFactory = new FipsAES.KeyWrapOperatorFactory();
                        FipsAES.WrapParameters wrapParameters = FipsAES.KWP;
                        FipsKeyWrapper<FipsAES.WrapParameters> fipsKeyWrapper = keyWrapOperatorFactory.createKeyWrapper(new SymmetricSecretKey(FipsAES.KWP, byArray3), wrapParameters);
                        PBES2Parameters pBES2Parameters = new PBES2Parameters((KeyDerivationFunc)aSN1Object, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad));
                        encryptedSecretKeyData = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), fipsKeyWrapper.wrap(byArray, 0, byArray.length));
                    }
                    this.entries.put(string, new ObjectData(SECRET_KEY, string, date, date2, encryptedSecretKeyData.getEncoded(), null));
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing private key: " + exception.toString(), exception);
                }
            } else {
                throw new KeyStoreException("BCFKS KeyStore unable to recognize key.");
            }
            this.lastModifiedDate = date2;
        }

        private SecureRandom getDefaultSecureRandom() {
            if (this.fipsProvider != null) {
                return this.fipsProvider.getDefaultSecureRandom();
            }
            return new SecureRandom();
        }

        private EncryptedPrivateKeyData createPrivateKeySequence(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, java.security.cert.Certificate[] certificateArray) throws CertificateEncodingException {
            Certificate[] certificateArray2 = new Certificate[certificateArray.length];
            for (int i = 0; i != certificateArray.length; ++i) {
                certificateArray2[i] = Certificate.getInstance(certificateArray[i].getEncoded());
            }
            return new EncryptedPrivateKeyData(encryptedPrivateKeyInfo, certificateArray2);
        }

        @Override
        public void engineSetKeyEntry(String string, byte[] byArray, java.security.cert.Certificate[] certificateArray) throws KeyStoreException {
            Date date;
            Date date2 = date = new Date();
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                date = this.extractCreationDate(objectData, date);
            }
            if (certificateArray != null) {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
                try {
                    encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(byArray);
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore private key encoding must be an EncryptedPrivateKeyInfo.", exception);
                }
                try {
                    this.privateKeyCache.remove(string);
                    this.entries.put(string, new ObjectData(PROTECTED_PRIVATE_KEY, string, date, date2, this.createPrivateKeySequence(encryptedPrivateKeyInfo, certificateArray).getEncoded(), null));
                }
                catch (Exception exception) {
                    throw new KeyStoreException("BCFKS KeyStore exception storing protected private key: " + exception.toString(), exception);
                }
            }
            try {
                this.entries.put(string, new ObjectData(PROTECTED_SECRET_KEY, string, date, date2, byArray, null));
            }
            catch (Exception exception) {
                throw new KeyStoreException("BCFKS KeyStore exception storing protected private key: " + exception.toString(), exception);
            }
            this.lastModifiedDate = date2;
        }

        @Override
        public void engineSetCertificateEntry(String string, java.security.cert.Certificate certificate) throws KeyStoreException {
            Date date;
            ObjectData objectData = this.entries.get(string);
            Date date2 = date = new Date();
            if (objectData != null) {
                if (!objectData.getType().equals(CERTIFICATE)) {
                    throw new KeyStoreException("BCFKS KeyStore already has a key entry with alias " + string);
                }
                date = this.extractCreationDate(objectData, date);
            }
            try {
                this.entries.put(string, new ObjectData(CERTIFICATE, string, date, date2, certificate.getEncoded(), null));
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new KeyStoreException("BCFKS KeyStore unable to handle certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
            }
            this.lastModifiedDate = date2;
        }

        private Date extractCreationDate(ObjectData objectData, Date date) {
            try {
                date = objectData.getCreationDate().getDate();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return date;
        }

        @Override
        public void engineDeleteEntry(String string) throws KeyStoreException {
            ObjectData objectData = this.entries.get(string);
            if (objectData == null) {
                return;
            }
            this.privateKeyCache.remove(string);
            this.entries.remove(string);
            this.lastModifiedDate = new Date();
        }

        @Override
        public Enumeration<String> engineAliases() {
            final Iterator<String> iterator = new HashSet<String>(this.entries.keySet()).iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }

        @Override
        public boolean engineContainsAlias(String string) {
            if (string == null) {
                throw new NullPointerException("alias value is null");
            }
            return this.entries.containsKey(string);
        }

        @Override
        public int engineSize() {
            return this.entries.size();
        }

        @Override
        public boolean engineIsKeyEntry(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                BigInteger bigInteger = objectData.getType();
                return bigInteger.equals(PRIVATE_KEY) || bigInteger.equals(SECRET_KEY) || bigInteger.equals(PROTECTED_PRIVATE_KEY) || bigInteger.equals(PROTECTED_SECRET_KEY);
            }
            return false;
        }

        @Override
        public boolean engineIsCertificateEntry(String string) {
            ObjectData objectData = this.entries.get(string);
            if (objectData != null) {
                return objectData.getType().equals(CERTIFICATE);
            }
            return false;
        }

        @Override
        public String engineGetCertificateAlias(java.security.cert.Certificate certificate) {
            byte[] byArray;
            if (certificate == null) {
                return null;
            }
            try {
                byArray = certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return null;
            }
            for (Map.Entry<String, ObjectData> entry : this.entries.entrySet()) {
                ObjectData objectData = entry.getValue();
                if (objectData.getType().equals(CERTIFICATE)) {
                    if (!Arrays.areEqual(objectData.getData(), byArray)) continue;
                    return entry.getKey();
                }
                if (!objectData.getType().equals(PRIVATE_KEY) && !objectData.getType().equals(PROTECTED_PRIVATE_KEY)) continue;
                try {
                    EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                    if (!Arrays.areEqual(encryptedPrivateKeyData.getCertificateChain()[0].toASN1Primitive().getEncoded(), byArray)) continue;
                    return entry.getKey();
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        private KeyDerivationFunc generatePkbdAlgorithmIdentifier(PBKDFConfig pBKDFConfig, int n) {
            if (MiscObjectIdentifiers.id_scrypt.equals(pBKDFConfig.getAlgorithm())) {
                ScryptConfig scryptConfig = (ScryptConfig)pBKDFConfig;
                byte[] byArray = new byte[scryptConfig.getSaltLength()];
                this.getDefaultSecureRandom().nextBytes(byArray);
                ScryptParams scryptParams = new ScryptParams(byArray, scryptConfig.getCostParameter(), scryptConfig.getBlockSize(), scryptConfig.getParallelizationParameter(), n);
                return new KeyDerivationFunc(MiscObjectIdentifiers.id_scrypt, scryptParams);
            }
            PBKDF2Config pBKDF2Config = (PBKDF2Config)pBKDFConfig;
            byte[] byArray = new byte[pBKDF2Config.getSaltLength()];
            this.getDefaultSecureRandom().nextBytes(byArray);
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, pBKDF2Config.getIterationCount(), n, pBKDF2Config.getPRF()));
        }

        private KeyDerivationFunc generatePkbdAlgorithmIdentifier(KeyDerivationFunc keyDerivationFunc, int n) {
            if (MiscObjectIdentifiers.id_scrypt.equals(keyDerivationFunc.getAlgorithm())) {
                ScryptParams scryptParams = ScryptParams.getInstance(keyDerivationFunc.getParameters());
                byte[] byArray = new byte[scryptParams.getSalt().length];
                this.getDefaultSecureRandom().nextBytes(byArray);
                ScryptParams scryptParams2 = new ScryptParams(byArray, scryptParams.getCostParameter(), scryptParams.getBlockSize(), scryptParams.getParallelizationParameter(), BigInteger.valueOf(n));
                return new KeyDerivationFunc(MiscObjectIdentifiers.id_scrypt, scryptParams2);
            }
            PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(keyDerivationFunc.getParameters());
            byte[] byArray = new byte[pBKDF2Params.getSalt().length];
            this.getDefaultSecureRandom().nextBytes(byArray);
            PBKDF2Params pBKDF2Params2 = new PBKDF2Params(byArray, pBKDF2Params.getIterationCount().intValue(), n, pBKDF2Params.getPrf());
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, pBKDF2Params2);
        }

        private byte[] generateKey(KeyDerivationFunc keyDerivationFunc, String string, char[] cArray, int n) throws IOException {
            byte[] byArray = PasswordConverter.PKCS12.convert(cArray);
            byte[] byArray2 = PasswordConverter.PKCS12.convert(string.toCharArray());
            int n2 = n;
            if (MiscObjectIdentifiers.id_scrypt.equals(keyDerivationFunc.getAlgorithm())) {
                ScryptParams scryptParams = ScryptParams.getInstance(keyDerivationFunc.getParameters());
                if (scryptParams.getKeyLength() != null) {
                    n2 = scryptParams.getKeyLength().intValue();
                } else if (n2 == -1) {
                    throw new IOException("no keyLength found in ScryptParams");
                }
                Scrypt.KDFFactory kDFFactory = new Scrypt.KDFFactory();
                byte[] byArray3 = Arrays.concatenate(byArray, byArray2);
                KDFCalculator<Scrypt.Parameters> kDFCalculator = kDFFactory.createKDFCalculator(Scrypt.ALGORITHM.using(scryptParams.getSalt(), scryptParams.getCostParameter().intValue(), scryptParams.getBlockSize().intValue(), scryptParams.getBlockSize().intValue(), byArray3));
                byte[] byArray4 = new byte[n2];
                kDFCalculator.generateBytes(byArray4);
                Arrays.clear(byArray3);
                Arrays.clear(byArray);
                return byArray4;
            }
            if (keyDerivationFunc.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBKDF2)) {
                FipsPBKD.Parameters parameters;
                PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(keyDerivationFunc.getParameters());
                if (pBKDF2Params.getKeyLength() != null) {
                    n2 = pBKDF2Params.getKeyLength().intValue();
                } else if (n2 == -1) {
                    throw new IOException("no keyLength found in PBKDF2Params");
                }
                FipsPBKD.DeriverFactory deriverFactory = new FipsPBKD.DeriverFactory();
                if (pBKDF2Params.getPrf().getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
                    parameters = FipsPBKD.PBKDF2.using(FipsSHS.Algorithm.SHA512_HMAC, Arrays.concatenate(byArray, byArray2)).withIterationCount(pBKDF2Params.getIterationCount().intValue()).withSalt(pBKDF2Params.getSalt());
                } else if (pBKDF2Params.getPrf().getAlgorithm().equals(NISTObjectIdentifiers.id_hmacWithSHA3_512)) {
                    parameters = FipsPBKD.PBKDF2.using(FipsSHS.Algorithm.SHA3_512_HMAC, Arrays.concatenate(byArray, byArray2)).withIterationCount(pBKDF2Params.getIterationCount().intValue()).withSalt(pBKDF2Params.getSalt());
                } else {
                    throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD PRF: " + pBKDF2Params.getPrf().getAlgorithm());
                }
                PasswordBasedDeriver<FipsPBKD.Parameters> passwordBasedDeriver = deriverFactory.createDeriver(parameters);
                return passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, n2);
            }
            throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD.");
        }

        private void verifyMac(byte[] byArray, PbkdMacIntegrityCheck pbkdMacIntegrityCheck, char[] cArray) throws NoSuchAlgorithmException, IOException {
            byte[] byArray2 = this.calculateMac(byArray, pbkdMacIntegrityCheck.getMacAlgorithm(), pbkdMacIntegrityCheck.getPbkdAlgorithm(), cArray);
            if (!Arrays.constantTimeAreEqual(byArray2, pbkdMacIntegrityCheck.getMac())) {
                throw new IOException("BCFKS KeyStore corrupted: MAC calculation failed.");
            }
        }

        private byte[] calculateMac(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, KeyDerivationFunc keyDerivationFunc, char[] cArray) throws NoSuchAlgorithmException, IOException {
            String string = algorithmIdentifier.getAlgorithm().getId();
            Mac mac = this.fipsProvider != null ? Mac.getInstance(string, this.fipsProvider) : Mac.getInstance(string);
            try {
                mac.init(new SecretKeySpec(this.generateKey(keyDerivationFunc, "INTEGRITY_CHECK", cArray != null ? cArray : new char[]{}, -1), string));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new ProvIOException("Cannot set up MAC calculation: " + invalidKeyException.getMessage(), invalidKeyException);
            }
            return mac.doFinal(byArray);
        }

        @Override
        public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws CertificateException, NoSuchAlgorithmException, IOException {
            if (loadStoreParameter == null) {
                this.engineLoad(null, null);
            } else if (loadStoreParameter instanceof BCFKSLoadStoreParameter) {
                BCFKSLoadStoreParameter bCFKSLoadStoreParameter = (BCFKSLoadStoreParameter)loadStoreParameter;
                char[] cArray = Utils.extractPassword(bCFKSLoadStoreParameter);
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(bCFKSLoadStoreParameter.getStorePBKDFConfig(), 64);
                this.storeEncryptionAlgorithm = bCFKSLoadStoreParameter.getStoreEncryptionAlgorithm() == BCFKSLoadStoreParameter.EncryptionAlgorithm.AES256_CCM ? NISTObjectIdentifiers.id_aes256_CCM : NISTObjectIdentifiers.id_aes256_wrap_pad;
                this.hmacAlgorithm = bCFKSLoadStoreParameter.getStoreMacAlgorithm() == BCFKSLoadStoreParameter.MacAlgorithm.HmacSHA512 ? new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE) : new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
                AlgorithmIdentifier algorithmIdentifier = this.hmacAlgorithm;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = this.storeEncryptionAlgorithm;
                InputStream inputStream = bCFKSLoadStoreParameter.getInputStream();
                this.engineLoad(inputStream, cArray);
                if (!(inputStream == null || algorithmIdentifier.equals(this.hmacAlgorithm) && this.isSimilarHmacPbkd(bCFKSLoadStoreParameter.getStorePBKDFConfig(), this.hmacPkbdAlgorithm) && aSN1ObjectIdentifier.equals(this.storeEncryptionAlgorithm))) {
                    throw new IOException("configuration parameters do not match existing store");
                }
            } else if (loadStoreParameter instanceof BCLoadStoreParameter) {
                BCLoadStoreParameter bCLoadStoreParameter = (BCLoadStoreParameter)loadStoreParameter;
                this.engineLoad(bCLoadStoreParameter.getInputStream(), Utils.extractPassword(loadStoreParameter));
            } else {
                throw new IllegalArgumentException("no support for 'param' of type " + loadStoreParameter.getClass().getName());
            }
        }

        private boolean isSimilarHmacPbkd(PBKDFConfig pBKDFConfig, KeyDerivationFunc keyDerivationFunc) {
            if (!pBKDFConfig.getAlgorithm().equals(keyDerivationFunc.getAlgorithm())) {
                return false;
            }
            if (MiscObjectIdentifiers.id_scrypt.equals(keyDerivationFunc.getAlgorithm())) {
                if (!(pBKDFConfig instanceof ScryptConfig)) {
                    return false;
                }
                ScryptConfig scryptConfig = (ScryptConfig)pBKDFConfig;
                ScryptParams scryptParams = ScryptParams.getInstance(keyDerivationFunc.getParameters());
                if (scryptConfig.getSaltLength() != scryptParams.getSalt().length || scryptConfig.getBlockSize() != scryptParams.getBlockSize().intValue() || scryptConfig.getCostParameter() != scryptParams.getCostParameter().intValue() || scryptConfig.getParallelizationParameter() != scryptParams.getParallelizationParameter().intValue()) {
                    return false;
                }
            } else {
                if (!(pBKDFConfig instanceof PBKDF2Config)) {
                    return false;
                }
                PBKDF2Config pBKDF2Config = (PBKDF2Config)pBKDFConfig;
                PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(keyDerivationFunc.getParameters());
                if (pBKDF2Config.getSaltLength() != pBKDF2Params.getSalt().length || pBKDF2Config.getIterationCount() != pBKDF2Params.getIterationCount().intValue()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws CertificateException, NoSuchAlgorithmException, IOException {
            if (loadStoreParameter == null) {
                throw new IllegalArgumentException("'param' arg cannot be null");
            }
            if (loadStoreParameter instanceof BCFKSLoadStoreParameter) {
                BCFKSLoadStoreParameter bCFKSLoadStoreParameter = (BCFKSLoadStoreParameter)loadStoreParameter;
                char[] cArray = Utils.extractPassword(bCFKSLoadStoreParameter);
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(bCFKSLoadStoreParameter.getStorePBKDFConfig(), 64);
                this.storeEncryptionAlgorithm = bCFKSLoadStoreParameter.getStoreEncryptionAlgorithm() == BCFKSLoadStoreParameter.EncryptionAlgorithm.AES256_CCM ? NISTObjectIdentifiers.id_aes256_CCM : NISTObjectIdentifiers.id_aes256_wrap_pad;
                this.hmacAlgorithm = bCFKSLoadStoreParameter.getStoreMacAlgorithm() == BCFKSLoadStoreParameter.MacAlgorithm.HmacSHA512 ? new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE) : new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
                this.engineStore(bCFKSLoadStoreParameter.getOutputStream(), cArray);
            } else if (loadStoreParameter instanceof BCLoadStoreParameter) {
                BCLoadStoreParameter bCLoadStoreParameter = (BCLoadStoreParameter)loadStoreParameter;
                this.engineStore(bCLoadStoreParameter.getOutputStream(), Utils.extractPassword(loadStoreParameter));
            } else {
                throw new IllegalArgumentException("no support for 'param' of type " + loadStoreParameter.getClass().getName());
            }
        }

        @Override
        public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            EncryptedObjectStoreData encryptedObjectStoreData;
            Object object;
            Object object2;
            if (this.creationDate == null) {
                throw new IOException("KeyStore not initialized");
            }
            ObjectData[] objectDataArray = this.entries.values().toArray(new ObjectData[this.entries.size()]);
            KeyDerivationFunc keyDerivationFunc = this.generatePkbdAlgorithmIdentifier(this.hmacPkbdAlgorithm, 32);
            byte[] byArray = this.generateKey(keyDerivationFunc, "STORE_ENCRYPTION", cArray != null ? cArray : new char[]{}, 32);
            ObjectStoreData objectStoreData = new ObjectStoreData(this.hmacAlgorithm, this.creationDate, this.lastModifiedDate, new ObjectDataSequence(objectDataArray), null);
            if (this.storeEncryptionAlgorithm.equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                object2 = new FipsAES.AEADOperatorFactory();
                object = FipsAES.CCM.withIV(this.getDefaultSecureRandom());
                FipsOutputAEADEncryptor<FipsAES.AuthParameters> fipsOutputAEADEncryptor = ((FipsAES.AEADOperatorFactory)object2).createOutputAEADEncryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray), (FipsAES.AuthParameters)object);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                CipherOutputStream cipherOutputStream = fipsOutputAEADEncryptor.getEncryptingStream(byteArrayOutputStream);
                cipherOutputStream.write(objectStoreData.getEncoded());
                ((OutputStream)cipherOutputStream).close();
                PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, new CCMParameters(((FipsAES.AuthParameters)object).getIV(), ((FipsAES.AuthParameters)object).getMACSizeInBits() / 8)));
                encryptedObjectStoreData = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), byteArrayOutputStream.toByteArray());
            } else {
                object2 = new FipsAES.KeyWrapOperatorFactory();
                object = FipsAES.KWP;
                FipsKeyWrapper<FipsAES.WrapParameters> fipsKeyWrapper = ((FipsAES.KeyWrapOperatorFactory)object2).createKeyWrapper(new SymmetricSecretKey(FipsAES.KWP, byArray), (FipsAES.WrapParameters)object);
                PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad));
                byte[] byArray2 = objectStoreData.getEncoded();
                encryptedObjectStoreData = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), fipsKeyWrapper.wrap(byArray2, 0, byArray2.length));
            }
            if (MiscObjectIdentifiers.id_scrypt.equals(this.hmacPkbdAlgorithm.getAlgorithm())) {
                object2 = ScryptParams.getInstance(this.hmacPkbdAlgorithm.getParameters());
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(this.hmacPkbdAlgorithm, ((ScryptParams)object2).getKeyLength().intValue());
            } else {
                object2 = PBKDF2Params.getInstance(this.hmacPkbdAlgorithm.getParameters());
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(this.hmacPkbdAlgorithm, ((PBKDF2Params)object2).getKeyLength().intValue());
            }
            object2 = this.calculateMac(encryptedObjectStoreData.getEncoded(), this.hmacAlgorithm, this.hmacPkbdAlgorithm, cArray);
            object = new ObjectStore(encryptedObjectStoreData, new ObjectStoreIntegrityCheck(new PbkdMacIntegrityCheck(this.hmacAlgorithm, this.hmacPkbdAlgorithm, (byte[])object2)));
            outputStream.write(((ASN1Object)object).getEncoded());
            outputStream.flush();
        }

        @Override
        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            ObjectStoreData objectStoreData;
            ASN1Object aSN1Object;
            Object object;
            this.entries.clear();
            this.privateKeyCache.clear();
            this.creationDate = null;
            this.lastModifiedDate = null;
            if (inputStream == null) {
                this.lastModifiedDate = this.creationDate = new Date();
                this.hmacAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
                this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(64);
                return;
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
            ObjectStore objectStore = ObjectStore.getInstance(aSN1InputStream.readObject());
            if (objectStore == null) {
                throw new EOFException("no data in keystore stream");
            }
            ObjectStoreIntegrityCheck objectStoreIntegrityCheck = objectStore.getIntegrityCheck();
            if (objectStoreIntegrityCheck.getType() != 0) {
                throw new IOException("BCFKS KeyStore unable to recognize integrity check.");
            }
            ASN1Encodable aSN1Encodable = PbkdMacIntegrityCheck.getInstance(objectStoreIntegrityCheck.getIntegrityCheck());
            this.hmacAlgorithm = aSN1Encodable.getMacAlgorithm();
            this.hmacPkbdAlgorithm = aSN1Encodable.getPbkdAlgorithm();
            this.verifyMac(objectStore.getStoreData().toASN1Primitive().getEncoded(), (PbkdMacIntegrityCheck)aSN1Encodable, cArray);
            aSN1Encodable = objectStore.getStoreData();
            if (aSN1Encodable instanceof EncryptedObjectStoreData) {
                object = (EncryptedObjectStoreData)aSN1Encodable;
                aSN1Object = ((EncryptedObjectStoreData)object).getEncryptionAlgorithm();
                objectStoreData = ObjectStoreData.getInstance(this.decryptData("STORE_ENCRYPTION", (AlgorithmIdentifier)aSN1Object, cArray, ((EncryptedObjectStoreData)object).getEncryptedContent().getOctets()));
            } else {
                objectStoreData = ObjectStoreData.getInstance(aSN1Encodable);
            }
            try {
                this.creationDate = objectStoreData.getCreationDate().getDate();
                this.lastModifiedDate = objectStoreData.getLastModifiedDate().getDate();
            }
            catch (ParseException parseException) {
                throw new IOException("BCFKS KeyStore unable to parse store data information.");
            }
            if (!objectStoreData.getIntegrityAlgorithm().equals(this.hmacAlgorithm)) {
                throw new IOException("BCFKS KeyStore storeData integrity algorithm does not match store integrity algorithm.");
            }
            object = objectStoreData.getObjectDataSequence().iterator();
            while (object.hasNext()) {
                aSN1Object = ObjectData.getInstance(object.next());
                this.entries.put(((ObjectData)aSN1Object).getIdentifier(), (ObjectData)aSN1Object);
            }
        }

        private byte[] decryptData(String string, AlgorithmIdentifier algorithmIdentifier, char[] cArray, byte[] byArray) throws IOException {
            if (!algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBES2)) {
                throw new IOException("BCFKS KeyStore cannot recognize protection algorithm.");
            }
            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
            EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
            if (encryptionScheme.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                CCMParameters cCMParameters = CCMParameters.getInstance(encryptionScheme.getParameters());
                FipsAES.AuthParameters authParameters = FipsAES.CCM.withIV(cCMParameters.getNonce()).withMACSize(cCMParameters.getIcvLen() * 8);
                FipsAES.AEADOperatorFactory aEADOperatorFactory = new FipsAES.AEADOperatorFactory();
                byte[] byArray2 = this.generateKey(pBES2Parameters.getKeyDerivationFunc(), string, cArray != null ? cArray : new char[]{}, 32);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FipsOutputAEADDecryptor<FipsAES.AuthParameters> fipsOutputAEADDecryptor = aEADOperatorFactory.createOutputAEADDecryptor((SymmetricKey)new SymmetricSecretKey(FipsAES.CCM, byArray2), authParameters);
                CipherOutputStream cipherOutputStream = fipsOutputAEADDecryptor.getDecryptingStream(byteArrayOutputStream);
                cipherOutputStream.write(byArray);
                ((OutputStream)cipherOutputStream).close();
                return byteArrayOutputStream.toByteArray();
            }
            if (encryptionScheme.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_wrap_pad)) {
                FipsAES.WrapParameters wrapParameters = FipsAES.KWP;
                FipsAES.KeyWrapOperatorFactory keyWrapOperatorFactory = new FipsAES.KeyWrapOperatorFactory();
                byte[] byArray3 = this.generateKey(pBES2Parameters.getKeyDerivationFunc(), string, cArray != null ? cArray : new char[]{}, 32);
                FipsKeyUnwrapper<FipsAES.WrapParameters> fipsKeyUnwrapper = keyWrapOperatorFactory.createKeyUnwrapper(new SymmetricSecretKey(FipsAES.KWP, byArray3), wrapParameters);
                try {
                    return fipsKeyUnwrapper.unwrap(byArray, 0, byArray.length);
                }
                catch (InvalidWrappingException invalidWrappingException) {
                    throw new IOException(invalidWrappingException.getMessage());
                }
            }
            throw new IOException("BCFKS KeyStore cannot recognize protection encryption algorithm.");
        }

        private KeyDerivationFunc generatePkbdAlgorithmIdentifier(int n) {
            byte[] byArray = new byte[64];
            this.getDefaultSecureRandom().nextBytes(byArray);
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, 16384, n, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE)));
        }
    }
}

