/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.internal.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.provider.ClassUtil;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Integers;

class GcmSpecUtil {
    static final Class gcmSpecClass = ClassUtil.lookup("javax.crypto.spec.GCMParameterSpec");
    static final Method tLen;
    static final Method iv;

    GcmSpecUtil() {
    }

    static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    static boolean isGcmSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        return gcmSpecClass != null && gcmSpecClass.isInstance(algorithmParameterSpec);
    }

    static boolean isGcmSpec(Class clazz) {
        return gcmSpecClass == clazz;
    }

    static Class[] getCipherSpecClasses() {
        if (GcmSpecUtil.gcmSpecExists()) {
            return new Class[]{gcmSpecClass, IvParameterSpec.class};
        }
        return new Class[]{AEADParameterSpec.class, IvParameterSpec.class};
    }

    static AlgorithmParameterSpec extractGcmSpec(ASN1Primitive aSN1Primitive) throws InvalidParameterSpecException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    GCMParameters gCMParameters = GCMParameters.getInstance(aSN1Primitive);
                    Constructor constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                    return constructor.newInstance(Integers.valueOf(gCMParameters.getIcvLen() * 8), gCMParameters.getNonce());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return new InvalidParameterSpecException("no constructor found!");
                }
                catch (Exception exception) {
                    return new InvalidParameterSpecException("construction failed: " + exception.getMessage());
                }
            }
        });
        if (object instanceof AlgorithmParameterSpec) {
            return (AlgorithmParameterSpec)object;
        }
        throw (InvalidParameterSpecException)object;
    }

    static GCMParameters extractGcmParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new GCMParameters((byte[])iv.invoke((Object)algorithmParameterSpec, new Object[0]), (Integer)tLen.invoke((Object)algorithmParameterSpec, new Object[0]) / 8);
                }
                catch (Exception exception) {
                    return new InvalidParameterSpecException("cannot process GCMParameterSpec: " + exception.getMessage());
                }
            }
        });
        if (object instanceof GCMParameters) {
            return (GCMParameters)object;
        }
        throw (InvalidParameterSpecException)object;
    }

    static {
        if (gcmSpecClass != null) {
            tLen = ClassUtil.extractMethod(gcmSpecClass, "getTLen");
            iv = ClassUtil.extractMethod(gcmSpecClass, "getIV");
        } else {
            tLen = null;
            iv = null;
        }
    }
}

