/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jcajce.provider.ClassUtil;

class ChaCha20SpecUtil {
    private static final Class chaCha20Spec = ClassUtil.lookup("javax.crypto.spec.ChaCha20ParameterSpec");
    static final Method counter;
    static final Method nonce;

    ChaCha20SpecUtil() {
    }

    static boolean chacha20SpecExists() {
        return chaCha20Spec != null;
    }

    static boolean isChaCha20Spec(AlgorithmParameterSpec algorithmParameterSpec) {
        return chaCha20Spec != null && chaCha20Spec.isInstance(algorithmParameterSpec);
    }

    static boolean isChaCha20Spec(Class clazz) {
        return chaCha20Spec == clazz;
    }

    static Class[] getCipherSpecClasses() {
        if (ChaCha20SpecUtil.chacha20SpecExists()) {
            return new Class[]{chaCha20Spec, IvParameterSpec.class};
        }
        return new Class[]{IvParameterSpec.class};
    }

    static AlgorithmParameterSpec extractChaCha20Spec(ASN1Primitive aSN1Primitive) throws InvalidParameterSpecException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(aSN1Primitive);
                    Constructor constructor = chaCha20Spec.getConstructor(byte[].class, Integer.TYPE);
                    return constructor.newInstance(aSN1OctetString.getOctets(), 0);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return new InvalidParameterSpecException("no constructor found!");
                }
                catch (Exception exception) {
                    return new InvalidParameterSpecException("construction failed: " + exception.getMessage());
                }
            }
        });
        if (object instanceof AlgorithmParameterSpec) {
            return (AlgorithmParameterSpec)object;
        }
        throw (InvalidParameterSpecException)object;
    }

    static ASN1Sequence extractChaCha20Parameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new DERSequence(new ASN1Encodable[]{new DEROctetString((byte[])nonce.invoke((Object)algorithmParameterSpec, new Object[0])), new ASN1Integer(((Integer)counter.invoke((Object)algorithmParameterSpec, new Object[0])).intValue())});
                }
                catch (Exception exception) {
                    return new InvalidParameterSpecException("cannot process ChaCha20ParameterSpec: " + exception.getMessage());
                }
            }
        });
        if (object instanceof ASN1Sequence) {
            return (ASN1Sequence)object;
        }
        throw (InvalidParameterSpecException)object;
    }

    static {
        if (chaCha20Spec != null) {
            counter = ClassUtil.extractMethod(chaCha20Spec, "getCounter");
            nonce = ClassUtil.extractMethod(chaCha20Spec, "getNonce");
        } else {
            counter = null;
            nonce = null;
        }
    }
}

