/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.security.SecureRandom;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsEntropyConfig;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.general.GeneralSecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this._sr = secureRandom;
        this._predictionResistant = bl;
    }

    @Override
    public EntropySource get(int n) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this._sr instanceof FipsSecureRandom || BasicEntropySourceProvider.this._sr instanceof GeneralSecureRandom) {
                    byte[] byArray = new byte[(n + 7) / 8];
                    BasicEntropySourceProvider.this._sr.nextBytes(byArray);
                    return byArray;
                }
                if (FipsEntropyConfig.getH() != 8.0f) {
                    int n2 = (int)((float)n / FipsEntropyConfig.getH() + 1.0f);
                    byte[] byArray = BasicEntropySourceProvider.this._sr.generateSeed((n2 + 7) / 8);
                    FipsOutputXOFCalculator<FipsSHS.Parameters> fipsOutputXOFCalculator = new FipsSHS.XOFOperatorFactory<FipsSHS.Parameters>().createOutputXOFCalculator(FipsSHS.SHAKE256);
                    UpdateOutputStream updateOutputStream = fipsOutputXOFCalculator.getFunctionStream();
                    updateOutputStream.update(byArray);
                    updateOutputStream.finished();
                    return fipsOutputXOFCalculator.getFunctionOutput((n + 7) / 8);
                }
                return BasicEntropySourceProvider.this._sr.generateSeed((n + 7) / 8);
            }

            @Override
            public int entropySize() {
                return n;
            }
        };
    }
}

