/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;

class PrivilegedUtils {
    PrivilegedUtils() {
    }

    static byte[] getKeyBytes(SymmetricKey symmetricKey) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return symmetricKey.getKeyBytes();
            }
        });
    }

    static ValidatedSymmetricKey getValidatedKey(SymmetricKey symmetricKey) {
        return new ValidatedSymmetricKey(symmetricKey.getAlgorithm(), PrivilegedUtils.getKeyBytes(symmetricKey));
    }
}

