/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;

class PrivilegedUtils {
    PrivilegedUtils() {
    }

    static ValidatedSymmetricKey getValidatedKey(SymmetricKey symmetricKey) {
        return new ValidatedSymmetricKey(symmetricKey.getAlgorithm(), PrivilegedUtils.getKeyBytes(symmetricKey));
    }

    static byte[] getKeyBytes(SymmetricKey symmetricKey) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return symmetricKey.getKeyBytes();
            }
        });
    }

    static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    securityManager.checkPermission(permission);
                    return null;
                }
            });
        }
    }
}

