/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class LoaderUtils {
    private static final Logger LOG = Logger.getLogger(LoaderUtils.class.getName());

    LoaderUtils() {
    }

    static File createTempDir(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("moduleName cannot be null");
        }
        String string2 = LoaderUtils.getPropertyValue("java.io.tmpdir");
        try {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File file = new File(string2);
                    if (file.isFile()) {
                        throw new IllegalStateException(String.format("'%s' exists and is a file", string2));
                    }
                    if (!file.exists() && !file.mkdirs()) {
                        throw new IllegalStateException(String.format("failed to create temporary directory '%s'", string2));
                    }
                    long l = System.nanoTime();
                    for (int i = 0; i < 10000; ++i) {
                        File file2 = new File(file, String.format("%s_%d", string, l + (long)i));
                        if (file2.exists() || !file2.mkdirs()) continue;
                        final File file3 = file2;
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("cleanup shutdown hook started");
                                }
                                if (!file3.exists()) {
                                    return;
                                }
                                boolean bl = true;
                                if (file3.isDirectory()) {
                                    for (File file : file3.listFiles()) {
                                        bl &= file.delete();
                                    }
                                }
                                if (!(bl &= file3.delete())) {
                                    LOG.fine("failed to delete: " + file3.getAbsolutePath());
                                } else {
                                    LOG.fine("successfully cleaned up: " + file3.getAbsolutePath());
                                }
                            }
                        }));
                        return file2;
                    }
                    throw new IllegalStateException(String.format("failed to create temporary directory in '%s'", string2));
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException(illegalStateException.getMessage(), illegalStateException);
        }
    }

    static File createVersionedTempDir(String string, String string2) throws IOException {
        if (string2 == null) {
            throw new NullPointerException("version cannot be null");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File file = new File(new File(string), string2);
                    if (file.isFile()) {
                        throw new IllegalStateException(String.format("'%s' exists and is a file", string));
                    }
                    if (!file.exists() && !file.mkdirs()) {
                        throw new IllegalStateException(String.format("failed to create temporary directory '%s'", string));
                    }
                    return file;
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException(illegalStateException.getMessage(), illegalStateException);
        }
    }

    static File extractFromClasspath(File file, String string, String string2) throws Exception {
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public File run() {
                InputStream inputStream = LoaderUtils.class.getResourceAsStream(string);
                if (inputStream == null) {
                    return null;
                }
                File file3 = new File(file, string2);
                if (file3.exists()) {
                    if (file3.isDirectory()) {
                        throw new IllegalStateException("extracted file name '" + file3.getAbsolutePath() + "' is actually a directory and already exists");
                    }
                    try (FileInputStream fileInputStream = new FileInputStream(file3);){
                        if (LoaderUtils.isContentSame(fileInputStream, inputStream)) {
                            File file2 = file3;
                            return file2;
                        }
                        throw new IllegalStateException("existing file name '" + file3.getAbsolutePath() + "' does not match expected file content");
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException("unable to read exising extracted library" + file3.getAbsolutePath(), exception);
                    }
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                    int n;
                    byte[] byArray = new byte[8192];
                    while ((n = inputStream.read(byArray)) > -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    return file3;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
    }

    static List<String> readStreamToLines(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#") || string.isEmpty()) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static boolean isContentSame(InputStream inputStream, InputStream inputStream2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedInputStream bufferedInputStream2 = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream2 = new BufferedInputStream(inputStream2);
            int n = 0;
            int n2 = 0;
            while (n >= 0) {
                n = bufferedInputStream.read();
                if (n == (n2 = bufferedInputStream2.read())) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {}
            try {
                bufferedInputStream2.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private static String getPropertyValue(String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string2 = Security.getProperty(string);
                if (string2 != null) {
                    return string2;
                }
                return System.getProperty(string);
            }
        });
    }
}

