/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.bouncycastle.LICENSE;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.NativeLoader;
import org.bouncycastle.crypto.fips.SHA256Digest;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public final class FipsStatus {
    public static final String READY = "READY";
    private static final Object statusLock = new Object();
    private static final String[] classes = new String[]{FipsSHS.class.getName()};
    private static final AtomicBoolean readyStatus = new AtomicBoolean(false);
    private static volatile Loader loader;
    private static volatile Throwable statusException;

    private FipsStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Object object = statusLock;
        synchronized (object) {
            if (loader == null && statusException == null) {
                try {
                    loader = new Loader();
                    loader.run();
                }
                catch (Exception exception) {
                    statusException = exception;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module startup failed: " + exception.getMessage(), exception));
                }
                FipsStatus.checksumValidate();
                NativeLoader.loadDriver();
                readyStatus.set(true);
            } else if (statusException != null) {
                throw new FipsOperationError("Module in error status: " + statusException.getMessage(), statusException);
            }
        }
        return readyStatus.get();
    }

    static boolean isBooting() {
        return !readyStatus.get();
    }

    private static void checksumValidate() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FipsStatus.getResourceName();
            }
        });
        if (string == null) {
            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to find"));
        }
        if (string.startsWith("jrt:/")) {
            byte[][] byArray = null;
            try {
                FileSystem fileSystem = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.singletonMap("java.home", System.getProperty("java.home")));
                try (Stream<Path> stream = Files.list(fileSystem.getPath("/modules", new String[0]));){
                    Iterator iterator = stream.iterator();
                    while (iterator.hasNext()) {
                        Path path = (Path)iterator.next();
                        if (!path.endsWith("/modules/org.bouncycastle.fips.core")) continue;
                        try {
                            byArray = FipsStatus.calculateModuleHMAC(Files.walk(path, new FileVisitOption[0]));
                            break;
                        }
                        catch (Exception exception) {
                            statusException = exception;
                            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + exception.getMessage(), exception));
                        }
                    }
                }
                if (!Arrays.constantTimeAreEqual(byArray[0], byArray[1])) {
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: expected [" + Hex.toHexString(byArray[1]) + "] got [" + Hex.toHexString(byArray[0]) + "]"));
                }
            }
            catch (IOException iOException) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to calculate: " + iOException.getMessage(), iOException));
            }
            if (byArray == null) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to calculate"));
            }
        } else if (FipsStatus.checkValidJarUrl(string)) {
            try {
                JarInputStream jarInputStream = new JarInputStream(new URL(string).openStream());
                byte[][] byArray = FipsStatus.calculateModuleHMAC(jarInputStream);
                if (!Arrays.constantTimeAreEqual(byArray[0], byArray[1])) {
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: expected [" + Hex.toHexString(byArray[1]) + "] got [" + Hex.toHexString(byArray[0]) + "]"));
                }
            }
            catch (Exception exception) {
                statusException = exception;
                FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + exception.getMessage(), exception));
            }
        } else {
            JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                @Override
                public JarFile run() {
                    try {
                        return new JarFile(string);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
            if (jarFile != null) {
                try {
                    int n;
                    byte[] byArray = FipsStatus.calculateModuleHMAC(jarFile);
                    InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/HMAC.SHA256"));
                    StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
                    while ((n = inputStream.read()) >= 0 && n != 13 && n != 10) {
                        stringBuilder.append((char)n);
                    }
                    byte[] byArray2 = Hex.decode(stringBuilder.toString().trim());
                    if (!Arrays.constantTimeAreEqual(byArray, byArray2)) {
                        FipsStatus.moveToErrorStatus((Object)((Object)new FipsOperationError("Module checksum failed: expected [" + stringBuilder.toString().trim() + "] got [" + Strings.fromByteArray(Hex.encode(byArray)))) + "]");
                    }
                }
                catch (Exception exception) {
                    statusException = exception;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + exception.getMessage(), exception));
                }
            }
        }
    }

    public static String getStatusMessage() {
        try {
            FipsStatus.isReady();
        }
        catch (FipsOperationError fipsOperationError) {
            // empty catch block
        }
        if (statusException != null) {
            return statusException.getMessage();
        }
        return READY;
    }

    private static void loadClass(String string) {
        try {
            Class.forName(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            statusException = exceptionInInitializerError.getCause() != null ? exceptionInInitializerError.getCause() : exceptionInInitializerError;
            throw exceptionInInitializerError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            statusException = classNotFoundException;
            throw new IllegalStateException("Unable to initialize module: " + classNotFoundException.getMessage(), classNotFoundException);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] getModuleHMAC() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean skipName(String string) {
        if (string.indexOf("module-info.class") >= 0) {
            return true;
        }
        if (string.startsWith("META-INF/")) {
            if (string.contains("OSGI-INF/")) {
                return true;
            }
            if (string.indexOf("versions/") < 0) {
                return true;
            }
        }
        return string.contains("OSGI-INF/");
    }

    private static boolean skipEntry(JarEntry jarEntry) {
        return jarEntry.isDirectory() || FipsStatus.skipName(jarEntry.getName());
    }

    private static byte[][] calculateModuleHMAC(Stream<Path> stream) throws Exception {
        Map.Entry entry2;
        HMac hMac = new HMac(new SHA256Digest());
        hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
        TreeMap treeMap = new TreeMap();
        stream.forEach(path -> treeMap.put(path.toString(), path));
        byte[] byArray = null;
        byte[] byArray2 = new byte[8192];
        for (Map.Entry entry2 : treeMap.entrySet()) {
            int n;
            Object object;
            Path path2 = (Path)entry2.getValue();
            if (Files.isDirectory(path2, new LinkOption[0])) continue;
            String string = path2.toAbsolutePath().toString().substring("/modules/org.bouncycastle.fips.core/".length());
            if (string.equals("BC-INF/HMAC.SHA256")) {
                object = Files.newInputStream(path2.toAbsolutePath(), new OpenOption[0]);
                byArray = Hex.decode(Strings.fromByteArray(Streams.readAll((InputStream)object)).trim());
                ((InputStream)object).close();
                continue;
            }
            if (FipsStatus.skipName(string)) continue;
            object = (Long)Files.getAttribute(path2, "size", new LinkOption[0]);
            InputStream inputStream = Files.newInputStream(path2.toAbsolutePath(), new OpenOption[0]);
            byte[] byArray3 = Strings.toUTF8ByteArray(string);
            hMac.update((byte)91);
            hMac.update(byArray3, 0, byArray3.length);
            hMac.update(Pack.longToBigEndian((Long)object), 0, 8);
            hMac.update((byte)93);
            while ((n = inputStream.read(byArray2, 0, byArray2.length)) != -1) {
                hMac.update(byArray2, 0, n);
            }
            inputStream.close();
        }
        hMac.update((byte)91);
        Object object = Strings.toUTF8ByteArray("END");
        hMac.update((byte[])object, 0, ((Object)object).length);
        hMac.update((byte)93);
        entry2 = (Map.Entry)new byte[hMac.getMacSize()];
        hMac.doFinal((byte[])entry2, 0);
        return new byte[][]{(byte[])entry2, byArray};
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object2;
            HMac hMac = new HMac(new SHA256Digest());
            hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object3 = jarFile.entries();
            while (object3.hasMoreElements()) {
                Object object4;
                object2 = object3.nextElement();
                if (FipsStatus.skipEntry((JarEntry)object2) || (object4 = treeMap.put(((ZipEntry)object2).getName(), object2)) == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = illegalStateException;
                throw illegalStateException;
            }
            object3 = new byte[8192];
            for (Map.Entry entry : treeMap.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = Strings.toUTF8ByteArray(jarEntry.getName());
                hMac.update((byte)91);
                hMac.update(byArray, 0, byArray.length);
                hMac.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                hMac.update((byte)93);
                while ((n = inputStream.read((byte[])object3, 0, ((Object)object3).length)) != -1) {
                    hMac.update((byte[])object3, 0, n);
                }
                inputStream.close();
            }
            hMac.update((byte)91);
            object2 = Strings.toUTF8ByteArray("END");
            hMac.update((byte[])object2, 0, ((Object)object2).length);
            hMac.update((byte)93);
            byte[] byArray = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray, 0);
            return byArray;
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[][] calculateModuleHMAC(JarInputStream jarInputStream) throws Exception {
        try {
            Object object;
            Object object3;
            JarEntry jarEntry;
            HMac hMac = new HMac(new SHA256Digest());
            hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            byte[] byArray = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (jarEntry.getName().equals("META-INF/HMAC.SHA256")) {
                    byArray = Hex.decode(Strings.fromByteArray(Streams.readAll(jarInputStream)).trim());
                    continue;
                }
                if (FipsStatus.skipEntry(jarEntry)) continue;
                object3 = Strings.toUTF8ByteArray(jarEntry.getName());
                ByteArrayOutputStream object22 = new ByteArrayOutputStream();
                object22.write(91);
                object22.write((byte[])object3, 0, ((Object)object3).length);
                object = Streams.readAll(jarInputStream);
                object22.write(Pack.longToBigEndian(((byte[])object).length), 0, 8);
                object22.write(93);
                object22.write((byte[])object, 0, ((byte[])object).length);
                byte[] byArray2 = treeMap.put(jarEntry.getName(), object22.toByteArray());
                if (byArray2 == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = illegalStateException;
                throw illegalStateException;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                object = (byte[])entry.getValue();
                hMac.update((byte[])object, 0, ((byte[])object).length);
            }
            hMac.update((byte)91);
            object3 = Strings.toUTF8ByteArray("END");
            hMac.update((byte[])object3, 0, ((Object)object3).length);
            hMac.update((byte)93);
            byte[] byArray3 = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray3, 0);
            object = new byte[][]{byArray3, byArray};
            return object;
        }
        finally {
            jarInputStream.close();
        }
    }

    private static String getResourceName() {
        String string = null;
        String string2 = LICENSE.class.getCanonicalName().replace(".", "/").replace("LICENSE", "MARKER");
        String string3 = FipsStatus.getMarker(LICENSE.class, string2);
        if (string3 != null) {
            if (string3.startsWith("jar:") && string3.contains("!/")) {
                try {
                    String string4;
                    int n = string3.indexOf(58, 4);
                    if (n == -1) {
                        return null;
                    }
                    string = string4 = URLDecoder.decode(string3.substring(n + 1, string3.lastIndexOf("!/")), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else if (string3.startsWith("file:") && string3.endsWith(".jar")) {
                try {
                    String string5;
                    string = string5 = URLDecoder.decode(string3.substring("file:".length()), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else {
                if (string3.startsWith("vfs:")) {
                    return string3;
                }
                if (string3.startsWith("jrt:")) {
                    return string3;
                }
                if (string3.startsWith("file:")) {
                    return string3;
                }
                if (FipsStatus.checkValidJarUrl(string3)) {
                    return string3;
                }
            }
        }
        return string;
    }

    static void moveToErrorStatus(String string) {
        FipsStatus.moveToErrorStatus(new FipsOperationError(string));
    }

    static void moveToErrorStatus(FipsOperationError fipsOperationError) {
        statusException = fipsOperationError;
        throw (FipsOperationError)((Object)statusException);
    }

    public static boolean isErrorStatus() {
        return statusException != null;
    }

    static String getMarker(Class clazz, String string) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            Object t2 = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                        return codeSource.getLocation();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (t2 != null) {
                return t2.toString();
            }
            return classLoader.getResource(string).toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ClassLoader.getSystemResource(string).toString();
            }
        });
    }

    private static boolean checkValidJarUrl(String string) {
        return (string.startsWith("http://") || string.startsWith("https://")) && string.endsWith(".jar");
    }

    static class Loader {
        Loader() {
        }

        void run() throws Exception {
            for (String string : classes) {
                if (FipsStatus.isErrorStatus()) continue;
                FipsStatus.loadClass(string);
            }
        }
    }
}

