/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.CSHAKEDigest;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestOperatorFactory;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKeyedXOFOperatorFactory;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputDigestCalculator;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsXOFOperatorFactory;
import org.bouncycastle.crypto.fips.KMAC;
import org.bouncycastle.crypto.fips.NativeLoader;
import org.bouncycastle.crypto.fips.ParallelHash;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SHA1Digest;
import org.bouncycastle.crypto.fips.SHA224Digest;
import org.bouncycastle.crypto.fips.SHA256Digest;
import org.bouncycastle.crypto.fips.SHA256NativeDigest;
import org.bouncycastle.crypto.fips.SHA384Digest;
import org.bouncycastle.crypto.fips.SHA3Digest;
import org.bouncycastle.crypto.fips.SHA512Digest;
import org.bouncycastle.crypto.fips.SHA512tDigest;
import org.bouncycastle.crypto.fips.SHAKEDigest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TupleHash;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.CipherKeyGenerator;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.crypto.internal.io.XofOutputStream;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.macs.TruncatingMac;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public final class FipsSHS {
    private static final int MIN_APPROVED_KEY_SIZE = 112;
    private static final Map<FipsAlgorithm, Integer> defaultMacSize = new HashMap<FipsAlgorithm, Integer>();
    private static Map<FipsAlgorithm, FipsEngineProvider<ExtendedDigest>> digests = new HashMap<FipsAlgorithm, FipsEngineProvider<ExtendedDigest>>();
    private static Map<FipsAlgorithm, FipsEngineProvider<Mac>> hMacs = new HashMap<FipsAlgorithm, FipsEngineProvider<Mac>>();
    public static final Parameters SHA1;
    public static final AuthParameters SHA1_HMAC;
    public static final Parameters SHA224;
    public static final AuthParameters SHA224_HMAC;
    public static final Parameters SHA256;
    public static final AuthParameters SHA256_HMAC;
    public static final Parameters SHA384;
    public static final AuthParameters SHA384_HMAC;
    public static final Parameters SHA512;
    public static final AuthParameters SHA512_HMAC;
    public static final Parameters SHA512_224;
    public static final AuthParameters SHA512_224_HMAC;
    public static final Parameters SHA512_256;
    public static final AuthParameters SHA512_256_HMAC;
    public static final Parameters SHA3_224;
    public static final AuthParameters SHA3_224_HMAC;
    public static final Parameters SHA3_256;
    public static final AuthParameters SHA3_256_HMAC;
    public static final Parameters SHA3_384;
    public static final AuthParameters SHA3_384_HMAC;
    public static final Parameters SHA3_512;
    public static final AuthParameters SHA3_512_HMAC;
    public static final Parameters SHAKE128;
    public static final Parameters SHAKE256;
    public static final CSHAKEParameters cSHAKE128;
    public static final CSHAKEParameters cSHAKE256;
    public static final KMACParameters KMAC128;
    public static final KMACParameters KMAC256;
    public static final TupleHashParameters TupleHash128;
    public static final TupleHashParameters TupleHash256;
    public static final ParallelHashParameters ParallelHash128;
    public static final ParallelHashParameters ParallelHash256;

    private FipsSHS() {
    }

    static DigestCloner<ExtendedDigest> createCloner(FipsAlgorithm fipsAlgorithm) {
        switch ((Variations)fipsAlgorithm.basicVariation()) {
            case SHA1: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA1Digest((SHA1Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA1);
                    }
                };
            }
            case SHA224: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA224Digest((SHA224Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA224);
                    }
                };
            }
            case SHA256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            if (extendedDigest instanceof SHA256NativeDigest) {
                                return new SHA256NativeDigest((SHA256NativeDigest)extendedDigest);
                            }
                            return new SHA256Digest((SHA256Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA256);
                    }
                };
            }
            case SHA384: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA384Digest((SHA384Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA384);
                    }
                };
            }
            case SHA512: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA512Digest((SHA512Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA512);
                    }
                };
            }
            case SHA512_224: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA512tDigest((SHA512tDigest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA512_224);
                    }
                };
            }
            case SHA512_256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA512tDigest((SHA512tDigest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA512_256);
                    }
                };
            }
            case SHA3_224: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA3_224);
                    }
                };
            }
            case SHA3_256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA3_256);
                    }
                };
            }
            case SHA3_384: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA3_384);
                    }
                };
            }
            case SHA3_512: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHA3_512);
                    }
                };
            }
            case SHAKE128: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHAKEDigest((SHAKEDigest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHAKE128);
                    }
                };
            }
            case SHAKE256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new SHAKEDigest((SHAKEDigest)extendedDigest);
                        }
                        return FipsSHS.createDigest(Algorithm.SHAKE256);
                    }
                };
            }
            case TupleHash128: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new TupleHash((TupleHash)extendedDigest);
                        }
                        TupleHashParameters tupleHashParameters = (TupleHashParameters)parameters;
                        return new TupleHash(128, tupleHashParameters.customizationString, tupleHashParameters.digestSizeInBits);
                    }
                };
            }
            case TupleHash256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        if (extendedDigest != null) {
                            return new TupleHash((TupleHash)extendedDigest);
                        }
                        TupleHashParameters tupleHashParameters = (TupleHashParameters)parameters;
                        return new TupleHash(256, tupleHashParameters.customizationString, tupleHashParameters.digestSizeInBits);
                    }
                };
            }
            case ParallelHash128: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        ParallelHashParameters parallelHashParameters = (ParallelHashParameters)parameters;
                        if (extendedDigest != null) {
                            return new ParallelHash((ParallelHash)extendedDigest);
                        }
                        return new ParallelHash(128, parallelHashParameters.customizationString, parallelHashParameters.blockLength, parallelHashParameters.digestSizeInBits);
                    }
                };
            }
            case ParallelHash256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest, Parameters parameters) {
                        ParallelHashParameters parallelHashParameters = (ParallelHashParameters)parameters;
                        if (extendedDigest != null) {
                            return new ParallelHash((ParallelHash)extendedDigest);
                        }
                        return new ParallelHash(256, parallelHashParameters.customizationString, parallelHashParameters.blockLength, parallelHashParameters.digestSizeInBits);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unknown algorithm passed to FipsSHS.OperatorFactory.createOutputDigestCalculator: " + fipsAlgorithm.getName());
    }

    static ExtendedDigest createBaseDigest(FipsAlgorithm fipsAlgorithm) {
        switch ((Variations)fipsAlgorithm.basicVariation()) {
            case SHA1: {
                return new SHA1Digest();
            }
            case SHA224: {
                return new SHA224Digest();
            }
            case SHA256: {
                if (!FipsStatus.isBooting() && NativeLoader.hasNativeService("SHA2")) {
                    return new SHA256NativeDigest();
                }
                return new SHA256Digest();
            }
            case SHA384: {
                return new SHA384Digest();
            }
            case SHA512: {
                return new SHA512Digest();
            }
            case SHA512_224: {
                return new SHA512tDigest(224);
            }
            case SHA512_256: {
                return new SHA512tDigest(256);
            }
            case SHA3_224: {
                return new SHA3Digest(224);
            }
            case SHA3_256: {
                return new SHA3Digest(256);
            }
            case SHA3_384: {
                return new SHA3Digest(384);
            }
            case SHA3_512: {
                return new SHA3Digest(512);
            }
            case SHAKE128: {
                return new SHAKEDigest(128);
            }
            case SHAKE256: {
                return new SHAKEDigest(256);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm passed to FipsSHS.OperatorFactory.createOutputDigestCalculator: " + fipsAlgorithm.getName());
    }

    private static ExtendedDigest makeValidatedDigest(FipsAlgorithm fipsAlgorithm, BasicKatTest<ExtendedDigest> basicKatTest) {
        return SelfTestExecutor.validate(fipsAlgorithm, FipsSHS.createBaseDigest(fipsAlgorithm), basicKatTest);
    }

    private static Xof makeValidatedXof(FipsParameters fipsParameters) {
        FipsAlgorithm fipsAlgorithm = fipsParameters.getAlgorithm();
        if (fipsAlgorithm == Algorithm.SHAKE128) {
            return SelfTestExecutor.validate(fipsAlgorithm, new SHAKEDigest(128), new ShaKatTest(Hex.decode("5881092dd818bf5cf8a3ddb793fbcba74097d5c526a6d35f97b83351940f2cc8")));
        }
        if (fipsAlgorithm == Algorithm.SHAKE256) {
            return SelfTestExecutor.validate(fipsAlgorithm, new SHAKEDigest(256), new ShaKatTest(Hex.decode("483366601360a8771c6863080cc4114d8db44530f8f1e1ee4f94ea37e78b5739d5a15bef186a5386c75744c0527e1faa9f8726e462a12a4feb06bd8801e751e4")));
        }
        if (fipsAlgorithm == Algorithm.cSHAKE128) {
            CSHAKEParameters cSHAKEParameters = (CSHAKEParameters)fipsParameters;
            return new CSHAKEDigest(128, cSHAKEParameters.functionNameString, cSHAKEParameters.customizationString);
        }
        if (fipsAlgorithm == Algorithm.cSHAKE256) {
            CSHAKEParameters cSHAKEParameters = (CSHAKEParameters)fipsParameters;
            return new CSHAKEDigest(256, cSHAKEParameters.functionNameString, cSHAKEParameters.customizationString);
        }
        if (fipsAlgorithm == Algorithm.KMAC128) {
            KMACParameters kMACParameters = (KMACParameters)fipsParameters;
            return new KMAC(128, kMACParameters.customizationString);
        }
        if (fipsAlgorithm == Algorithm.KMAC256) {
            KMACParameters kMACParameters = (KMACParameters)fipsParameters;
            return new KMAC(256, kMACParameters.customizationString);
        }
        if (fipsAlgorithm == Algorithm.TupleHash128) {
            TupleHashParameters tupleHashParameters = (TupleHashParameters)fipsParameters;
            return new TupleHash(128, tupleHashParameters.customizationString);
        }
        if (fipsAlgorithm == Algorithm.TupleHash256) {
            TupleHashParameters tupleHashParameters = (TupleHashParameters)fipsParameters;
            return new TupleHash(256, tupleHashParameters.customizationString);
        }
        if (fipsAlgorithm == Algorithm.ParallelHash128) {
            ParallelHashParameters parallelHashParameters = (ParallelHashParameters)fipsParameters;
            return new ParallelHash(128, parallelHashParameters.customizationString, parallelHashParameters.blockLength);
        }
        if (fipsAlgorithm == Algorithm.ParallelHash256) {
            ParallelHashParameters parallelHashParameters = (ParallelHashParameters)fipsParameters;
            return new ParallelHash(256, parallelHashParameters.customizationString, parallelHashParameters.blockLength);
        }
        throw new IllegalArgumentException("Unknown extendable output function requested: " + fipsAlgorithm.getName());
    }

    static ExtendedDigest createDigest(FipsAlgorithm fipsAlgorithm) {
        if (digests.containsKey(fipsAlgorithm)) {
            return (ExtendedDigest)digests.get(fipsAlgorithm).createEngine();
        }
        return null;
    }

    private static Mac makeValidatedHMac(FipsAlgorithm fipsAlgorithm, BasicKatTest<Mac> basicKatTest) {
        HMac hMac;
        switch ((Variations)fipsAlgorithm.basicVariation()) {
            case SHA1_HMAC: {
                hMac = new HMac(new SHA1Digest());
                break;
            }
            case SHA224_HMAC: {
                hMac = new HMac(new SHA224Digest());
                break;
            }
            case SHA256_HMAC: {
                if (NativeLoader.hasNativeService("SHA2")) {
                    hMac = new HMac(new SHA256NativeDigest());
                    break;
                }
                hMac = new HMac(new SHA256Digest());
                break;
            }
            case SHA384_HMAC: {
                hMac = new HMac(new SHA384Digest());
                break;
            }
            case SHA512_HMAC: {
                hMac = new HMac(new SHA512Digest());
                break;
            }
            case SHA512_224_HMAC: {
                hMac = new HMac(new SHA512tDigest(224));
                break;
            }
            case SHA512_256_HMAC: {
                hMac = new HMac(new SHA512tDigest(256));
                break;
            }
            case SHA3_224_HMAC: {
                hMac = new HMac(new SHA3Digest(224));
                break;
            }
            case SHA3_256_HMAC: {
                hMac = new HMac(new SHA3Digest(256));
                break;
            }
            case SHA3_384_HMAC: {
                hMac = new HMac(new SHA3Digest(384));
                break;
            }
            case SHA3_512_HMAC: {
                hMac = new HMac(new SHA3Digest(512));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsSHS.OperatorFactory.createOutputMACCalculator: " + fipsAlgorithm.getName());
            }
        }
        return SelfTestExecutor.validate(fipsAlgorithm, hMac, basicKatTest);
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm fipsAlgorithm) {
        return hMacs.get(fipsAlgorithm);
    }

    static Mac createHMac(FipsAlgorithm fipsAlgorithm) {
        if (hMacs.containsKey(fipsAlgorithm)) {
            return (Mac)FipsSHS.getMacProvider(fipsAlgorithm).createEngine();
        }
        return null;
    }

    static {
        defaultMacSize.put(Algorithm.SHA1_HMAC, 160);
        defaultMacSize.put(Algorithm.SHA224_HMAC, 224);
        defaultMacSize.put(Algorithm.SHA256_HMAC, 256);
        defaultMacSize.put(Algorithm.SHA384_HMAC, 384);
        defaultMacSize.put(Algorithm.SHA512_HMAC, 512);
        defaultMacSize.put(Algorithm.SHA512_224_HMAC, 224);
        defaultMacSize.put(Algorithm.SHA512_256_HMAC, 256);
        defaultMacSize.put(Algorithm.SHA3_224_HMAC, 224);
        defaultMacSize.put(Algorithm.SHA3_256_HMAC, 256);
        defaultMacSize.put(Algorithm.SHA3_384_HMAC, 384);
        defaultMacSize.put(Algorithm.SHA3_512_HMAC, 512);
        defaultMacSize.put(Algorithm.KMAC128, 256);
        defaultMacSize.put(Algorithm.KMAC256, 512);
        ShaKatTest shaKatTest = new ShaKatTest(Hex.decode("a9993e364706816aba3e25717850c26c9cd0d89d"));
        digests.put(Algorithm.SHA1, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA1, shaKatTest);
            }
        });
        ShaKatTest shaKatTest2 = new ShaKatTest(Hex.decode("23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7"));
        digests.put(Algorithm.SHA224, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA224, shaKatTest2);
            }
        });
        ShaKatTest shaKatTest3 = new ShaKatTest(Hex.decode("ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad"));
        digests.put(Algorithm.SHA256, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA256, shaKatTest3);
            }
        });
        ShaKatTest shaKatTest4 = new ShaKatTest(Hex.decode("cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7"));
        digests.put(Algorithm.SHA384, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA384, shaKatTest4);
            }
        });
        ShaKatTest shaKatTest5 = new ShaKatTest(Hex.decode("ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f"));
        digests.put(Algorithm.SHA512, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA512, shaKatTest5);
            }
        });
        ShaKatTest shaKatTest6 = new ShaKatTest(Hex.decode("4634270F707B6A54DAAE7530460842E20E37ED265CEEE9A43E8924AA"));
        digests.put(Algorithm.SHA512_224, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA512_224, shaKatTest6);
            }
        });
        ShaKatTest shaKatTest7 = new ShaKatTest(Hex.decode("53048E2681941EF99B2E29B76B4C7DABE4C2D0C634FC6D46E0E2F13107E7AF23"));
        digests.put(Algorithm.SHA512_256, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA512_256, shaKatTest7);
            }
        });
        ShaKatTest shaKatTest8 = new ShaKatTest(Hex.decode("e642824c3f8cf24ad09234ee7d3c766fc9a3a5168d0c94ad73b46fdf"));
        digests.put(Algorithm.SHA3_224, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_224, shaKatTest8);
            }
        });
        ShaKatTest shaKatTest9 = new ShaKatTest(Hex.decode("3a985da74fe225b2045c172d6bd390bd855f086e3e9d525b46bfe24511431532"));
        digests.put(Algorithm.SHA3_256, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_256, shaKatTest9);
            }
        });
        ShaKatTest shaKatTest10 = new ShaKatTest(Hex.decode("ec01498288516fc926459f58e2c6ad8df9b473cb0fc08c2596da7cf0e49be4b298d88cea927ac7f539f1edf228376d25"));
        digests.put(Algorithm.SHA3_384, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_384, shaKatTest10);
            }
        });
        ShaKatTest shaKatTest11 = new ShaKatTest(Hex.decode("b751850b1a57168a5693cd924b6b096e08f621827444f70d884f5d0240d2712e10e116e9192af3c91a7ec57647e3934057340b4cf408d5a56592f8274eec53f0"));
        digests.put(Algorithm.SHA3_512, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_512, shaKatTest11);
            }
        });
        ShaKatTest shaKatTest12 = new ShaKatTest(Hex.decode("5881092dd818bf5cf8a3ddb793fbcba74097d5c526a6d35f97b83351940f2cc8"));
        digests.put(Algorithm.SHAKE128, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHAKE128, shaKatTest12);
            }
        });
        ShaKatTest shaKatTest13 = new ShaKatTest(Hex.decode("483366601360a8771c6863080cc4114d8db44530f8f1e1ee4f94ea37e78b5739d5a15bef186a5386c75744c0527e1faa9f8726e462a12a4feb06bd8801e751e4"));
        digests.put(Algorithm.SHAKE256, new FipsEngineProvider<ExtendedDigest>(){

            @Override
            public ExtendedDigest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHAKE256, shaKatTest13);
            }
        });
        HMacKatTest hMacKatTest = new HMacKatTest(Hex.decode("effcdf6ae5eb2fa2d27416d5f184df9c259a7c79"));
        hMacs.put(Algorithm.SHA1_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA1_HMAC, hMacKatTest);
            }
        });
        HMacKatTest hMacKatTest2 = new HMacKatTest(Hex.decode("a30e01098bc6dbbf45690f3a7e9e6d0f8bbea2a39e6148008fd05e44"));
        hMacs.put(Algorithm.SHA224_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA224_HMAC, hMacKatTest2);
            }
        });
        HMacKatTest hMacKatTest3 = new HMacKatTest(Hex.decode("5bdcc146bf60754e6a042426089575c75a003f089d2739839dec58b964ec3843"));
        hMacs.put(Algorithm.SHA256_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA256_HMAC, hMacKatTest3);
            }
        });
        HMacKatTest hMacKatTest4 = new HMacKatTest(Hex.decode("af45d2e376484031617f78d2b58a6b1b9c7ef464f5a01b47e42ec3736322445e8e2240ca5e69e2c78b3239ecfab21649"));
        hMacs.put(Algorithm.SHA384_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA384_HMAC, hMacKatTest4);
            }
        });
        HMacKatTest hMacKatTest5 = new HMacKatTest(Hex.decode("164b7a7bfcf819e2e395fbe73b56e0a387bd64222e831fd610270cd7ea2505549758bf75c05a994a6d034f65f8f0e6fdcaeab1a34d4a6b4b636e070a38bce737"));
        hMacs.put(Algorithm.SHA512_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA512_HMAC, hMacKatTest5);
            }
        });
        HMacKatTest hMacKatTest6 = new HMacKatTest(Hex.decode("4a530b31a79ebcce36916546317c45f247d83241dfb818fd37254bde"));
        hMacs.put(Algorithm.SHA512_224_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA512_224_HMAC, hMacKatTest6);
            }
        });
        HMacKatTest hMacKatTest7 = new HMacKatTest(Hex.decode("6df7b24630d5ccb2ee335407081a87188c221489768fa2020513b2d593359456"));
        hMacs.put(Algorithm.SHA512_256_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA512_256_HMAC, hMacKatTest7);
            }
        });
        HMacKatTest hMacKatTest8 = new HMacKatTest(Hex.decode("7fdb8dd88bd2f60d1b798634ad386811c2cfc85bfaf5d52bbace5e66"));
        hMacs.put(Algorithm.SHA3_224_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA3_224_HMAC, hMacKatTest8);
            }
        });
        HMacKatTest hMacKatTest9 = new HMacKatTest(Hex.decode("c7d4072e788877ae3596bbb0da73b887c9171f93095b294ae857fbe2645e1ba5"));
        hMacs.put(Algorithm.SHA3_256_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA3_256_HMAC, hMacKatTest9);
            }
        });
        HMacKatTest hMacKatTest10 = new HMacKatTest(Hex.decode("f1101f8cbf9766fd6764d2ed61903f21ca9b18f57cf3e1a23ca13508a93243ce48c045dc007f26a21b3f5e0e9df4c20a"));
        hMacs.put(Algorithm.SHA3_384_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA3_384_HMAC, hMacKatTest10);
            }
        });
        HMacKatTest hMacKatTest11 = new HMacKatTest(Hex.decode("5a4bfeab6166427c7a3647b747292b8384537cdb89afb3bf5665e4c5e709350b287baec921fd7ca0ee7a0c31d022a95e1fc92ba9d77df883960275beb4e62024"));
        hMacs.put(Algorithm.SHA3_512_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA3_512_HMAC, hMacKatTest11);
            }
        });
        digests.get(Algorithm.SHA1).createEngine();
        digests.get(Algorithm.SHA256).createEngine();
        digests.get(Algorithm.SHA512).createEngine();
        hMacs.get(Algorithm.SHA256_HMAC).createEngine();
        FipsSHS.makeValidatedXof(new Parameters(Algorithm.SHAKE256));
        FipsSHS.makeValidatedXof(new CSHAKEParameters(Algorithm.cSHAKE128));
        for (Map.Entry<FipsAlgorithm, FipsEngineProvider<ExtendedDigest>> entry : digests.entrySet()) {
            FipsRegister.registerEngineProvider(entry.getKey(), entry.getValue());
        }
        FipsRegister.registerEngineProvider(Algorithm.SHAKE128, new FipsEngineProvider<Xof>(){

            @Override
            public Xof createEngine() {
                return FipsSHS.makeValidatedXof(new Parameters(Algorithm.SHAKE128));
            }
        });
        FipsRegister.registerEngineProvider(Algorithm.SHAKE256, new FipsEngineProvider<Xof>(){

            @Override
            public Xof createEngine() {
                return FipsSHS.makeValidatedXof(new Parameters(Algorithm.SHAKE256));
            }
        });
        for (Map.Entry<FipsAlgorithm, FipsEngineProvider<Object>> entry : hMacs.entrySet()) {
            FipsRegister.registerEngineProvider(entry.getKey(), entry.getValue());
        }
        SHA1 = new Parameters(Algorithm.SHA1);
        SHA1_HMAC = new AuthParameters(Algorithm.SHA1_HMAC);
        SHA224 = new Parameters(Algorithm.SHA224);
        SHA224_HMAC = new AuthParameters(Algorithm.SHA224_HMAC);
        SHA256 = new Parameters(Algorithm.SHA256);
        SHA256_HMAC = new AuthParameters(Algorithm.SHA256_HMAC);
        SHA384 = new Parameters(Algorithm.SHA384);
        SHA384_HMAC = new AuthParameters(Algorithm.SHA384_HMAC);
        SHA512 = new Parameters(Algorithm.SHA512);
        SHA512_HMAC = new AuthParameters(Algorithm.SHA512_HMAC);
        SHA512_224 = new Parameters(Algorithm.SHA512_224);
        SHA512_224_HMAC = new AuthParameters(Algorithm.SHA512_224_HMAC);
        SHA512_256 = new Parameters(Algorithm.SHA512_256);
        SHA512_256_HMAC = new AuthParameters(Algorithm.SHA512_256_HMAC);
        SHA3_224 = new Parameters(Algorithm.SHA3_224);
        SHA3_224_HMAC = new AuthParameters(Algorithm.SHA3_224_HMAC);
        SHA3_256 = new Parameters(Algorithm.SHA3_256);
        SHA3_256_HMAC = new AuthParameters(Algorithm.SHA3_256_HMAC);
        SHA3_384 = new Parameters(Algorithm.SHA3_384);
        SHA3_384_HMAC = new AuthParameters(Algorithm.SHA3_384_HMAC);
        SHA3_512 = new Parameters(Algorithm.SHA3_512);
        SHA3_512_HMAC = new AuthParameters(Algorithm.SHA3_512_HMAC);
        SHAKE128 = new Parameters(Algorithm.SHAKE128);
        SHAKE256 = new Parameters(Algorithm.SHAKE256);
        cSHAKE128 = new CSHAKEParameters(Algorithm.cSHAKE128);
        cSHAKE256 = new CSHAKEParameters(Algorithm.cSHAKE256);
        KMAC128 = new KMACParameters(Algorithm.KMAC128, 256);
        KMAC256 = new KMACParameters(Algorithm.KMAC256, 512);
        TupleHash128 = new TupleHashParameters(Algorithm.TupleHash128, 256);
        TupleHash256 = new TupleHashParameters(Algorithm.TupleHash256, 512);
        ParallelHash128 = new ParallelHashParameters(Algorithm.ParallelHash128, 256);
        ParallelHash256 = new ParallelHashParameters(Algorithm.ParallelHash256, 512);
    }

    private static class HMacKatTest
    implements BasicKatTest<Mac> {
        private static final byte[] stdHMacVector = Strings.toByteArray("what do ya want for nothing?");
        private static final byte[] key = Hex.decode("4a656665");
        private final byte[] kat;

        HMacKatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Mac mac) {
            mac.init(new KeyParameterImpl(Arrays.clone(key)));
            mac.update(stdHMacVector, 0, stdHMacVector.length);
            byte[] byArray = new byte[mac.getMacSize()];
            mac.doFinal(byArray, 0);
            return Arrays.areEqual(byArray, this.kat);
        }
    }

    private static class ShaKatTest<T extends Digest>
    implements BasicKatTest<T> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private final byte[] kat;

        ShaKatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            digest.reset();
            return Arrays.areEqual(byArray, this.kat);
        }
    }

    private static class LocalFipsOutputDigestCalculator<T extends Parameters>
    extends FipsOutputDigestCalculator<T>
    implements Cloneable {
        private final ExtendedDigest digest;
        private final T parameter;
        private final DigestCloner<ExtendedDigest> cloner;

        private LocalFipsOutputDigestCalculator(T t2, DigestCloner<ExtendedDigest> digestCloner) {
            this(t2, null, digestCloner);
        }

        private LocalFipsOutputDigestCalculator(T t2, ExtendedDigest extendedDigest, DigestCloner<ExtendedDigest> digestCloner) {
            this.digest = digestCloner.makeDigest(extendedDigest, (Parameters)t2);
            this.parameter = t2;
            this.cloner = digestCloner;
        }

        @Override
        public T getParameters() {
            return this.parameter;
        }

        @Override
        public int getDigestSize() {
            return this.digest.getDigestSize();
        }

        @Override
        public int getDigestBlockSize() {
            return this.digest.getByteLength();
        }

        @Override
        public UpdateOutputStream getDigestStream() {
            return new DigestOutputStream(this.digest);
        }

        @Override
        public int getDigest(byte[] byArray, int n) {
            return this.digest.doFinal(byArray, n);
        }

        @Override
        public void reset() {
            this.digest.reset();
        }

        @Override
        public FipsOutputDigestCalculator<T> clone() throws CloneNotSupportedException {
            return new LocalFipsOutputDigestCalculator<T>(this.parameter, this.digest, this.cloner);
        }

        public String toString() {
            return "LocalFipsOutputDigestCalculator(" + this.digest.toString() + ")";
        }

        /* synthetic */ LocalFipsOutputDigestCalculator(Parameters parameters, DigestCloner digestCloner, 1 var3_3) {
            this(parameters, digestCloner);
        }
    }

    private static interface DigestCloner<D extends ExtendedDigest> {
        public D makeDigest(D var1, Parameters var2);
    }

    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return authParameters.getMACSizeInBits() / 8;
        }

        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
            if (authParameters instanceof KMACParameters) {
                if (!validatedSymmetricKey.getAlgorithm().equals(authParameters.getAlgorithm())) {
                    throw new IllegalArgumentException("key not for algorithm specified");
                }
                Xof xof = FipsSHS.makeValidatedXof(authParameters);
                if (!(xof instanceof Mac)) {
                    throw new IllegalArgumentException("XOF algorithm given not MAC capable");
                }
                KeyParameter keyParameter = Utils.getKeyParameter(validatedSymmetricKey);
                if (CryptoServicesRegistrar.isInApprovedOnlyMode() && keyParameter.getKey().length * 8 < 112) {
                    throw new IllegalKeyException("Key size for KMAC must be at least 112 bits in approved mode: " + authParameters.getAlgorithm().getName());
                }
                ((Mac)((Object)xof)).init(keyParameter);
                return new LocalXofMac(xof, authParameters.macSizeInBits);
            }
            Mac mac = FipsSHS.createHMac(authParameters.getAlgorithm());
            if (mac.getMacSize() != (authParameters.getMACSizeInBits() + 7) / 8) {
                mac = new TruncatingMac(mac, authParameters.macSizeInBits);
            }
            KeyParameter keyParameter = Utils.getKeyParameter(validatedSymmetricKey);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && keyParameter.getKey().length * 8 < 112) {
                throw new IllegalKeyException("Key size for HMAC must be at least 112 bits in approved mode: " + authParameters.getAlgorithm().getName());
            }
            mac.init(keyParameter);
            return mac;
        }
    }

    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(FipsAlgorithm fipsAlgorithm, int n, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (n < 112) {
                    throw new IllegalArgumentException("Key size for HMAC/KMAC must be at least 112 bits in approved mode: " + fipsAlgorithm.getName());
                }
                Utils.validateKeyGenRandom(secureRandom, 112, fipsAlgorithm);
            }
            this.algorithm = fipsAlgorithm;
            this.keySizeInBits = n;
            this.random = secureRandom;
        }

        @Override
        public SymmetricKey generateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    private static class LocalXofMac
    implements Mac {
        private final Mac xof;
        private final int macSizeInBits;

        public LocalXofMac(Xof xof, int n) {
            this.xof = (Mac)((Object)xof);
            this.macSizeInBits = n;
        }

        @Override
        public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
            this.xof.init(cipherParameters);
        }

        @Override
        public String getAlgorithmName() {
            return this.xof.getAlgorithmName();
        }

        @Override
        public int getMacSize() {
            return (this.macSizeInBits + 7) / 8;
        }

        @Override
        public void update(byte by) throws IllegalStateException {
            this.xof.update(by);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
            this.xof.update(byArray, n, n2);
        }

        @Override
        public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
            return ((Xof)((Object)this.xof)).doFinal(byArray, n, this.getMacSize());
        }

        @Override
        public void reset() {
            this.xof.reset();
        }
    }

    private static class LocalFipsOutputXOFCalculator<T extends FipsParameters>
    extends FipsOutputXOFCalculator {
        private final T parameters;
        private final XofOutputStream xofStream;
        private boolean isOutputing;

        public LocalFipsOutputXOFCalculator(T t2, Xof xof) {
            this.parameters = t2;
            this.xofStream = new XofOutputStream(xof);
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public UpdateOutputStream getFunctionStream() {
            if (this.isOutputing) {
                this.isOutputing = false;
                this.xofStream.reset();
            }
            return this.xofStream;
        }

        @Override
        public int getFunctionOutput(byte[] byArray, int n, int n2) {
            this.isOutputing = true;
            return this.xofStream.getOutput(byArray, n, n2);
        }

        @Override
        public void reset() {
            this.xofStream.reset();
        }
    }

    public static final class KeyedXOFOperatorFactory<T extends FipsParameters>
    extends FipsKeyedXOFOperatorFactory<T> {
        @Override
        public FipsOutputXOFCalculator<T> createOutputXOFCalculator(SymmetricKey symmetricKey, T t2) {
            ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
            if (!validatedSymmetricKey.getAlgorithm().equals(((FipsParameters)t2).getAlgorithm())) {
                throw new IllegalArgumentException("key not for algorithm specified");
            }
            Xof xof = FipsSHS.makeValidatedXof(t2);
            if (!(xof instanceof Mac)) {
                throw new IllegalArgumentException("XOF algorithm given not MAC capable");
            }
            KeyParameter keyParameter = Utils.getKeyParameter(validatedSymmetricKey);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && keyParameter.getKey().length * 8 < 112) {
                throw new IllegalKeyException("Key size for KMAC must be at least 112 bits in approved mode: " + ((FipsParameters)t2).getAlgorithm().getName());
            }
            ((Mac)((Object)xof)).init(keyParameter);
            return new LocalFipsOutputXOFCalculator<T>(t2, xof);
        }
    }

    public static final class XOFOperatorFactory<T extends Parameters>
    extends FipsXOFOperatorFactory<T> {
        @Override
        public FipsOutputXOFCalculator<T> createOutputXOFCalculator(T t2) {
            return new LocalFipsOutputXOFCalculator<T>(t2, FipsSHS.makeValidatedXof(t2));
        }
    }

    public static final class OperatorFactory<T extends Parameters>
    extends FipsDigestOperatorFactory<T> {
        @Override
        public FipsOutputDigestCalculator<T> createOutputDigestCalculator(T t2) {
            return new LocalFipsOutputDigestCalculator((Parameters)t2, FipsSHS.createCloner(((FipsParameters)t2).getAlgorithm()), null);
        }
    }

    public static final class ParallelHashParameters
    extends Parameters {
        private final int digestSizeInBits;
        private final byte[] customizationString;
        private final int blockLength;

        ParallelHashParameters(FipsAlgorithm fipsAlgorithm, int n) {
            this(fipsAlgorithm, n, null, fipsAlgorithm.equals(Algorithm.ParallelHash128) ? 32 : 64);
        }

        private ParallelHashParameters(FipsAlgorithm fipsAlgorithm, int n, byte[] byArray, int n2) {
            super(fipsAlgorithm);
            this.digestSizeInBits = n;
            this.customizationString = byArray;
            this.blockLength = n2;
        }

        public int getDigestSizeInBits() {
            return this.digestSizeInBits;
        }

        public byte[] getCustomizationString() {
            return Arrays.clone(this.customizationString);
        }

        public ParallelHashParameters withCustomizationString(byte[] byArray) {
            return new ParallelHashParameters(this.getAlgorithm(), this.digestSizeInBits, Arrays.clone(byArray), this.blockLength);
        }

        public ParallelHashParameters withDigestSize(int n) {
            return new ParallelHashParameters(this.getAlgorithm(), n, this.customizationString, this.blockLength);
        }

        public ParallelHashParameters withBlockLength(int n) {
            return new ParallelHashParameters(this.getAlgorithm(), this.digestSizeInBits, this.customizationString, n);
        }
    }

    public static final class TupleHashParameters
    extends Parameters {
        private final int digestSizeInBits;
        private final byte[] customizationString;

        TupleHashParameters(FipsAlgorithm fipsAlgorithm, int n) {
            this(fipsAlgorithm, n, null);
        }

        private TupleHashParameters(FipsAlgorithm fipsAlgorithm, int n, byte[] byArray) {
            super(fipsAlgorithm);
            this.digestSizeInBits = n;
            this.customizationString = byArray;
        }

        public int getDigestSizeInBits() {
            return this.digestSizeInBits;
        }

        public byte[] getCustomizationString() {
            return Arrays.clone(this.customizationString);
        }

        public TupleHashParameters withCustomizationString(byte[] byArray) {
            return new TupleHashParameters(this.getAlgorithm(), this.digestSizeInBits, Arrays.clone(byArray));
        }

        public TupleHashParameters withDigestSize(int n) {
            return new TupleHashParameters(this.getAlgorithm(), n, this.customizationString);
        }
    }

    public static final class KMACParameters
    extends AuthParameters {
        private final byte[] customizationString;

        KMACParameters(FipsAlgorithm fipsAlgorithm, int n) {
            this(fipsAlgorithm, n, (byte[])null);
        }

        private KMACParameters(FipsAlgorithm fipsAlgorithm, int n, byte[] byArray) {
            super(fipsAlgorithm, n);
            this.customizationString = byArray;
        }

        public byte[] getCustomizationString() {
            return Arrays.clone(this.customizationString);
        }

        public KMACParameters withCustomizationString(byte[] byArray) {
            return new KMACParameters(this.getAlgorithm(), this.getMACSizeInBits(), Arrays.clone(byArray));
        }

        @Override
        public KMACParameters withMACSize(int n) {
            return new KMACParameters(this.getAlgorithm(), n, this.customizationString);
        }
    }

    public static final class CSHAKEParameters
    extends Parameters {
        private final byte[] functionNameString;
        private final byte[] customizationString;

        CSHAKEParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null, null);
        }

        private CSHAKEParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.functionNameString = byArray;
            this.customizationString = byArray2;
        }

        public CSHAKEParameters withFunctionName(byte[] byArray) {
            return new CSHAKEParameters(this.getAlgorithm(), Arrays.clone(byArray), this.customizationString);
        }

        public CSHAKEParameters withCustomizationString(byte[] byArray) {
            return new CSHAKEParameters(this.getAlgorithm(), this.functionNameString, Arrays.clone(byArray));
        }
    }

    public static class AuthParameters
    extends FipsParameters
    implements AuthenticationParameters<AuthParameters> {
        private final int macSizeInBits;

        private AuthParameters(FipsAlgorithm fipsAlgorithm, int n) {
            super(fipsAlgorithm);
            this.macSizeInBits = n;
        }

        AuthParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, (Integer)defaultMacSize.get(fipsAlgorithm));
        }

        @Override
        public int getMACSizeInBits() {
            return this.macSizeInBits;
        }

        @Override
        public AuthParameters withMACSize(int n) {
            return new AuthParameters(this.getAlgorithm(), n);
        }
    }

    public static class Parameters
    extends FipsParameters {
        Parameters(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }
    }

    public static final class Algorithm {
        public static final FipsDigestAlgorithm SHA1 = new FipsDigestAlgorithm("SHA-1", (Enum)Variations.SHA1);
        public static final FipsDigestAlgorithm SHA1_HMAC = new FipsDigestAlgorithm("SHA-1/HMAC", (Enum)Variations.SHA1_HMAC);
        public static final FipsDigestAlgorithm SHA224 = new FipsDigestAlgorithm("SHA-224", (Enum)Variations.SHA224);
        public static final FipsDigestAlgorithm SHA224_HMAC = new FipsDigestAlgorithm("SHA-224/HMAC", (Enum)Variations.SHA224_HMAC);
        public static final FipsDigestAlgorithm SHA256 = new FipsDigestAlgorithm("SHA-256", (Enum)Variations.SHA256);
        public static final FipsDigestAlgorithm SHA256_HMAC = new FipsDigestAlgorithm("SHA-256/HMAC", (Enum)Variations.SHA256_HMAC);
        public static final FipsDigestAlgorithm SHA384 = new FipsDigestAlgorithm("SHA-384", (Enum)Variations.SHA384);
        public static final FipsDigestAlgorithm SHA384_HMAC = new FipsDigestAlgorithm("SHA-384/HMAC", (Enum)Variations.SHA384_HMAC);
        public static final FipsDigestAlgorithm SHA512 = new FipsDigestAlgorithm("SHA-512", (Enum)Variations.SHA512);
        public static final FipsDigestAlgorithm SHA512_HMAC = new FipsDigestAlgorithm("SHA-512/HMAC", (Enum)Variations.SHA512_HMAC);
        public static final FipsDigestAlgorithm SHA512_224 = new FipsDigestAlgorithm("SHA-512(224)", (Enum)Variations.SHA512_224);
        public static final FipsDigestAlgorithm SHA512_224_HMAC = new FipsDigestAlgorithm("SHA-512(224)/HMAC", (Enum)Variations.SHA512_224_HMAC);
        public static final FipsDigestAlgorithm SHA512_256 = new FipsDigestAlgorithm("SHA-512(256)", (Enum)Variations.SHA512_256);
        public static final FipsDigestAlgorithm SHA512_256_HMAC = new FipsDigestAlgorithm("SHA-512(256)/HMAC", (Enum)Variations.SHA512_256_HMAC);
        public static final FipsDigestAlgorithm SHA3_224 = new FipsDigestAlgorithm("SHA3-224", (Enum)Variations.SHA3_224);
        public static final FipsDigestAlgorithm SHA3_224_HMAC = new FipsDigestAlgorithm("SHA3-224/HMAC", (Enum)Variations.SHA3_224_HMAC);
        public static final FipsDigestAlgorithm SHA3_256 = new FipsDigestAlgorithm("SHA3-256", (Enum)Variations.SHA3_256);
        public static final FipsDigestAlgorithm SHA3_256_HMAC = new FipsDigestAlgorithm("SHA3-256/HMAC", (Enum)Variations.SHA3_256_HMAC);
        public static final FipsDigestAlgorithm SHA3_384 = new FipsDigestAlgorithm("SHA3-384", (Enum)Variations.SHA3_384);
        public static final FipsDigestAlgorithm SHA3_384_HMAC = new FipsDigestAlgorithm("SHA3-384/HMAC", (Enum)Variations.SHA3_384_HMAC);
        public static final FipsDigestAlgorithm SHA3_512 = new FipsDigestAlgorithm("SHA3-512", (Enum)Variations.SHA3_512);
        public static final FipsDigestAlgorithm SHA3_512_HMAC = new FipsDigestAlgorithm("SHA3-512/HMAC", (Enum)Variations.SHA3_512_HMAC);
        public static final FipsDigestAlgorithm SHAKE128 = new FipsDigestAlgorithm("SHAKE128", (Enum)Variations.SHAKE128);
        public static final FipsDigestAlgorithm SHAKE256 = new FipsDigestAlgorithm("SHAKE256", (Enum)Variations.SHAKE256);
        public static final FipsDigestAlgorithm cSHAKE128 = new FipsDigestAlgorithm("cSHAKE128", (Enum)Variations.cSHAKE128);
        public static final FipsDigestAlgorithm cSHAKE256 = new FipsDigestAlgorithm("cSHAKE256", (Enum)Variations.cSHAKE256);
        public static final FipsDigestAlgorithm KMAC128 = new FipsDigestAlgorithm("KMAC128", (Enum)Variations.KMAC128);
        public static final FipsDigestAlgorithm KMAC256 = new FipsDigestAlgorithm("KMAC256", (Enum)Variations.KMAC256);
        public static final FipsDigestAlgorithm TupleHash128 = new FipsDigestAlgorithm("TupleHash128", (Enum)Variations.TupleHash128);
        public static final FipsDigestAlgorithm TupleHash256 = new FipsDigestAlgorithm("TupleHash256", (Enum)Variations.TupleHash256);
        public static final FipsDigestAlgorithm ParallelHash128 = new FipsDigestAlgorithm("ParallelHash128", (Enum)Variations.ParallelHash128);
        public static final FipsDigestAlgorithm ParallelHash256 = new FipsDigestAlgorithm("ParallelHash256", (Enum)Variations.ParallelHash256);

        private Algorithm() {
        }
    }

    static enum Variations {
        SHA1,
        SHA1_HMAC,
        SHA224,
        SHA224_HMAC,
        SHA256,
        SHA256_HMAC,
        SHA384,
        SHA384_HMAC,
        SHA512,
        SHA512_HMAC,
        SHA512_224,
        SHA512_224_HMAC,
        SHA512_256,
        SHA512_256_HMAC,
        SHA3_224,
        SHA3_256,
        SHA3_384,
        SHA3_512,
        SHA3_224_HMAC,
        SHA3_256_HMAC,
        SHA3_384_HMAC,
        SHA3_512_HMAC,
        SHAKE128,
        SHAKE256,
        cSHAKE128,
        cSHAKE256,
        KMAC128,
        KMAC256,
        TupleHash128,
        TupleHash256,
        ParallelHash128,
        ParallelHash256;

    }
}

