/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TestTrigger;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class AESNativeCFB
implements StreamCipher,
MultiBlockCipher {
    private static byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f");
    private static byte[] enc = Hex.decode("c6a13b37878f5b826f4f8162a1c8d879af9d9926f7dac87192b1c4143ad98958");
    private static TestTrigger trigger = new TestTrigger();
    private final int bitSize;
    private CFBRefWrapper referenceWrapper;
    private byte[] oldKey;
    private byte[] oldIv;
    private boolean encrypting;

    private AESNativeCFB() {
        this(128);
    }

    private AESNativeCFB(int n) {
        this.bitSize = n;
        switch (n) {
            case 128: {
                break;
            }
            default: {
                throw new IllegalArgumentException("native feedback bit size can only be 128");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            boolean bl2 = this.encrypting;
            this.encrypting = bl;
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (cipherParameters instanceof ParametersWithIV) {
                ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                byArray2 = parametersWithIV.getIV();
                if (byArray2.length > this.getBlockSize() || byArray2.length < 1) {
                    throw new IllegalArgumentException("initialisation vector must be between one and block size length");
                }
                if (byArray2.length < this.getBlockSize()) {
                    byte[] byArray3 = new byte[this.getBlockSize()];
                    System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
                    byArray2 = byArray3;
                }
                this.oldIv = Arrays.clone(byArray2);
                if (parametersWithIV.getParameters() != null) {
                    byArray = ((KeyParameter)parametersWithIV.getParameters()).getKey();
                }
                if (byArray != null) {
                    bl2 = this.encrypting;
                    this.oldKey = Arrays.clone(byArray);
                } else {
                    byArray = this.oldKey;
                }
            } else if (cipherParameters instanceof KeyParameter) {
                byArray = ((KeyParameter)cipherParameters).getKey();
                this.oldKey = Arrays.clone(byArray);
                byArray2 = this.oldIv;
            }
            if (byArray == null && bl2 != this.encrypting) {
                throw new IllegalArgumentException("cannot change encrypting state without providing key.");
            }
            if (byArray2 == null) {
                throw new IllegalArgumentException("iv is null");
            }
            switch (byArray.length) {
                case 16: 
                case 24: 
                case 32: {
                    break;
                }
                default: {
                    throw new IllegalStateException("key must be only 16,24,or 32 bytes long.");
                }
            }
            this.referenceWrapper = new CFBRefWrapper(AESNativeCFB.makeNative(this.encrypting, byArray.length));
            AESNativeCFB.init(this.referenceWrapper.getReference(), byArray, byArray2);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CFB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte returnByte(byte by) {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCFB.processByte(this.referenceWrapper.getReference(), by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCFB.processBytes(this.referenceWrapper.getReference(), byArray, n, n2, byArray2, n3);
        }
    }

    @Override
    public int getBlockSize() {
        return this.bitSize / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("not initialized");
            }
            return AESNativeCFB.processBytes(this.referenceWrapper.getReference(), byArray, n, this.getBlockSize(), byArray2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                return;
            }
            AESNativeCFB.reset(this.referenceWrapper.getReference());
        }
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCFB.getNativeMultiBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        AESNativeCFB aESNativeCFB = this;
        synchronized (aESNativeCFB) {
            if (this.referenceWrapper == null) {
                throw new IllegalStateException("CFB engine not initialized");
            }
            return this.processBytes(byArray, n, n2 * this.getBlockSize(), byArray2, n3);
        }
    }

    private static native byte processByte(long var0, byte var2);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6) throws DataLengthException;

    static native long makeNative(boolean var0, int var1);

    static native void init(long var0, byte[] var2, byte[] var3);

    static native void dispose(long var0);

    static native int getNativeMultiBlockSize();

    private static native void reset(long var0);

    public String toString() {
        if (this.oldKey != null) {
            return "CFB[Native](AES[Native](" + this.oldKey.length * 8 + "))";
        }
        return "CFB[Native](AES[Native](not initialized))";
    }

    static AESNativeCFB newInstance() {
        AESNativeCFB aESNativeCFB = new AESNativeCFB();
        if (trigger.triggerTest()) {
            return SelfTestExecutor.validate(FipsAES.CFB128.getAlgorithm(), aESNativeCFB, new BasicKatTest<AESNativeCFB>(){

                @Override
                public boolean hasTestPassed(AESNativeCFB aESNativeCFB) throws Exception {
                    byte[] byArray = new byte[32];
                    byte[] byArray2 = new byte[32];
                    byte[] byArray3 = new byte[16];
                    aESNativeCFB.init(true, new ParametersWithIV(new KeyParameterImpl(key), byArray3));
                    aESNativeCFB.processBlocks(byArray, 0, 2, byArray2, 0);
                    if (!Arrays.areEqual(enc, byArray2)) {
                        return false;
                    }
                    aESNativeCFB.init(false, new ParametersWithIV(new KeyParameterImpl(key), byArray3));
                    aESNativeCFB.processBlocks(enc, 0, 2, byArray2, 0);
                    aESNativeCFB.referenceWrapper = null;
                    return Arrays.areEqual(byArray, byArray2);
                }
            });
        }
        return aESNativeCFB;
    }

    private static class CFBRefWrapper
    extends NativeReference {
        public CFBRefWrapper(long l) {
            super(l);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeCFB.dispose(l);
        }
    }
}

