/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KemOtherInfo
extends ASN1Object {
    private static final PKIFreeText DEFAULT_staticString = new PKIFreeText("CMP-KEM");
    private final PKIFreeText staticString;
    private ASN1OctetString transactionID;
    private ASN1OctetString senderNonce;
    private ASN1OctetString recipNonce;
    private final ASN1Integer len;
    private final AlgorithmIdentifier mac;
    private final ASN1OctetString ct;

    public KemOtherInfo(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString aSN1OctetString3, ASN1Integer aSN1Integer, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString4) {
        this.staticString = DEFAULT_staticString;
        this.transactionID = aSN1OctetString;
        this.senderNonce = aSN1OctetString2;
        this.recipNonce = aSN1OctetString3;
        this.len = aSN1Integer;
        this.mac = algorithmIdentifier;
        this.ct = aSN1OctetString4;
    }

    public KemOtherInfo(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString aSN1OctetString3, long l, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString4) {
        this(aSN1OctetString, aSN1OctetString2, aSN1OctetString3, new ASN1Integer(l), algorithmIdentifier, aSN1OctetString4);
    }

    private KemOtherInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 4 || aSN1Sequence.size() > 7) {
            throw new IllegalArgumentException("sequence size should be between 4 and 7 inclusive");
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.staticString = PKIFreeText.getInstance(enumeration.nextElement());
        if (!this.staticString.equals(DEFAULT_staticString)) {
            throw new IllegalArgumentException("staticString field should be " + DEFAULT_staticString);
        }
        ASN1Object aSN1Object = null;
        block5: while (enumeration.hasMoreElements() && (aSN1Object = (ASN1Object)enumeration.nextElement()) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Object;
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.transactionID = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 1: {
                    this.senderNonce = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 2: {
                    this.recipNonce = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
        }
        this.len = ASN1Integer.getInstance(aSN1Object);
        this.mac = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.ct = ASN1OctetString.getInstance(enumeration.nextElement());
    }

    public static KemOtherInfo getInstance(Object object) {
        if (object instanceof KemOtherInfo) {
            return (KemOtherInfo)object;
        }
        if (object != null) {
            return new KemOtherInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public ASN1OctetString getSenderNonce() {
        return this.senderNonce;
    }

    public ASN1OctetString getRecipNonce() {
        return this.recipNonce;
    }

    public ASN1Integer getLen() {
        return this.len;
    }

    public AlgorithmIdentifier getMac() {
        return this.mac;
    }

    public ASN1OctetString getCt() {
        return this.ct;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(7);
        aSN1EncodableVector.add(this.staticString);
        KemOtherInfo.addOptional(aSN1EncodableVector, 0, this.transactionID);
        KemOtherInfo.addOptional(aSN1EncodableVector, 1, this.senderNonce);
        KemOtherInfo.addOptional(aSN1EncodableVector, 2, this.recipNonce);
        aSN1EncodableVector.add(this.len);
        aSN1EncodableVector.add(this.mac);
        aSN1EncodableVector.add(this.ct);
        return new DERSequence(aSN1EncodableVector);
    }

    private static void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n, aSN1Encodable));
        }
    }

    private static ASN1TaggedObject tryGetTagged(ASN1Sequence aSN1Sequence, int n) {
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n);
        return aSN1Encodable instanceof ASN1TaggedObject ? (ASN1TaggedObject)aSN1Encodable : null;
    }
}

