/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.client.AHSProxy;
import org.apache.hadoop.yarn.client.api.AHSClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AHSClientImpl
extends AHSClient {
    protected ApplicationHistoryProtocol ahsClient;
    protected InetSocketAddress ahsAddress;

    public AHSClientImpl() {
        super(AHSClientImpl.class.getName());
    }

    private static InetSocketAddress getAHSAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.timeline-service.address", "0.0.0.0:10200", 10200);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.ahsAddress = AHSClientImpl.getAHSAddress(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.ahsClient = AHSProxy.createAHSProxy(this.getConfig(), ApplicationHistoryProtocol.class, this.ahsAddress);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.ahsClient != null) {
            RPC.stopProxy((Object)this.ahsClient);
        }
        super.serviceStop();
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
        GetApplicationReportResponse response = this.ahsClient.getApplicationReport(request);
        return response.getApplicationReport();
    }

    @Override
    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        GetApplicationsRequest request = GetApplicationsRequest.newInstance(null, null);
        GetApplicationsResponse response = this.ahsClient.getApplications(request);
        return response.getApplicationList();
    }

    @Override
    public ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)applicationAttemptId);
        GetApplicationAttemptReportResponse response = this.ahsClient.getApplicationAttemptReport(request);
        return response.getApplicationAttemptReport();
    }

    @Override
    public List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance((ApplicationId)appId);
        GetApplicationAttemptsResponse response = this.ahsClient.getApplicationAttempts(request);
        return response.getApplicationAttemptList();
    }

    @Override
    public ContainerReport getContainerReport(ContainerId containerId) throws YarnException, IOException {
        GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)containerId);
        GetContainerReportResponse response = this.ahsClient.getContainerReport(request);
        return response.getContainerReport();
    }

    @Override
    public List<ContainerReport> getContainers(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)applicationAttemptId);
        GetContainersResponse response = this.ahsClient.getContainers(request);
        return response.getContainerList();
    }
}

