/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceRequestPBImpl
extends ResourceRequest {
    YarnProtos.ResourceRequestProto proto = YarnProtos.ResourceRequestProto.getDefaultInstance();
    YarnProtos.ResourceRequestProto.Builder builder = null;
    boolean viaProto = false;
    private Priority priority = null;
    private Resource capability = null;
    private ExecutionTypeRequest executionTypeRequest = null;

    public ResourceRequestPBImpl() {
        this.builder = YarnProtos.ResourceRequestProto.newBuilder();
    }

    public ResourceRequestPBImpl(YarnProtos.ResourceRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.priority != null) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.capability != null) {
            this.builder.setCapability(this.convertToProtoFormat(this.capability));
        }
        if (this.executionTypeRequest != null) {
            this.builder.setExecutionTypeRequest(ProtoUtils.convertToProtoFormat(this.executionTypeRequest));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceRequestProto.newBuilder((YarnProtos.ResourceRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    public Priority getPriority() {
        YarnProtos.ResourceRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    public ExecutionTypeRequest getExecutionTypeRequest() {
        YarnProtos.ResourceRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.executionTypeRequest != null) {
            return this.executionTypeRequest;
        }
        if (!p.hasExecutionTypeRequest()) {
            return null;
        }
        this.executionTypeRequest = ProtoUtils.convertFromProtoFormat(p.getExecutionTypeRequest());
        return this.executionTypeRequest;
    }

    public void setExecutionTypeRequest(ExecutionTypeRequest execSpec) {
        this.maybeInitBuilder();
        if (execSpec == null) {
            this.builder.clearExecutionTypeRequest();
        }
        this.executionTypeRequest = execSpec;
    }

    public String getResourceName() {
        YarnProtos.ResourceRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasResourceName()) {
            return null;
        }
        return p.getResourceName();
    }

    public void setResourceName(String resourceName) {
        this.maybeInitBuilder();
        if (resourceName == null) {
            this.builder.clearResourceName();
            return;
        }
        this.builder.setResourceName(resourceName);
    }

    public Resource getCapability() {
        YarnProtos.ResourceRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.capability != null) {
            return this.capability;
        }
        if (!p.hasCapability()) {
            return null;
        }
        this.capability = this.convertFromProtoFormat(p.getCapability());
        return this.capability;
    }

    public void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
        }
        this.capability = capability;
    }

    public synchronized int getNumContainers() {
        YarnProtos.ResourceRequestProto p = this.viaProto ? this.proto : this.builder;
        return p.getNumContainers();
    }

    public synchronized void setNumContainers(int numContainers) {
        this.maybeInitBuilder();
        this.builder.setNumContainers(numContainers);
    }

    public boolean getRelaxLocality() {
        YarnProtos.ResourceRequestProto p = this.viaProto ? this.proto : this.builder;
        return p.getRelaxLocality();
    }

    public void setRelaxLocality(boolean relaxLocality) {
        this.maybeInitBuilder();
        this.builder.setRelaxLocality(relaxLocality);
    }

    public long getAllocationRequestId() {
        YarnProtos.ResourceRequestProto p = this.viaProto ? this.proto : this.builder;
        return p.getAllocationRequestId();
    }

    public void setAllocationRequestId(long allocationRequestID) {
        this.maybeInitBuilder();
        this.builder.setAllocationRequestId(allocationRequestID);
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority t2) {
        return ((PriorityPBImpl)t2).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t2) {
        return ProtoUtils.convertToProtoFormat(t2);
    }

    public String toString() {
        return "{AllocationRequestId: " + this.getAllocationRequestId() + ", Priority: " + this.getPriority() + ", Capability: " + this.getCapability() + ", # Containers: " + this.getNumContainers() + ", Location: " + this.getResourceName() + ", Relax Locality: " + this.getRelaxLocality() + ", Execution Type Request: " + this.getExecutionTypeRequest() + ", Node Label Expression: " + this.getNodeLabelExpression() + "}";
    }

    public String getNodeLabelExpression() {
        YarnProtos.ResourceRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeLabelExpression()) {
            return null;
        }
        return p.getNodeLabelExpression().trim();
    }

    public void setNodeLabelExpression(String nodeLabelExpression) {
        this.maybeInitBuilder();
        if (nodeLabelExpression == null) {
            this.builder.clearNodeLabelExpression();
            return;
        }
        this.builder.setNodeLabelExpression(nodeLabelExpression);
    }
}

