/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerSubState;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerStatusPBImpl
extends ContainerStatus {
    YarnProtos.ContainerStatusProto proto = YarnProtos.ContainerStatusProto.getDefaultInstance();
    YarnProtos.ContainerStatusProto.Builder builder = null;
    boolean viaProto = false;
    private ContainerId containerId = null;
    private static final String HOST = "HOST";
    private static final String IPS = "IPS";
    private static final String PORTS = "PORTS";
    private Map<String, String> containerAttributes = new HashMap<String, String>();

    public ContainerStatusPBImpl() {
        this.builder = YarnProtos.ContainerStatusProto.newBuilder();
    }

    public ContainerStatusPBImpl(YarnProtos.ContainerStatusProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.ContainerStatusProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ContainerStatusPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerStatus: [").append("ContainerId: ").append(this.getContainerId()).append(", ").append("ExecutionType: ").append(this.getExecutionType()).append(", ").append("State: ").append(this.getState()).append(", ").append("Capability: ").append(this.getCapability()).append(", ").append("Diagnostics: ").append(this.getDiagnostics()).append(", ").append("ExitStatus: ").append(this.getExitStatus()).append(", ").append("IP: ").append(this.getIPs()).append(", ").append("Host: ").append(this.getHost()).append(", ").append("ExposedPorts: ").append(this.getExposedPorts()).append(", ").append("ContainerSubState: ").append(this.getContainerSubState()).append("]");
        return sb.toString();
    }

    private void mergeLocalToBuilder() {
        if (this.containerId != null) {
            this.builder.setContainerId(this.convertToProtoFormat(this.containerId));
        }
        if (this.containerAttributes != null && !this.containerAttributes.isEmpty()) {
            this.addContainerAttributesToProto();
        }
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerStatusProto.newBuilder((YarnProtos.ContainerStatusProto)this.proto);
        }
        this.viaProto = false;
    }

    private void addContainerAttributesToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainerAttributes();
        if (this.containerAttributes == null) {
            return;
        }
        Iterable<YarnProtos.StringStringMapProto> iterable = new Iterable<YarnProtos.StringStringMapProto>(){

            @Override
            public Iterator<YarnProtos.StringStringMapProto> iterator() {
                return new Iterator<YarnProtos.StringStringMapProto>(){
                    private Iterator<String> keyIter;
                    {
                        this.keyIter = ContainerStatusPBImpl.this.containerAttributes.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.StringStringMapProto next() {
                        String key = this.keyIter.next();
                        String value = (String)ContainerStatusPBImpl.this.containerAttributes.get(key);
                        if (value == null) {
                            value = "";
                        }
                        return YarnProtos.StringStringMapProto.newBuilder().setKey(key).setValue(value).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllContainerAttributes((Iterable)iterable);
    }

    private void initContainerAttributes() {
        YarnProtos.ContainerStatusProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getContainerAttributesList();
        for (YarnProtos.StringStringMapProto c : list) {
            if (this.containerAttributes.containsKey(c.getKey())) continue;
            this.containerAttributes.put(c.getKey(), c.getValue());
        }
    }

    public synchronized ExecutionType getExecutionType() {
        YarnProtos.ContainerStatusProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasExecutionType()) {
            return ExecutionType.GUARANTEED;
        }
        return this.convertFromProtoFormat(p.getExecutionType());
    }

    public synchronized void setExecutionType(ExecutionType executionType) {
        this.maybeInitBuilder();
        if (executionType == null) {
            this.builder.clearExecutionType();
            return;
        }
        this.builder.setExecutionType(this.convertToProtoFormat(executionType));
    }

    public synchronized ContainerState getState() {
        YarnProtos.ContainerStatusProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getState());
    }

    public synchronized void setState(ContainerState state) {
        this.maybeInitBuilder();
        if (state == null) {
            this.builder.clearState();
            return;
        }
        this.builder.setState(this.convertToProtoFormat(state));
    }

    public synchronized ContainerSubState getContainerSubState() {
        YarnProtos.ContainerStatusProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasContainerSubState()) {
            return null;
        }
        return ProtoUtils.convertFromProtoFormat(p.getContainerSubState());
    }

    public synchronized void setContainerSubState(ContainerSubState subState) {
        this.maybeInitBuilder();
        if (subState == null) {
            this.builder.clearContainerSubState();
            return;
        }
        this.builder.setContainerSubState(ProtoUtils.convertToProtoFormat(subState));
    }

    public synchronized ContainerId getContainerId() {
        YarnProtos.ContainerStatusProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.containerId != null) {
            return this.containerId;
        }
        if (!p.hasContainerId()) {
            return null;
        }
        this.containerId = this.convertFromProtoFormat(p.getContainerId());
        return this.containerId;
    }

    public synchronized void setContainerId(ContainerId containerId) {
        this.maybeInitBuilder();
        if (containerId == null) {
            this.builder.clearContainerId();
        }
        this.containerId = containerId;
    }

    public synchronized int getExitStatus() {
        YarnProtos.ContainerStatusProto p = this.viaProto ? this.proto : this.builder;
        return p.getExitStatus();
    }

    public synchronized void setExitStatus(int exitStatus) {
        this.maybeInitBuilder();
        this.builder.setExitStatus(exitStatus);
    }

    public synchronized String getDiagnostics() {
        YarnProtos.ContainerStatusProto p = this.viaProto ? this.proto : this.builder;
        return p.getDiagnostics();
    }

    public synchronized void setDiagnostics(String diagnostics) {
        this.maybeInitBuilder();
        this.builder.setDiagnostics(diagnostics);
    }

    public synchronized Resource getCapability() {
        YarnProtos.ContainerStatusProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasCapability()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getCapability());
    }

    public synchronized void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
            return;
        }
        this.builder.setCapability(this.convertToProtoFormat(capability));
    }

    public synchronized List<String> getIPs() {
        String ips;
        if (!this.containerAttributes.containsKey(IPS)) {
            this.initContainerAttributes();
        }
        return (ips = this.containerAttributes.get(IPS)) == null ? null : Arrays.asList(ips.split(","));
    }

    public synchronized void setIPs(List<String> ips) {
        this.maybeInitBuilder();
        if (ips == null) {
            this.containerAttributes.remove(IPS);
            this.addContainerAttributesToProto();
            return;
        }
        this.containerAttributes.put(IPS, StringUtils.join((CharSequence)",", ips));
    }

    public synchronized String getExposedPorts() {
        String ports;
        if (!this.containerAttributes.containsKey(PORTS)) {
            this.initContainerAttributes();
        }
        return (ports = this.containerAttributes.get(PORTS)) == null ? "" : ports;
    }

    public synchronized void setExposedPorts(String ports) {
        this.maybeInitBuilder();
        if (ports == null) {
            this.containerAttributes.remove(PORTS);
            return;
        }
        this.containerAttributes.put(PORTS, ports);
    }

    public synchronized String getHost() {
        if (this.containerAttributes.get(HOST) == null) {
            this.initContainerAttributes();
        }
        return this.containerAttributes.get(HOST);
    }

    public synchronized void setHost(String host) {
        this.maybeInitBuilder();
        if (host == null) {
            this.containerAttributes.remove(HOST);
            return;
        }
        this.containerAttributes.put(HOST, host);
    }

    private YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t2) {
        return ((ContainerIdPBImpl)t2).getProto();
    }

    private ExecutionType convertFromProtoFormat(YarnProtos.ExecutionTypeProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private YarnProtos.ExecutionTypeProto convertToProtoFormat(ExecutionType e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }
}

